<?xml version="1.0"?>
<!-- 
NAME
    kujob.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_job_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    lbarton     11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    htseng      03/09/04 - bug 3489195 
    htseng      07/09/03 - bug 3043955 fix sqlterminator for BEGIN-END block 
    lbarton     04/22/03 - fix DoParse calls
    htseng      08/02/02 - add grantee parse param
    htseng      07/26/02 - add more parse params
    htseng      04/05/02 - add transform_pram DBA.
    htseng      03/04/02 - setup default value for EXPORT.
    htseng      10/24/01 - change EXECUTE to BEGIN/END.
    htseng      09/25/01 - Merged htseng_add_object_job_stylesheet
    htseng	09/24/01 - restored 
    htseng	09/10/01 - Creation 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <xsl:param name="EXPORT">0</xsl:param>
 <xsl:param name="DBA">0</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:template match="JOB_T">
  <xsl:if test="$EXPORT=0">
   <xsl:call-template name="DoParse">
    <xsl:with-param name="Verb">DBMS_JOB.SUBMIT</xsl:with-param>
    <xsl:with-param name="ObjectType">JOB</xsl:with-param>
    <xsl:with-param name="NameNode" select="POWNER"/>
   </xsl:call-template>
   <xsl:text> BEGIN SYS.DBMS_JOB.SUBMIT(</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
    <xsl:text>    </xsl:text>
   </xsl:if>
   <xsl:text> JOB=> </xsl:text>
   <xsl:text>:jobno,</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
    <xsl:text>    </xsl:text>
   </xsl:if>
   <xsl:text> WHAT=> '</xsl:text>
   <xsl:value-of select="WHAT"/>
   <xsl:text>',</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
    <xsl:text>    </xsl:text>
   </xsl:if>
   <xsl:text> NEXT_DATE=>TO_DATE('</xsl:text>
   <xsl:value-of select="NEXT_DATE"/>
   <xsl:text>','YYYY-MM-DD:HH24:MI:SS'),</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
    <xsl:text>    </xsl:text>
   </xsl:if>
   <xsl:text> INTERVAL=> '</xsl:text>
   <xsl:value-of select="INTERVAL_NUM"/>
   <xsl:text>',</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
    <xsl:text>    </xsl:text>
   </xsl:if>
   <xsl:text> NO_PARSE=> TRUE</xsl:text>
   <xsl:if test="FIELD1!=0">
    <xsl:text>,</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
     <xsl:text>    </xsl:text>
    </xsl:if>
    <xsl:text> INSTANCE=> </xsl:text>
    <xsl:value-of select="FIELD1"/>
    <xsl:text>,</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
     <xsl:text>    </xsl:text>
    </xsl:if>
    <xsl:text> FORCE=> TRUE</xsl:text>
   </xsl:if>
   <xsl:text>);</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
    <xsl:text>    </xsl:text>
   </xsl:if>
   <xsl:text> END; </xsl:text>
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>&#xa; </xsl:text>
    <xsl:text>/</xsl:text>
    <!-- Terminate the SQL statement -->
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
  </xsl:if>
  <!-- $EXPORT=0 -->
  <xsl:if test="$EXPORT=1">
   <!-- DBA generate  SYS.DBMS_IJOB.SUBMIT,SYS.DBMS_IJOB.INSTANCE  -->
   <!-- USER  generate  DBMS_JOB.ISUBMIT,  DBMS_JOB.INSTANCE  -->
   <xsl:choose>
    <xsl:when test="$DBA=1">
     <xsl:call-template name="DoParse">
      <xsl:with-param name="Verb">DBMS_IJOB.SUBMIT</xsl:with-param>
      <xsl:with-param name="ObjectType">JOB</xsl:with-param>
      <xsl:with-param name="NameNode" select="POWNER"/>
     </xsl:call-template>
     <xsl:text> BEGIN SYS.DBMS_IJOB.SUBMIT(</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:call-template name="DoParse">
      <xsl:with-param name="Verb">DBMS_JOB.ISUBMIT</xsl:with-param>
      <xsl:with-param name="ObjectType">JOB</xsl:with-param>
      <xsl:with-param name="NameNode" select="POWNER"/>
     </xsl:call-template>
     <xsl:text> BEGIN DBMS_JOB.ISUBMIT(</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
    <xsl:text>    </xsl:text>
   </xsl:if>
   <xsl:text> JOB=> </xsl:text>
   <xsl:value-of select="JOB_ID"/>
   <xsl:text>,</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
    <xsl:text>    </xsl:text>
   </xsl:if>
   <xsl:if test="$DBA =1">
    <xsl:text> LUSER=> '</xsl:text>
    <xsl:value-of select="LOWNER"/>
    <xsl:text>',</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
     <xsl:text>    </xsl:text>
    </xsl:if>
    <xsl:text> PUSER=> '</xsl:text>
    <xsl:value-of select="POWNER"/>
    <xsl:text>',</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
     <xsl:text>    </xsl:text>
    </xsl:if>
    <xsl:text> CUSER=> '</xsl:text>
    <xsl:value-of select="COWNER"/>
    <xsl:text>',</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
     <xsl:text>    </xsl:text>
    </xsl:if>
   </xsl:if>
   <xsl:text> NEXT_DATE=> TO_DATE('</xsl:text>
   <xsl:value-of select="NEXT_DATE"/>
   <xsl:text>', 'YYYY-MM-DD:HH24:MI:SS'),</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
    <xsl:text>    </xsl:text>
   </xsl:if>
   <xsl:text> INTERVAL=> '</xsl:text>
   <xsl:value-of select="INTERVAL_NUM"/>
   <xsl:text>',</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
    <xsl:text>    </xsl:text>
   </xsl:if>
   <xsl:if test="$DBA =1">
    <xsl:text> BROKEN=> </xsl:text>
    <xsl:choose>
     <xsl:when test="FLAG =0 ">
      <xsl:text> FALSE,</xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text> TRUE,</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
     <xsl:text>    </xsl:text>
    </xsl:if>
   </xsl:if>
   <xsl:text> WHAT=> '</xsl:text>
   <xsl:value-of select="WHAT"/>
   <xsl:text>',</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
    <xsl:text>    </xsl:text>
   </xsl:if>
   <xsl:choose>
    <xsl:when test="$DBA =1">
     <xsl:text> NLSENV=> '</xsl:text>
     <xsl:value-of select="NLSENV"/>
     <xsl:text>',</xsl:text>
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
      <xsl:text>    </xsl:text>
     </xsl:if>
     <xsl:text> ENV=> '</xsl:text>
     <xsl:value-of select="ENV"/>
     <xsl:text>');</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text> NO_PARSE=> TRUE);</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
    <xsl:text>    </xsl:text>
   </xsl:if>
   <xsl:text> END;   </xsl:text>
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>&#xa; </xsl:text>
    <xsl:text>/</xsl:text>
    <!-- Terminate the SQL statement -->
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:if test="FIELD1!=0">
    <xsl:choose>
     <xsl:when test="$DBA =1">
      <xsl:call-template name="DoParse">
       <xsl:with-param name="Verb">DBMS_IJOB.INSTANCE</xsl:with-param>
       <xsl:with-param name="ObjectType">JOB</xsl:with-param>
       <xsl:with-param name="NameNode" select="POWNER"/>
      </xsl:call-template>
      <xsl:text> BEGIN SYS.DBMS_IJOB.INSTANCE(</xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:call-template name="DoParse">
       <xsl:with-param name="Verb">DBMS_JOB.INSTANCE</xsl:with-param>
       <xsl:with-param name="ObjectType">JOB</xsl:with-param>
       <xsl:with-param name="NameNode" select="POWNER"/>
      </xsl:call-template>
      <xsl:text> BEGIN DBMS_JOB.INSTANCE(</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
     <xsl:text>    </xsl:text>
    </xsl:if>
    <xsl:text> JOB=> </xsl:text>
    <xsl:value-of select="JOB_ID"/>
    <xsl:text>,</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
     <xsl:text>    </xsl:text>
    </xsl:if>
    <xsl:text> INSTANCE=> </xsl:text>
    <xsl:value-of select="FIELD1"/>
    <xsl:text>,</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
     <xsl:text>    </xsl:text>
    </xsl:if>
    <xsl:text> FORCE=> TRUE);</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
     <xsl:text>    </xsl:text>
    </xsl:if>
    <xsl:text> END; </xsl:text>
    <xsl:if test="$SQLTERMINATOR=1">
     <xsl:text>&#xa; </xsl:text>
     <xsl:text>/</xsl:text>
     <!-- Terminate the SQL statement -->
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
   </xsl:if>
   <!-- FIELD1!= 0 -->
  </xsl:if>
  <!-- $EXPORT= 1 -->
 </xsl:template>
</xsl:stylesheet>
