<?xml version="1.0"?>
<!-- 
NAME
    kudir.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_directory_t UDTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED        MM/DD/YY
    lbarton     11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    lbarton     10/29/02 - EXPORT param
    htseng      08/02/02 - add grantee parse param
    htseng      07/26/02 - add more parse params
    dgagne      08/22/01 - Merged dgagne_add_xsl_stylesheets
    dgagne      05/09/01 - Created
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <xsl:param name="EXPORT">0</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:template match="DIRECTORY_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">DIRECTORY</xsl:with-param>
   <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
  </xsl:call-template>
  <xsl:text> CREATE</xsl:text>
  <!-- omit OR REPLACE if the undocumented EXPORT param is set -->
  <xsl:if test="$EXPORT=0">
   <xsl:text> OR REPLACE</xsl:text>
  </xsl:if>
  <xsl:text> DIRECTORY "</xsl:text>
  <xsl:value-of select="SCHEMA_OBJ/NAME"/>
  <xsl:text>" AS '</xsl:text>
  <xsl:value-of select="OS_PATH"/>
  <xsl:text>'</xsl:text>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
