create or replace
PACKAGE test_case AS

-- a record structure for the table: T_ALERT_HOURS
TYPE alert_hours_rec IS RECORD
(
ah_id t_alert_hours.ah_id%TYPE
,ah_end_time t_alert_hours.ah_end_time%TYPE
);

-- an array of records for the structure for the table: T_ALERT_HOURS
TYPE alert_hours_tab IS TABLE OF alert_hours_rec;

-- a cursor for the table: T_ALERT_HOURS
CURSOR alert_hours_cur
(
c_ah_id NUMBER
,c_ah_rt_code VARCHAR2
) RETURN alert_hours_rec;

-- look up the information for table: T_ALERT_HOURS
FUNCTION fetch_alert_hours_info
(
p_ah_id IN NUMBER
,p_ah_priority IN NUMBER
,p_ah_rt_code IN VARCHAR2
) RETURN alert_hours_rec DETERMINISTIC;

function test_func (
    p_arg1 in number default null )
    return varchar2;


END test_case;