/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.model.xml;

import java.io.IOException;

import javax.ide.model.Project;
import javax.ide.model.spi.XMLDocumentImpl;
import javax.ide.model.text.TextDocument;

/**
 *  The <CODE>XMLDocument</CODE> class.
 */
public class XMLDocument extends TextDocument
{
  private XMLDocumentImpl getXMLDocumentImpl()
  {
    return (XMLDocumentImpl) getElementImpl();
  }

  /**

   * Fetches the {@link XMLModel}. This calls opens the document and loads 
   * its contents. The <code>XMLModel</code> instance returned lives while 
   * clients refer to it. Once a model instance is not referred by 
   * clients it may be garbage collected at any time.
   *
   * @return the {@link XMLModel} containing the document's xml model.
   * @exception IOException if the document cannot be opened.
   */
  public final XMLModel getXMLModel( Project project ) throws IOException
  {
    return getXMLDocumentImpl().getXMLModel( project );
  }
}
