/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.model.spi;

public final class XMLDocType 
{
  private final String _publicId;
  private final String _systemId;

  public XMLDocType( String publicId, String systemId )
  {
    _publicId = publicId;
    _systemId = systemId;
  }
  
  public String getPublicID()
  {
    return _publicId;
  }
  
  public String getSystemID()
  {
    return _systemId;
  }
  
  public boolean equals( Object o )
  {
    if ( o == this )
    {
      return true;
    }
    if ( !(o instanceof XMLDocType))
    {
      return false;
    }
    XMLDocType that = (XMLDocType)o;
    
    return 
      ( that._publicId == null && _publicId == null &&
        that._systemId == null && _systemId == null ) ||
      ( that._publicId != null && that._publicId.equals( this._publicId ) &&
        that._systemId != null && that._systemId.equals( this._systemId ) );
  }
  
  public int hashCode()
  {
    int hash = 42;
    hash = _publicId == null ? hash : 37 * hash + _publicId.hashCode();
    hash = _systemId == null ? hash : 37 * hash + _systemId.hashCode();
    
    return hash;
  }
  
  public String toString()
  {
    return getClass().getName() + "[publicID="+
      String.valueOf( _publicId ) + ", systemID=" +
      String.valueOf( _systemId ) + "]";
  }
}
