/*
 * @(#)TryStatementT.java
 */

package javax.ide.model.java.source.tree;

import java.util.List;

/**
 * A try statement. JLS3 14.20.
 *
 * @author Andy Yu
 * */
public interface TryStatementT
  extends CompoundStatementT
{
  // ----------------------------------------------------------------------

  /**
   * @return The array of catch clauses. Returns a collection of
   * CatchClauseTs. <p/>
   *
   * List of CatchClauseTs.
   */
  public List getCatchClauses();

  /**
   * @return The finally clause if present.
   */
  public FinallyClauseT getFinallyClause();


  // ----------------------------------------------------------------------
}
