/*
 * @(#)CompoundStatementT.java
 */

package javax.ide.model.java.source.tree;

/**
 * Common supertype for statements that have children statements. <p/>
 *
 * @author Andy Yu
 * */
public interface CompoundStatementT
  extends StatementT
{
  // ----------------------------------------------------------------------

  /**
   * In a for statement, null is returned.
   *
   * @return The nested (i.e. parenthesized) expression for this
   * compound statement.
   */
  public ExpressionT getControlExpression();

  /**
   * @return The primary clause.
   */
  public StatementT getPrimaryClause();

  /**
   * In an if statement, this is the "else" clause.
   * In a try statement, this is the "finally" clause.
   *
   * @return The optional secondary clause.
   */
  public StatementT getEndClause();

  // ----------------------------------------------------------------------
}
