/*
 * @(#)ClassBodyT.java
 */

package javax.ide.model.java.source.tree;

import java.util.Collection;
import java.util.List;

/**
 * A class body, sometimes called a class block. <p/>
 * 
 * NOTE: Should this include Tree elements for empty class members? <p/>
 *
 * @author Andy Yu
 * */
public interface ClassBodyT
  extends Tree
{
  // ----------------------------------------------------------------------

  /**
   * Gets the list of declared member declarations.
   *
   * @return All source-model declared members of this class,
   * including synthetic members. This will include every member:
   * methods, constructors, field declarations, enum constant
   * declarations, inner classes, and initializers. <p/>
   *
   * List of MemberTs.
   */
  public List getMembers();

  /**
   * Gets the collection of declared field variables and enum
   * constants.
   *
   * @return All declared field variables and enum constants, not
   * including synthetic ones (e.g. "this$0"). <p/>
   *
   * Collection of MemberVariableTs.
   */
  public Collection getMemberVariables();

  /**
   * Gets the list of enum constants.
   *
   * Collection of EnumConstantTs.
   */
  public List getEnumConstants();

  /**
   * Gets the list of declared field declarations. Does NOT include
   * enum constant declarations.
   *
   * @return All declared field declarations, not including synthetic
   * ones (e.g. "this$0"). This does NOT includes enum constant
   * declarations. <p/>
   *
   * List of FieldDeclTs.
   */
  public List getFieldDeclarations();

  /**
   * Gets the collection of declared field variables. Does NOT include
   * enum constant variables.
   *
   * @return All declared field variables, not including synthetic
   * ones (e.g. "this$0"). This does NOT includes enum constant
   * variables. <p/>
   *
   * Collection of FieldVariableTs.
   */
  public Collection getFieldVariables();

  /**
   * Gets the list of declared method (but not constructor) declarations.
   *
   * @return All source-model declared methods of this class, not
   * including constructors. Does not include the synthetic default
   * constructor or the synthetic <clinit> method. <p/>
   *
   * List of MethodTs.
   */
  public List getMethods();

  /**
   * Gets the list of declared constructor declarations.
   *
   * @return All source-model declared constructors of this
   * class. Does not include the synthetic default constructor nor the
   * synthetic <clinit> method. <p/>
   *
   * List of MethodTs.
   */
  public List getConstructors();

  /**
   * Gets the list of declared member class declarations.
   *
   * @return All source-model directly declared inner classes of this
   * class.  <p/>
   *
   * List of ClassTs.
   */
  public List getClasses();

  /**
   * Gets the list of declared class initializers.
   *
   * @return All source-model initializers declared in this
   * class.  <p/>
   *
   * List of ClassInitializerTs.
   */
  public List getInitializers();


  // ----------------------------------------------------------------------
}
