/*
 * @(#)FieldD.java
 */

package javax.ide.model.java.declaration;

/**
 * Represents a field or enum constant.
 *
 * @author Andy Yu
 */
public interface FieldD
  extends MemberD, HasNameD, HasTypeD, HasAnnotationsD
{
  // ----------------------------------------------------------------------

  /**
   * True if this is an enum constant.
   *
   * @return True if this is an enum constant.
   */
  public boolean isEnumConstant();

  /**
   * True if this is modified with "volatile".
   *
   * @return True if this is modified with "volatile".
   */
  public boolean isVolatile();

  /**
   * True if this is modified with "transient".
   *
   * @return True if this is modified with "transient".
   */
  public boolean isTransient();

  /**
   * Gets the constant value of this field, as defined by the JVMS.
   *
   * @return Gets the constant value of this field: <p/>
   *
   * <ul>
   *
   * <li> A value of primitive type gets returned as an instance of the
   *      appropriate wrapper class. (e.g. Integer)
   *
   * <li> A string value gets returned as a String instance.
   *
   * </ul>
   */
  public Object getConstantValue();


  // ----------------------------------------------------------------------
}
