/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.menu.spi;

import javax.ide.Identifiable;

/**
 * Menu model elements that can be positioned relative to other items of the
 * same type are Positionable. They provide one of 'before' or 'after', or
 * neither.
 */
abstract class Positionable implements Identifiable
{
  private final String _id;
  private String _before;
  private String _after;
  private Float _weight;

  protected Positionable( String id )
  {
    _id = id;
  }

  public final String getBefore()
  {
    return _before;
  }

  public final String getAfter()
  {
    return _after;
  }

  public final String getID()
  {
    return _id;
  }

  void setBefore( String before )
  {
    _before = before;
  } 

  void setAfter( String after )
  {
    _after = after;
  }

  public void setWeight( Float weight )
  {
    _weight = weight;
  }

  public Float getWeight()
  {
    return _weight;
  }

  @Override
  public String toString()
  {
    return getID();
  }
}
