/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.log;

import javax.ide.view.View;

/**
 * The <code>LogPage</code> interface defines the methods to log and 
 * clear messages from a page. <p>
 *
 * Extensions that introduce new page types need to implemente this 
 * interface. A new page is introduced by declaring it in the extension
 * deployment descriptor (EDD) file. There, the page implementation class 
 * is associated with a unique string identifying the page type.<p>
 *
 * When an <code>LogPage</code> implementation is instantiated, the page 
 * type string and a page specific name are used as the components of page
 * {@link javax.ide.util.ID}.
 */
public abstract class LogPage extends View
{
  /**
   *  Display the specified <CODE>msg</CODE>.
   *
   *  @param msg the message to display.
   */
  public abstract void       log( Object msg );

  /**
   *  Clear all currently displayed messages.
   */
  public abstract void       clearAll();

  /**
   *  Get the title to be displayed in the log window hosting this page.
   *
   *  @return the title to display in the host's title bar.
   */
  public abstract String     getLongTitle();

  /**
   *  Get the name to display when this page is tabbed.
   *
   *  @return the name to display when tabbed.
   */
  public abstract String     getShortTitle();
  
  /**
   *  Get the tooltip to display when this page is tabbed.
   *
   *  @return the tooltip to display when tabbed.
   */
  public abstract String     getToolTip();
}
