package javax.ide.extension.spi;


import com.sun.xml.internal.stream.events.XMLEventAllocatorImpl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;

import java.lang.reflect.*;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.LogRecord;

import java.util.logging.Logger;

import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementVisitor;

import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;


public class PullManifestParser
{
  private static Logger LOG = Logger.getLogger("javax.ide.extension.spi");
  public final static String INTERRUPT_PARSE_CONTEXT_KEY = "oracle.ide.parse.interrupt";
  private final DefaultElementContext _context;
  private LocationAdapter _locator;
  private XMLEventAllocator _xmlEventAllocator;

  public PullManifestParser(DefaultElementContext initialContext)
  {
    _context = initialContext;
  }

  /**
   * Get the context
   */
  public ElementContext getContext()
  {
    return _context;
  }

  public void parse(InputStream inputSource, String source)
    throws ParserConfigurationException, XMLStreamException, IOException
  {
    parse(null, inputSource, source);
  }

  private static XMLInputFactory _xmlStreamInputFactory = null;

  private static XMLInputFactory createXMLStreamInputFactory()
  {
    final XMLInputFactory factory = XMLInputFactory.newInstance();
    XMLEventAllocator allocator = null;
    String xmlEventAllocatorFQN = System.getProperty("javax.xml.stream.util.XMLEventAllocator");
    if (xmlEventAllocatorFQN != null)
    {
      Class clazz;
      try
      {
        clazz = Class.forName(xmlEventAllocatorFQN);
        allocator = (XMLEventAllocator) clazz.newInstance();
      }
      catch (ClassNotFoundException e)
      {
        LOG.log(Level.SEVERE,
                "Could not classload " + xmlEventAllocatorFQN + ". Will use com.sun.xml.internal.stream.events.XMLEventAllocatorImpl",
                e);
      }
      catch (Exception e)
      {
        LOG.log(Level.SEVERE,
                "Could not instantiate " + xmlEventAllocatorFQN + ". Will use com.sun.xml.internal.stream.events.XMLEventAllocatorImpl",
                e);
      }
    }

    if (allocator == null)
      allocator = new XMLEventAllocatorImpl();

    factory.setEventAllocator(allocator);

    return factory;

  }

  public void parse(XMLStreamReader reader, InputStream inputSource, String source)
    throws ParserConfigurationException, IOException, XMLStreamException
  {
    if (reader == null)
    {
      if (_xmlStreamInputFactory == null)
        _xmlStreamInputFactory = createXMLStreamInputFactory();
      _xmlEventAllocator = _xmlStreamInputFactory.getEventAllocator();
      reader = _xmlStreamInputFactory.createXMLStreamReader(source, inputSource);
    }

    try
    {
      while (reader.hasNext())
      {
        int event = reader.next();
        if (event == XMLStreamConstants.START_ELEMENT)
        {
          setDocumentLocation(new LocationAdapterImpl(reader.getLocation()));
          StartElement startElementEvent = getXMLEvent(reader).asStartElement();
          boolean toContinue =
            startElement(reader.getNamespaceURI(), startElementEvent.getName().getLocalPart(), startElementEvent.getName().getLocalPart(),
                         new StAXAttributesAdapter(startElementEvent));
          // Check if loop should continue. The early interruption flag of the context controls this.
          if (!toContinue)
            break;
        }
        else if (event == XMLStreamConstants.END_ELEMENT)
        {
          setDocumentLocation(new LocationAdapterImpl(reader.getLocation()));
          EndElement endElementEvent = getXMLEvent(reader).asEndElement();
          endElement(reader.getNamespaceURI(), endElementEvent.getName().getLocalPart(),
                     endElementEvent.getName().getLocalPart());
        }
        else if (event == XMLStreamConstants.CHARACTERS)
        {
          Characters chars = getXMLEvent(reader).asCharacters();
          char charArray[] = chars.getData().toCharArray();
          characters(charArray, 0, charArray.length);
        }
        else if (event == XMLStreamConstants.COMMENT)
        {
          // ignore
        }
      }
    }
    finally
    {
      // Always reset the context, otherwise we're potentially stranded
      // with unbalanced start / ends. This fixes bug 5457726.
      _context.reset();

      reader.close();
    }
  }

  private XMLEvent getXMLEvent(XMLStreamReader reader)
    throws XMLStreamException
  {
    return _xmlEventAllocator.allocate(reader);
  }

  private static class StAXAttributesAdapter
    implements DefaultElementContext.Attributes
  {
    private Collection<Attribute> m_attributes;
    private final StartElement m_startElement;

    StAXAttributesAdapter(StartElement startElement)
    {
      m_startElement = startElement;
      m_attributes = new ArrayList<Attribute>(1);
      Iterator<Attribute> attributeIterator = startElement.getAttributes();
      while (attributeIterator.hasNext())
        m_attributes.add(attributeIterator.next());
    }

    @Override
    public String getValue(String key)
    {
      Attribute attribute = m_startElement.getAttributeByName(new QName(key));
      return attribute != null? attribute.getValue(): null;
    }

    @Override
    public Iterator<Attribute> iterator()
    {
      return m_startElement.getAttributes();
    }
  }

  static class StAXAttribute
    implements Attribute
  {
    private final String m_name;
    private final QName m_qname;
    private final String m_value;
    private final String CDATA = "CDATA";

    StAXAttribute(String name, String value)
    {
      m_name = name;
      m_value = value;
      m_qname = new QName(m_name);
    }

    @Override
    public QName getName()
    {
      return m_qname;
    }

    @Override
    public String getValue()
    {
      return m_value;
    }

    @Override
    public String getDTDType()
    {
      return CDATA;
    }

    @Override
    public boolean isSpecified()
    {
      return true;
    }

    @Override
    public int getEventType()
    {
      return XMLStreamConstants.ATTRIBUTE;
    }

    @Override
    public Location getLocation()
    {
      return null;
    }

    @Override
    public boolean isStartElement()
    {
      return false;
    }

    @Override
    public boolean isAttribute()
    {
      return true;
    }

    @Override
    public boolean isNamespace()
    {
      return false;
    }

    @Override
    public boolean isEndElement()
    {
      return false;
    }

    @Override
    public boolean isEntityReference()
    {
      return false;
    }

    @Override
    public boolean isProcessingInstruction()
    {
      return false;
    }

    @Override
    public boolean isCharacters()
    {
      return false;
    }

    @Override
    public boolean isStartDocument()
    {
      return false;
    }

    @Override
    public boolean isEndDocument()
    {
      return false;
    }

    @Override
    public StartElement asStartElement()
    {
      return null;
    }

    @Override
    public EndElement asEndElement()
    {
      return null;
    }

    @Override
    public Characters asCharacters()
    {
      return null;
    }

    @Override
    public QName getSchemaType()
    {
      return null;
    }

    @Override
    public void writeAsEncodedUnicode(Writer writer)
    {
      // no-op
    }
  }

  private boolean startElement(String uri, String name, String qName, DefaultElementContext.Attributes attributes)
  {
    ElementVisitor visitor = _context.getVisitorForStartElement(new ElementName(uri, name));

    _context.beginElement(uri, name, attributes);

    if (visitor != null)
    {
      recordPosition(_context);
      try
      {
        visitor.start(_context);
      }
      catch (Throwable re)
      {
        if (re instanceof ThreadDeath)
          throw (ThreadDeath) re;
        LogRecord r =
          new ExtensionLogRecord(_locator, Level.SEVERE, "Exception processing manifest: " +
                                 re.getClass().getName() + ":" + re.getMessage());
        r.setThrown(re);
        _context.getLogger().log(r);
      }
    }

    _context.postBeginElement();

    if (Boolean.TRUE.equals(_context.getScopeData().get(INTERRUPT_PARSE_CONTEXT_KEY)))
    {
      // Call end for the element that asked for the interupt
      endElement(uri, name, qName);
      for (ElementName elementName: _context.getElementPath())
      {
        endElement(elementName.getNamespaceURI(), elementName.getLocalName(), elementName.getLocalName());
      }
      return false;
    }
    return true;
  }

  public void endElement(String uri, String name, String qName)
  {
    _context.endElement(uri, name);
    ElementVisitor visitor = _context.getVisitorForEndElement();
    if (visitor != null)
    {
      recordPosition(_context);
      try
      {
        visitor.end(_context);
      }
      catch (Throwable re)
      {
        if (re instanceof ThreadDeath)
          throw (ThreadDeath) re;
        LogRecord r =
          new ExtensionLogRecord(_locator, Level.SEVERE, "Exception processing manifest: " +
                                                   re.getClass().getName() + ":" + re.getMessage());
        r.setThrown(re);
        _context.getLogger().log(r);
      }
    }
    _context.postEndElement();
  }

  public void characters(char[] ch, int start, int length)
  {
    _context.appendCharacters(ch, start, length);
  }

  public void setDocumentLocation(LocationAdapter location)
  {
    _locator = s_locatorWrapper != null? s_locatorWrapper.wrapLocation(location): location;
  }

  private void recordPosition(ElementContext context)
  {
    context.getScopeData().put(ElementVisitor.KEY_LOCATOR, _locator != null? _locator: null);
  }

  public static void setLocatorWrapperFactory(LocatorWrapperFactory factory)
  {
    s_locatorWrapper = factory;
  }

  /**
   * Helper method to create a snapshot copy of a given Locator.
   * This method should be used to copy Locators created by the
   * SAXManifestParser because it is optimized to deal with
   * LocatorWrappers.
   */
  public static Location copyLocator(Location location)
  {
    if (location == null)
    {
      return null;
    }

    if (location instanceof LocatorWrapper)
    {
      //Added this optimization because a LocatorWrapper implementation had
      //a slow getSystemId implementation.  It makes sense to defer any
      //computation done by the wrapper until it is actually queried
      return ((LocatorWrapper) location).createSnapshotCopy();
    }
    else
    {
      return new LocationImpl(location.getPublicId(), location.getSystemId(), location.getColumnNumber(),
                              location.getLineNumber(), location.getCharacterOffset());
    }
  }

  private static LocatorWrapperFactory s_locatorWrapper = null;
}
