/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webbrowser;

import java.awt.Window;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.natives.NativeHandler;
import oracle.ide.natives.registry.RegistryException;
import oracle.ide.natives.registry.RegistryKey;
import oracle.ide.net.URLFileSystem;
import oracle.ide.nulls.DefaultPrintWriter;
import oracle.ide.util.Assert;
import oracle.ide.util.ExecUtil;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.webbrowser.BrowserArb;
import oracle.ideimpl.webbrowser.BrowserOptions;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.PlatformUtils;

public final class BrowserRunner
extends oracle.ide.webbrowser.BrowserRunner {
    private static final Logger LOG = Logger.getLogger(BrowserRunner.class.getName());
    private static String osName = System.getProperty("os.name", "Windows").toLowerCase();
    private static final String DEFAULT_BROWSER_KEY_ON_VISTA = "Software\\Microsoft\\Windows\\Shell\\Associations\\UrlAssociations\\http\\UserChoice";
    private static final String DEFAULT_BROWSER_ATTR_ON_VISTA = "Progid";
    private static final String PROG_ID_KEY_PREFIX = "SOFTWARE\\Classes\\";
    private static final String PROG_ID_KEY_SUFFIX = "\\shell\\open\\command";
    private static final String OLD_DEFAULT_BROWSER_KEY = "Software\\Classes\\htmlfile\\shell\\open\\command";
    private static final String DEFAULT_BROWSER_KEY = "Software\\Classes\\http\\shell\\open\\command";
    private static final String APP_PATH_KEY_PREFIX = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\";
    private static final String START_MENU_INTERNET_PATH_KEY_PREFIX = "SOFTWARE\\Clients\\StartMenuInternet\\";
    private static final String START_MENU_INTERNET_PATH_KEY_SUFFIX = "\\shell\\open\\command";

    @Override
    public void runBrowserOnURL(URL url, File htmlFile, PrintWriter printWriter) {
        try {
            this.runBrowserOnURLImpl(url, htmlFile, printWriter);
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    @Override
    public void runBrowserOnURLV2(URL url, File htmlFile, PrintWriter printWriter) throws Exception {
        this.runBrowserOnURLImpl(url, htmlFile, printWriter);
    }

    static boolean isPlatformWindows() {
        return File.separatorChar == '\\';
    }

    static boolean isPlatformWindowsMe() {
        return osName.startsWith("windows me");
    }

    static boolean isPlatformMac() {
        return osName.startsWith("mac") || osName.startsWith("darwin");
    }

    private void runBrowserOnURLImpl(URL url, File htmlFile, PrintWriter printWriter) throws Exception {
        Preferences prefs = Preferences.getPreferences();
        BrowserOptions opts = BrowserOptions.getInstance((PropertyStorage)prefs);
        String cmdPath = opts.getBrowserPathList().get(opts.getDefaultBrowserIndex()).toString();
        String cmdParams = opts.substituteURL(opts.getBrowserParamList().get(opts.getDefaultBrowserIndex()).toString(), url);
        String targetURLStr = BrowserRunner.getPlatformTargetURLString(url);
        if (ModelUtil.hasLength((String)cmdPath)) {
            BrowserRunner.runBrowserCommand(cmdPath, cmdParams, targetURLStr, printWriter);
        } else {
            LOG.severe("Cannot open URL " + url + " because the web browser command line is not valid (empty).");
        }
    }

    private static String getKeyValue(String key, boolean useUserHive) {
        return BrowserRunner.getKeyValue(key, null, useUserHive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getKeyValue(String key, String attr, boolean useUserHive) {
        block18: {
            String string;
            RegistryKey softwareKey = null;
            try {
                RegistryKey keyHive;
                RegistryKey registryKey = keyHive = useUserHive ? NativeHandler.getRegistry().getCurrentUserKey() : NativeHandler.getRegistry().getLocalMachineKey();
                if (keyHive == null) {
                    String string2 = null;
                    return string2;
                }
                softwareKey = keyHive.openKey(key, 131097L);
                if (softwareKey == null) break block18;
                string = softwareKey.getStringValue(attr);
            }
            catch (Exception exception) {
                break block18;
            }
            finally {
                if (softwareKey != null) {
                    try {
                        softwareKey.close();
                    }
                    catch (RegistryException registryException) {}
                }
            }
            return string;
        }
        return null;
    }

    protected static String getWindowsDefaultBrowserPath() {
        String defaultBrowserPath = BrowserRunner.getKeyValue(DEFAULT_BROWSER_KEY, true);
        if (defaultBrowserPath == null) {
            defaultBrowserPath = BrowserRunner.getKeyValue(DEFAULT_BROWSER_KEY, false);
        }
        if (defaultBrowserPath == null) {
            defaultBrowserPath = BrowserRunner.getKeyValue(OLD_DEFAULT_BROWSER_KEY, false);
        }
        if (PlatformUtils.isWindows() && !PlatformUtils.isWindowsNT() && !PlatformUtils.isWindows2K() && !PlatformUtils.isWindowsXP()) {
            String defaultBrowserProgId = BrowserRunner.getKeyValue(DEFAULT_BROWSER_KEY_ON_VISTA, DEFAULT_BROWSER_ATTR_ON_VISTA, true);
            String progIdKey = PROG_ID_KEY_PREFIX + defaultBrowserProgId + "\\shell\\open\\command";
            String defaultBrowserPathOnVista = BrowserRunner.getKeyValue(progIdKey, false);
            if (defaultBrowserPathOnVista != null) {
                defaultBrowserPath = defaultBrowserPathOnVista;
            }
        }
        return defaultBrowserPath;
    }

    protected static String getWindowsBrowserPath(String startMenuInternetName, String appPathName) {
        String path = null;
        String startMenuInternetKey = START_MENU_INTERNET_PATH_KEY_PREFIX + startMenuInternetName + "\\shell\\open\\command";
        path = BrowserRunner.getKeyValue(startMenuInternetKey, true);
        if (path == null) {
            path = BrowserRunner.getKeyValue(startMenuInternetKey, false);
        }
        if (path == null) {
            String appPathKey = APP_PATH_KEY_PREFIX + appPathName;
            path = BrowserRunner.getKeyValue(appPathKey, false);
        }
        if (path != null && (path = path.trim()).startsWith("\"") && path.endsWith("\"")) {
            path = path.substring(1, path.length() - 1);
        }
        return path;
    }

    static String getPlatformTargetURLString(URL url) {
        String targetURLStr = BrowserRunner.isPlatformWindows() ? ("file".equalsIgnoreCase(url.getProtocol()) ? URLFileSystem.toDisplayString((URL)url) : URLFileSystem.toEncodedString((URL)url, (String)"UTF-8")) : (BrowserRunner.isPlatformMac() ? URLFileSystem.toDisplayString((URL)url) : URLFileSystem.toEncodedString((URL)url, (String)"UTF-8"));
        return targetURLStr;
    }

    private static void runBrowserCommand(String browserCmdPath, String browserCmdParams, String targetURLStr, PrintWriter printWriter) throws Exception {
        ArrayList<String> execCmdList = new ArrayList<String>(5);
        execCmdList.add(browserCmdPath);
        String[] a = IdeUtil.convertStringToStringArray((String)browserCmdParams, (boolean)true, (boolean)false);
        int length = a.length;
        for (int i = 0; i < length; ++i) {
            execCmdList.add(a[i]);
        }
        BrowserRunner.runBrowserCommandImpl(execCmdList, targetURLStr, printWriter);
    }

    private static void runBrowserCommandImpl(ArrayList execCmdList, String targetURLStr, PrintWriter printWriter) throws Exception {
        BrowserRunner.runBrowserCommandImpl(execCmdList, targetURLStr, printWriter, true);
    }

    private static boolean execCmdListContainsTargetUrl(ArrayList<String> execCmdList, String targetURLStr) {
        if (execCmdList == null) {
            return false;
        }
        for (String execCmd : execCmdList) {
            if (!execCmd.contains(targetURLStr)) continue;
            return true;
        }
        return false;
    }

    private static void runBrowserCommandImpl(ArrayList execCmdList, String targetURLStr, PrintWriter printWriter, Boolean reportExceptionDialog) throws Exception {
        try {
            if (!BrowserRunner.execCmdListContainsTargetUrl(execCmdList, targetURLStr)) {
                execCmdList.add(targetURLStr);
            }
            String[] cmdArray = BrowserRunner.toCommandArray(execCmdList);
            Process process = Runtime.getRuntime().exec(cmdArray);
            BrowserRunner.handleOutput(process, printWriter);
        }
        catch (Exception e) {
            if (reportExceptionDialog.booleanValue()) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e, (String)BrowserArb.getString(69), (String)BrowserArb.getString(70));
            }
            throw e;
        }
    }

    private static void handleOutput(Process process, PrintWriter printWriter) throws Exception {
        ProcessOutput poErr = new ProcessOutput(process.getErrorStream(), printWriter);
        new Thread((Runnable)poErr, "BrowserProcessErr").start();
        ProcessOutput poOut = new ProcessOutput(process.getInputStream(), printWriter);
        new Thread((Runnable)poOut, "BrowserProcessOut").start();
    }

    private static String[] toCommandArray(ArrayList cmdList) {
        String[] cmdArray = cmdList.toArray(new String[cmdList.size()]);
        return ExecUtil.cleanUpCommand((String[])cmdArray);
    }

    private static final class ProcessOutput
    implements Runnable {
        private BufferedReader _in;
        private PrintWriter _printWriter;

        ProcessOutput(InputStream in, PrintWriter printWriter) throws IOException {
            this._in = new BufferedReader(new InputStreamReader(in));
            this._printWriter = printWriter != null ? printWriter : new DefaultPrintWriter();
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this._in.readLine()) != null) {
                    this._printWriter.println(line);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (this._in != null) {
                    try {
                        this._in.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

