/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import oracle.ide.model.Project;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.model.FeaturesPanel;

public final class TechnologiesPanel
extends ProjectSettingsTraversablePanel {
    public static final String TECHNOLOGY_SCOPE_DATA_KEY = "technologyScope";
    public static final String SELECTED_TECH_SCOPES = "selectedTechnologies";
    private static final String HELP_ID = "f1_idedprojsettechnologyscopedpp_html";
    private static final String[] PROPERTY_KEYS = new String[]{"technologyScope"};
    private FeaturesPanel _featuresPanel;
    private boolean _featuresAreEditable;
    private transient TechId[] _fixedTechnologies = new TechId[0];

    public TechnologiesPanel() {
        this.setHelpID(HELP_ID);
        this.setLayout(new BorderLayout());
    }

    public void setUnremoveableTechnologies(TechId ... techIds) {
        this._fixedTechnologies = techIds;
    }

    public void setFeaturesAreEditable(boolean editable) {
        this._featuresAreEditable = editable;
    }

    public void onProjectPanelEntry(TraversableContext tc) {
        if (this._featuresPanel != null) {
            this.remove((Component)((Object)this._featuresPanel));
        }
        this._featuresPanel = this.createFeaturesPanelForContext(tc);
        this._featuresPanel.onEntry(tc);
        this.add((Component)((Object)this._featuresPanel), "Center");
        this.validate();
    }

    public void onExit(TraversableContext tc) {
        this.putTechnologyScopeToContext(tc, this._featuresPanel.getTechnologyScope());
    }

    public String getDataKey() {
        return TechnologyScopeConfiguration.DATA_KEY;
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    public TechId[] getSelectedTechnologies() {
        TechnologyScope scope = this._featuresPanel.getTechnologyScope();
        return scope != null ? scope.toArray() : new TechId[]{};
    }

    private TechnologyScope getTechnologyScopeFromContext(TraversableContext tc) {
        PropertyStorage propertyData;
        TechnologyScope scope = (TechnologyScope)tc.getDesignTimeObject(TECHNOLOGY_SCOPE_DATA_KEY);
        if (scope != null) {
            return scope;
        }
        Object object = propertyData = tc.find("PropertyData") != null ? TechnologiesPanel.getPropertyData((Namespace)tc) : (Project)tc.find("Project");
        if (propertyData != null) {
            TechnologyScopeConfiguration techScopeConfiguration = TechnologyScopeConfiguration.getInstance((PropertyStorage)propertyData);
            return techScopeConfiguration.getTechnologyScope();
        }
        return null;
    }

    private void putTechnologyScopeToContext(TraversableContext tc, TechnologyScope scope) {
        PropertyStorage propertyData;
        if (tc.getDesignTimeObject(TECHNOLOGY_SCOPE_DATA_KEY) != null) {
            tc.putDesignTimeObject(TECHNOLOGY_SCOPE_DATA_KEY, (Object)scope);
            return;
        }
        Object object = propertyData = tc.find("PropertyData") != null ? TechnologiesPanel.getPropertyData((Namespace)tc) : (Project)tc.find("Project");
        if (propertyData != null) {
            TechnologyScopeConfiguration techScopeConfiguration = TechnologyScopeConfiguration.getInstance((PropertyStorage)propertyData);
            techScopeConfiguration.setTechnologyScope(scope);
        }
    }

    private FeaturesPanel createFeaturesPanelForContext(TraversableContext tc) {
        PropertyChangeListener[] listeners;
        FeaturesPanel panel;
        FeaturesPanel.EditMode editMode;
        TechnologyScope scope = this.getTechnologyScopeFromContext(tc);
        tc.put(TECHNOLOGY_SCOPE_DATA_KEY, (Object)scope);
        TechId[] techIds = scope.toArray();
        tc.put(SELECTED_TECH_SCOPES, (Object)techIds);
        tc.put("fixedTechnologies", (Object)this._fixedTechnologies);
        if (tc.find("PropertyData") != null) {
            editMode = TechnologiesPanel.isDefaultProject((Namespace)tc) ? FeaturesPanel.EditMode.READ_ONLY : FeaturesPanel.EditMode.DEFERRED_EDIT_WITH_UPDATE;
            panel = new FeaturesPanel(editMode);
            String projPropsKey = "project-properties-fixed-feature-list";
            if (!tc.contains("project-properties-fixed-feature-list")) {
                tc.put("project-properties-fixed-feature-list", (Object)techIds);
            }
            tc.put("fixedTechnologies", tc.get("project-properties-fixed-feature-list"));
        } else {
            editMode = this._featuresAreEditable ? FeaturesPanel.EditMode.EDITABLE : FeaturesPanel.EditMode.READ_ONLY;
            panel = new FeaturesPanel(editMode);
        }
        for (PropertyChangeListener l : listeners = super.getPropertyChangeListeners(SELECTED_TECH_SCOPES)) {
            panel.addPropertyChangeListener(SELECTED_TECH_SCOPES, l);
        }
        return panel;
    }

    public void addTechnologyPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("The listener cannot be null.");
        }
        super.addPropertyChangeListener(SELECTED_TECH_SCOPES, listener);
    }

    public void removeTechnologyPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("The listener cannot be null.");
        }
        super.removePropertyChangeListener(listener);
        if (this._featuresPanel != null) {
            this._featuresPanel.removePropertyChangeListener(listener);
        }
    }
}

