/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.ghost;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.MouseInputAdapter;
import oracle.javatools.ui.CloseButton;
import oracle.javatools.ui.ghost.ComponentConverter;
import oracle.javatools.ui.ghost.GhostBorder;
import oracle.javatools.ui.ghost.GhostTitle;
import oracle.javatools.ui.ghost.UIConstants;

public class GhostPalette
extends JLayeredPane {
    public static final String PROPERTY_IS_CLOSING = "is-closing";
    protected float fadeAmount = 0.0f;
    private Timer aniTimer;
    private static int FADE_DURATION = 125;
    private static int FADE_FRAMES = 10;
    private static final int CLOSE_WIDTH = 30;
    private final ResizeL resizeListener = new ResizeL();
    private final CloseButton closeButton = new CloseButton();
    private final FocusTracker focusTracker = new FocusTracker();
    private boolean redirectToContent = false;
    private GhostTitle titleComp;
    private static String CONTROL_KEY = "CONTROL_KEY";
    private boolean hideOnLoseFocus = true;
    private boolean receivesFocus = true;
    private boolean isMovable = true;
    private boolean isResizable = true;
    private OwningL owningL = new OwningL();
    protected final JPanel container = new JPanel(new BorderLayout(0, 2));
    protected UIConstants.Look look = UIConstants.Look.LIGHT;
    private JComponent owningComp;
    private List<JComponent> clearList = new ArrayList<JComponent>();

    public GhostPalette() {
        this.init(null);
    }

    public GhostPalette(String title) {
        this.init(title);
    }

    public GhostPalette(JComponent owningComponent) {
        this.init(null);
        this.setOwningComponent(owningComponent);
    }

    private void init(String title) {
        this.setLayout(null);
        this.setOpaque(false);
        this.titleComp = new GhostTitle(this.getLook());
        this.add((Component)this.titleComp, new Integer(JLayeredPane.POPUP_LAYER - 10));
        this.setTitle(title);
        this.setBorder(new GhostBorder());
        this.container.setOpaque(false);
        this.closeButton.setSize(20, 20);
        this.closeButton.setFocusable(false);
        this.add((Component)this.closeButton, new Integer(JLayeredPane.POPUP_LAYER - 10));
        this.setFocusCycleRoot(true);
        this.add(this.container);
        this.addMouseListener(this.resizeListener);
        this.addMouseMotionListener(this.resizeListener);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) > 0L && GhostPalette.this.isShowing()) {
                    GhostPalette.this.updateChildUIs();
                }
            }
        });
        this.setBackground(UIConstants.getColor("ghost.panel.background", UIConstants.Look.LIGHT));
        this.closeButton.addMouseListener(new MouseAdapter(){
            private boolean possibleClick = false;

            @Override
            public void mouseClicked(MouseEvent e) {
                GhostPalette.this.closeButtonClicked();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.possibleClick = true;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.possibleClick = false;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.possibleClick) {
                    GhostPalette.this.closeButtonClicked();
                }
                this.possibleClick = false;
            }
        });
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
        String ESCAPE_KEY = "ESCAPE_KEY";
        this.getInputMap(1).put(escape, ESCAPE_KEY);
        this.getActionMap().put(ESCAPE_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GhostPalette.this.closeButtonClicked();
            }
        });
        this.setupTemporaryHide();
        this.redirectToContent = true;
    }

    @Deprecated
    public void allowTemporaryHide() {
        this.setupTemporaryHide();
    }

    protected void setupTemporaryHide() {
        KeyStroke hide = KeyStroke.getKeyStroke(18, 512);
        KeyStroke hideCtrl = KeyStroke.getKeyStroke(18, 640);
        String HIDE_KEY = "HIDE_KEY";
        this.container.getInputMap(2).put(hide, HIDE_KEY);
        this.container.getInputMap(2).put(hideCtrl, HIDE_KEY);
        this.container.getActionMap().put(HIDE_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GhostPalette.this.fadeAmount = 0.1f;
                GhostPalette.this.repaintVisible();
            }
        });
        KeyStroke showUp = KeyStroke.getKeyStroke(18, 0, true);
        KeyStroke showUpShift = KeyStroke.getKeyStroke(18, 64, true);
        KeyStroke showUpCtrl = KeyStroke.getKeyStroke(18, 128, true);
        String SHOW_UP_KEY = "SHOW_UP_KEY";
        this.container.getInputMap(2).put(showUp, SHOW_UP_KEY);
        this.container.getInputMap(2).put(showUpShift, SHOW_UP_KEY);
        this.container.getInputMap(2).put(showUpCtrl, SHOW_UP_KEY);
        this.container.getActionMap().put(SHOW_UP_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GhostPalette.this.fadeAmount = 1.0f;
                GhostPalette.this.repaintVisible();
            }
        });
    }

    public JComponent getOwningComponent() {
        return this.owningComp;
    }

    public void setOwningComponent(JComponent owningComponent) {
        if (this.owningComp != null) {
            this.owningComp.removeComponentListener(this.owningL);
            this.owningComp.removeAncestorListener(this.owningL);
        }
        this.owningComp = owningComponent;
        if (this.owningComp != null) {
            this.owningComp.addComponentListener(this.owningL);
            this.owningComp.addAncestorListener(this.owningL);
        }
    }

    public void setHideOnControlUp(boolean hide) {
        KeyStroke control = KeyStroke.getKeyStroke(17, 0, true);
        if (hide) {
            this.container.getInputMap(2).put(control, CONTROL_KEY);
            this.container.getActionMap().put(CONTROL_KEY, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GhostPalette.this.hidePanel();
                }
            });
        } else {
            this.container.getInputMap(2).remove(control);
            this.container.getActionMap().remove(CONTROL_KEY);
        }
    }

    protected void closeButtonClicked() {
        boolean isVetoed = false;
        try {
            this.fireVetoableChange(PROPERTY_IS_CLOSING, false, true);
        }
        catch (PropertyVetoException pve) {
            isVetoed = true;
        }
        if (!isVetoed) {
            this.hidePanel();
        }
    }

    public void hidePanel() {
        this.hidePanel(true);
    }

    private void hidePanel(boolean resetFocus) {
        if (resetFocus && this.owningComp != null) {
            this.owningComp.dispatchEvent(new FocusEvent(this.owningComp, 1004));
        }
        this.setVisible(false);
    }

    public void registerTransparentComponent(JComponent comp) {
        if (!this.clearList.contains(comp)) {
            this.clearList.add(comp);
        }
    }

    public void unregisterTransparentComponent(JComponent comp) {
        this.clearList.remove(comp);
    }

    List<JComponent> getTransparentComponents() {
        return new ArrayList<JComponent>(this.clearList);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        Border b = this.getBorder();
        if (b != null) {
            Insets i = b.getBorderInsets(this);
            this.container.setBounds(i.left, i.top, w - i.left - i.right, h - i.top - i.bottom);
        } else {
            this.container.setBounds(0, 0, w, h);
        }
        this.invalidate();
    }

    public void setCloseVisible(boolean visible) {
        this.closeButton.setVisible(visible);
    }

    public boolean isCloseVisible() {
        return this.closeButton.isVisible();
    }

    private void positionChrome() {
        int x = this.getWidth() - this.getBorder().getBorderInsets((Component)this).right - 14;
        int y = 6;
        this.closeButton.setLocation(x, y);
        int maxLabelWidth = this.getWidth() - 30;
        this.titleComp.setSize(this.titleComp.getPreferredSize());
        if (this.closeButton.isVisible()) {
            this.titleComp.setSize(maxLabelWidth, this.titleComp.getHeight());
        }
        Insets insets = this.getBorder().getBorderInsets(this);
        this.titleComp.setLocation(insets.left + 2, 7);
    }

    private void updateChildUIs() {
        ComponentConverter.convertToGhost(this.container, this.look);
    }

    public void setLook(UIConstants.Look look) {
        this.look = look;
        this.container.setBackground(UIConstants.getColor("ghost.panel.background", look));
        this.titleComp.setForeground(UIConstants.getColor("ghost.title.foreground", this.getLook()));
        this.titleComp.setFont(UIConstants.getFont("ghost.title.font", this.getLook()));
    }

    public UIConstants.Look getLook() {
        return this.look;
    }

    public JComponent getContentPanel() {
        return this.container;
    }

    public static JLayeredPane getActiveLayeredPane() {
        Window activeW = null;
        for (Window w : Window.getWindows()) {
            if (!w.isActive()) continue;
            activeW = w;
            break;
        }
        if (activeW instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)activeW)).getLayeredPane();
        }
        return null;
    }

    public void show(boolean positionInLayer, boolean fadeIn) {
        JLayeredPane lp = GhostPalette.getActiveLayeredPane();
        if (lp == null) {
            return;
        }
        this.positionPanel(lp, positionInLayer);
        this.makeVisible(fadeIn);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.dispose();
        }
    }

    public void show(JLayeredPane layeredPane, boolean positionInLayer, boolean fadeIn) {
        if (layeredPane == null) {
            throw new IllegalArgumentException("layeredPane is null");
        }
        this.positionPanel(layeredPane, positionInLayer);
        this.makeVisible(fadeIn);
    }

    protected void positionPanel(JLayeredPane layeredPane, boolean positionInLayer) {
        int x;
        if (positionInLayer) {
            this.positionInLayer(layeredPane);
        }
        int width = Math.min(this.getWidth(), layeredPane.getWidth());
        int height = Math.min(this.getHeight(), layeredPane.getHeight());
        this.setSize(width, height);
        int fh = layeredPane.getHeight();
        int fw = layeredPane.getWidth();
        int y = this.getY();
        if (y + this.getHeight() > fh) {
            y = Math.max(0, fh - this.getHeight());
        }
        if ((x = this.getX()) + this.getWidth() > fw) {
            x = Math.max(0, fw - this.getWidth());
        }
        if (y != this.getY() || x != this.getX()) {
            this.setLocation(x, y);
        }
        layeredPane.add((Component)this, new Integer(JLayeredPane.POPUP_LAYER - 3));
        this.positionChrome();
    }

    protected void makeVisible(boolean fadeIn) {
        if (fadeIn) {
            this.fadeInOut(true);
        } else {
            this.fadeAmount = 1.0f;
        }
        if (this.receivesFocus) {
            this.container.transferFocus();
            if (GhostTitle.isAssistiveTechnologySet()) {
                try {
                    this.titleComp.requestFocus();
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            Timer t = new Timer(250, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (GhostPalette.this.isShowing()) {
                        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                        focusManager.addPropertyChangeListener(GhostPalette.this.focusTracker);
                    }
                }
            });
            t.setRepeats(false);
            t.start();
        }
    }

    private void positionInLayer(JLayeredPane layeredPane) {
        int x = layeredPane.getWidth() / 2 - this.getWidth() / 2;
        int y = 2 * (layeredPane.getHeight() / 5) - this.getHeight() / 2;
        y = Math.max(0, y);
        x = Math.max(0, x);
        this.setLocation(x, y);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.removePropertyChangeListener(this.focusTracker);
    }

    protected void dispose() {
        Container parent;
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.removePropertyChangeListener(this.focusTracker);
        if (this.owningComp != null) {
            this.owningComp.removeComponentListener(this.owningL);
            this.owningComp.removeAncestorListener(this.owningL);
            this.owningComp = null;
        }
        if ((parent = this.getParent()) != null) {
            parent.remove(this);
            parent.repaint(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    public void fadeInOut(boolean visible) {
        this.fadeInOut(visible, true);
    }

    private void fadeInOut(final boolean visible, final boolean resetFocus) {
        int fadeStep = FADE_DURATION / FADE_FRAMES;
        final long initialTime = System.currentTimeMillis();
        if (this.aniTimer == null) {
            this.aniTimer = new Timer(fadeStep, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    long elapsed = System.currentTimeMillis() - initialTime;
                    GhostPalette.this.fadeAmount = (float)elapsed / (float)FADE_DURATION;
                    if (!visible) {
                        GhostPalette.this.fadeAmount = 1.0f - GhostPalette.this.fadeAmount;
                    }
                    if (GhostPalette.this.fadeAmount <= 0.0f) {
                        GhostPalette.this.fadeAmount = 0.0f;
                        if (GhostPalette.this.isShowing()) {
                            GhostPalette.this.hidePanel(resetFocus);
                        }
                        GhostPalette.this.aniTimer.stop();
                        GhostPalette.this.aniTimer = null;
                    } else if (GhostPalette.this.fadeAmount >= 1.0f) {
                        GhostPalette.this.fadeAmount = 1.0f;
                        GhostPalette.this.aniTimer.stop();
                        GhostPalette.this.aniTimer = null;
                    }
                    if (GhostPalette.this.isShowing()) {
                        GhostPalette.this.repaintVisible();
                    }
                }
            });
            this.aniTimer.setCoalesce(true);
            if (!this.aniTimer.isRunning()) {
                this.aniTimer.restart();
            }
        }
    }

    protected void repaintVisible() {
        this.repaint();
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.redirectToContent) {
            this.container.add(comp, constraints, index);
        } else {
            super.addImpl(comp, constraints, index);
        }
    }

    @Override
    public void remove(Component comp) {
        if (this.redirectToContent) {
            this.container.remove(comp);
        } else {
            super.remove(comp);
        }
    }

    public void pack() {
        Dimension newSize = new Dimension(this.container.getPreferredSize().width, this.container.getPreferredSize().height);
        if (this.getTitle() != null) {
            int titleWidth = this.titleComp.getPreferredSize().width + 4;
            if (this.isCloseVisible()) {
                titleWidth += 30;
            }
            newSize.width = Math.max(newSize.width, titleWidth);
        }
        Insets borderInsets = this.getBorder() != null ? this.getBorder().getBorderInsets(this) : new Insets(0, 0, 0, 0);
        newSize.height += borderInsets.top + borderInsets.bottom;
        newSize.width += borderInsets.left + borderInsets.right;
        this.setSize(newSize.width, newSize.height);
        this.setPreferredSize(new Dimension(newSize.width, newSize.height));
        this.positionChrome();
        this.validate();
        this.revalidate();
    }

    @Override
    public void setLayout(LayoutManager manager) {
        if (this.redirectToContent) {
            this.container.setLayout(manager);
        } else {
            super.setLayout(manager);
        }
    }

    @Override
    public void add(Component comp, Object constraints) {
        if (this.redirectToContent) {
            this.container.setVisible(true);
            this.container.add(comp, constraints);
        } else {
            super.add(comp, constraints);
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.fadeAmount >= 0.0f && this.fadeAmount < 1.0f) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setComposite(AlphaComposite.getInstance(3, this.fadeAmount));
        }
        if (this.getBorder() != null) {
            this.getBorder().paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(g);
    }

    public void setTitle(String title) {
        this.titleComp.setText(title);
        this.titleComp.setVisible(title != null);
    }

    public String getTitle() {
        String title = this.titleComp.getText();
        if (title == null || title.length() == 0) {
            title = null;
        }
        return title;
    }

    float getFadeAmount() {
        return this.fadeAmount;
    }

    public void setReceivesFocus(boolean receivesFocus) {
        this.receivesFocus = receivesFocus;
    }

    public boolean getReceivesFocus() {
        return this.receivesFocus;
    }

    public void setHideOnLoseFocus(boolean newhideOnLoseFocus) {
        this.hideOnLoseFocus = newhideOnLoseFocus;
    }

    public boolean isHideOnLoseFocus() {
        return this.hideOnLoseFocus;
    }

    public void setMovable(boolean isMovable) {
        this.isMovable = isMovable;
    }

    public boolean isMovable() {
        return this.isMovable;
    }

    public void setResizable(boolean isResizable) {
        this.isResizable = isResizable;
    }

    public boolean isResizable() {
        return this.isResizable;
    }

    private class OwningL
    extends ComponentAdapter
    implements AncestorListener {
        private OwningL() {
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            GhostPalette.this.dispose();
        }

        public void componentHidden() {
            GhostPalette.this.dispose();
        }
    }

    protected class ContentPanel
    extends JPanel {
        public ContentPanel() {
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.putClientProperty(UIConstants.VETO_CONVERSION, true);
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            float alpha = 0.93f * GhostPalette.this.fadeAmount;
            g2.setComposite(AlphaComposite.getInstance(3, alpha));
            g.setColor(this.getBackground());
            g.fillRect(0, 0 - this.getInsets().top, this.getWidth(), this.getHeight() + this.getInsets().top + this.getInsets().bottom);
            super.paint(g);
        }
    }

    private class FocusTracker
    implements PropertyChangeListener {
        private FocusTracker() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (!(e.getNewValue() instanceof Component)) {
                return;
            }
            Component c = (Component)e.getNewValue();
            if (e.getNewValue() != null && e.getNewValue() != GhostPalette.this.titleComp && e.getNewValue() != SwingUtilities.windowForComponent(GhostPalette.this) && !SwingUtilities.isDescendingFrom(c, GhostPalette.this)) {
                if (GhostPalette.this.hideOnLoseFocus) {
                    Window w;
                    KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    Component co = focusManager.getPermanentFocusOwner();
                    Window cow = co == null ? null : SwingUtilities.windowForComponent(co);
                    Window window = w = GhostPalette.this.owningComp == null ? null : SwingUtilities.windowForComponent(GhostPalette.this.owningComp);
                    if (co == focusManager.getFocusOwner() && w == cow && co != null && cow != null) {
                        GhostPalette.this.fadeInOut(false, false);
                    }
                } else {
                    GhostPalette.this.fadeAmount = 1.0f;
                }
            }
        }
    }

    private class ResizeL
    extends MouseInputAdapter {
        private int resizeEdge = -1;
        private Point dragPoint;
        private Point loc;

        private ResizeL() {
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            int x = me.getX();
            int y = me.getY();
            int activeArea = 6;
            int rightEdge = GhostPalette.this.getWidth() - activeArea - 6;
            int footerOuter = GhostPalette.this.getHeight() - 6;
            int topOuter = 0;
            int topInner = topOuter + activeArea;
            int footerInner = footerOuter - activeArea;
            if (GhostPalette.this.isResizable && (x < activeArea * 2 && y > topOuter && y < topInner || x < activeArea && y > topOuter && y < topInner + activeArea)) {
                this.resizeEdge = 8;
                GhostPalette.this.setCursor(Cursor.getPredefinedCursor(6));
            } else if (GhostPalette.this.isResizable && (x < activeArea * 2 && y > footerInner && y < footerOuter || x < activeArea && y > footerInner - activeArea && y < footerOuter)) {
                this.resizeEdge = 6;
                GhostPalette.this.setCursor(Cursor.getPredefinedCursor(4));
            } else if (GhostPalette.this.isResizable && (x > rightEdge - activeArea && x < GhostPalette.this.getWidth() - 6 && y > topOuter && y < topInner || x > rightEdge && y > topOuter && y < topInner + activeArea)) {
                this.resizeEdge = 2;
                GhostPalette.this.setCursor(Cursor.getPredefinedCursor(7));
            } else if (GhostPalette.this.isResizable && (x > rightEdge - activeArea * 2 && x < GhostPalette.this.getWidth() - 6 && y > footerInner && y < footerOuter || x > rightEdge && y > footerInner - activeArea && y < footerOuter)) {
                this.resizeEdge = 4;
                GhostPalette.this.setCursor(Cursor.getPredefinedCursor(5));
            } else if (GhostPalette.this.isResizable && y > topOuter && y < topInner) {
                this.resizeEdge = 1;
                GhostPalette.this.setCursor(Cursor.getPredefinedCursor(8));
            } else if (GhostPalette.this.isResizable && y > footerInner && y < footerOuter) {
                this.resizeEdge = 5;
                GhostPalette.this.setCursor(Cursor.getPredefinedCursor(9));
            } else if (GhostPalette.this.isResizable && x < activeArea && y < footerInner && y > topInner) {
                this.resizeEdge = 7;
                GhostPalette.this.setCursor(Cursor.getPredefinedCursor(10));
            } else if (GhostPalette.this.isResizable && x > rightEdge && x < GhostPalette.this.getWidth() - 6 && y < footerInner && y > topInner) {
                this.resizeEdge = 3;
                GhostPalette.this.setCursor(Cursor.getPredefinedCursor(11));
            } else if (GhostPalette.this.isMovable) {
                this.resizeEdge = 0;
                GhostPalette.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mouseExited(MouseEvent me) {
            if (this.loc == null) {
                this.resizeEdge = -1;
                GhostPalette.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (me.getButton() == 1) {
                Point mp = me.getPoint();
                SwingUtilities.convertPointToScreen(mp, GhostPalette.this);
                this.loc = GhostPalette.this.getLocationOnScreen();
                this.dragPoint = new Point(mp.x - this.loc.x, mp.y - this.loc.y);
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (me.getButton() == 1) {
                this.loc = null;
                this.dragPoint = null;
            }
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            Point mp = me.getPoint();
            SwingUtilities.convertPointToScreen(mp, GhostPalette.this);
            if (this.loc == null || GhostPalette.this.getParent() == null) {
                return;
            }
            int x = this.loc.x;
            int y = this.loc.y;
            int w = GhostPalette.this.getSize().width;
            int h = GhostPalette.this.getSize().height;
            switch (this.resizeEdge) {
                case 1: {
                    h += this.loc.y - mp.y;
                    this.loc.y = mp.y;
                    break;
                }
                case 8: {
                    h += this.loc.y - mp.y;
                    w += this.loc.x - mp.x;
                    this.loc.y = mp.y;
                    this.loc.x = mp.x;
                    break;
                }
                case 2: {
                    h += this.loc.y - mp.y;
                    w = mp.x - this.loc.x + 6;
                    this.loc.y = mp.y;
                    break;
                }
                case 3: {
                    w = mp.x - this.loc.x + 6;
                    break;
                }
                case 7: {
                    w += this.loc.x - mp.x;
                    this.loc.x = mp.x;
                    break;
                }
                case 4: {
                    w = mp.x - this.loc.x + 6;
                    h = mp.y - this.loc.y + 6;
                    break;
                }
                case 6: {
                    w += this.loc.x - mp.x;
                    h = mp.y - this.loc.y + 6;
                    this.loc.x = mp.x;
                    break;
                }
                case 5: {
                    h = mp.y - this.loc.y + 6;
                    break;
                }
                case 0: {
                    this.loc.y = mp.y - this.dragPoint.y;
                    this.loc.x = mp.x - this.dragPoint.x;
                }
            }
            if (w < GhostPalette.this.getMinimumSize().width) {
                w = GhostPalette.this.getSize().width;
                this.loc.x = x;
            }
            if (w > GhostPalette.this.getMaximumSize().width) {
                w = GhostPalette.this.getSize().width;
                this.loc.x = x;
            }
            if (h < GhostPalette.this.getMinimumSize().height) {
                h = GhostPalette.this.getSize().height;
                this.loc.y = y;
            }
            if (h > GhostPalette.this.getMaximumSize().height) {
                h = GhostPalette.this.getSize().height;
                this.loc.y = y;
            }
            SwingUtilities.convertPointFromScreen(this.loc, GhostPalette.this.getParent());
            Rectangle r = new Rectangle(this.loc.x, this.loc.y, w, h);
            if (this.resizeEdge != 0) {
                r = r.intersection(GhostPalette.this.getParent().getBounds());
            } else {
                r.x = Math.max(0, r.x);
                r.y = Math.max(0, r.y);
                r.x = Math.min(GhostPalette.this.getParent().getWidth() - r.width, r.x);
                r.y = Math.min(GhostPalette.this.getParent().getHeight() - r.height, r.y);
            }
            Rectangle oldR = GhostPalette.this.getBounds();
            GhostPalette.this.setBounds(r);
            GhostPalette.this.positionChrome();
            GhostPalette.this.revalidate();
            this.loc = GhostPalette.this.getLocationOnScreen();
            GhostPalette.this.repaint(oldR);
            GhostPalette.this.repaintVisible();
        }
    }
}

