/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.builders;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.builders.BuiltCombo;
import oracle.javatools.ui.builders.ComboBuilder;
import oracle.javatools.ui.builders.ExAppBasicPanel;
import oracle.javatools.ui.list.GenericCheckListCellRenderer;
import oracle.javatools.ui.list.LabelListCellRenderer;
import oracle.javatools.util.CollectionEvent;
import oracle.javatools.util.CollectionListener;
import oracle.javatools.util.ListenableCollection;

class ExAppComboPanel
extends ExAppBasicPanel {
    private static BuiltCombo builtCombo;
    protected Label label = new Label();
    protected Hint hint = new Hint();
    protected Prompt prompt = new Prompt();
    private Selection selection = new Selection();
    private Editable editable = new Editable();
    private Checkable checkable = new Checkable();
    private Actions actions = new Actions();
    private SecondaryActions secondaryActions = new SecondaryActions();
    private Renderer renderer = new Renderer();
    private RenderUsingMethod renderusingmethod = new RenderUsingMethod();
    protected VisibleRows visiblerows = new VisibleRows();
    private int i = 0;
    private static final String[] ANIMALS;
    private static final String[] COLORS;

    ExAppComboPanel() {
    }

    @Override
    protected JComponent createControlPanel() {
        JPanel controlPanel = new JPanel((LayoutManager)new MigLayout("aligny top, nogrid, ins 5 5 5 16, gapy 2"));
        JButton buildButton = new JButton("Build");
        buildButton.setFont(buildButton.getFont().deriveFont(1));
        buildButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExAppComboPanel.this.build();
            }
        });
        controlPanel.add((Component)new JLabel("Select your configuration, then press:"), "gapbottom 16, span, split, gapx 2");
        controlPanel.add((Component)buildButton, "wrap");
        controlPanel.add((Component)ExAppComboPanel.headingLabel("Configuration"), "wrap");
        controlPanel.add((Component)new JLabel("Model:"), "");
        controlPanel.add((Component)MODEL_TYPE.combo, "wrap");
        controlPanel.add((Component)this.label.cb, "");
        controlPanel.add((Component)this.label.tf, "wrap");
        controlPanel.add((Component)this.hint.cb, "");
        controlPanel.add((Component)this.hint.tf, "wrap");
        controlPanel.add((Component)this.prompt.cb, "");
        controlPanel.add((Component)this.prompt.tf, "wrap");
        controlPanel.add((Component)this.selection.cb, "span, wrap");
        controlPanel.add((Component)this.editable.cb, "span, wrap");
        controlPanel.add((Component)this.checkable.cb, "");
        controlPanel.add((Component)this.checkable.b1, "");
        controlPanel.add((Component)this.checkable.b2, "");
        controlPanel.add((Component)this.checkable.initialcb, "wrap");
        controlPanel.add((Component)this.renderer.cb, "span, wrap");
        controlPanel.add((Component)new JLabel("Visible Rows:"), "");
        controlPanel.add((Component)this.visiblerows.sp, "span, wrap");
        controlPanel.add((Component)this.renderusingmethod.cb, "");
        controlPanel.add((Component)this.renderusingmethod.tf, "wrap");
        controlPanel.add((Component)this.actions.cb, "span, wrap");
        controlPanel.add((Component)this.secondaryActions.cb, "");
        controlPanel.add((Component)this.secondaryActions.cbIcon, "");
        controlPanel.add((Component)this.secondaryActions.nameLabel, "gapleft 8");
        controlPanel.add((Component)this.secondaryActions.tf, "wrap");
        return controlPanel;
    }

    protected void build() {
        ComboBuilder builder = new ComboBuilder();
        StringBuilder createSB = new StringBuilder("");
        StringBuilder selectSB = new StringBuilder("");
        MODEL_TYPE.build(builder, createSB, selectSB);
        this.visiblerows.build(builder, createSB, selectSB);
        this.checkable.build(builder, createSB, selectSB);
        this.selection.build(builder, createSB, selectSB);
        this.editable.build(builder, createSB, selectSB);
        this.renderer.build(builder, createSB, selectSB);
        this.renderusingmethod.build(builder, createSB, selectSB);
        this.label.build(builder, createSB, selectSB);
        this.hint.build(builder, createSB, selectSB);
        this.prompt.build(builder, createSB, selectSB);
        this.actions.build(builder, createSB, selectSB);
        this.secondaryActions.build(builder, createSB, selectSB);
        switch ((MODEL_TYPE)((Object)MODEL_TYPE.combo.getSelectedItem())) {
            case ARRAY: 
            case LIST: {
                createSB.append("\nBuiltCombo<String> builtCombo = builder.build();\n\nadd(builtCombo.getGUI());");
                break;
            }
            case OBJECT: {
                createSB.append("\nBuiltCombo<Locale> builtCombo = builder.build();\n\nadd(builtCombo.getGUI());");
            }
        }
        this.constructTextArea.setText(createSB.toString());
        this.constructTextArea.setCaretPosition(0);
        this.selectTextArea.setText(selectSB.toString());
        this.selectTextArea.setCaretPosition(0);
        builtCombo = builder.build();
        this.updateComponent(builtCombo.getGUI());
    }

    @Override
    protected void dump() {
        if (builtCombo == null) {
            return;
        }
        System.out.println("Dump as java.util.List (no parameter)");
        List list = builtCombo.getListModel();
        System.out.println(list);
        System.out.println();
        System.out.println("Dump as java.util.List<String>");
        List stringList = builtCombo.getListModel();
        System.out.println(stringList);
        System.out.println();
        System.out.println("Selected item");
        System.out.println(builtCombo.getSelectedValue().toString());
        System.out.println();
        System.out.println("---------------------------------");
    }

    static {
        ANIMALS = new String[]{"Cows", "Mice", "Monkeys", "Birds", "Lions", "Rats", "Rhinos", "Elephants", "Hippos", "Spiders", "Tigers", "Cats", "Dogs"};
        COLORS = new String[]{"Red", "Blue", "Magenta", "Violet", "Yellow", "Cyan", "Green", "Purple", "Mauve", "Beige", "Crimson", "Orange", "Puce"};
    }

    private class Hint {
        boolean def = false;
        JCheckBox cb = new JCheckBox("Hint", this.def);
        JTextField tf = new JTextField("This is a hint for the combo", 12);

        private Hint() {
        }

        void build(ComboBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (this.cb.isSelected() != this.def) {
                builder.setHint(this.tf.getText());
                createSB.append("builder.setHint(\"" + this.tf.getText() + "\");\n");
            }
        }
    }

    private class Prompt {
        boolean def = false;
        JCheckBox cb = new JCheckBox("Prompt", this.def);
        JTextField tf = new JTextField("This is a prompt for the combo", 12);

        private Prompt() {
        }

        void build(ComboBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (this.cb.isSelected() != this.def) {
                builder.setPrompt(this.tf.getText());
                createSB.append("builder.setPrompt(\"" + this.tf.getText() + "\");\n");
            }
        }
    }

    private class Label {
        boolean def = false;
        JCheckBox cb = new JCheckBox("Label", this.def);
        JTextField tf = new JTextField("&Label:", 12);

        private Label() {
            this.cb.setToolTipText("Add label for this component, set the text including a '&' for the Mnemonic");
        }

        void build(ComboBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (this.cb.isSelected() != this.def) {
                builder.setLabel(this.tf.getText());
                createSB.append("builder.setLabel(\"" + this.tf.getText() + "\");\n");
            }
        }
    }

    protected class VisibleRows {
        int def = 8;
        JSpinner sp = new JSpinner(new SpinnerNumberModel(this.def, 1, 20, 1));

        protected VisibleRows() {
            this.sp.setToolTipText("The default number of rows initially visible");
        }

        void build(ComboBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            int i = (Integer)this.sp.getValue();
            if (i != this.def) {
                builder.setVisibleRows(i);
                createSB.append("builder.setVisibleRows(" + i + ");\n");
            }
        }
    }

    private class Checkable {
        JCheckBox cb = new JCheckBox("Checkable");
        JCheckBox initialcb = new JCheckBox("Initial Checks");
        JButton b1 = new JButton("API: Check");
        JButton b2 = new JButton("API: UnCheck");
        ListenableCollection checkedCollection;

        private Checkable() {
            this.cb.setToolTipText("Make the combo items checkable");
            this.initialcb.setToolTipText("Check some items up front");
            this.b1.setEnabled(false);
            this.b2.setEnabled(false);
            this.b1.setToolTipText("API Call to check an item");
            this.b2.setToolTipText("API Call to uncheck an item");
            this.b1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object o = builtCombo.getJComboBox().getModel().getElementAt(0);
                    Checkable.this.checkedCollection.add(o);
                }
            });
            this.b2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object o = builtCombo.getJComboBox().getModel().getElementAt(0);
                    Checkable.this.checkedCollection.remove(o);
                }
            });
        }

        void build(ComboBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (this.cb.isSelected()) {
                this.b1.setEnabled(true);
                this.b2.setEnabled(true);
                createSB.append("ListenableCollection checkedItems = builder.setCheckable(initialCheckedItems);\n");
                selectSB.append("ListenableCollection checkedItems = builder.setCheckable(initialCheckedItems);\n");
                ArrayList<String> initialCheckedList = new ArrayList<String>();
                if (this.initialcb.isSelected()) {
                    MODEL_TYPE type = (MODEL_TYPE)((Object)MODEL_TYPE.combo.getSelectedItem());
                    if (type == MODEL_TYPE.ARRAY) {
                        initialCheckedList.add(ANIMALS[1]);
                        initialCheckedList.add(ANIMALS[3]);
                        initialCheckedList.add(ANIMALS[5]);
                    } else if (type == MODEL_TYPE.LIST) {
                        initialCheckedList.add(COLORS[1]);
                        initialCheckedList.add(COLORS[3]);
                        initialCheckedList.add(COLORS[5]);
                    }
                }
                this.checkedCollection = builder.setCheckable(initialCheckedList);
                this.checkedCollection.addListener((CollectionListener)new CollectionListener<String>(){

                    public void collectionChanged(CollectionEvent<String> event) {
                        System.out.print("Checked: ");
                        for (Object o : event.getSource()) {
                            System.out.print(o.toString() + " ");
                        }
                        System.out.println();
                    }
                });
            }
        }
    }

    private class Actions {
        JCheckBox cb = new JCheckBox("Actions");

        private Actions() {
            this.cb.setToolTipText("Make the combo editable");
        }

        void build(ComboBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (this.cb.isSelected()) {
                createSB.append("builder.setActions(addAction, removeAction);\n");
                AbstractAction addAction = new AbstractAction(){
                    {
                        this.putValue("SmallIcon", OracleIcons.getIcon((String)"add.png"));
                        this.putValue("ShortDescription", "Add");
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                    }
                };
                AbstractAction removeAction = new AbstractAction(){
                    {
                        this.putValue("SmallIcon", OracleIcons.getIcon((String)"delete.png"));
                        this.putValue("ShortDescription", "Remove");
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                    }
                };
                builder.setActions(addAction, removeAction);
            }
        }
    }

    private class SecondaryActions {
        JCheckBox cb = new JCheckBox("Secondary Actions");
        JCheckBox cbIcon = new JCheckBox("Icon");
        JTextField tf = new JTextField("&Actions", 14);
        JLabel nameLabel = new JLabel("Text:");

        private SecondaryActions() {
            this.cb.setToolTipText("Make the combo editable");
            this.cbIcon.setEnabled(false);
            this.tf.setEnabled(false);
            this.nameLabel.setEnabled(false);
            this.cb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SecondaryActions.this.cbIcon.setEnabled(SecondaryActions.this.cb.isSelected());
                    SecondaryActions.this.tf.setEnabled(SecondaryActions.this.cb.isSelected());
                    SecondaryActions.this.nameLabel.setEnabled(SecondaryActions.this.cb.isSelected());
                }
            });
        }

        void build(ComboBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (this.cb.isSelected()) {
                AbstractAction action1 = new AbstractAction(){
                    {
                        this.putValue("Name", "Item 1");
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                    }
                };
                AbstractAction action2 = new AbstractAction(){
                    {
                        this.putValue("Name", "Item 2");
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                    }
                };
                String name = this.tf.getText();
                if (!this.cbIcon.isSelected() && name.isEmpty()) {
                    createSB.append("builder.setActionsSecondary(action1, action2);\n");
                    builder.setActionsSecondary(action1, action2);
                } else {
                    createSB.append("builder.setActionsSecondary(");
                    if (name.isEmpty()) {
                        createSB.append("null, ");
                    } else {
                        createSB.append("\"" + name + "\", ");
                    }
                    if (!this.cbIcon.isSelected()) {
                        createSB.append("null,");
                    } else {
                        createSB.append("icon, ");
                    }
                    createSB.append(" action1, action2);\n");
                    if (name.isEmpty()) {
                        name = null;
                    }
                    Icon icon = this.cbIcon.isSelected() ? OracleIcons.getIcon((String)"configure.png") : null;
                    builder.setActionsSecondary(name, icon, action1, action2);
                }
            }
        }
    }

    private class Editable {
        JCheckBox cb = new JCheckBox("Editable");

        private Editable() {
            this.cb.setToolTipText("Make the combo editable");
        }

        void build(ComboBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (this.cb.isSelected()) {
                createSB.append("builder.setEditable(true);\n");
            }
            builder.setEditable(this.cb.isSelected());
        }
    }

    private class Selection {
        JCheckBox cb = new JCheckBox("Selection");

        private Selection() {
            this.cb.setToolTipText("Tell the combo which items should be initally selected");
        }

        void build(ComboBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (this.cb.isSelected()) {
                switch ((MODEL_TYPE)((Object)MODEL_TYPE.combo.getSelectedItem())) {
                    case LIST: {
                        builder.setSelection(COLORS[2]);
                        createSB.append("builder.setSelection(\"Magenta\");\n");
                        break;
                    }
                    case ARRAY: {
                        builder.setSelection(ANIMALS[2]);
                        createSB.append("builder.setSelection(\"Monkeys\");\n");
                    }
                }
            }
        }
    }

    private class RenderUsingMethod {
        boolean def = false;
        JCheckBox cb = new JCheckBox("Render Using Method: ", this.def);
        JTextField tf = new JTextField("getDisplayCountry", 16);

        private RenderUsingMethod() {
            this.cb.setToolTipText("Instead of writing a renderer, simply tell the builder which method on the item to call to get the text from");
            this.cb.setEnabled(MODEL_TYPE.combo.getSelectedItem() == MODEL_TYPE.OBJECT);
            this.tf.setEnabled(MODEL_TYPE.combo.getSelectedItem() == MODEL_TYPE.OBJECT);
            MODEL_TYPE.combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RenderUsingMethod.this.cb.setEnabled(MODEL_TYPE.combo.getSelectedItem() == MODEL_TYPE.OBJECT);
                    RenderUsingMethod.this.tf.setEnabled(MODEL_TYPE.combo.getSelectedItem() == MODEL_TYPE.OBJECT);
                }
            });
        }

        void build(ComboBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (this.cb.isEnabled() && this.cb.isSelected() != this.def) {
                builder.setRenderUsingMethod(this.tf.getText());
                createSB.append("builder.setRenderUsingMethod(\"" + this.tf.getText() + "\");\n");
            }
        }
    }

    private class Renderer {
        boolean def = false;
        JCheckBox cb = new JCheckBox("Renderer (for Locale)", this.def);

        private Renderer() {
            this.cb.setToolTipText("Set a renderer for the list");
            this.cb.setEnabled(MODEL_TYPE.combo.getSelectedItem() == MODEL_TYPE.OBJECT);
            MODEL_TYPE.combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Renderer.this.cb.setEnabled(MODEL_TYPE.combo.getSelectedItem() == MODEL_TYPE.OBJECT);
                }
            });
        }

        void build(ComboBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            if (this.cb.isEnabled() && this.cb.isSelected() != this.def) {
                builder.setRenderer((ListCellRenderer)((Object)(((ExAppComboPanel)ExAppComboPanel.this).checkable.cb.isSelected() ? new LocaleCheckRenderer() : new LocaleRenderer())));
                createSB.append("builder.setRenderer(" + (((ExAppComboPanel)ExAppComboPanel.this).checkable.cb.isSelected() ? "new LocaleCheckRenderer()" : "new LocaleRenderer()") + ");\n");
            }
        }

        private class LocaleCheckRenderer
        extends GenericCheckListCellRenderer<Locale> {
            private LocaleCheckRenderer() {
            }

            @Override
            public void formatCheckBox(JCheckBox checkBox, JList list, Locale value, int index, boolean isSelected, boolean cellHasFocus) {
                checkBox.setText(value.getDisplayLanguage());
            }
        }

        private class LocaleRenderer
        extends LabelListCellRenderer<Locale> {
            private LocaleRenderer() {
            }

            @Override
            public void formatLabel(JLabel label, JList list, Locale value, int index, boolean isSelected, boolean cellHasFocus) {
                label.setText(value.getDisplayLanguage());
            }
        }
    }

    private static enum MODEL_TYPE {
        NONE,
        ARRAY,
        LIST,
        OBJECT;

        private static JComboBox combo;

        public String toString() {
            switch (this) {
                case NONE: {
                    return "None";
                }
                case ARRAY: {
                    return "String[] (Animals)";
                }
                case LIST: {
                    return "java.util.List<String> (Colors)";
                }
                case OBJECT: {
                    return "Locale[]";
                }
            }
            return super.toString();
        }

        private static void build(ComboBuilder builder, StringBuilder createSB, StringBuilder selectSB) {
            switch ((MODEL_TYPE)((Object)combo.getSelectedItem())) {
                case NONE: {
                    createSB.append("ComboBuilder builder = new ComboBuilder();\n");
                    break;
                }
                case ARRAY: {
                    builder.setModel(ANIMALS);
                    createSB.append("ComboBuilder<String> builder = new ComboBuilder<String>();\n");
                    createSB.append("builder.setModel(array);\n");
                    selectSB.append("String animal = builtCombo.getSelectedValue();");
                    break;
                }
                case LIST: {
                    builder.setModel(Arrays.asList(COLORS));
                    createSB.append("ComboBuilder<String> builder = new ComboBuilder<String>();\n");
                    createSB.append("builder.setModel(list);\n");
                    selectSB.append("String color = builtCombo.getSelectedValue();");
                    break;
                }
                case OBJECT: {
                    Locale[] availableLocales = DateFormatSymbols.getAvailableLocales();
                    builder.setModel(availableLocales);
                    createSB.append("ComboBuilder<Locale> builder = new ComboBuilder<Locale>();\n");
                    createSB.append("builder.setModel(Locale.getAvailableLocales());\n");
                    selectSB.append("Locale locale = builtCombo.getSelectedValue();");
                }
            }
        }

        static {
            combo = new JComboBox<MODEL_TYPE>(MODEL_TYPE.values());
            combo.setSelectedIndex(1);
            combo.setToolTipText("The ComboBuilder takes arrays and java.util.Lists to save you writing a ListModel");
        }
    }
}

