/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.swing.util.UIUtils;
import oracle.bali.xml.model.XmlView;

public class ContextMenuListener
extends MouseAdapter {
    private static final int _POPUP_OFFSET_X = 3;
    private static final int _POPUP_OFFSET_Y = 3;
    private static final String _CLEAR_COMMAND = "clear";
    private final Component _owner;
    private final XmlGui _gui;

    public ContextMenuListener(Component owner, XmlGui gui) {
        this._owner = owner;
        this._gui = gui;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        JPopupMenu contextMenu = new JPopupMenu();
        if (e.isPopupTrigger()) {
            List actions = this._gui.getContextActions();
            for (Action action : actions) {
                XmlView view;
                List<Component> extraMenus;
                if (action.getValue("ActionCommandKey").equals(_CLEAR_COMMAND) && !(extraMenus = UIUtils.asComponentList((view = this._gui.getView()).getExtraContextMenus(view.getSelection().getCursorLocation()))).isEmpty()) {
                    contextMenu.add(new JPopupMenu.Separator());
                    for (Component comp : extraMenus) {
                        contextMenu.add(comp);
                    }
                    contextMenu.add(new JPopupMenu.Separator());
                }
                contextMenu.add(UIUtils.createMenuItem(action));
            }
            contextMenu.show(this._owner, e.getX() + 3, e.getY() + 3);
        }
    }
}

