/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.usages;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.usages.ServerLocation;
import oracle.dbtools.raptor.usages.ServerLocations;
import oracle.dbtools.raptor.usages.UsageClient;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;

class FileSender {
    private static final FileSender _instance = new FileSender();
    private List<ServerLocation> _uploadServers;
    private static final Logger LOGGER = Logger.getLogger(FileSender.class.getName());

    private FileSender() {
    }

    public static FileSender getInstance() {
        return _instance;
    }

    boolean logToServer(File ... fileArray) {
        boolean bl = false;
        if (fileArray != null && fileArray.length > 0) {
            try (UsageClient usageClient = UsageClient.createClient();){
                ContentType contentType = ContentType.create((String)"text/xml", (String)"UTF-8");
                FileEntity[] fileEntityArray = new FileEntity[fileArray.length];
                for (int i = 0; i < fileArray.length; ++i) {
                    fileEntityArray[i] = new FileEntity(fileArray[i], contentType);
                }
                List<ServerLocation> list = this.getUsageServers(usageClient);
                Iterator<ServerLocation> iterator = list.iterator();
                while (iterator.hasNext()) {
                    ServerLocation serverLocation = iterator.next();
                    for (FileEntity fileEntity : fileEntityArray) {
                        if (FileSender.sendEntity(fileEntity, usageClient, serverLocation)) continue;
                        iterator.remove();
                    }
                }
                bl = true;
            }
            catch (IOException iOException) {
                oracle.dbtools.util.Logger.severe(FileSender.class, (Throwable)iOException);
            }
            catch (Exception exception) {
                oracle.dbtools.util.Logger.severe(FileSender.class, (Throwable)exception);
            }
        }
        return bl;
    }

    private static boolean sendEntity(FileEntity fileEntity, UsageClient usageClient, ServerLocation serverLocation) throws ClientProtocolException, IOException {
        HttpPost httpPost = new HttpPost(serverLocation.getUrl());
        httpPost.setEntity((HttpEntity)fileEntity);
        try (CloseableHttpResponse closeableHttpResponse = usageClient.executeRequest((HttpUriRequest)httpPost);){
            if (LOGGER.isLoggable(Level.FINE)) {
                closeableHttpResponse.getEntity().writeTo((OutputStream)System.out);
            }
            if (200 == closeableHttpResponse.getStatusLine().getStatusCode()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private List<ServerLocation> getUsageServers(UsageClient usageClient) {
        if (this._uploadServers == null || this._uploadServers.size() == 0) {
            this._uploadServers = new ArrayList<ServerLocation>(ServerLocations.getServers(usageClient));
        }
        return this._uploadServers;
    }
}

