/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.edit.util;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class GeometryUtil {
    public static double[] distToLine(Point2D p, Point2D q1, Point2D q2) {
        return GeometryUtil.distToLine(p.getX(), p.getY(), q1.getX(), q1.getY(), q2.getX(), q2.getY());
    }

    public static double[] distToLine(double px, double py, double q1x, double q1y, double q2x, double q2y) {
        double[] result = new double[2];
        if ((px - q1x) * (q2x - q1x) + (py - q1y) * (q2y - q1y) <= 0.0) {
            result[0] = Math.sqrt((px - q1x) * (px - q1x) + (py - q1y) * (py - q1y));
            result[1] = 0.0;
            return result;
        }
        if ((px - q2x) * (q1x - q2x) + (py - q2y) * (q1y - q2y) <= 0.0) {
            result[0] = Math.sqrt((px - q2x) * (px - q2x) + (py - q2y) * (py - q2y));
            result[1] = 1.0;
            return result;
        }
        result[1] = 2.0;
        double denom = Math.sqrt((q2x - q1x) * (q2x - q1x) + (q2y - q1y) * (q2y - q1y));
        if (denom == 0.0) {
            result[0] = Math.sqrt((px - q1x) * (px - q1x) + (py - q1y) * (py - q1y));
            return result;
        }
        result[0] = Math.abs((px - q1x) * (q2y - q1y) - (py - q1y) * (q2x - q1x)) / denom;
        return result;
    }

    public double distToPoint(Point2D p1, Point2D p2) {
        if (p1 == null || p2 == null) {
            return Double.NaN;
        }
        double dx = p1.getX() - p2.getX();
        double dy = p1.getY() - p2.getY();
        double distance = Math.sqrt(dx * dx + dy * dy);
        return distance;
    }

    public static Point2D getIntersectionPoint(Point2D p, Point2D p1, Point2D p2) {
        double ymin;
        double xmin;
        double xi = p1.getX();
        double xf = p2.getX();
        double yi = p1.getY();
        double yf = p2.getY();
        double x = p.getX();
        double y = p.getY();
        double dx = xf - xi;
        double dy = yf - yi;
        if (dx == 0.0) {
            xmin = xi;
            ymin = y;
        } else if (dy == 0.0) {
            xmin = x;
            ymin = yi;
        } else {
            double alfa = dy / dx;
            xmin = (x + alfa * (y - yi) + alfa * alfa * xi) / (1.0 + alfa * alfa);
            ymin = (x - xmin) / alfa + y;
        }
        return new Point2D.Double(xmin, ymin);
    }

    public static boolean pointInPolygon(Point2D p, Point2D[] q) {
        boolean state = false;
        if (q.length > 1) {
            Point2D qn = q[0];
            for (int i = 0; i < q.length - 1; ++i) {
                Point2D qi = qn;
                qn = q[i + 1];
                if (qi.getX() < p.getX() == qn.getX() < p.getX() || !(qi.getY() >= p.getY()) && !(qn.getY() >= p.getY()) || !(qi.getY() >= p.getY() && qn.getY() >= p.getY()) && !(qi.getY() + (p.getX() - qi.getX()) * (qn.getY() - qi.getY()) / (qn.getX() - qi.getX()) >= p.getY())) continue;
                state = !state;
            }
        }
        return state;
    }

    public static boolean isClockwise(Point2D[] q) {
        double sum = 0.0;
        for (int i = 0; i < q.length - 1; ++i) {
            sum += q[i].getX() * q[i + 1].getY() - q[i + 1].getX() * q[i].getY();
        }
        return sum < 0.0;
    }

    public static boolean isClockwise(double[] coords) {
        double area = GeometryUtil.getPolygonArea(coords);
        return !(area < 0.0);
    }

    public static double getPolygonArea(double[] coords) {
        if (coords == null) {
            return 0.0;
        }
        double r1 = 0.0;
        double r2 = 0.0;
        double area = 0.0;
        double prev_x = coords[0];
        double prev_y = coords[1];
        for (int k = 2; k < coords.length - 1; k += 2) {
            double next_x = coords[k];
            double next_y = coords[k + 1];
            r1 += prev_x * next_y;
            r2 += prev_y * next_x;
            prev_x = next_x;
            prev_y = next_y;
        }
        area = (r2 - r1) / 2.0;
        return area;
    }

    public static double[] reverseCoordinates(double[] oords, int dim) {
        if (oords == null || oords.length == 0 || dim < 0) {
            return null;
        }
        double[] res = new double[oords.length];
        int size = oords.length;
        for (int i = 0; i < size; i += dim) {
            for (int j = 0; j < dim; ++j) {
                res[size - dim - i + j] = oords[i + j];
            }
        }
        return res;
    }

    public static double[] removePointRepetition(double[] oords, int dim) {
        if (oords == null || oords.length == 0 || dim < 0) {
            return null;
        }
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        Point2D.Double pt = new Point2D.Double(oords[0], oords[1]);
        points.add(pt);
        int size = oords.length;
        for (int i = dim; i < size; i += dim) {
            double prevX = oords[i - dim];
            double prevY = oords[i - dim + 1];
            double x = oords[i];
            double y = oords[i + 1];
            if (prevX == x && prevY == y) continue;
            pt = new Point2D.Double(x, y);
            points.add(pt);
        }
        double[] res = new double[points.size() * dim];
        for (int i = 0; i < points.size(); ++i) {
            double x = ((Point2D)points.get(i)).getX();
            double y = ((Point2D)points.get(i)).getY();
            res[i * dim] = x;
            res[i * dim + 1] = y;
        }
        return res;
    }

    public static double[] getArcMBR(double x1, double y1, double x2, double y2, double x3, double y3) {
        double xmin = Math.min(x1, x2);
        double xmax = Math.max(x1, x2);
        double ymin = Math.min(y1, y2);
        double ymax = Math.max(y1, y2);
        xmin = Math.min(xmin, x3);
        xmax = Math.max(xmax, x3);
        ymin = Math.min(ymin, y3);
        ymax = Math.max(ymax, y3);
        double[] mbr = new double[]{xmin, ymin, xmax, ymax};
        return mbr;
    }

    public static boolean pointInMBR(Point2D p, Rectangle2D mbr) {
        if (mbr == null) {
            return false;
        }
        return !(p.getX() < mbr.getMinX() || p.getY() < mbr.getMinY() || p.getX() > mbr.getMaxX()) && !(p.getY() > mbr.getMaxY());
    }

    public static boolean incPointInPolygon(Point2D p, Point2D[] q, boolean state) {
        if (q.length > 1) {
            Point2D qn = q[0];
            for (int i = 0; i < q.length - 1; ++i) {
                Point2D qi = qn;
                qn = q[i + 1];
                if (qi.getX() < p.getX() == qn.getX() < p.getX() || !(qi.getY() >= p.getY()) && !(qn.getY() >= p.getY()) || !(qi.getY() >= p.getY() && qn.getY() >= p.getY()) && !(qi.getY() + (p.getX() - qi.getX()) * (qn.getY() - qi.getY()) / (qn.getX() - qi.getX()) >= p.getY())) continue;
                state = !state;
            }
        }
        return state;
    }

    public static boolean inSector(Point2D p, Point2D[] sectorPoints) {
        double tx = sectorPoints[1].getX();
        double ty = sectorPoints[1].getY();
        double s1x = sectorPoints[0].getX() - tx;
        double s1y = sectorPoints[0].getY() - ty;
        double s2x = sectorPoints[2].getX() - tx;
        double s2y = sectorPoints[2].getY() - ty;
        tx = p.getX() - tx;
        ty = p.getY() - ty;
        return s2x * s1y - s1x * s2y > 0.0 ? s2x * ty - tx * s2y > 0.0 && s1x * ty - tx * s1y < 0.0 : s2x * ty - tx * s2y > 0.0 || s1x * ty - tx * s1y < 0.0;
    }

    public static boolean onLine(double px, double py, double q1x, double q1y, double q2x, double q2y) {
        double comp;
        if (px == q1x && py == q1y || px == q2x && py == q2y) {
            return false;
        }
        double q2q1x = q2x - q1x;
        double q2q1y = q2y - q1y;
        if ((px - q1x) * q2q1x + (py - q1y) * q2q1y <= 0.0 || -(px - q2x) * q2q1x - (py - q2y) * q2q1y <= 0.0) {
            return false;
        }
        double d = comp = px == 0.0 ? 1.0E-13 : 1.0E-14 * Math.abs(px);
        return Math.abs((px - q1x) * q2q1y - (py - q1y) * q2q1x) / Math.sqrt(q2q1x * q2q1x + q2q1y * q2q1y) < comp;
    }

    public static boolean onLine(Point2D p, Point2D q1, Point2D q2) {
        return GeometryUtil.onLine(p.getX(), p.getY(), q1.getX(), q1.getY(), q2.getX(), q2.getY());
    }

    public static boolean lineLineIntersect(double a1x, double a1y, double a2x, double a2y, double b1x, double b1y, double b2x, double b2y, double[] c) {
        double denom = (a2y - a1y) * (b2x - b1x) - (b2y - b1y) * (a2x - a1x);
        if (denom == 0.0) {
            return false;
        }
        if (a1x == b1x && a1y == b1y || a1x == b2x && a1y == b2y || a2x == b1x && a2y == b1y || a2x == b2x && a2y == b2y) {
            return false;
        }
        if (GeometryUtil.onLine(a1x, a1y, b1x, b1y, b2x, b2y) || GeometryUtil.onLine(a2x, a2y, b1x, b1y, b2x, b2y) || GeometryUtil.onLine(b1x, b1y, a1x, a1y, a2x, a2y) || GeometryUtil.onLine(b2x, b2y, a1x, a1y, a2x, a2y)) {
            return false;
        }
        double s = (a1x * (b2y - b1y) + b1x * (a1y - b2y) + b2x * (b1y - a1y)) / denom;
        double t = -(a1x * (b1y - a2y) + a2x * (a1y - b1y) + b1x * (a2y - a1y)) / denom;
        if (s > 0.0 && s < 1.0 && t > 0.0 && t < 1.0) {
            if (c != null) {
                c[0] = a1x + s * (a2x - a1x);
                c[1] = a1y + s * (a2y - a1y);
            }
            return true;
        }
        return false;
    }

    public static boolean lineLineIntersect(Point2D a1, Point2D a2, Point2D b1, Point2D b2, Point2D c) {
        double[] ca = null;
        if (c != null) {
            ca = new double[2];
        }
        boolean result = GeometryUtil.lineLineIntersect(a1.getX(), a1.getY(), a2.getX(), a2.getY(), b1.getX(), b1.getY(), b2.getX(), b2.getY(), ca);
        if (c != null) {
            c.setLocation(ca[0], ca[1]);
        }
        return result;
    }

    public static boolean lineStringSelfIntersects(Point2D[] ls, boolean allowLoop) {
        for (int i = 0; i < ls.length - 1; ++i) {
            for (int j = i + 1; j < ls.length; ++j) {
                if ((i != 0 || j != ls.length - 1 || !allowLoop) && ls[i].equals(ls[j])) {
                    return true;
                }
                if ((j >= ls.length - 1 || !GeometryUtil.onLine(ls[i], ls[j], ls[j + 1])) && !GeometryUtil.onLine(ls[j], ls[i], ls[i + 1]) && (j >= ls.length - 1 || !GeometryUtil.lineLineIntersect(ls[i], ls[i + 1], ls[j], ls[j + 1], null))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean lineStringsIntersect(Point2D[] sCoords, Point2D[] tCoords, boolean allowEndTouch) {
        if (sCoords.length == 2 && tCoords.length == 2 && (sCoords[0].equals(tCoords[0]) || sCoords[0].equals(tCoords[1])) && (sCoords[1].equals(tCoords[0]) || sCoords[1].equals(tCoords[1]))) {
            return true;
        }
        for (int i = 0; i < sCoords.length; ++i) {
            for (int j = 0; j < tCoords.length; ++j) {
                if (sCoords[i].equals(tCoords[j]) && (!allowEndTouch || i != 0 && i != sCoords.length - 1 || j != 0 && j != tCoords.length - 1)) {
                    return true;
                }
                if (!(j < tCoords.length - 1 && GeometryUtil.onLine(sCoords[i], tCoords[j], tCoords[j + 1]) || i < sCoords.length - 1 && GeometryUtil.onLine(tCoords[j], sCoords[i], sCoords[i + 1])) && (i >= sCoords.length - 1 || j >= tCoords.length - 1 || !GeometryUtil.lineLineIntersect(sCoords[i], sCoords[i + 1], tCoords[j], tCoords[j + 1], null))) continue;
                return true;
            }
        }
        return false;
    }

    public static double subtendedArea(Point2D[] coords) {
        double twiceArea = 0.0;
        for (int i = 0; i < coords.length - 1; ++i) {
            twiceArea += coords[i].getX() * coords[i + 1].getY() - coords[i + 1].getX() * coords[i].getY();
        }
        return twiceArea / 2.0;
    }

    public static Rectangle2D computeMBR(Point2D[] coords) {
        if (coords == null || coords.length == 0) {
            return null;
        }
        double xmin = coords[0].getX();
        double xmax = coords[0].getX();
        double ymin = coords[0].getY();
        double ymax = coords[0].getY();
        for (int i = 1; i < coords.length; ++i) {
            xmin = Math.min(xmin, coords[i].getX());
            xmax = Math.max(xmax, coords[i].getX());
            ymin = Math.min(ymin, coords[i].getY());
            ymax = Math.max(ymax, coords[i].getY());
        }
        return new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    public static boolean lineStringSelfIntersects(double[] oords, int dim, boolean allowLoop) {
        if (oords == null || oords.length == 0 || dim < 0) {
            return false;
        }
        int size = oords.length / dim;
        Point2D[] points = new Point2D[size];
        for (int i = 0; i < size; ++i) {
            double x = oords[i * dim];
            double y = oords[i * dim + 1];
            Point2D.Double pt = new Point2D.Double(x, y);
            points[i] = pt;
        }
        return GeometryUtil.lineStringSelfIntersects(points, true);
    }
}

