/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.ThemeStore;
import oracle.sdovis.theme.ThemeDefinition;

public class ThemeCache {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected String dsName;
    protected Hashtable themes;
    protected int maxSize;
    protected Hashtable editedThemes = null;
    protected ThemeStore themeStore = null;

    public ThemeCache(String dataSrc, int maxNumThemes, ThemeStore themeStore) {
        this.dsName = dataSrc;
        this.maxSize = maxNumThemes;
        this.themes = new Hashtable(37);
        this.themeStore = themeStore;
    }

    public String getDataSourceName() {
        return this.dsName;
    }

    public synchronized ThemeDefinition getOrLoadThemeDefinition(String themeName) {
        themeName = themeName.toUpperCase();
        ThemeDefinition tdef = null;
        if (this.editedThemes != null && (tdef = (ThemeDefinition)this.editedThemes.get(themeName)) != null) {
            return tdef;
        }
        CacheEntry ce = (CacheEntry)this.themes.get(themeName);
        if (ce != null) {
            ce.mark();
            return ce.themeDef;
        }
        ThemeDefinition td = null;
        try {
            td = this.themeStore.getThemeDefinition(themeName);
            if (td != null && (td.isMetadataRegistered() || "GEOM_CUSTOM".equalsIgnoreCase(td.getThemeType()) || "WFS".equalsIgnoreCase(td.getThemeType()) || "WMTS".equalsIgnoreCase(td.getThemeType()) || "LRS".equalsIgnoreCase(td.getThemeType()) || "WMS".equalsIgnoreCase(td.getThemeType()))) {
                this.putThemeDefinition(themeName, td);
            }
            return td;
        }
        catch (Exception e) {
            log.severe("[datasource:" + this.dsName + "] cannot load theme " + themeName);
            return null;
        }
    }

    public ThemeDefinition getThemeDefinition(String themeName) {
        themeName = themeName.toUpperCase();
        ThemeDefinition tdef = null;
        if (this.editedThemes != null && (tdef = (ThemeDefinition)this.editedThemes.get(themeName)) != null) {
            return tdef;
        }
        CacheEntry ce = (CacheEntry)this.themes.get(themeName);
        if (ce != null) {
            ce.mark();
            return ce.themeDef;
        }
        return null;
    }

    public void putThemeDefinition(String themeName, ThemeDefinition td) {
        themeName = themeName.toUpperCase();
        if (this.themes.size() > this.maxSize) {
            this.purge();
        }
        CacheEntry ce = new CacheEntry(td);
        this.themes.put(themeName, ce);
    }

    public void remove(String themeName) {
        themeName = themeName.toUpperCase();
        this.themes.remove(themeName);
    }

    public void removeAll() {
        this.themes.clear();
    }

    private void purge() {
    }

    public boolean addThemeToEditedList(String name, ThemeDefinition t) {
        if (name == null || t == null) {
            return false;
        }
        if (this.editedThemes == null) {
            this.editedThemes = new Hashtable();
        }
        this.editedThemes.put(name.toUpperCase(), t);
        return true;
    }

    public boolean removeThemeFromEditedList(String name) {
        if (name == null || this.editedThemes == null) {
            return false;
        }
        this.editedThemes.remove(name.toUpperCase());
        return true;
    }

    public void clearThemeEditedList() {
        if (this.editedThemes != null) {
            this.editedThemes.clear();
        }
    }

    public String[] getCachedThemeNames() {
        if (this.themes == null) {
            return new String[0];
        }
        String[] res = new String[this.themes.size()];
        int i = 0;
        Enumeration e = this.themes.keys();
        while (e.hasMoreElements()) {
            res[i++] = (String)e.nextElement();
        }
        return res;
    }

    public void setThemeStore(ThemeStore themeStore) {
        this.themeStore = themeStore;
    }

    public ThemeStore getThemeStore() {
        return this.themeStore;
    }

    static class CacheEntry {
        ThemeDefinition themeDef;
        long lastUsed;

        public CacheEntry(ThemeDefinition _td) {
            this.themeDef = _td;
            this.lastUsed = System.currentTimeMillis();
        }

        public void mark() {
            this.lastUsed = System.currentTimeMillis();
        }
    }
}

