/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.stylex;

import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.XMLUtil;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.stylex.AbstractBucketStyleModel;
import oracle.mapviewer.share.stylex.BucketSeries;

public class VariableMarkerStyleModel
extends AbstractBucketStyleModel {
    static final long serialVersionUID = 4360058853925091486L;
    SizeDefinition2D markerSize = new SizeDefinition2D(0.0, 0.0, null);
    String baseMarkerName = null;

    public VariableMarkerStyleModel() {
        this.type = 9;
        this.bucketSeries = new BucketSeries();
    }

    public VariableMarkerStyleModel(BucketSeries bs) {
        this.type = 9;
        this.bucketSeries = bs;
    }

    @Override
    public Object clone() {
        VariableMarkerStyleModel obj = (VariableMarkerStyleModel)super.clone();
        obj.setSizes(this.markerSize);
        return obj;
    }

    public void setSizes(SizeDefinition2D size) {
        this.markerSize = new SizeDefinition2D(0.0, 0.0, null);
        if (size == null) {
            return;
        }
        this.markerSize.setSize(size.getWidth(), size.getHeight());
        this.markerSize.setUnit(size.getUnit());
    }

    @Override
    public String getTypeName() {
        return "ADVANCED";
    }

    @Override
    public String toXMLString() {
        String xmlDef = "<?xml version=\"1.0\" ?>\n";
        xmlDef = xmlDef + "<AdvancedStyle>\n  <VariableMarkerStyle";
        String unit = "";
        if (this.markerSize.getUnit() != null && !this.markerSize.getUnit().equalsIgnoreCase("px")) {
            unit = this.markerSize.getUnit();
        }
        String startStr = StyleUtils.getUSLocaleFormat(this.markerSize.getWidth());
        startStr = StyleUtils.cleanDecimalZeros(startStr, 1);
        String incStr = StyleUtils.getUSLocaleFormat(this.markerSize.getHeight());
        incStr = StyleUtils.cleanDecimalZeros(incStr, 1);
        if (this.markerSize.isPixelUnit()) {
            startStr = String.valueOf((int)this.markerSize.getWidth());
            incStr = String.valueOf((int)this.markerSize.getHeight());
        }
        xmlDef = xmlDef + " basemarker=\"" + XMLUtil.replaceXMLEntities(this.baseMarkerName) + "\"";
        xmlDef = xmlDef + " startsize=\"" + startStr + unit + "\"";
        xmlDef = xmlDef + " increment=\"" + incStr + unit + "\">\n";
        xmlDef = xmlDef + this.bucketSeries.toXMLString();
        xmlDef = xmlDef + "\n   </VariableMarkerStyle>\n</AdvancedStyle>\n";
        return xmlDef;
    }

    public void setStartSize(int startSize) {
        this.markerSize.setWidth(startSize);
    }

    public void setStartSize(double startSize) {
        this.markerSize.setWidth(startSize);
    }

    public int getStartSize() {
        return (int)this.markerSize.getWidth();
    }

    public double getDoubleStartSize() {
        return this.markerSize.getWidth();
    }

    public void setIncrement(int increment) {
        this.markerSize.setHeight(increment);
    }

    public void setIncrement(double increment) {
        this.markerSize.setHeight(increment);
    }

    public int getIncrement() {
        return (int)this.markerSize.getHeight();
    }

    public double getDoubleIncrement() {
        return this.markerSize.getHeight();
    }

    public String getSizesUnit() {
        return this.markerSize.getUnit();
    }

    public void setSizesUnit(String unit) {
        this.markerSize.setUnit(unit);
    }

    public void setBaseMarkerName(String baseMarkerName) {
        this.baseMarkerName = baseMarkerName;
    }

    public String getBaseMarkerName() {
        return this.baseMarkerName;
    }

    @Override
    public String[] getStyleDependency() {
        String[] deps = null;
        if (this.baseMarkerName != null) {
            deps = new String[]{this.baseMarkerName};
        }
        return deps;
    }
}

