/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.mapping.clas.glm;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dmt.dataminer.core.dal.sql.SqlMapper;
import oracle.dmt.dataminer.core.dal.sql.mapping.CoreMappingLrb;
import oracle.dmt.dataminer.core.model.common.build.AttributeBiCoefficient;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;

public class GetAllPropensitiesMapper
extends SqlMapper<AttributeBiCoefficient> {
    private static String PROPENSITY_TARGET_ONE = "propensity_target_one";
    private static String PROPENSITY_TARGET_TWO = "propensity_target_two";
    private static String ATTR_NAME_SUBNAME = "attribute_name_subname";

    public GetAllPropensitiesMapper(Version version) {
        super(version);
    }

    @Override
    public AttributeBiCoefficient map(ResultSet resultSet) throws SQLException {
        AttributeBiCoefficient attributeBiCoefficient = null;
        attributeBiCoefficient = DbVersionHelper.isDB122Up(this.dbVersion) ? this.mapRow122Up(resultSet) : this.mapRowOriginal(resultSet);
        return attributeBiCoefficient;
    }

    private AttributeBiCoefficient mapRowOriginal(ResultSet resultSet) throws SQLException {
        String string;
        String string2 = resultSet.getString("ATTRIBUTE_NAME");
        if (string2 == null) {
            string2 = "<" + CoreMappingLrb.get("INTERCEPT_NAME") + ">";
        }
        if ((string = resultSet.getString("ATTRIBUTE_VALUE")) == null) {
            string = "";
        }
        BigDecimal bigDecimal = resultSet.getBigDecimal(PROPENSITY_TARGET_ONE);
        BigDecimal bigDecimal2 = resultSet.getBigDecimal(PROPENSITY_TARGET_TWO);
        if (bigDecimal == null && bigDecimal2 != null) {
            bigDecimal = new BigDecimal(-1.0 * bigDecimal2.doubleValue());
        } else if (bigDecimal2 == null && bigDecimal != null) {
            bigDecimal2 = new BigDecimal(-1.0 * bigDecimal.doubleValue());
        }
        AttributeBiCoefficient attributeBiCoefficient = new AttributeBiCoefficient(string2, string, bigDecimal != null ? Double.valueOf(bigDecimal.doubleValue()) : null, bigDecimal2 != null ? Double.valueOf(bigDecimal2.doubleValue()) : null);
        return attributeBiCoefficient;
    }

    private AttributeBiCoefficient mapRow122Up(ResultSet resultSet) throws SQLException {
        String string = resultSet.getString("FEATURE_EXPRESSION");
        String string2 = resultSet.getString("ATTRIBUTE_NAME");
        String string3 = resultSet.getString(ATTR_NAME_SUBNAME);
        string2 = string2 == null && string == null ? "<" + CoreMappingLrb.get("INTERCEPT_NAME") + ">" : (string2 == null ? string : string3);
        String string4 = resultSet.getString("ATTRIBUTE_VALUE");
        if (string4 == null) {
            string4 = "";
        }
        BigDecimal bigDecimal = resultSet.getBigDecimal(PROPENSITY_TARGET_ONE);
        BigDecimal bigDecimal2 = resultSet.getBigDecimal(PROPENSITY_TARGET_TWO);
        if (bigDecimal == null && bigDecimal2 != null) {
            bigDecimal = new BigDecimal(-1.0 * bigDecimal2.doubleValue());
        } else if (bigDecimal2 == null && bigDecimal != null) {
            bigDecimal2 = new BigDecimal(-1.0 * bigDecimal.doubleValue());
        }
        AttributeBiCoefficient attributeBiCoefficient = new AttributeBiCoefficient(string2, string4, bigDecimal != null ? Double.valueOf(bigDecimal.doubleValue()) : null, bigDecimal2 != null ? Double.valueOf(bigDecimal2.doubleValue()) : null);
        return attributeBiCoefficient;
    }
}

