/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.mapping.clas.common;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import oracle.dmt.dataminer.core.dal.sql.SqlMapper;
import oracle.dmt.dataminer.core.model.clas.common.PerformanceInfo;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;

public class GetWeightsMapper
extends SqlMapper<PerformanceInfo> {
    private String dataType;

    public GetWeightsMapper(Version version, String string) {
        super(version);
        assert (StringUtils.isNotEmpty(string)) : "Data Type Cannot be Null.";
        this.dataType = string;
    }

    @Override
    public List<PerformanceInfo> mapAll(ResultSet resultSet) throws Exception {
        throw new UnsupportedOperationException("User read item method on DAO");
    }

    @Override
    public PerformanceInfo mapOne(ResultSet resultSet) throws Exception {
        return this.map(resultSet);
    }

    @Override
    public PerformanceInfo map(ResultSet resultSet) throws Exception {
        PerformanceInfo performanceInfo = new PerformanceInfo("BUILD_SETTING_PERFORM_OP_CUST");
        while (resultSet.next()) {
            this.putValue(resultSet, performanceInfo);
        }
        return performanceInfo;
    }

    private void putValue(ResultSet resultSet, PerformanceInfo performanceInfo) throws SQLException {
        Object object = null;
        switch (this.dataType) {
            case "NUMBER": 
            case "FLOAT": 
            case "BINARY_FLOAT": 
            case "BINARY_DOUBLE": {
                object = resultSet.getBigDecimal("TARGET_VALUE");
                break;
            }
            default: {
                object = resultSet.getString("TARGET_VALUE");
            }
        }
        Object object2 = DbVersionHelper.isDB122Up(this.dbVersion) ? resultSet.getBigDecimal("TARGET_WEIGHT") : resultSet.getBigDecimal("CLASS_WEIGHT");
        if (object != null && object2 != null) {
            performanceInfo.put(object.toString(), (BigDecimal)object2);
        }
    }
}

