/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.utils.StringUtils;

public class Conditional {
    private static final String CONDITION_FORMAT = "%s %s %s";
    private static final String IN_CONDITION_FORMAT = "%s %s (%s)";
    private static final String BETWEEN_CONDITION_FORMAT_COLON = "%s %s :%s %s :%s";
    private static final String CONDITION_FORMAT_COLON = "%s %s :%s";
    private static final String VALUE = "{$VALUE}";
    private static final String LIKE_STARTS = "{$VALUE}%";
    private static final String LIKE_CONTAINS = "%{$VALUE}%";
    private static final String LIKE_ENDS = "%{$VALUE}";

    public static String getLikeParameter(String string, SqlUtils.LikeMode likeMode) {
        if (StringUtils.isEmpty(string)) {
            return "";
        }
        switch (likeMode) {
            case STARTS: {
                return StringUtils.getReplacedString(LIKE_STARTS, VALUE, string);
            }
            case CONTAINS: {
                return StringUtils.getReplacedString(LIKE_CONTAINS, VALUE, string);
            }
            case ENDS: {
                return StringUtils.getReplacedString(LIKE_ENDS, VALUE, string);
            }
        }
        assert (false) : "LIKE mode is not supported.";
        return "";
    }

    public static String in(String string, Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!collection.isEmpty()) {
            int n;
            for (n = 0; n < collection.size() - 1; ++n) {
                stringBuilder.append(String.format(":%s%d, ", string, n));
            }
            stringBuilder.append(String.format(":%s%d", string, n));
        }
        stringBuilder = new StringBuilder(String.format(IN_CONDITION_FORMAT, new Object[]{string, SqlKeyword.IN, stringBuilder}));
        return stringBuilder.toString();
    }

    public static String notIn(String string, Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!collection.isEmpty()) {
            int n;
            for (n = 0; n < collection.size() - 1; ++n) {
                stringBuilder.append(String.format(":%s%d, ", string, n));
            }
            stringBuilder.append(String.format(":%s%d", string, n));
        }
        stringBuilder = new StringBuilder(String.format(IN_CONDITION_FORMAT, new Object[]{string, SqlKeyword.NOT_IN, stringBuilder}));
        return stringBuilder.toString();
    }

    public static String in(String string, String string2, Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!collection.isEmpty()) {
            int n;
            for (n = 0; n < collection.size() - 1; ++n) {
                stringBuilder.append(String.format(":%s%d, ", string2, n));
            }
            stringBuilder.append(String.format(":%s%d", string2, n));
        }
        stringBuilder = new StringBuilder(String.format(IN_CONDITION_FORMAT, new Object[]{string, SqlKeyword.IN, stringBuilder}));
        return stringBuilder.toString();
    }

    public static String notIn(String string, String string2, Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!collection.isEmpty()) {
            int n;
            for (n = 0; n < collection.size() - 1; ++n) {
                stringBuilder.append(String.format(":%s%d, ", string2, n));
            }
            stringBuilder.append(String.format(":%s%d", string2, n));
        }
        stringBuilder = new StringBuilder(String.format(IN_CONDITION_FORMAT, new Object[]{string, SqlKeyword.NOT_IN, stringBuilder}));
        return stringBuilder.toString();
    }

    public static String between(String string, String string2, String string3) {
        if (StringUtils.isEmpty(string2) || StringUtils.isEmpty(string3)) {
            return "";
        }
        return Conditional.createCondition(string, SqlKeyword.BETWEEN, false, string2, string3);
    }

    public static String between(String string, Object object, Object object2) {
        if (object == null || object2 == null) {
            return "";
        }
        return Conditional.createCondition(string, SqlKeyword.BETWEEN, false, String.format("%s_%s", string, "FROM"), String.format("%s_%s", string, "TO"));
    }

    public static String notBetween(String string, String string2, String string3) {
        if (StringUtils.isEmpty(string2) || StringUtils.isEmpty(string3)) {
            return "";
        }
        return Conditional.createCondition(string, SqlKeyword.NOT_BETWEEN, false, string2, string3);
    }

    public static String notBetween(String string, Object object, Object object2) {
        if (object == null || object2 == null) {
            return "";
        }
        return Conditional.createCondition(string, SqlKeyword.NOT_BETWEEN, false, String.format("%s_%s", string, "FROM"), String.format("%s_%s", string, "TO"));
    }

    public static String isNull(String string) {
        return Conditional.createCondition(string, SqlKeyword.IS, false, new Object[]{SqlKeyword.NULL});
    }

    public static String isNotNull(String string) {
        return Conditional.createCondition(string, SqlKeyword.IS_NOT, false, new Object[]{SqlKeyword.NULL});
    }

    public static String like(String string, String string2, Object object) {
        if (object == null) {
            return "";
        }
        return String.format(CONDITION_FORMAT_COLON, new Object[]{string, SqlKeyword.LIKE, string2});
    }

    public static String equals(String string, Object object) {
        return Conditional.createCondition(string, SqlKeyword.EQUALS, true, object);
    }

    public static String equals(String string, String string2, Object object) {
        return Conditional.createCondition(string, string2, SqlKeyword.EQUALS, true, object);
    }

    public static String equalsOrNull(String string, Object object) {
        String string2 = null;
        string2 = object == null ? Conditional.isNull(string) : Conditional.createCondition(string, SqlKeyword.EQUALS, true, object);
        return string2;
    }

    public static String notEquals(String string, Object object) {
        return Conditional.createCondition(string, SqlKeyword.NOT_EQUALS, true, object);
    }

    public static String greater(String string, Object object) {
        return Conditional.createCondition(string, SqlKeyword.GREATER_THAN, true, object);
    }

    public static String greaterEquals(String string, Object object) {
        return Conditional.createCondition(string, SqlKeyword.GREATER_OR_EQUALS, true, object);
    }

    public static String greaterEquals(String string, String string2, Object object) {
        return Conditional.createCondition(string, string2, SqlKeyword.GREATER_OR_EQUALS, true, object);
    }

    public static String less(String string, Object object) {
        return Conditional.createCondition(string, SqlKeyword.LESS_THAN, true, object);
    }

    public static String lessEquals(String string, Object object) {
        return Conditional.createCondition(string, SqlKeyword.LESS_OR_EQUALS, true, object);
    }

    public static String lessEquals(String string, String string2, Object object) {
        return Conditional.createCondition(string, string2, SqlKeyword.LESS_OR_EQUALS, true, object);
    }

    private static String createCondition(String string, SqlKeyword sqlKeyword, boolean bl, Object ... objectArray) {
        return Conditional.createCondition(string, string, sqlKeyword, bl, objectArray);
    }

    private static String createCondition(String string, String string2, SqlKeyword sqlKeyword, boolean bl, Object ... objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(Arrays.asList(objectArray));
        arrayList.removeIf(object -> object == null);
        if (arrayList.isEmpty()) {
            return "";
        }
        String string3 = null;
        switch (sqlKeyword) {
            case BETWEEN: {
                if (objectArray.length < 2) {
                    string3 = "";
                    break;
                }
                string3 = String.format(BETWEEN_CONDITION_FORMAT_COLON, new Object[]{string2, SqlKeyword.BETWEEN, objectArray[0], SqlKeyword.AND, objectArray[1]});
                break;
            }
            case NOT_BETWEEN: {
                if (objectArray.length < 2) {
                    string3 = "";
                    break;
                }
                string3 = String.format(BETWEEN_CONDITION_FORMAT_COLON, new Object[]{string2, SqlKeyword.NOT_BETWEEN, objectArray[0], SqlKeyword.AND, objectArray[1]});
                break;
            }
            default: {
                string3 = bl ? String.format(CONDITION_FORMAT_COLON, new Object[]{string, sqlKeyword, string2}) : String.format(CONDITION_FORMAT, new Object[]{string2, sqlKeyword, objectArray[0]});
            }
        }
        return string3;
    }

    private static enum SqlKeyword {
        AND("AND"),
        BETWEEN("BETWEEN"),
        EQUALS("="),
        NOT_EQUALS("!="),
        GREATER_OR_EQUALS(">="),
        GREATER_THAN(">"),
        LESS_OR_EQUALS("<="),
        LESS_THAN("<"),
        LIKE("LIKE"),
        LIKE_STARTS_WITH("LIKE"),
        IN("IN"),
        NOT_IN("NOT IN"),
        IS("IS"),
        IS_NOT("IS NOT"),
        NOT_BETWEEN("NOT BETWEEN"),
        NULL("NULL");

        private String _sqlSymbol;

        private SqlKeyword(String string2) {
            this._sqlSymbol = string2;
        }

        public String toString() {
            return this._sqlSymbol;
        }
    }
}

