/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.latch.Latch;
import java.io.IOException;
import java.io.RandomAccessFile;

class FileHandle {
    private RandomAccessFile file;
    private Latch fileLatch;
    private int logVersion;
    private long fileNum;

    FileHandle(long fileNum, String label) {
        this.fileLatch = new Latch("file_" + label + "_fileHandle");
        this.fileNum = fileNum;
    }

    void init(RandomAccessFile file, int logVersion) {
        this.file = file;
        this.logVersion = logVersion;
    }

    RandomAccessFile getFile() {
        return this.file;
    }

    long getFileNum() {
        return this.fileNum;
    }

    int getLogVersion() {
        return this.logVersion;
    }

    boolean isOldHeaderVersion() {
        return this.logVersion < 6;
    }

    void latch() throws DatabaseException {
        this.fileLatch.acquire();
    }

    boolean latchNoWait() throws DatabaseException {
        return this.fileLatch.acquireNoWait();
    }

    void release() throws DatabaseException {
        this.fileLatch.release();
    }

    void close() throws IOException {
        if (this.file != null) {
            this.file.close();
            this.file = null;
        }
    }
}

