/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.teradata;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.datamove.offline.Messages;
import oracle.dbtools.migration.datamove.offline.streams.Offline3rdPartyDMSAbstract;
import oracle.dbtools.migration.workbench.plugin.TeradataPreferencePanel;
import oracle.dbtools.raptor.utils.RaptorGroupLoader;
import oracle.ide.Ide;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class Teradata12Offline3rdPartyPrintStream
extends Offline3rdPartyDMSAbstract {
    Logger m_logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    protected StringTemplateGroup m_templateGroup = null;
    protected String catalog;
    protected String schema;
    public static final String CHANNEL_PREFIX = ":#:";
    public static final String CHANNEL_SUFFIX = ":";
    public static final String CHANNEL_CMD_SCRIPT = ":#:SCRIPT:";
    public static final String CHANNEL_BTEQ_SCRIPT = ":#:BTEQ:";
    public static final String CHANNEL_FEXP_SCRIPT = ":#:FEXP:";
    public static final String CHANNEL_TABLE_SCRIPT = ":#:DATA:";
    public static final String REPLACEALLSTRING = "[ \\\\/$]";
    protected Map<String, PrintWriter> channels = new TreeMap<String, PrintWriter>();

    public Map<String, PrintWriter> getChannels() {
        return this.channels;
    }

    public Teradata12Offline3rdPartyPrintStream(String string, String string2) {
        super(string, string2);
    }

    public void startDatabase(String string, String string2) {
        PrintWriter printWriter;
        super.startDatabase(string, string2);
        System.out.println("startDatabase " + string + "." + string2);
        this.catalog = string;
        this.schema = string2;
        String string3 = this.getCatalogDir() + File.separator + "unload_script.bteq";
        super.startDatabase(string, string2);
        this.println(this.channels.get(CHANNEL_CMD_SCRIPT), "mkdir data", true);
        this.println(this.channels.get(CHANNEL_CMD_SCRIPT), "mkdir log", true);
        if (TeradataPreferencePanel.isUseFExp()) {
            this.println(this.channels.get(CHANNEL_CMD_SCRIPT), "fexp  -i UTF8 -u UTF8 -c UTF16 -r \".logon %1/%2,%3 ;\" < unload_script.fexp", true);
        } else {
            this.println(this.channels.get(CHANNEL_CMD_SCRIPT), "bteq -e UTF8 -c UTF8 .logon %1/%2,%3 < unload_script.bteq", true);
        }
        String string4 = Ide.getEnvironOptions().getEncoding();
        try {
            printWriter = null;
            printWriter = string4 == null ? new PrintWriter(string3) : new PrintWriter(string3, string4);
            this.channels.put(CHANNEL_BTEQ_SCRIPT, printWriter);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_logger.log(Level.SEVERE, Messages.getString((String)"Offline3rdPartyPrintStream.6"), new Object[]{string3, fileNotFoundException.getMessage()});
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.m_logger.log(Level.SEVERE, Messages.getString((String)"Offline3rdPartyPrintStream.7"), new Object[]{string3, unsupportedEncodingException.getMessage()});
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
        }
        string3 = this.getCatalogDir() + File.separator + "unload_script.fexp";
        try {
            printWriter = null;
            printWriter = string4 == null ? new PrintWriter(string3) : new PrintWriter(string3, string4);
            this.channels.put(CHANNEL_FEXP_SCRIPT, printWriter);
            StringTemplate stringTemplate = this.getTemplateGroup().getTemplateDefinition("FexpUnloadHead");
            stringTemplate.reset();
            stringTemplate.setAttribute("logtable", (Object)(string2 + ".LogTable"));
            this.println(printWriter, CHANNEL_FEXP_SCRIPT + stringTemplate.toString(), true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_logger.log(Level.SEVERE, Messages.getString((String)"Offline3rdPartyPrintStream.6"), new Object[]{string3, fileNotFoundException.getMessage()});
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.m_logger.log(Level.SEVERE, Messages.getString((String)"Offline3rdPartyPrintStream.7"), new Object[]{string3, unsupportedEncodingException.getMessage()});
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
        }
    }

    public final void startTableOld(String string) {
        System.out.println("startTable called " + string);
    }

    public final void endTableOld() {
        System.out.println("endTable called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTable(String string) {
        Object object;
        System.out.println("startTable " + string);
        if (this.channels.containsKey(CHANNEL_TABLE_SCRIPT) && (object = this.channels.get(CHANNEL_TABLE_SCRIPT)) != null) {
            try {
                ((PrintWriter)object).flush();
                ((PrintWriter)object).close();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.channels.remove(CHANNEL_TABLE_SCRIPT);
            }
        }
        try {
            object = string.replaceAll(REPLACEALLSTRING, "_");
            String string2 = Ide.getEnvironOptions().getEncoding();
            PrintWriter printWriter = null;
            File file = new File(this.getSchemaDir(), "data");
            File file2 = new File(file, (String)object + ".csv");
            if (!file.isDirectory()) {
                file.mkdirs();
            }
            printWriter = string2 == null ? new PrintWriter(file2) : new PrintWriter(file2, string2);
            this.channels.put(CHANNEL_TABLE_SCRIPT, printWriter);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
        }
    }

    public void endTable() {
        PrintWriter printWriter = this.channels.get(CHANNEL_TABLE_SCRIPT);
        System.out.println("endTeraTable");
        printWriter.flush();
        printWriter.close();
        this.channels.remove(CHANNEL_TABLE_SCRIPT);
    }

    public void endDatabase() {
        System.out.println("endDatabase");
        StringTemplate stringTemplate = this.getTemplateGroup().getTemplateDefinition("FexpUnloadTail");
        stringTemplate.reset();
        this.println(this.channels.get(CHANNEL_FEXP_SCRIPT), CHANNEL_FEXP_SCRIPT + stringTemplate.toString(), true);
        super.endDatabase();
        for (PrintWriter printWriter : this.channels.values()) {
            if (printWriter == null) continue;
            try {
                printWriter.flush();
                printWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    public void finished() {
        System.out.println("finished");
        super.finished();
    }

    public void println(PrintWriter printWriter, String string, boolean bl) {
        PrintWriter printWriter2 = this.channels.get(CHANNEL_BTEQ_SCRIPT);
        String string2 = string;
        if (string2 != null) {
            if (string2.startsWith(CHANNEL_PREFIX) && string2.indexOf(CHANNEL_SUFFIX, CHANNEL_PREFIX.length()) > 0) {
                String string3 = string2.substring(0, string2.indexOf(CHANNEL_SUFFIX, CHANNEL_PREFIX.length()) + 1);
                if (string3.equals(CHANNEL_CMD_SCRIPT)) {
                    super.println(printWriter, string2.substring(string2.indexOf(CHANNEL_SUFFIX, CHANNEL_PREFIX.length()) + 1), bl);
                    return;
                }
                if (this.channels.containsKey(string3)) {
                    printWriter2 = this.channels.get(string3);
                    string2 = string.substring(string2.indexOf(CHANNEL_SUFFIX, CHANNEL_PREFIX.length()) + 1);
                }
            } else {
                System.out.println("Non Channel Print");
            }
            if (printWriter2 == null) {
                super.println(printWriter, string, bl);
            } else {
                printWriter2.println(string2);
            }
        } else {
            printWriter2.println(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeFile(String string, String string2, String string3) {
        InputStream inputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            Object object;
            InputStream inputStream2 = ((Object)((Object)this)).getClass().getResourceAsStream(string2);
            inputStream = new BufferedInputStream(inputStream2);
            File file = null;
            file = new File(string + File.separator + string3);
            if (!file.exists()) {
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                object = new byte[10000];
                int n = 0;
                n = inputStream.read((byte[])object);
                while (n > -1) {
                    ((BufferedOutputStream)filterOutputStream).write((byte[])object, 0, n);
                    n = inputStream.read((byte[])object);
                }
                ((BufferedOutputStream)filterOutputStream).flush();
                inputStream.close();
            }
            object = file.getPath();
            String string4 = object;
            return string4;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    protected StringTemplateGroup getTemplateGroup() {
        if (this.m_templateGroup == null) {
            RaptorGroupLoader raptorGroupLoader = new RaptorGroupLoader("oracle/dbtools/migration/workbench/plugin/teradata/templates", ((Object)((Object)this)).getClass().getClassLoader());
            StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)raptorGroupLoader);
            StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
            this.m_templateGroup = StringTemplateGroup.loadGroup((String)"OfflineCapturer");
            if (this.m_templateGroup == null && raptorGroupLoader != null) {
                this.m_templateGroup = raptorGroupLoader.loadGroup("OfflineCapturer");
            }
        }
        return this.m_templateGroup;
    }

    public String getExtension() {
        return null;
    }

    public String getFileName() {
        return null;
    }

    public String getDataFileName(String string, String string2) {
        return null;
    }

    public String getRowDelimiter() {
        return null;
    }

    public String getFieldTerminator() {
        return null;
    }

    public ArrayList<String> getColumnList() {
        return null;
    }
}

