/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.plugin.TeradataMachine;
import oracle.dbtools.migration.workbench.plugin.TeradataState;
import oracle.dbtools.raptor.utils.RaptorGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

class Teradata12FEXPExternalSQLLoaderState
extends TeradataState {
    Logger LOGGER = Logger.getLogger(MigrationUtils.class.getClass().getName());
    protected TeradataMachine machine = null;
    protected StringTemplateGroup m_templateGroup = null;

    public Teradata12FEXPExternalSQLLoaderState(TeradataMachine teradataMachine) {
        super(teradataMachine);
    }

    @Override
    public String getDatafileExtension() {
        return "fexp." + super.getDatafileExtension();
    }

    @Override
    public String getDataExportCommmand(TeradataMachine teradataMachine, String string, MdColumn[] mdColumnArray, String string2, boolean bl) {
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        StringTemplate stringTemplate = null;
        String string3 = null;
        try {
            String string4;
            String string5;
            String string6;
            this.loadTemplates();
            if (string2.toLowerCase().endsWith(".dat")) {
                string6 = "data/" + string2.substring(0, string2.length() - 4) + ".exp";
                string5 = "data/" + string2.substring(0, string2.length() - 4) + ".fexp.dat";
                string4 = "data/" + string2.substring(0, string2.length() - 4) + ".csv";
            } else {
                string6 = "data/" + string2 + ".exp";
                string5 = "data/" + string2 + ".fexp.dat";
                string4 = "data/" + string2 + ".csv";
            }
            String string7 = migrationConfig.getEndColumnDelimiter();
            String string8 = "'" + string7 + "'";
            String string9 = migrationConfig.getEndRowDelimiter();
            String string10 = "'" + string9 + "'";
            String string11 = string.substring(0, string.indexOf("."));
            String[] stringArray = new String[mdColumnArray.length];
            for (int i = 0; i < mdColumnArray.length; ++i) {
                MdColumn mdColumn = mdColumnArray[i];
                String string12 = mdColumn.getColumnType();
                String string13 = mdColumn.getColumnName();
                Integer n = mdColumn.getPrecision();
                Integer n2 = mdColumn.getScale();
                if (n == null) {
                    n = 0;
                }
                if (n2 == null) {
                    n2 = 0;
                }
                stringArray[i] = this.getColumnPattern(string13, string12, n, n2, string8, mdColumn.getNullableFlag(), i == mdColumnArray.length - 1);
            }
            stringTemplate = this.m_templateGroup.getTemplateDefinition("Convert");
            stringTemplate.reset();
            stringTemplate.setAttribute("expfile", (Object)string6);
            stringTemplate.setAttribute("datfile", (Object)string5);
            stringTemplate.setAttribute("csvfile", (Object)string4);
            stringTemplate.setAttribute("collist", (Object)stringArray);
            stringTemplate.setAttribute("table", (Object)teradataMachine.quote(string));
            stringTemplate.setAttribute("eofd", (Object)string8);
            stringTemplate.setAttribute("eord", (Object)string10);
            stringTemplate.setAttribute("platformWindows", (Object)bl);
            string3 = stringTemplate.toString();
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.WARNING, exception.getLocalizedMessage());
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generateCSV(TeradataMachine teradataMachine, String string, MdColumn[] mdColumnArray) {
        String string2 = "";
        try {
            StringTemplate stringTemplate;
            this.loadTemplates();
            StringTemplate stringTemplate2 = stringTemplate = this.m_templateGroup.getTemplateDefinition("GenerateControlCSV");
            synchronized (stringTemplate2) {
                stringTemplate.reset();
                for (MdColumn mdColumn : mdColumnArray) {
                    stringTemplate.setAttribute("columndetails", (Object)new TeradataState.ColumnDetails(mdColumn));
                }
                stringTemplate.setAttribute("table", (Object)string);
                string2 = stringTemplate.toString();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    @Override
    public String getDataExportScript(TeradataMachine teradataMachine, String string, MdColumn[] mdColumnArray, String string2) {
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        StringTemplate stringTemplate = null;
        try {
            this.loadTemplates();
            String string3 = string2.toLowerCase().endsWith(".dat") ? "data/" + string2.substring(0, string2.length() - 4) + ".exp" : "data/" + string2 + ".exp";
            String string4 = migrationConfig.getEndColumnDelimiter();
            String string5 = "'" + string4 + "'";
            String string6 = migrationConfig.getEndRowDelimiter();
            String string7 = "'" + string6 + "'";
            String[] stringArray = new String[mdColumnArray.length];
            for (int i = 0; i < mdColumnArray.length; ++i) {
                MdColumn mdColumn = mdColumnArray[i];
                String string8 = mdColumn.getColumnType();
                String string9 = mdColumn.getColumnName();
                Integer n = mdColumn.getPrecision();
                Integer n2 = mdColumn.getScale();
                if (n == null) {
                    n = 0;
                }
                if (n2 == null) {
                    n2 = 0;
                }
                stringArray[i] = this.getColumnPattern(string9, string8, n, n2, string5, mdColumn.getNullableFlag(), i == mdColumnArray.length - 1);
            }
            stringTemplate = this.m_templateGroup.getTemplateDefinition("Unload");
            stringTemplate.reset();
            stringTemplate.setAttribute("outfile", (Object)string3);
            stringTemplate.setAttribute("collist", (Object)stringArray);
            stringTemplate.setAttribute("table", (Object)teradataMachine.quote(string));
            stringTemplate.setAttribute("eofd", (Object)string5);
            stringTemplate.setAttribute("eord", (Object)string7);
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.WARNING, exception.getLocalizedMessage());
        }
        return stringTemplate.toString();
    }

    public String getDataExportCommmand(String string, MdColumn[] mdColumnArray, String string2, boolean bl) {
        return null;
    }

    @Override
    public String getColumnPattern(String string, String string2, int n, int n2, String string3, boolean bl, boolean bl2) {
        String string4;
        String string5 = "";
        String string6 = "''";
        String string7 = string4 = bl2 ? "" : " || " + string3;
        if (string2.equals("DECIMAL")) {
            String string8 = Teradata12FEXPExternalSQLLoaderState.makeNumericFormat(n, n2);
            string5 = "CAST(CAST(\"" + string + "\" AS FORMAT '" + string8 + "') AS CHAR(" + string8.length() + "))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(" + string8.length() + "))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("DATE")) {
            string5 = "(\"" + string + "\"(FORMAT 'Y4-MM-DD') (CHAR(10)))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || '          ' )";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("ANSITIME")) {
            string5 = "(\"" + string + "\"(FORMAT 'HH:MI:SS.S(6)') (CHAR(15)))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(15))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("ANSITIMEWITHTIMEZONE")) {
            string5 = "(\"" + string + "\"(FORMAT 'HH:MI:SS.S(6)Z') (CHAR(21)))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(21))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("TIMESTAMPWITHOUTTIMEZONE")) {
            string5 = "(\"" + string + "\"(FORMAT 'Y4-MM-DDbHH:MI:SS.S(6)') (CHAR(26)))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(26))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("TIMESTAMPWITHTIMEZONE")) {
            string5 = "(\"" + string + "\"(FORMAT 'Y4-MM-DD HH:MI:SS.S(6)Z') (CHAR(32)))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(32))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("DAY") || string2.equals("DAYHOUR") || string2.equals("DAYMINUTE") || string2.equals("DAYSECOND")) {
            int n3 = n + 10 + (n2 > 0 ? n2 + 1 : 0);
            string5 = "CAST(CAST(\"" + string + "\" AS INTERVAL DAY(" + n + ") TO SECOND(" + n2 + ")) AS CHAR(" + n3 + "))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(" + n3 + "))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("HOUR") || string2.equals("HOURMINUTE") || string2.equals("HOURSECOND")) {
            switch (n) {
                case 4: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                default: {
                    n = 1;
                }
            }
            int n4 = n + 10 + (n2 > 0 ? n2 + 1 : 0);
            string5 = "CAST(CAST(\"" + string + "\" AS INTERVAL DAY(" + n + ") TO SECOND(" + n2 + ")) AS CHAR(" + n4 + "))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(" + n4 + "))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("MINUTE") || string2.equals("MINUTETOSECOND") || string2.equals("SECOND")) {
            int n5 = 11 + (n2 > 0 ? n2 + 1 : 0);
            string5 = "CAST(CAST(\"" + string + "\" AS INTERVAL DAY(1) TO SECOND(" + n2 + ")) AS CHAR(" + n5 + "))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(" + n5 + "))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("YEAR") || string2.equals("YEARMONTH")) {
            int n6 = n + 4;
            string5 = "CAST(CAST(\"" + string + "\" AS INTERVAL YEAR(" + n + ") TO MONTH) AS CHAR(" + n6 + "))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(" + n6 + "))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("MONTH")) {
            switch (n) {
                case 4: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                default: {
                    n = 1;
                }
            }
            int n7 = n + 4;
            string5 = "CAST(CAST(\"" + string + "\" AS INTERVAL YEAR(" + n + ") TO MONTH) AS CHAR(" + n7 + "))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(" + n7 + "))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("CHARVARYINGLATIN") || string2.equals("CHARVARYINGGRAPHIC") || string2.equals("CHARVARYINGUNICODE") || string2.equals("CHARVARYINGKANJI1") || string2.equals("CHARVARYINGKANJISJIS")) {
            string5 = n > 4000 ? "'000009Too Large'" : "((CAST(CAST(CHARACTER_LENGTH(\"" + string + "\") AS FORMAT'-9(6)') AS CHAR(6))) || \"" + string + "\")";
            string6 = "'000000'";
            string4 = "";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || " + string6 + ")";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
        } else if (string2.equals("BYTEFIXED")) {
            string5 = "'" + Teradata12FEXPExternalSQLLoaderState.makeHexVARCHARC(6, "BYTEFIXED not allowed in fexp migration", n) + "'";
            string6 = "'000000'";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || " + string6 + ")";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("BYTELARGEOBJECT")) {
            string5 = "'" + Teradata12FEXPExternalSQLLoaderState.makeHexVARCHARC(6, "BYTELARGEOBJECT not allowed in fexp migration", -1) + "'";
            string6 = "'000000'";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || " + string6 + ")";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("BYTEVARYING")) {
            string5 = "'" + Teradata12FEXPExternalSQLLoaderState.makeHexVARCHARC(6, "BYTEVARYING not allowed in fexp migration", n) + "'";
            string6 = "'000000'";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || " + string6 + ")";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("CHARLARGEOBJECTLATIN") || string2.equals("CHARLARGEOBJECTGRAPHIC") || string2.equals("CHARLARGEOBJECTUNICODE") || string2.equals("CHARLARGEOBJECTKANJI1") || string2.equals("CHARLARGEOBJECTKANJISJIS")) {
            string5 = "'" + Teradata12FEXPExternalSQLLoaderState.makeVARCHARC(6, string2 + " not allowed in fexp migration", -1) + "'";
            string6 = "'000000'";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || " + string6 + ")";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("REAL")) {
            string5 = "(CAST(\"" + string + "\" AS FORMAT '+9.9999999999999999E+999'))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || '+9.9999999999999999E+999')";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("BIGINTEGER")) {
            string5 = "(CAST(\"" + string + "\" AS FORMAT '+9(20)'))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(21))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("INTEGER")) {
            string5 = "(CAST(\"" + string + "\" AS FORMAT '+9(11)'))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(12))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("SMALLINT")) {
            string5 = "(CAST(\"" + string + "\" AS FORMAT '+9(5)'))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(6))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("BYTEINT")) {
            string5 = "(CAST(\"" + string + "\" AS FORMAT '+9(3)'))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(4))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("CHARFIXEDLATIN")) {
            string5 = "\"" + string + "\"";
            if (bl) {
                String string9 = "('N' || " + string3 + ")";
                string6 = "('Y' || " + string3 + ")";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string9 + " end, case when \"" + string + "\" is null then (CAST ('' as char(" + n + "))) else (" + string5 + ") end, ''";
            } else {
                string5 = "'', " + string5 + ", ''";
            }
        } else if (string2.equals("CHARFIXEDGRAPHIC")) {
            string5 = "(TRANSLATE(\"" + string + "\" USING GRAPHIC_TO_UNICODE))";
            if (bl) {
                String string10 = "('N' || " + string3 + ")";
                string6 = "('Y' || " + string3 + ")";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string10 + " end, case when \"" + string + "\" is null then (CAST ('' as char(" + n + ")) else (" + string5 + ") end, ''";
            } else {
                string5 = "'', " + string5 + ", ''";
            }
        } else {
            string5 = "\"" + string + "\"";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + ")";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
        }
        return string5 + string4;
    }

    @Override
    public Object[] generateExternalTableColumnDefinitions(TeradataMachine teradataMachine, MdColumn[] mdColumnArray, MdColumn[] mdColumnArray2) {
        return mdColumnArray2;
    }

    @Override
    public String generateExternalColumnDefinitions(TeradataMachine teradataMachine, MdColumn[] mdColumnArray, MdColumn[] mdColumnArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        Vector<MdColumn> vector = new Vector<MdColumn>();
        for (int i = 0; i < mdColumnArray2.length; ++i) {
            String string;
            MdColumn mdColumn = mdColumnArray2[i];
            MdColumn mdColumn2 = mdColumnArray[i];
            stringBuffer.append(this.maybeQuoteExternalFieldReference(teradataMachine, mdColumn2, mdColumn));
            stringBuffer.append(' ');
            stringBuffer.append(this.formatSQLLoaderColumn(teradataMachine, mdColumn2, mdColumn, i + 1 >= mdColumnArray2.length));
            if (i < mdColumnArray2.length - 1) {
                stringBuffer.append(", \n");
            }
            if (!(string = mdColumn2.getColumnType()).equals("BYTELARGEOBJECT") && !string.equals("CHARLARGEOBJECTLATIN") && !string.equals("CHARLARGEOBJECTGRAPHIC") && !string.equals("CHARLARGEOBJECTUNICODE") && !string.equals("CHARLARGEOBJECTKANJI1") && !string.equals("CHARLARGEOBJECTKANJISJIS")) continue;
            vector.add(mdColumn);
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    @Override
    public String generateExternalSelectColumnList(TeradataMachine teradataMachine, MdColumn[] mdColumnArray, MdColumn[] mdColumnArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = new Vector();
        String string = "";
        for (int i = 0; i < mdColumnArray2.length; ++i) {
            MdColumn mdColumn = mdColumnArray2[i];
            MdColumn mdColumn2 = mdColumnArray[i];
            stringBuffer.append(string);
            stringBuffer.append(mdColumn.getColumnName());
            string = ",  \n";
        }
        return stringBuffer.toString();
    }

    @Override
    public String maybeQuoteSqlldrFieldReference(TeradataMachine teradataMachine, MdColumn mdColumn, MdColumn mdColumn2) {
        return null;
    }

    @Override
    public String maybeQuoteExternalFieldReference(TeradataMachine teradataMachine, MdColumn mdColumn, MdColumn mdColumn2) {
        String string = mdColumn.getColumnType();
        StringBuffer stringBuffer = new StringBuffer();
        if (mdColumn2.getNullableFlag()) {
            stringBuffer.append(teradataMachine.trunk30("NL_" + mdColumn2.getColumnName()));
            stringBuffer.append(" VARCHAR(2,16),\n");
        }
        if (string.equals("DATE")) {
            stringBuffer.append("IG" + mdColumn.getColumnOrder() + "DATE RAW(2),\n");
        } else if (string.equals("ANSITIME")) {
            stringBuffer.append("IG" + mdColumn.getColumnOrder() + "ANSITIME RAW(2),\n");
        } else if (string.equals("ANSITIMEWITHTIMEZONE")) {
            stringBuffer.append("IG" + mdColumn.getColumnOrder() + "ANSITIMETZ RAW(2),\n");
        } else if (string.equals("TIMESTAMPWITHOUTTIMEZONE")) {
            stringBuffer.append("IG" + mdColumn.getColumnOrder() + "TS RAW(2),\n");
        } else if (string.equals("TIMESTAMPWITHTIMEZONE")) {
            stringBuffer.append("IG" + mdColumn.getColumnOrder() + "TSTZ RAW(2),\n");
        }
        stringBuffer.append(mdColumn2.getColumnName());
        return stringBuffer.toString();
    }

    @Override
    public String formatSQLLoaderColumn(TeradataMachine teradataMachine, MdColumn mdColumn, MdColumn mdColumn2, boolean bl) {
        String string = "";
        String string2 = mdColumn2.getColumnName();
        boolean bl2 = mdColumn.getNullableFlag();
        String string3 = mdColumn.getColumnType();
        String string4 = "";
        if (bl2) {
            string4 = " NULLIF " + teradataMachine.trunk30("NL_" + string2) + "='Y'";
        }
        if (string3.equals("BIGINTEGER") || string3.equals("BYTEFIXED") || string3.equals("BYTEINT") || string3.equals("BYTELARGEOBJECT") || string3.equals("BYTEVARYING") || string3.equals("CHARFIXEDGRAPHIC") || string3.equals("CHARFIXEDKANJI1") || string3.equals("CHARFIXEDKANJISJIS") || string3.equals("CHARFIXEDLATIN") || string3.equals("CHARFIXEDUNICODE") || string3.equals("CHARLARGEOBJECTGRAPHIC") || string3.equals("CHARLARGEOBJECTKANJI1") || string3.equals("CHARLARGEOBJECTKANJISJIS") || string3.equals("CHARLARGEOBJECTLATIN") || string3.equals("CHARLARGEOBJECTUNICODE") || string3.equals("CHARVARYINGGRAPHIC") || string3.equals("CHARVARYINGKANJI1") || string3.equals("CHARVARYINGKANJISJIS") || string3.equals("CHARVARYINGLATIN") || string3.equals("CHARVARYINGUNICODE") || string3.equals("DAY") || string3.equals("DAYHOUR") || string3.equals("DAYMINUTE") || string3.equals("DAYSECOND") || string3.equals("DECIMAL") || string3.equals("INTEGER") || string3.equals("MINUTE") || string3.equals("MINUTETOSECOND") || string3.equals("REAL") || string3.equals("SECOND") || string3.equals("SMALLINT") || string3.equals("HOUR") || string3.equals("HOURMINUTE") || string3.equals("HOURSECOND") || string3.equals("YEAR") || string3.equals("YEARMONTH") || string3.equals("MONTH")) {
            string = "VARCHAR(2,4000)";
        } else if (string3.equals("DATE")) {
            string = " CHAR(10) DATE_FORMAT DATE MASK \"YYYY-MM-DD\"";
        } else if (string3.equals("ANSITIME")) {
            string = " CHAR(15) DATE_FORMAT TIMESTAMP MASK \"HH24:MI:SS.FF6\"";
        } else if (string3.equals("ANSITIMEWITHTIMEZONE")) {
            string = " CHAR(21) DATE_FORMAT TIMESTAMP WITH TIME ZONE MASK \"HH24:MI:SS.FF6TZH:TZM\"";
        } else if (string3.equals("TIMESTAMPWITHOUTTIMEZONE")) {
            string = " CHAR(26) DATE_FORMAT TIMESTAMP MASK \"YYYY-MM-DD HH24:MI:SS.FF6\"";
        } else if (string3.equals("TIMESTAMPWITHTIMEZONE")) {
            string = " CHAR(32) DATE_FORMAT TIMESTAMP WITH TIME ZONE MASK \"YYYY-MM-DD HH24:MI:SS.FF6TZH:TZM\"";
        } else {
            string = "XXX(" + string3 + ")XXX";
            System.out.println("UNHANDLED TYPE " + string + string4);
        }
        return string + string4;
    }

    protected void loadTemplates() {
        if (this.m_templateGroup == null) {
            RaptorGroupLoader raptorGroupLoader = new RaptorGroupLoader("oracle/dbtools/migration/workbench/plugin/teradata/templates", this.getClass().getClassLoader());
            StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)raptorGroupLoader);
            StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
            this.m_templateGroup = StringTemplateGroup.loadGroup((String)"OfflineCapturer");
        }
    }

    @Override
    public String getSQLLoaderCommand(TeradataMachine teradataMachine, String string, String string2, boolean bl) {
        this.loadTemplates();
        return "";
    }

    protected static String makeHexVARCHARC(int n, CharSequence charSequence, int n2) {
        if (charSequence == null || charSequence.length() == 0) {
            return Teradata12FEXPExternalSQLLoaderState.makeVARCHARC(n, charSequence, n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            int n3 = Character.getNumericValue(c);
            String string = Integer.toHexString(n3 & 0xFF);
            stringBuffer.append(string);
        }
        return Teradata12FEXPExternalSQLLoaderState.makeVARCHARC(n, stringBuffer.toString(), n2 * 2);
    }

    protected static String makeVARCHARC(int n, CharSequence charSequence, int n2) {
        int n3;
        int n4;
        int n5 = n4 = charSequence == null ? 0 : charSequence.length();
        if (n2 >= 0 && n4 > n2) {
            n4 = n2;
        }
        String string = Integer.toString(n4);
        StringBuffer stringBuffer = new StringBuffer();
        for (n3 = 0; n3 < n - string.length(); ++n3) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        for (n3 = 0; n3 < n4; ++n3) {
            stringBuffer.append(charSequence.charAt(n3));
        }
        return stringBuffer.toString();
    }

    public static String makeNumericFormat(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('-');
        for (int i = 0; i < n; ++i) {
            if (i == n - n2) {
                stringBuffer.append('.');
            }
            stringBuffer.append('9');
        }
        return stringBuffer.toString();
    }

    @Override
    public String getPostLoadSQL() {
        return null;
    }
}

