/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.plugin.TeradataMachine;
import oracle.dbtools.migration.workbench.plugin.TeradataState;
import oracle.dbtools.raptor.utils.RaptorGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

class Teradata12BTEQState
extends TeradataState {
    Logger LOGGER = Logger.getLogger(MigrationUtils.class.getClass().getName());
    StringBuffer postSQLBuf = new StringBuffer();
    List<MdColumn> lobCols = new Vector<MdColumn>();
    protected TeradataMachine machine = null;
    protected StringTemplateGroup m_templateGroup = null;

    public Teradata12BTEQState(TeradataMachine teradataMachine) {
        super(teradataMachine);
    }

    @Override
    public String getDataExportCommmand(TeradataMachine teradataMachine, String string, MdColumn[] mdColumnArray, String string2, boolean bl) {
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        StringTemplate stringTemplate = null;
        String string3 = null;
        try {
            String string4;
            String string5;
            String string6;
            this.loadTemplates();
            if (string2.toLowerCase().endsWith(".dat")) {
                string6 = string2.substring(0, string2.length() - 4) + ".exp";
                string5 = string2.substring(0, string2.length() - 4) + ".dat";
                string4 = string2.substring(0, string2.length() - 4) + ".csv";
            } else {
                string6 = string2 + ".exp";
                string5 = string2 + ".dat";
                string4 = string2 + ".csv";
            }
            String string7 = migrationConfig.getEndColumnDelimiter();
            String string8 = "'" + string7 + "'";
            String string9 = migrationConfig.getEndRowDelimiter();
            String string10 = "'" + string9 + "'";
            String[] stringArray = new String[mdColumnArray.length];
            for (int i = 0; i < mdColumnArray.length; ++i) {
                MdColumn mdColumn = mdColumnArray[i];
                String string11 = mdColumn.getColumnType();
                String string12 = mdColumn.getColumnName();
                Integer n = mdColumn.getPrecision();
                Integer n2 = mdColumn.getScale();
                if (n == null) {
                    n = 0;
                }
                if (n2 == null) {
                    n2 = 0;
                }
                stringArray[i] = this.getColumnPattern(string12, string11, n, n2, string7, mdColumn.getNullableFlag(), i == mdColumnArray.length - 1);
            }
            stringTemplate = this.m_templateGroup.getTemplateDefinition("Convert");
            stringTemplate.reset();
            stringTemplate.setAttribute("expfile", (Object)string6);
            stringTemplate.setAttribute("datfile", (Object)string5);
            stringTemplate.setAttribute("csvfile", (Object)string4);
            stringTemplate.setAttribute("collist", (Object)stringArray);
            stringTemplate.setAttribute("table", (Object)teradataMachine.quote(string));
            stringTemplate.setAttribute("eofd", (Object)string8);
            stringTemplate.setAttribute("eord", (Object)string10);
            stringTemplate.setAttribute("platformWindows", (Object)bl);
            string3 = stringTemplate.toString();
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.WARNING, exception.getLocalizedMessage());
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generateCSV(TeradataMachine teradataMachine, String string, MdColumn[] mdColumnArray) {
        String string2 = "";
        try {
            StringTemplate stringTemplate;
            this.loadTemplates();
            StringTemplate stringTemplate2 = stringTemplate = this.m_templateGroup.getTemplateDefinition("GenerateControlCSV");
            synchronized (stringTemplate2) {
                stringTemplate.reset();
                for (MdColumn mdColumn : mdColumnArray) {
                    stringTemplate.setAttribute("columndetails", (Object)new TeradataState.ColumnDetails(mdColumn));
                }
                stringTemplate.setAttribute("table", (Object)string);
                string2 = stringTemplate.toString();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    @Override
    public String getDataExportScript(TeradataMachine teradataMachine, String string, MdColumn[] mdColumnArray, String string2) {
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        StringTemplate stringTemplate = null;
        try {
            this.loadTemplates();
            String string3 = string2.toLowerCase().endsWith(".dat") ? "data/" + string2.substring(0, string2.length() - 4) + ".dat" : "data/" + string2 + ".dat";
            String string4 = migrationConfig.getEndColumnDelimiter();
            String string5 = "'" + string4 + "'";
            String string6 = migrationConfig.getEndRowDelimiter();
            String string7 = "'" + string6 + "'";
            String[] stringArray = new String[mdColumnArray.length];
            for (int i = 0; i < mdColumnArray.length; ++i) {
                MdColumn mdColumn = mdColumnArray[i];
                String string8 = mdColumn.getColumnType();
                String string9 = mdColumn.getColumnName();
                Integer n = mdColumn.getPrecision();
                Integer n2 = mdColumn.getScale();
                if (n == null) {
                    n = 0;
                }
                if (n2 == null) {
                    n2 = 0;
                }
                stringArray[i] = this.getColumnPattern(string9, string8, n, n2, string4, mdColumn.getNullableFlag(), i == mdColumnArray.length - 1);
            }
            stringTemplate = this.m_templateGroup.getTemplateDefinition("Unload");
            stringTemplate.reset();
            stringTemplate.setAttribute("outfile", (Object)string3);
            stringTemplate.setAttribute("collist", (Object)stringArray);
            stringTemplate.setAttribute("table", (Object)teradataMachine.quote(string));
            stringTemplate.setAttribute("eofd", (Object)string5);
            stringTemplate.setAttribute("eord", (Object)string7);
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.WARNING, exception.getLocalizedMessage());
        }
        return stringTemplate.toString();
    }

    @Override
    public String getColumnPattern(String string, String string2, int n, int n2, String string3, boolean bl, boolean bl2) {
        String string4 = "";
        boolean bl3 = true;
        String string5 = "";
        String string6 = "0";
        if (bl) {
            string5 = "case when \"" + string + "\" is null then 'Y' else 'N' end,\n";
        }
        if (string2.equals("DECIMAL")) {
            String string7 = Teradata12BTEQState.makeNumericFormat(n, n2, '+');
            string6 = Teradata12BTEQState.makeLengthString(string7.length(), 6);
            string4 = "CAST(\"" + string + "\" AS FORMAT '" + string7 + "')";
            string4 = "CAST((" + string4 + ") AS VARCHAR(" + string7.length() + "))";
            if (bl) {
                string4 = "case when \"" + string + "\" is null then '######' else " + string4 + " end";
            }
        } else if (string2.equals("DATE")) {
            string4 = "(\"" + string + "\"(FORMAT 'Y4-MM-DD') (VARCHAR(10)))";
            string6 = "'000010'";
            if (bl) {
                string4 = "case when \"" + string + "\" is null then '####-##-##' else " + string4 + " end";
            }
        } else if (string2.equals("ANSITIME")) {
            string4 = "(\"" + string + "\"(FORMAT 'HH:MI:SS.S(6)') (VARCHAR(15)))";
            string6 = "'000015'";
            if (bl) {
                string4 = "case when \"" + string + "\" is null then '##:##:##.######' else " + string4 + " end";
            }
        } else if (string2.equals("ANSITIMEWITHTIMEZONE")) {
            string4 = "(\"" + string + "\"(FORMAT 'HH:MI:SS.S(6)Z') (VARCHAR(21)))";
            string6 = "'000021'";
            if (bl) {
                string4 = "case when \"" + string + "\" is null then '##:##:##.######+##:##' else " + string4 + " end";
            }
        } else if (string2.equals("TIMESTAMPWITHOUTTIMEZONE")) {
            string4 = "(\"" + string + "\"(FORMAT 'Y4-MM-DDBHH:MI:SS.S(6)') (VARCHAR(26)))";
            string6 = "'000026'";
            if (bl) {
                string4 = "case when \"" + string + "\" is null then '####-##-## ##:##:##.######' else " + string4 + " end";
            }
        } else if (string2.equals("TIMESTAMPWITHTIMEZONE")) {
            string4 = "(\"" + string + "\"(FORMAT 'Y4-MM-DDBHH:MI:SS.S(6)Z') (VARCHAR(32)))";
            string6 = "'000032'";
            if (bl) {
                string4 = "case when \"" + string + "\" is null then '####-##-## ##:##:##.######+##:##' else " + string4 + " end";
            }
        } else if (string2.equals("DAY") || string2.equals("DAYHOUR") || string2.equals("DAYMINUTE") || string2.equals("DAYSECOND")) {
            int n3 = n + 10 + (n2 > 0 ? n2 + 1 : 0);
            string4 = "CAST(CAST(\"" + string + "\" AS INTERVAL DAY(" + n + ") TO SECOND(" + n2 + ")) AS VARCHAR(" + n3 + "))";
            if (bl) {
                string4 = "case when \"" + string + "\" is null then '' else " + string4 + " end";
            }
            string6 = Teradata12BTEQState.makeLengthString(string, bl, n3, 6);
        } else if (string2.equals("HOUR") || string2.equals("HOURMINUTE") || string2.equals("HOURSECOND")) {
            switch (n) {
                case 4: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                default: {
                    n = 1;
                }
            }
            int n4 = n + 10 + (n2 > 0 ? n2 + 1 : 0);
            string4 = "CAST(CAST(\"" + string + "\" AS INTERVAL DAY(" + n + ") TO SECOND(" + n2 + ")) AS VARCHAR(" + n4 + "))";
            if (bl) {
                string4 = "case when \"" + string + "\" is null then '' else " + string4 + " end";
            }
            string6 = Teradata12BTEQState.makeLengthString(string, bl, n4, 6);
        } else if (string2.equals("MINUTE") || string2.equals("MINUTETOSECOND") || string2.equals("SECOND")) {
            int n5 = 11 + (n2 > 0 ? n2 + 1 : 0);
            string4 = "CAST(CAST(\"" + string + "\" AS INTERVAL DAY(1) TO SECOND(" + n2 + ")) AS VARCHAR(" + n5 + "))";
            if (bl) {
                string4 = "case when \"" + string + "\" is null then '' else " + string4 + " end";
            }
            string6 = Teradata12BTEQState.makeLengthString(string, bl, n5, 6);
        } else if (string2.equals("YEAR") || string2.equals("YEARMONTH")) {
            int n6 = n + 4;
            string4 = "CAST(CAST(\"" + string + "\" AS INTERVAL YEAR(" + n + ") TO MONTH) AS VARCHAR(" + n6 + "))";
            if (bl) {
                string4 = "case when \"" + string + "\" is null then '' else " + string4 + " end";
            }
            string6 = Teradata12BTEQState.makeLengthString(string, bl, n6, 6);
        } else if (string2.equals("MONTH")) {
            switch (n) {
                case 4: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                default: {
                    n = 1;
                }
            }
            int n7 = n + 4;
            string4 = "CAST(CAST(\"" + string + "\" AS INTERVAL YEAR(" + n + ") TO MONTH) AS VARCHAR(" + n7 + "))";
            if (bl) {
                string4 = "case when \"" + string + "\" is null then '' else " + string4 + " end";
            }
            string6 = Teradata12BTEQState.makeLengthString(string, bl, n7, 6);
        } else if (string2.equals("CHARVARYINGLATIN") || string2.equals("CHARVARYINGGRAPHIC") || string2.equals("CHARVARYINGUNICODE") || string2.equals("CHARVARYINGKANJI1") || string2.equals("CHARVARYINGKANJISJIS")) {
            string4 = n > 4000 ? "'Too Large'" : "(\"" + string + "\")";
            string6 = "CAST((CASE WHEN " + string4 + " IS NULL THEN 0 ELSE CHARACTER_LENGTH(" + string4 + ") END) AS FORMAT '999999')";
            string6 = "CAST((" + string6 + ") AS VARCHAR(6))";
            if (bl) {
                string4 = "case when \"" + string + "\" is null then '' else " + string4 + " end";
            }
        } else if (string2.equals("BYTEFIXED")) {
            string4 = "\"" + string + "\"";
            string6 = Teradata12BTEQState.makeLengthString(n, 6);
            string4 = "CAST((" + string6 + ") AS VARCHAR(6)), " + string4;
            string6 = null;
            bl3 = false;
        } else if (string2.equals("BYTELARGEOBJECT")) {
            string4 = "\"" + string + "\"";
            string6 = "CAST((CASE WHEN " + string4 + " IS NULL THEN 8 ELSE (BYTES(" + string4 + ")+8) END) AS FORMAT '999999')";
            string4 = "CAST((" + string6 + ") AS VARCHAR(6)), " + string4;
            string6 = null;
            bl3 = false;
        } else if (string2.equals("BYTEVARYING")) {
            string4 = "\"" + string + "\"";
            string6 = "CAST((CASE WHEN " + string4 + " IS NULL THEN 2 ELSE (BYTES(" + string4 + ")+2) END) AS FORMAT '999999')";
            string4 = "CAST((" + string6 + ") AS VARCHAR(6)), " + string4;
            string6 = null;
            bl3 = false;
        } else if (string2.equals("CHARLARGEOBJECTLATIN") || string2.equals("CHARLARGEOBJECTGRAPHIC") || string2.equals("CHARLARGEOBJECTUNICODE") || string2.equals("CHARLARGEOBJECTKANJI1") || string2.equals("CHARLARGEOBJECTKANJISJIS")) {
            string4 = "\"" + string + "\"";
            string6 = "CAST((CASE WHEN " + string4 + " IS NULL THEN 0 ELSE CHARACTER_LENGTH(" + string4 + ") END) AS FORMAT '999999')";
            string6 = "CAST((" + string6 + ") AS VARCHAR(6))";
            if (bl) {
                string4 = "case when \"" + string + "\" is null then '' else " + string4 + " end";
            }
        } else if (string2.equals("REAL")) {
            string4 = "(CAST(\"" + string + "\" AS FORMAT '+9.9999999999999999E+999'))";
            string4 = "CAST((" + string4 + ") AS VARCHAR(24))";
            string6 = "'000024'";
            if (bl) {
                string4 = "case when \"" + string + "\" is null then '####################E###' else " + string4 + " end";
            }
        } else if (string2.equals("BIGINTEGER")) {
            string4 = "(CAST(\"" + string + "\" AS FORMAT '+9(20)'))";
            string4 = "CAST((" + string4 + ") AS VARCHAR(21))";
            string6 = "'000021'";
            if (bl) {
                string4 = "case when \"" + string + "\" is null then '#####################' else " + string4 + " end";
            }
        } else if (string2.equals("INTEGER")) {
            string4 = "(CAST(\"" + string + "\" AS FORMAT '+9(11)'))";
            string4 = "CAST((" + string4 + ") AS VARCHAR(12))";
            string6 = "'000012'";
            if (bl) {
                string4 = "case when \"" + string + "\" is null then '############' else " + string4 + " end";
            }
        } else if (string2.equals("SMALLINT")) {
            string4 = "(CAST(\"" + string + "\" AS FORMAT '+9(5)'))";
            string4 = "CAST((" + string4 + ") AS VARCHAR(6))";
            string6 = "'000006'";
            if (bl) {
                string4 = "case when \"" + string + "\" is null then '######' else " + string4 + " end";
            }
        } else if (string2.equals("BYTEINT")) {
            string4 = "(CAST(\"" + string + "\" AS FORMAT '+9(3)'))";
            string4 = "CAST((" + string4 + ") AS VARCHAR(4))";
            string6 = "'000004'";
            if (bl) {
                string4 = "case when \"" + string + "\" is null then '####' else " + string4 + " end";
            }
        } else if (string2.equals("CHARFIXEDLATIN")) {
            string4 = "(TRANSLATE(\"" + string + "\" USING LATIN_TO_UNICODE))";
            string4 = "CAST((" + string4 + ") AS VARCHAR(" + n + "))";
            string6 = Teradata12BTEQState.makeLengthString(n, 6);
            if (bl) {
                string4 = "case when \"" + string + "\" is null then '" + Teradata12BTEQState.makeFiller('#', n) + "' else " + string4 + " end";
            }
        } else if (string2.equals("CHARFIXEDUNICODE")) {
            string4 = "\"" + string + "\"";
            string4 = "CAST((" + string4 + ") AS VARCHAR(" + n + "))";
            string6 = Teradata12BTEQState.makeLengthString(n, 6);
            if (bl) {
                string4 = "case when \"" + string + "\" is null then '" + Teradata12BTEQState.makeFiller('#', n) + "' else " + string4 + " end";
            }
        } else if (string2.equals("CHARFIXEDGRAPHIC")) {
            string4 = "(TRANSLATE(\"" + string + "\" USING GRAPHIC_TO_UNICODE))";
            string4 = "CAST((" + string4 + ") AS VARCHAR(" + n + "))";
            string6 = Teradata12BTEQState.makeLengthString(n, 6);
            if (bl) {
                string4 = "case when \"" + string + "\" is null then '" + Teradata12BTEQState.makeFiller('#', n) + "' else " + string4 + " end";
            }
        } else if (string2.equals("CHARFIXEDKANJISJIS")) {
            string4 = "(TRANSLATE(\"" + string + "\" USING KANJISJIS_TO_UNICODE))";
            string4 = "CAST((" + string4 + ") AS VARCHAR(" + n + "))";
            string6 = Teradata12BTEQState.makeLengthString(n, 6);
            if (bl) {
                string4 = "case when \"" + string + "\" is null then '" + Teradata12BTEQState.makeFiller('#', n) + "' else " + string4 + " end";
            }
        } else if (string2.equals("CHARFIXEDKANJI1")) {
            string4 = "(TRANSLATE(\"" + string + "\" USING KANJI1_KANJISJIS_TO_UNICODE))";
            string4 = "CAST((" + string4 + ") AS VARCHAR(" + n + "))";
            string6 = Teradata12BTEQState.makeLengthString(n, 6);
            if (bl) {
                string4 = "case when \"" + string + "\" is null then '" + Teradata12BTEQState.makeFiller('#', n) + "' else " + string4 + " end";
            }
        } else {
            string4 = "\"" + string + "\"";
            string6 = null;
        }
        string4 = (bl3 ? "(" : "") + (string6 != null ? string6 + " || " : "") + string4 + (bl3 ? ")" : "");
        return string5 + string4;
    }

    @Override
    public Object[] generateExternalTableColumnDefinitions(TeradataMachine teradataMachine, MdColumn[] mdColumnArray, MdColumn[] mdColumnArray2) {
        return mdColumnArray2;
    }

    @Override
    public String generateExternalColumnDefinitions(TeradataMachine teradataMachine, MdColumn[] mdColumnArray, MdColumn[] mdColumnArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = new Vector();
        for (int i = 0; i < mdColumnArray2.length; ++i) {
            MdColumn mdColumn = mdColumnArray2[i];
            MdColumn mdColumn2 = mdColumnArray[i];
            stringBuffer.append(this.maybeQuoteExternalFieldReference(teradataMachine, mdColumn2, mdColumn));
            stringBuffer.append(' ');
            stringBuffer.append(this.formatSQLLoaderColumn(teradataMachine, mdColumn2, mdColumn, i + 1 >= mdColumnArray2.length));
            if (i >= mdColumnArray2.length - 1) continue;
            stringBuffer.append(", \n");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    @Override
    public String generateExternalSelectColumnList(TeradataMachine teradataMachine, MdColumn[] mdColumnArray, MdColumn[] mdColumnArray2) {
        return null;
    }

    public void generateBLOBUpdateSQL() {
        if (this.lobCols.size() > 0) {
            String string = "    ";
            for (MdColumn mdColumn : this.lobCols) {
                this.postSQLBuf.append(string);
                this.postSQLBuf.append("\"" + mdColumn.getColumnName() + "\"=DBMS_LOB.SUBSTR(\"" + mdColumn.getColumnName() + "\",DBMS_LOB.GETLENGTH(\"" + mdColumn.getColumnName() + "\")-8,8)");
                string = ",\n    ";
            }
            this.lobCols.clear();
        }
    }

    @Override
    public String maybeQuoteSqlldrFieldReference(TeradataMachine teradataMachine, MdColumn mdColumn, MdColumn mdColumn2) {
        String string = mdColumn.getColumnType();
        StringBuffer stringBuffer = new StringBuffer();
        if (mdColumn2.getNullableFlag()) {
            stringBuffer.append(teradataMachine.trunk30("NL_" + mdColumn2.getColumnName()));
            stringBuffer.append(" FILLER VARCHAR,\n");
        }
        if (string.equals("BIGINTEGER") || string.equals("BYTEFIXED") || string.equals("BYTEINT") || string.equals("BYTELARGEOBJECT") || string.equals("CHARFIXEDGRAPHIC") || string.equals("CHARFIXEDKANJI1") || string.equals("CHARFIXEDKANJISJIS") || string.equals("CHARFIXEDLATIN") || string.equals("CHARFIXEDUNICODE") || string.equals("CHARVARYINGGRAPHIC") || string.equals("CHARVARYINGKANJI1") || string.equals("CHARVARYINGKANJISJIS") || string.equals("CHARVARYINGLATIN") || string.equals("CHARVARYINGUNICODE") || string.equals("DAY") || string.equals("DAYHOUR") || string.equals("DAYMINUTE") || string.equals("DAYSECOND") || string.equals("DECIMAL") || string.equals("INTEGER") || string.equals("MINUTE") || string.equals("MINUTETOSECOND") || string.equals("REAL") || string.equals("SECOND") || string.equals("SMALLINT") || string.equals("DATE") || string.equals("ANSITIME") || string.equals("ANSITIMEWITHTIMEZONE") || string.equals("TIMESTAMPWITHOUTTIMEZONE") || string.equals("TIMESTAMPWITHTIMEZONE") || string.equals("HOUR") || string.equals("HOURMINUTE") || string.equals("HOURSECOND") || string.equals("YEAR") || string.equals("YEARMONTH") || string.equals("MONTH")) {
            stringBuffer.append("IG" + mdColumn.getColumnOrder() + " FILLER RAW(2),\n");
        } else if (string.equals("CHARLARGEOBJECTLATIN") || string.equals("CHARLARGEOBJECTGRAPHIC") || string.equals("CHARLARGEOBJECTUNICODE") || string.equals("CHARLARGEOBJECTKANJI1") || string.equals("CHARLARGEOBJECTKANJISJIS")) {
            stringBuffer.append("IG" + mdColumn.getColumnOrder() + " FILLER RAW(8),\n");
        } else if (string.equals("BYTEVARYING")) {
            stringBuffer.append("IG" + mdColumn.getColumnOrder() + " FILLER RAW(8),\n");
        }
        stringBuffer.append(mdColumn2.getColumnName());
        return stringBuffer.toString();
    }

    @Override
    public String maybeQuoteExternalFieldReference(TeradataMachine teradataMachine, MdColumn mdColumn, MdColumn mdColumn2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (mdColumn2.getNullableFlag()) {
            stringBuffer.append(teradataMachine.trunk30("NL_" + mdColumn2.getColumnName()));
            stringBuffer.append(" FILLER VARCHAR(16),\n");
        }
        stringBuffer.append(mdColumn2.getColumnName());
        return stringBuffer.toString();
    }

    @Override
    public String formatSQLLoaderColumn(TeradataMachine teradataMachine, MdColumn mdColumn, MdColumn mdColumn2, boolean bl) {
        String string = "";
        String string2 = mdColumn2.getColumnName();
        boolean bl2 = mdColumn.getNullableFlag();
        String string3 = mdColumn.getColumnType();
        String string4 = "";
        Integer n = mdColumn.getPrecision() == null ? 0 : mdColumn.getPrecision();
        String string5 = "";
        String string6 = "";
        Integer n2 = mdColumn2.getPrecision();
        int n3 = 0;
        if (bl2) {
            string5 = " NULLIF " + teradataMachine.trunk30("NL_" + string2) + "='Y'";
        }
        n3 = n2 == null ? 0 : n2;
        if (string3.equals("BIGINTEGER") || string3.equals("BYTEINT") || string3.equals("CHARFIXEDGRAPHIC") || string3.equals("CHARFIXEDKANJI1") || string3.equals("CHARFIXEDKANJISJIS") || string3.equals("CHARFIXEDLATIN") || string3.equals("CHARFIXEDUNICODE") || string3.equals("CHARLARGEOBJECTGRAPHIC") || string3.equals("CHARLARGEOBJECTKANJI1") || string3.equals("CHARLARGEOBJECTKANJISJIS") || string3.equals("CHARLARGEOBJECTLATIN") || string3.equals("CHARLARGEOBJECTUNICODE") || string3.equals("CHARVARYINGGRAPHIC") || string3.equals("CHARVARYINGKANJI1") || string3.equals("CHARVARYINGKANJISJIS") || string3.equals("CHARVARYINGLATIN") || string3.equals("CHARVARYINGUNICODE") || string3.equals("DECIMAL") || string3.equals("INTEGER") || string3.equals("REAL") || string3.equals("SMALLINT")) {
            string = "VARCHARC(6,4000)";
        } else if (string3.equals("BYTEFIXED")) {
            string = "VARRAWC(6,4000)";
        } else if (string3.equals("BYTEVARYING")) {
            string = "VARRAW(4000)";
        } else if (string3.equals("DAY") || string3.equals("DAYHOUR") || string3.equals("DAYMINUTE") || string3.equals("DAYSECOND") || string3.equals("HOUR") || string3.equals("HOURMINUTE") || string3.equals("HOURSECOND") || string3.equals("MINUTE") || string3.equals("MINUTETOSECOND") || string3.equals("SECOND")) {
            string = "VARCHARC(6,4000)";
            string6 = " \"TO_DSINTERVAL(:" + string2 + ")\"";
        } else if (string3.equals("YEAR") || string3.equals("YEARMONTH") || string3.equals("MONTH")) {
            string = "VARCHARC(6,4000)";
            string6 = " \"TO_YMINTERVAL(:" + string2 + ")\"";
        } else if (string3.equals("BYTELARGEOBJECT")) {
            string = "VARRAWC(6,99999)";
            this.lobCols.add(mdColumn);
        } else if (string3.equals("DATE")) {
            string = "VARCHARC(6,4000)";
            string6 = " \"TO_DATE(:" + string2 + ",  'YYYY-MM-DD')\"";
        } else if (string3.equals("ANSITIME")) {
            string = "VARCHARC(6,4000)";
            string6 = " \"TO_TIMESTAMP(:" + string2 + ",  'HH24:MI:SS.FF6')\"";
        } else if (string3.equals("ANSITIMEWITHTIMEZONE")) {
            string = "VARCHARC(6,4000)";
            string6 = " \"TO_TIMESTAMP_TZ(:" + string2 + ",  'HH24:MI:SS.FF6TZH:TZM')\"";
        } else if (string3.equals("TIMESTAMPWITHOUTTIMEZONE")) {
            string = "VARCHARC(6,4000)";
            string6 = " \"TO_TIMESTAMP(:" + string2 + ",  'YYYY-MM-DD HH24:MI:SS.FF6')\"";
        } else if (string3.equals("TIMESTAMPWITHTIMEZONE")) {
            string = "VARCHARC(6,4000)";
            string6 = " \"TO_TIMESTAMP_TZ(:" + string2 + ",  'YYYY-MM-DD HH24:MI:SS.FF6TZH:TZM')\"";
        } else {
            string = "XXX(" + string3 + ")XXX";
            System.out.println("UNHANDLED TYPE " + string + (bl ? "" : string4) + string5 + string6);
        }
        return string + (bl ? "" : string4) + string5 + string6;
    }

    protected void loadTemplates() {
        if (this.m_templateGroup == null) {
            RaptorGroupLoader raptorGroupLoader = new RaptorGroupLoader("oracle/dbtools/migration/workbench/plugin/teradata/templates", this.getClass().getClassLoader());
            StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)raptorGroupLoader);
            StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
            this.m_templateGroup = StringTemplateGroup.loadGroup((String)"OfflineCapturer");
        }
    }

    @Override
    public String getSQLLoaderCommand(TeradataMachine teradataMachine, String string, String string2, boolean bl) {
        this.loadTemplates();
        return "";
    }

    public static String makeFiller(char c, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    @Override
    public String getPostLoadSQL() {
        this.generateBLOBUpdateSQL();
        String string = this.postSQLBuf.toString();
        this.postSQLBuf.setLength(0);
        return string;
    }
}

