/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.util;

import java.util.Locale;

public class BIDIText {
    public static final char UNICODE_LRO = '\u202d';
    public static final int NATIONAL_DIGIT_SUBSTITUTION = 1;
    public static final int NONE_DIGIT_SUBSTITUTION = 0;
    public static final int CONTEXT_DIGIT_SUBSTITUTION = 2;
    private static final int _NO_DIRECTION = -1;
    private static final int _ARABIC_LETTER_BASE = 1569;
    private static final int _ARABIC_EXTENDED_LETTER_BASE = 1649;
    private static final int _ISOLATED_SHAPE = 0;
    private static final int _INITIAL_SHAPE = 1;
    private static final int _FINAL_SHAPE = 2;
    private static final int _MEDIAL_SHAPE = 3;
    private static final int _ALEF_MADDA_ABOVE = 0;
    private static final int _ALEF_HAMZA_ABOVE = 1;
    private static final int _ALEF_HAMZA_BELOW = 2;
    private static final int _ALEF = 3;
    private static final char _LATIN_DECIMAL_SEPARATOR = '.';
    private static final char _LATIN_THOUSAND_SEPARATOR = ',';
    private static final char _ARABIC_DECIMAL_SEPARATOR = '\u066b';
    private static final char _ARABIC_THOUSAND_SEPARATOR = '\u060c';
    private static final char _ZWNBS = '\ufeff';
    private static Locale _locale = Locale.getDefault();
    private static Locale _clientLocale;
    private static boolean _isHebrewEnabled;
    private static boolean _isArabicEnabled;
    private static boolean _isExtendedArabicEnabled;
    private static boolean _isClientHebrewEnabled;
    private static boolean _isClientArabicEnabled;
    private static boolean _osDoesLayout;
    private static boolean _javaDoesLayout;
    private static boolean _insertVisualControlCharAlways;
    private static boolean _changeSpaceToNBSpace;
    private static final char[][] _sGlyphs;
    private static final char[][] _sExtendedGlyphs;
    private static final char[][] _sLAM_ALEF_glyphs;
    private static final char[] _HEBREW_NUMBER_SEPARATORS;
    private static final char[] _SPECIAL_HEBREW_NUMBER_SEPARATORS;
    private static final char[] _ARABIC_NUMBER_SEPARATORS;
    private static final char _SPECIAL_ARABIC_NUMBER_SEPARATOR = ':';
    private String _logicalText;
    private char[] _visualText;
    private int[] _logicalOrder;
    private int[] _visualOrder;
    private int _nLogical;
    private int _nVisual;
    private int _baseDirection;
    private int[] _directions;
    private boolean _displayOnly;
    private static int _digitSubstitution;

    public BIDIText(String string, int n, Locale locale) {
        this(string, n, locale, false);
    }

    BIDIText(String string, int n, Locale locale, boolean bl) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("invalid direction:" + n);
        }
        this._baseDirection = n;
        _locale = locale;
        this._nLogical = string.length();
        this._logicalText = string;
        this._visualText = string.toCharArray();
        this._displayOnly = bl;
        this._directions = new int[this._nLogical];
        this._visualOrder = this._displayOnly ? null : new int[this._nLogical];
        this._logicalOrder = this._displayOnly ? null : new int[this._nLogical];
        _isHebrewEnabled = _locale.getLanguage().equals("iw") || _locale.getLanguage().equals("he");
        _isExtendedArabicEnabled = _locale.getLanguage().equals("fa");
        _isArabicEnabled = _locale.getLanguage().equals("ar") || _isExtendedArabicEnabled;
        _javaDoesLayout = !System.getProperty("java.version").startsWith("1.1");
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = System.getProperty("os.name");
        if (string2.startsWith("Windows")) {
            boolean bl4;
            float f;
            boolean bl5 = "Windows NT".equals(string2);
            String string3 = System.getProperty("os.version");
            try {
                Float f2 = new Float(string3);
                f = f2.floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                f = 5.1f;
            }
            bl2 = bl4 = (double)f >= 5.0;
            bl3 = bl5 || bl4;
        }
        _osDoesLayout = _isHebrewEnabled && bl3 || _isArabicEnabled && bl2;
    }

    public String getLogicalText() {
        return this._logicalText;
    }

    public int getLogicalLength() {
        return this._nLogical;
    }

    public String getVisualText() {
        int n;
        if (this._logicalText == null || this._logicalText.length() == 0) {
            return "";
        }
        int n2 = this._logicalText.length();
        char[] cArray = new char[n2];
        int[] nArray = new int[n2];
        int n3 = this._baseDirection;
        char[] cArray2 = this._logicalText.toCharArray();
        this._visualText = this._logicalText.toCharArray();
        int[] nArray2 = null;
        if (!this._displayOnly) {
            this._visualOrder = new int[n2];
            nArray2 = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray2[n] = n;
            }
        }
        this._nVisual = 0;
        this._updateDirections(cArray2);
        cArray2 = BIDIText._shapeDigits(cArray2, this._baseDirection);
        for (n = 0; n < n2; ++n) {
            int n4 = n;
            n3 = this._directions[n];
            while (n < n2 && this._directions[n] == n3) {
                ++n;
            }
            int n5 = n - n4;
            if (n3 == 2) {
                char[] cArray3 = new char[n5];
                int[] nArray3 = this._displayOnly ? null : new int[n5];
                System.arraycopy(cArray2, n4, cArray3, 0, n5);
                if (!this._displayOnly) {
                    System.arraycopy(nArray2, n4, nArray3, 0, n5);
                }
                cArray3 = BIDIText._shapeArabicSegment(cArray3);
                BIDIText._flipArray(cArray3, 0, cArray3.length);
                if (!this._displayOnly) {
                    BIDIText._flipArray(nArray3, 0, nArray3.length);
                }
                this._flipDigitsInText(cArray3, nArray3);
                System.arraycopy(cArray3, 0, cArray2, n4, cArray3.length);
                if (!this._displayOnly) {
                    System.arraycopy(nArray3, 0, nArray2, n4, nArray3.length);
                }
            }
            if (this._baseDirection == 2) {
                System.arraycopy(this._visualText, 0, cArray, 0, this._nVisual);
                System.arraycopy(cArray2, n4, this._visualText, 0, n5);
                System.arraycopy(cArray, 0, this._visualText, n5, this._nVisual);
                if (!this._displayOnly) {
                    System.arraycopy(this._visualOrder, 0, nArray, 0, this._nVisual);
                    System.arraycopy(nArray2, n4, this._visualOrder, 0, n5);
                    System.arraycopy(nArray, 0, this._visualOrder, n5, this._nVisual);
                }
            } else {
                System.arraycopy(cArray2, n4, this._visualText, this._nVisual, n5);
                if (!this._displayOnly) {
                    System.arraycopy(nArray2, n4, this._visualOrder, this._nVisual, n5);
                }
            }
            this._nVisual += n5;
            --n;
        }
        this._compactArrays();
        if (!this._displayOnly) {
            this._updateLogicalOrder();
        }
        if (BIDIText.isAlwaysInsertVisualControlChar() || _osDoesLayout || _javaDoesLayout && (_isArabicEnabled || _isHebrewEnabled)) {
            this._insertVisualControlChar('\u202d', 0);
            if (BIDIText.isAlwaysChangeSpaceToNBSpace()) {
                this._changeSpaceToNBSpace(this._visualText);
            }
        }
        return new String(this._visualText, 0, this._nVisual);
    }

    private void _changeSpaceToNBSpace(char[] cArray) {
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] != ' ') continue;
            cArray[i] = 160;
        }
    }

    public int[] getLogicalOrder() {
        return this._logicalOrder;
    }

    public int[] getVisualOrder() {
        return this._visualOrder;
    }

    public int getBaseDirection() {
        return this._baseDirection;
    }

    public int getLeftmostIndex() {
        return this._visualOrder[0];
    }

    public int getRightmostIndex() {
        return this._visualOrder[this._nVisual - 1];
    }

    public int[] getLogicalDirections() {
        return this._directions;
    }

    public static boolean isRightToLeft(char c) {
        return BIDIText._isRightToLeft(c);
    }

    public static void setAlwaysInsertVisualControlChar(boolean bl) {
        _insertVisualControlCharAlways = bl;
    }

    public static boolean isAlwaysInsertVisualControlChar() {
        return _insertVisualControlCharAlways;
    }

    public static void setAlwaysChangeSpaceToNBSpace(boolean bl) {
        _changeSpaceToNBSpace = bl;
    }

    public static boolean isAlwaysChangeSpaceToNBSpace() {
        return _changeSpaceToNBSpace;
    }

    public static void setBIDIClientLocale(Locale locale) {
        if ("ar".equals(locale.getLanguage())) {
            _isClientArabicEnabled = true;
            _isClientHebrewEnabled = false;
        } else if ("iw".equals(locale.getLanguage()) || "he".equals(locale.getLanguage())) {
            _isClientHebrewEnabled = true;
            _isClientArabicEnabled = false;
        } else if ("fa".equals(locale.getLanguage())) {
            _isExtendedArabicEnabled = true;
            _isClientArabicEnabled = true;
            _isClientHebrewEnabled = false;
        } else {
            _isClientHebrewEnabled = false;
            _isClientArabicEnabled = false;
        }
        _clientLocale = locale;
    }

    public static Locale getBIDIClientLocale() {
        return _clientLocale;
    }

    public static void setDigitSubstitution(int n) {
        if (n > 2 || n < 0) {
            throw new IllegalArgumentException();
        }
        _digitSubstitution = n;
    }

    public static int getDigitSubstitution() {
        return _digitSubstitution;
    }

    private static char _shapeLAM_ALEF(int n, char c, char c2) {
        boolean bl = false;
        boolean bl2 = false;
        bl = BIDIText._canConnectToLeft(c);
        bl2 = BIDIText._canConnectToRight(c2);
        char c3 = bl ? _sLAM_ALEF_glyphs[n][2] : _sLAM_ALEF_glyphs[n][0];
        return c3;
    }

    private static char[] _shapeArabicSegment(char[] cArray) {
        boolean bl = false;
        boolean bl2 = false;
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        int n = 0;
        for (n = 0; n < cArray.length; ++n) {
            int n2 = cArray[n];
            char c = BIDIText._getPreviousChar(cArray, n);
            char c2 = BIDIText._getNextChar(cArray, n);
            if (n2 >= 1569 && n2 <= 1610 || n2 >= 1649 && n2 <= 1747) {
                bl2 = BIDIText._canConnectToRight(c2);
                if (bl2 && bl) {
                    cArray2[n] = BIDIText._getMedialShape((char)n2);
                } else if (bl2 && !bl) {
                    cArray2[n] = BIDIText._getInitialShape((char)n2);
                } else if (!bl2 && bl) {
                    cArray2[n] = BIDIText._getFinalShape((char)n2);
                } else if (!bl2 && !bl) {
                    cArray2[n] = BIDIText._getIsolatedShape((char)n2);
                }
                if (BIDIText._canConnectToLeft((char)n2)) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            cArray2[n] = n2 == 65269 ? BIDIText._shapeLAM_ALEF(0, c, c2) : (n2 == 65271 ? BIDIText._shapeLAM_ALEF(1, c, c2) : (n2 == 65273 ? BIDIText._shapeLAM_ALEF(2, c, c2) : (n2 == 65275 ? BIDIText._shapeLAM_ALEF(3, c, c2) : (n2 == 40 ? 41 : (n2 == 41 ? 40 : (n2 == 62 ? 60 : (n2 == 60 ? 62 : (n2 == 123 ? 125 : (n2 == 125 ? 123 : (n2 == 91 ? 93 : (n2 == 93 ? 91 : (n2 == 41 ? 40 : (n2 == 63 ? (_isArabicEnabled || _isClientArabicEnabled || BIDIText._isArabicLetter(BIDIText._getPreviousChar(cArray, n)) || BIDIText._getPreviousChar(cArray2, n) == '\u061f' ? 1567 : n2) : n2)))))))))))));
            if (n2 == 65279) continue;
            bl = false;
        }
        return cArray2;
    }

    private static char[] _shapeDigits(char[] cArray, int n) {
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        if ((_isArabicEnabled || _isClientArabicEnabled) && _digitSubstitution != 0) {
            for (int i = 0; i < cArray.length; ++i) {
                boolean bl;
                char c = cArray[i];
                int n2 = BIDIText._getPrevStrongDirection(cArray, i);
                if (n2 != 2 && (n2 != -1 || n != 2) && 1 != _digitSubstitution) continue;
                if (c >= '0' && c <= '9') {
                    if (!_isExtendedArabicEnabled) {
                        cArray2[i] = (char)(1632 + (c - 48));
                        continue;
                    }
                    cArray2[i] = (char)(1776 + (c - 48));
                    continue;
                }
                if (c != '.' && c != ',' || i + 1 >= cArray.length || !Character.isDigit(cArray[i + 1])) continue;
                boolean bl2 = bl = i <= 0 || !BIDIText._isArabicLetter(cArray[i - 1]) && cArray[i - 1] != '\ufeff';
                if (!bl) continue;
                cArray2[i] = c == '.' ? 1643 : 1548;
            }
        }
        return cArray2;
    }

    private static boolean _canConnectToRight(char c) {
        if (c >= '\u0621' && c <= '\u064a') {
            if (_sGlyphs[c - 1569][2] != '\u0000') {
                return true;
            }
            if (_sGlyphs[c - 1569][3] != '\u0000') {
                return true;
            }
        }
        if (c >= '\u0671' && c <= '\u06d3') {
            if (_sExtendedGlyphs[c - 1649][2] != '\u0000') {
                return true;
            }
            if (_sExtendedGlyphs[c - 1649][3] != '\u0000') {
                return true;
            }
        } else if (c >= '\ufef5' && c <= '\ufefc') {
            return true;
        }
        return false;
    }

    private static boolean _canConnectToLeft(char c) {
        if (c >= '\u0621' && c <= '\u064a') {
            if (_sGlyphs[c - 1569][1] != '\u0000') {
                return true;
            }
            if (_sGlyphs[c - 1569][3] != '\u0000') {
                return true;
            }
        }
        if (c >= '\u0671' && c <= '\u06d3') {
            if (_sExtendedGlyphs[c - 1649][1] != '\u0000') {
                return true;
            }
            if (_sExtendedGlyphs[c - 1649][3] != '\u0000') {
                return true;
            }
        }
        return false;
    }

    private static void _flipArray(char[] cArray, int n, int n2) {
        int n3 = n2 / 2;
        int n4 = n + n2 - 1;
        for (int i = 0; i < n3; ++i) {
            char c = cArray[n + i];
            cArray[n + i] = cArray[n4 - i];
            cArray[n4 - i] = c;
        }
    }

    private static void _flipArray(int[] nArray, int n, int n2) {
        int n3 = n2 / 2;
        int n4 = n + n2 - 1;
        for (int i = 0; i < n3; ++i) {
            int n5 = nArray[n + i];
            nArray[n + i] = nArray[n4 - i];
            nArray[n4 - i] = n5;
        }
    }

    private void _flipDigitsInText(char[] cArray, int[] nArray) {
        int n = cArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            boolean bl;
            char c = cArray[i];
            boolean bl2 = bl = !(!_isHebrewEnabled && !_isClientHebrewEnabled || c != '%' && c != '$' && c != '#' || i == n - 1 || !Character.isDigit(cArray[i + 1]));
            if (!Character.isDigit(c) && c != '\u066b' && c != '\u060c' && !bl) continue;
            n2 = i;
            boolean bl3 = false;
            while (i < n) {
                if (Character.isDigit(cArray[i])) {
                    ++i;
                    continue;
                }
                if ((!_isExtendedArabicEnabled && !_isArabicEnabled || (this._baseDirection != 2 || cArray[i] != ':') && (BIDIText.getDigitSubstitution() != 0 || cArray[i] != '.' && cArray[i] != ',')) && cArray[i] != '\u066b' && cArray[i] != '\u060c' && !(bl3 = (_isHebrewEnabled || _isClientHebrewEnabled) && BIDIText._isHebrewNumberSeparator(cArray[i])) && (cArray[i] != '.' || i == n - 1 || !Character.isDigit(cArray[i + 1])) || i == n2 && (!_isHebrewEnabled && !_isClientHebrewEnabled || cArray[i] != '%' && cArray[i] != '$' && cArray[i] != '#') || bl3 && BIDIText._isSpecialHebrewNumberSeparators(cArray[i]) && (i == n - 1 || !Character.isDigit(cArray[i + 1])) || (cArray[i] == '+' || cArray[i] == '-' || this._baseDirection == 2 && cArray[i] == '.' && (!_isExtendedArabicEnabled && !_isArabicEnabled || BIDIText.getDigitSubstitution() != 0)) && (i == n - 1 || !Character.isDigit(cArray[i + 1])) || cArray[i] == ':' && (i == n - 1 || !Character.isDigit(cArray[i + 1])) || bl3 && cArray[i] == '*' && BIDIText._isPreviousLetterHebrew(cArray, i)) break;
                ++i;
            }
            BIDIText._flipArray(cArray, n2, i - n2);
            if (nArray == null) continue;
            BIDIText._flipArray(nArray, n2, i - n2);
        }
    }

    private static boolean _isPreviousLetterHebrew(char[] cArray, int n) {
        int n2 = cArray.length;
        for (int i = n + 1; i < n2; ++i) {
            if (!Character.isLetter(cArray[i])) continue;
            return BIDIText._isHebrewLetter(cArray[i]);
        }
        return false;
    }

    private static char _getIsolatedShape(char c) {
        char c2 = '\u0000';
        if (c >= '\u0621' && c <= '\u064a') {
            c2 = _sGlyphs[c - 1569][0];
        } else if (c >= '\u0671' && c <= '\u06d3') {
            c2 = _sExtendedGlyphs[c - 1649][0];
        }
        return c2;
    }

    private static char _getFinalShape(char c) {
        if (c == '\u0621') {
            return BIDIText._getIsolatedShape(c);
        }
        char c2 = '\u0000';
        if (c >= '\u0621' && c <= '\u064a') {
            c2 = _sGlyphs[c - 1569][2];
        } else if (c >= '\u0671' && c <= '\u06d3') {
            c2 = _sExtendedGlyphs[c - 1649][2];
        }
        return c2;
    }

    private static char _getInitialShape(char c) {
        char c2 = '\u0000';
        if (c >= '\u0621' && c <= '\u064a') {
            c2 = _sGlyphs[c - 1569][1];
        } else if (c >= '\u0671' && c <= '\u06d3') {
            c2 = _sExtendedGlyphs[c - 1649][1];
        }
        if (c2 == '\u0000') {
            c2 = BIDIText._getIsolatedShape(c);
        }
        return c2;
    }

    private static char _getMedialShape(char c) {
        char c2 = '\u0000';
        if (c >= '\u0621' && c <= '\u064a') {
            c2 = _sGlyphs[c - 1569][3];
        } else if (c >= '\u0671' && c <= '\u06d3') {
            c2 = _sExtendedGlyphs[c - 1649][3];
        }
        if (c2 == '\u0000') {
            c2 = BIDIText._getFinalShape(c);
        }
        return c2;
    }

    private static int _getNextStrongDirection(char[] cArray, int n, int n2) {
        if (n2 <= 0) {
            n2 = cArray.length;
        }
        for (int i = n; i < n2; ++i) {
            if (BIDIText._isRightToLeft(cArray[i])) {
                return 2;
            }
            if (!BIDIText._isLeftToRight(cArray[i])) continue;
            return 1;
        }
        return -1;
    }

    private static int _getPrevStrongDirection(char[] cArray, int n) {
        for (int i = n; i >= 0; --i) {
            if (BIDIText._isRightToLeft(cArray[i])) {
                return 2;
            }
            if (!BIDIText._isLeftToRight(cArray[i])) continue;
            return 1;
        }
        return -1;
    }

    private static boolean _isArabicLetter(char c) {
        return c >= '\u0600' && c <= '\u065f';
    }

    private static boolean _isExtendedArabicLetter(char c) {
        return c >= '\u0671' && c <= '\u06d3';
    }

    private static boolean _isHebrewLetter(char c) {
        return c >= '\u0590' && c <= '\u05ff';
    }

    private static boolean _isLatinLetter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private static boolean _isRightToLeft(char c) {
        if (BIDIText._isArabicLetter(c) || BIDIText._isExtendedArabicLetter(c) || BIDIText._isHebrewLetter(c)) {
            return true;
        }
        if (c >= '\ufe70' && c <= '\ufeff') {
            return true;
        }
        return c >= '\ufb50' && c <= '\ufdff';
    }

    private static boolean _isLeftToRight(char c) {
        return !BIDIText._isRightToLeft(c) && Character.isLetter(c);
    }

    private static boolean _isArabicDiacritic(char c) {
        return c > '\u064a' && c < '\u0652';
    }

    private static boolean _isHebrewNumberSeparator(char c) {
        for (int i = 0; i < _HEBREW_NUMBER_SEPARATORS.length; ++i) {
            if (c != _HEBREW_NUMBER_SEPARATORS[i]) continue;
            return true;
        }
        return false;
    }

    private static boolean _isSpecialHebrewNumberSeparators(char c) {
        int n = _SPECIAL_HEBREW_NUMBER_SEPARATORS.length;
        for (int i = 0; i < n; ++i) {
            if (_SPECIAL_HEBREW_NUMBER_SEPARATORS[i] != c) continue;
            return true;
        }
        return false;
    }

    private static boolean _isArabicNumberSeparator(char c) {
        for (int i = 0; i < _ARABIC_NUMBER_SEPARATORS.length; ++i) {
            if (c != _ARABIC_NUMBER_SEPARATORS[i]) continue;
            return true;
        }
        return false;
    }

    private static char _getPreviousChar(char[] cArray, int n) {
        --n;
        block3: while (n >= 0) {
            char c = cArray[n];
            switch (c) {
                case '\ufeff': {
                    --n;
                    continue block3;
                }
            }
            return c;
        }
        return '\u0000';
    }

    private static char _getNextChar(char[] cArray, int n) {
        ++n;
        block3: while (n < cArray.length) {
            char c = cArray[n];
            switch (c) {
                case '\ufeff': {
                    ++n;
                    continue block3;
                }
            }
            return c;
        }
        return '\u0000';
    }

    private void _updateLogicalOrder() {
        int n;
        for (n = 0; n < this._nLogical; ++n) {
            this._logicalOrder[n] = -1;
        }
        for (n = 0; n < this._nVisual; ++n) {
            this._logicalOrder[this._visualOrder[n]] = n;
        }
        for (n = 0; n < this._nLogical; ++n) {
            if (this._logicalOrder[n] != -1) continue;
            this._logicalOrder[n] = n - 1 >= 0 ? this._logicalOrder[n - 1] : 0;
        }
    }

    private void _updateDirections(char[] cArray) {
        int n;
        int n2;
        int n3 = cArray.length;
        int n4 = this._baseDirection;
        for (n2 = 0; n2 < n3; ++n2) {
            if (cArray[n2] == '\u0644') {
                if (n2 + 1 < n3) {
                    n = 0;
                    if (cArray[n2 + 1] == '\u0622') {
                        cArray[n2] = 65269;
                        n = 1;
                    } else if (cArray[n2 + 1] == '\u0623') {
                        cArray[n2] = 65271;
                        n = 1;
                    } else if (cArray[n2 + 1] == '\u0625') {
                        cArray[n2] = 65273;
                        n = 1;
                    } else if (cArray[n2 + 1] == '\u0627') {
                        cArray[n2] = 65275;
                        n = 1;
                    }
                    if (n != 0) {
                        this._directions[n2] = 2;
                        this._directions[n2 + 1] = 2;
                        cArray[n2 + 1] = 65279;
                        ++n2;
                        continue;
                    }
                }
            } else if (BIDIText._isArabicDiacritic(cArray[n2])) {
                cArray[n2] = 65279;
                this._directions[n2] = 2;
                continue;
            }
            this._directions[n2] = Character.isDigit(cArray[n2]) ? -1 : (BIDIText._isRightToLeft(cArray[n2]) ? 2 : (BIDIText._isLeftToRight(cArray[n2]) ? 1 : -1));
        }
        n4 = -1;
        for (n2 = 0; n2 < n3; ++n2) {
            int n5;
            n = -1;
            if (this._directions[n2] != -1) {
                n4 = this._directions[n2];
                continue;
            }
            n = BIDIText._getNextStrongDirection(cArray, n2, n3);
            this._directions[n2] = n4 == n && n4 != -1 ? n4 : (Character.isDigit(cArray[n2]) && this._isFollowedByLTR(n2, n3) && this._baseDirection == 2 ? 1 : ((n5 = this._getDirection(cArray, n2)) != -1 ? n5 : (n4 != -1 && Character.isDigit(cArray[n2]) ? n4 : (n4 == -1 && n != -1 && this._isDigitOrDigitSeparator(cArray, n2) ? n : (n4 != -1 && this.isFollowedByDigits(cArray, n2, 0) ? n4 : this._baseDirection)))));
        }
    }

    private void _insertVisualControlChar(char c, int n) {
        char[] cArray = new char[this._nVisual + 1];
        int[] nArray = this._displayOnly ? null : new int[this._nVisual + 1];
        System.arraycopy(this._visualText, 0, cArray, 0, n);
        cArray[n] = c;
        System.arraycopy(this._visualText, n, cArray, n + 1, this._nVisual - n);
        this._visualText = cArray;
        if (!this._displayOnly) {
            System.arraycopy(this._visualOrder, 0, nArray, 0, n);
            nArray[n] = 0;
            System.arraycopy(this._visualOrder, n, nArray, n + 1, this._nVisual - n);
            this._visualOrder = nArray;
        }
        ++this._nVisual;
        if (!this._displayOnly) {
            for (int i = 0; i < this._nLogical; ++i) {
                if (this._logicalOrder[i] < n || this._logicalOrder[i] + 1 >= this._nVisual) continue;
                int n2 = i;
                this._logicalOrder[n2] = this._logicalOrder[n2] + 1;
            }
        }
    }

    private void _compactArrays() {
        char[] cArray = new char[this._nVisual];
        int[] nArray = this._displayOnly ? null : new int[this._nVisual];
        int n = 0;
        for (int i = 0; i < this._nVisual; ++i) {
            char c = this._visualText[i];
            if (c == '\ufeff') continue;
            cArray[n] = this._visualText[i];
            if (!this._displayOnly) {
                nArray[n] = this._visualOrder[i];
            }
            ++n;
        }
        System.arraycopy(cArray, 0, this._visualText, 0, n);
        if (!this._displayOnly) {
            System.arraycopy(nArray, 0, this._visualOrder, 0, n);
        }
        this._nVisual = n;
    }

    private boolean _isFollowedByLTR(int n, int n2) {
        while (this._directions[n] == -1 && n < n2 - 1) {
            ++n;
        }
        return this._directions[n] == 1;
    }

    private boolean _isFollowedByRTL(int n, int n2) {
        while (this._directions[n] == -1 && n < n2 - 1) {
            ++n;
        }
        return this._directions[n] == 2;
    }

    private boolean isFollowedByDigits(char[] cArray, int n, int n2) {
        if (n >= cArray.length) {
            return false;
        }
        int n3 = n2 <= 0 ? cArray.length : n + n2;
        if (n3 > cArray.length) {
            n3 = cArray.length;
        }
        while (n < n3) {
            if (BIDIText._isRightToLeft(cArray[n]) || BIDIText._isLeftToRight(cArray[n])) {
                return false;
            }
            if (!Character.isDigit(cArray[n++])) continue;
            return true;
        }
        return false;
    }

    private boolean _isDigitOrDigitSeparator(char[] cArray, int n) {
        char c = cArray[n];
        if (Character.isDigit(c)) {
            return true;
        }
        char c2 = '\u0000';
        char c3 = '\u0000';
        if (n - 1 >= 0) {
            c2 = cArray[n - 1];
        }
        if (n + 1 < cArray.length) {
            c3 = cArray[n + 1];
        }
        return Character.isDigit(c2) && Character.isDigit(c3) && (c == '\u066b' || c == '\u060c');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int _getDirection(char[] cArray, int n) {
        char c = cArray[n];
        if (_isHebrewEnabled || _isClientHebrewEnabled) {
            if (this._baseDirection == 1 && Character.isDigit(c) && this._isFollowedByRTL(n, cArray.length)) {
                return 2;
            }
            if (!BIDIText._isHebrewNumberSeparator(c)) return -1;
            char c2 = '\u0000';
            char c3 = '\u0000';
            if (n - 1 >= 0) {
                c2 = cArray[n - 1];
            }
            if (n + 1 < cArray.length) {
                c3 = cArray[n + 1];
            }
            if (!Character.isDigit(c2)) return -1;
            if (c == '%' || c == '$' || c == '#') {
                return this._directions[n - 1];
            }
            if (!Character.isDigit(c3)) return -1;
            if (c != '*') return this._directions[n - 1];
            if (this._baseDirection != 2 || this._isFollowedByLTR(n, cArray.length)) return -1;
            return 1;
        }
        if (this._baseDirection != 2 || !_isArabicEnabled && !_isClientArabicEnabled || c != ':') return -1;
        char c4 = '\u0000';
        char c5 = '\u0000';
        if (n - 1 >= 0) {
            c4 = cArray[n - 1];
        }
        if (n + 1 < cArray.length) {
            c5 = cArray[n + 1];
        }
        if (!Character.isDigit(c5) || !Character.isDigit(c4)) return -1;
        return this._directions[n - 1];
    }

    static {
        _isExtendedArabicEnabled = false;
        _isClientHebrewEnabled = false;
        _isClientArabicEnabled = false;
        _insertVisualControlCharAlways = true;
        _changeSpaceToNBSpace = false;
        _sGlyphs = new char[][]{{'\ufe80', '\u0000', '\u0000', '\u0000'}, {'\ufe81', '\u0000', '\ufe82', '\u0000'}, {'\ufe83', '\u0000', '\ufe84', '\u0000'}, {'\ufe85', '\u0000', '\ufe86', '\u0000'}, {'\ufe87', '\u0000', '\ufe88', '\u0000'}, {'\ufe89', '\ufe8b', '\ufe8a', '\ufe8c'}, {'\ufe8d', '\u0000', '\ufe8e', '\u0000'}, {'\ufe8f', '\ufe91', '\ufe90', '\ufe92'}, {'\ufe93', '\u0000', '\ufe94', '\u0000'}, {'\ufe95', '\ufe97', '\ufe96', '\ufe98'}, {'\ufe99', '\ufe9b', '\ufe9a', '\ufe9c'}, {'\ufe9d', '\ufe9f', '\ufe9e', '\ufea0'}, {'\ufea1', '\ufea3', '\ufea2', '\ufea4'}, {'\ufea5', '\ufea7', '\ufea6', '\ufea8'}, {'\ufea9', '\u0000', '\ufeaa', '\u0000'}, {'\ufeab', '\u0000', '\ufeac', '\u0000'}, {'\ufead', '\u0000', '\ufeae', '\u0000'}, {'\ufeaf', '\u0000', '\ufeb0', '\u0000'}, {'\ufeb1', '\ufeb3', '\ufeb2', '\ufeb4'}, {'\ufeb5', '\ufeb7', '\ufeb6', '\ufeb8'}, {'\ufeb9', '\ufebb', '\ufeba', '\ufebc'}, {'\ufebd', '\ufebf', '\ufebe', '\ufec0'}, {'\ufec1', '\ufec3', '\ufec2', '\ufec4'}, {'\ufec5', '\ufec7', '\ufec6', '\ufec8'}, {'\ufec9', '\ufecb', '\ufeca', '\ufecc'}, {'\ufecd', '\ufecf', '\ufece', '\ufed0'}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {'\u0640', '\u0640', '\u0640', '\u0640'}, {'\ufed1', '\ufed3', '\ufed2', '\ufed4'}, {'\ufed5', '\ufed7', '\ufed6', '\ufed8'}, {'\ufed9', '\ufedb', '\ufeda', '\ufedc'}, {'\ufedd', '\ufedf', '\ufede', '\ufee0'}, {'\ufee1', '\ufee3', '\ufee2', '\ufee4'}, {'\ufee5', '\ufee7', '\ufee6', '\ufee8'}, {'\ufee9', '\ufeeb', '\ufeea', '\ufeec'}, {'\ufeed', '\u0000', '\ufeee', '\u0000'}, {'\ufeef', '\u0000', '\ufef0', '\u0000'}, {'\ufef1', '\ufef3', '\ufef2', '\ufef4'}};
        _sExtendedGlyphs = new char[][]{{' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {'\ufb56', '\ufb58', '\ufb57', '\ufb59'}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {'\ufb7a', '\ufb7c', '\ufb7b', '\ufb7d'}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {'\ufb8a', '\u0000', '\ufb8b', '\u0000'}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {'\ufb8e', '\ufb90', '\ufb8f', '\ufb91'}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {'\ufb92', '\ufb94', '\ufb93', '\ufb95'}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {'\ufbfc', '\ufbfe', '\ufbfd', '\ufbff'}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}, {' ', ' ', ' ', ' '}};
        _sLAM_ALEF_glyphs = new char[][]{{'\ufef5', '\u0000', '\ufef6', '\u0000'}, {'\ufef7', '\u0000', '\ufef8', '\u0000'}, {'\ufef9', '\u0000', '\ufefa', '\u0000'}, {'\ufefb', '\u0000', '\ufefc', '\u0000'}};
        _HEBREW_NUMBER_SEPARATORS = new char[]{',', '.', '+', '-', '*', '/', ':', '#', '$', '%'};
        _SPECIAL_HEBREW_NUMBER_SEPARATORS = new char[]{',', '*', '/', ':'};
        _ARABIC_NUMBER_SEPARATORS = new char[]{'\u066b', '\u060c'};
        _digitSubstitution = 2;
    }
}

