/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwText.im;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import oracle.ewt.lwAWT.lwText.LWCommonText;
import oracle.ewt.lwAWT.lwText.LWTextArea;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.lwAWT.lwText.im.InputMethodListenerHandler;
import oracle.ewt.lwAWT.lwText.im.InputMethodRequestsHandler;

class InputMethodUtil {
    private LWCommonText _textComponent = null;
    private transient TextLayout _textLayout = null;
    private AttributedCharacterIterator _dispStrItr = null;
    private AttributedCharacterIterator _dispRowStrItr = null;
    private int _composedStringStart = -1;
    private InputMethodRequestsHandler _inputMethodRequestsHnd;
    private InputMethodListenerHandler _listener;

    public InputMethodUtil(LWCommonText lWCommonText) {
        this.setTextComponent(lWCommonText);
        this._inputMethodRequestsHnd = new InputMethodRequestsHandler(this);
        this._listener = new InputMethodListenerHandler(this);
        lWCommonText.addInputMethodListener(this._listener);
        lWCommonText.addFocusListener(this._listener);
    }

    public void setTextComponent(LWCommonText lWCommonText) {
        this._textComponent = lWCommonText;
    }

    public LWCommonText getTextComponent() {
        return this._textComponent;
    }

    public InputMethodRequests getInputMethodRequests() {
        return this._inputMethodRequestsHnd;
    }

    public AttributedCharacterIterator getDisplayText() {
        return this._dispStrItr;
    }

    public void setDisplayText(AttributedCharacterIterator attributedCharacterIterator) {
        this._dispStrItr = attributedCharacterIterator;
        if (attributedCharacterIterator == null) {
            this._dispRowStrItr = null;
        }
    }

    public void setComposedStart(int n) {
        this._composedStringStart = n;
    }

    public int getComposedStart() {
        return this._composedStringStart;
    }

    public void endComposition() {
        this._listener.endComposition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextLayout getDisplayTextLayout() {
        FontRenderContext fontRenderContext = ((Graphics2D)this._textComponent.getGraphics()).getFontRenderContext();
        LWCommonText lWCommonText = this._textComponent;
        synchronized (lWCommonText) {
            if (this._dispStrItr != null && this._dispStrItr.getEndIndex() >= this._dispStrItr.getBeginIndex()) {
                if (this._textComponent instanceof LWTextField && !this._textComponent.isValidTextlayout()) {
                    this._textLayout = new TextLayout(this._dispStrItr, fontRenderContext);
                } else if (this._textComponent instanceof LWTextArea && this._dispRowStrItr != null && this._dispRowStrItr.getEndIndex() >= this._dispRowStrItr.getBeginIndex()) {
                    this._textLayout = new TextLayout(this._dispRowStrItr, fontRenderContext);
                }
            }
            this._textComponent.validateTextLayout();
        }
        return this._textLayout;
    }

    public static boolean paintDisplayText(Object object, Graphics graphics, int n, int n2) {
        InputMethodUtil inputMethodUtil = null;
        if (!(object instanceof InputMethodUtil)) {
            return false;
        }
        inputMethodUtil = (InputMethodUtil)object;
        if (inputMethodUtil.getDisplayText() == null) {
            return false;
        }
        TextLayout textLayout = inputMethodUtil.getDisplayTextLayout();
        if (textLayout != null) {
            textLayout.draw((Graphics2D)graphics, n, n2);
            return true;
        }
        return false;
    }

    public void makeRowString(int n, int n2) {
        if (this._dispStrItr != null && this._textComponent instanceof LWTextArea) {
            AttributedString attributedString = new AttributedString(this._dispStrItr, n, n + n2);
            this._dispRowStrItr = attributedString.getIterator();
            this._dispRowStrItr.first();
        }
    }
}

