/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.oracle;

import java.awt.Color;
import java.awt.image.ImageFilter;
import java.util.Locale;
import oracle.bali.share.collection.StringKey;
import oracle.ewt.ColorScheme;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.laf.basic.ColorizingFilter;

class OracleColorScheme
extends ColorScheme {
    public static final Object CONTROL_SHADOW_DARK = new StringKey("controlShadowDark");
    public static final Object GROUP_BOX = new StringKey("groupBox");
    public static final Object GROUP_BOX_TEXT = new StringKey("groupBoxText");
    public static final Object CONTROL_SHADOW_VERY_LIGHT = new StringKey("controlShadowVeryLight");
    public static final Object CONTROL_LT_HIGHLIGHT_VERY_DARK = new StringKey("controlLtHighlightVeryDark");
    public static final Object HEADER_TEXT = new StringKey("headerText");
    public static final Object HEADER = new StringKey("header");
    public static final Object GRID_TEXT = new StringKey("gridText");
    public static final Object GRID = new StringKey("grid");
    public static final Object THUMB_HIGHLIGHT = new StringKey("thumbHighlight");
    public static final Object THUMB_SHADOW = new StringKey("thumbShadow");
    private static final int _NUM_COLORS = 9;
    private static final int _DEFINING_INDEX = 2;
    private String _name;
    private String _description;
    private int[] _intRamp;
    private Color[] _colorRamp;
    private int[] _mappingTable;
    private int _schemeIndex;

    public OracleColorScheme(String string, String string2, Color color, Color color2, boolean bl, int n) {
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        float[] fArray = Color.RGBtoHSB(n2, n3, n4, null);
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = 0.8f;
        int n5 = -872415232;
        int[] nArray = new int[9];
        nArray[0] = -1;
        nArray[5] = 0;
        for (int i = 1; i < 5; ++i) {
            int n6 = Color.HSBtoRGB(f, f2, f3);
            nArray[i] = (n6 &= 0xFFFFFF) & 0xFFFFFF | n5;
            f3 -= 0.2f;
            n5 -= 0x33000000;
        }
        if (bl) {
            nArray[1] = -858993460;
        }
        nArray[6] = color2.getRGB();
        if (n2 == n3 && n3 == n4) {
            nArray[7] = 14678255;
            nArray[8] = 11726551;
        } else {
            nArray[7] = (n3 << 15) + 0x800000 | (n4 << 7) + 32768 | (n2 >> 1) + 128;
            nArray[8] = (n4 << 15) + 0x800000 | (n2 << 7) + 32768 | (n3 >> 1) + 128;
        }
        this._init(string, string2, nArray, n);
    }

    public OracleColorScheme(String string, String string2, int[] nArray, int n) {
        this._init(string, string2, nArray, n);
    }

    public String getName() {
        return this._name;
    }

    public String getDisplayName(Locale locale) {
        return this.getName();
    }

    public String getDescription(Locale locale) {
        return this._description;
    }

    public final Color getDefiningColor() {
        return this._getColorRamp()[2];
    }

    public ImageFilter createColorizingFilter() {
        return new ColorizingFilter(this.getColorMappingTable());
    }

    public int getSchemeIndex() {
        return this._schemeIndex;
    }

    public void initializeCommonColors(UIDefaults uIDefaults) {
        Object[] objectArray = new Object[]{LookAndFeel.ACTIVE_CAPTION, "#4", LookAndFeel.ACTIVE_CAPTION_TEXT, "#0", LookAndFeel.ACTIVE_CAPTION_BORDER, "#1", LookAndFeel.INACTIVE_CAPTION, "#2", LookAndFeel.INACTIVE_CAPTION_TEXT, "#1", LookAndFeel.WINDOW, "#3", LookAndFeel.DIALOG, "#1", LookAndFeel.WINDOW_TEXT, "#5", LookAndFeel.MENU, "#1", LookAndFeel.TEXT, "#0", LookAndFeel.TEXT_TEXT, "#5", LookAndFeel.TEXT_HIGHLIGHT, "#6", LookAndFeel.TEXT_HIGHLIGHT_TEXT, "#0", LookAndFeel.TEXT_INACTIVE_TEXT, "#3", LookAndFeel.CONTROL, "#1", LookAndFeel.SCROLLBAR, "#2", LookAndFeel.INFO_TEXT, "#5", LookAndFeel.SECONDARY_TEXT_HIGHLIGHT, "#3", LookAndFeel.PINSTRIPE3, "#7", LookAndFeel.PINSTRIPE4, "#8", LookAndFeel.LIGHT_INTENSITY, "#1", LookAndFeel.CONTROL_INACTIVE, "#1", LookAndFeel.NORMAL_INTENSITY, "#2", LookAndFeel.DARK_INTENSITY, "#3", LookAndFeel.VERY_DARK_INTENSITY, "#4", LookAndFeel.LIGHT_LOOK, "#1", LookAndFeel.DARK_LOOK, "#3", LookAndFeel.VERY_DARK_LOOK, "#4", GRID, "#0", HEADER, "#1", LookAndFeel.TEXT_INACTIVE_HIGHLIGHT, "#3", LookAndFeel.ARROW, "#2"};
        this._initializeColors(uIDefaults, objectArray);
        uIDefaults.put(LookAndFeel.DESKTOP, new Color(-10066330));
    }

    public void initializeLightColors(UIDefaults uIDefaults) {
        Object[] objectArray = new Object[]{LookAndFeel.CONTROL_TEXT, "#5", GROUP_BOX_TEXT, "#5", HEADER_TEXT, "#5", LookAndFeel.CONTROL_HIGHLIGHT, "#1", LookAndFeel.CONTROL_LT_HIGHLIGHT, "#0", THUMB_HIGHLIGHT, "#0", LookAndFeel.CONTROL_SHADOW, "#2", THUMB_SHADOW, "#2", LookAndFeel.CONTROL_DK_SHADOW, "#3", LookAndFeel.CONTROL_INACTIVE_TEXT, "#3", CONTROL_SHADOW_DARK, "#2", GROUP_BOX, "#2", CONTROL_SHADOW_VERY_LIGHT, "#2", CONTROL_LT_HIGHLIGHT_VERY_DARK, "#0"};
        this._initializeColors(uIDefaults, objectArray);
    }

    public void initializeDarkColors(UIDefaults uIDefaults) {
        Object[] objectArray = new Object[]{LookAndFeel.CONTROL_TEXT, "#0", GROUP_BOX_TEXT, "#0", HEADER_TEXT, "#0", LookAndFeel.CONTROL_HIGHLIGHT, "#2", LookAndFeel.CONTROL_LT_HIGHLIGHT, "#1", THUMB_HIGHLIGHT, "#1", LookAndFeel.CONTROL_SHADOW, "#3", THUMB_SHADOW, "#3", LookAndFeel.CONTROL_DK_SHADOW, "#4", LookAndFeel.CONTROL_INACTIVE_TEXT, "#4", CONTROL_SHADOW_DARK, "#4", GROUP_BOX, "#4", CONTROL_SHADOW_VERY_LIGHT, "#0", CONTROL_LT_HIGHLIGHT_VERY_DARK, "#2"};
        this._initializeColors(uIDefaults, objectArray);
    }

    public String toString() {
        return super.toString() + " " + this.getName();
    }

    void __setIntRamp(int[] nArray) {
        this._intRamp = nArray;
    }

    void __initCommonDefaults(UIDefaults uIDefaults, UIDefaults uIDefaults2) {
    }

    private void _initializeColors(UIDefaults uIDefaults, Object[] objectArray) {
        Color[] colorArray = this._getColorRamp();
        for (int i = 0; i < objectArray.length; i += 2) {
            Color color = Color.black;
            try {
                color = colorArray[Integer.decode((String)objectArray[i + 1])];
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            uIDefaults.put(objectArray[i], color);
        }
    }

    protected int[] getColorMappingTable() {
        if (this._mappingTable == null) {
            int[] nArray = new int[256];
            int[] nArray2 = this._intRamp;
            int n = 0;
            int n2 = nArray2[0] >> 24 & 0xFF;
            for (int i = 255; i >= 0; --i) {
                if (i == n2) {
                    nArray[i] = nArray2[n] | 0xFF000000;
                    n2 = nArray2[++n] >> 24 & 0xFF;
                    continue;
                }
                nArray[i] = 0xFF000000 | (i << 16 | i << 8 | i);
            }
            this._mappingTable = nArray;
        }
        return this._mappingTable;
    }

    private Color[] _getColorRamp() {
        if (this._colorRamp == null) {
            int[] nArray = this._intRamp;
            int n = nArray.length;
            Color[] colorArray = new Color[n];
            for (int i = 0; i < n; ++i) {
                colorArray[i] = new Color(nArray[i] | 0xFF000000);
            }
            this._colorRamp = colorArray;
        }
        return this._colorRamp;
    }

    private void _init(String string, String string2, int[] nArray, int n) {
        this._name = string;
        this._description = string2;
        this._intRamp = nArray;
        this._schemeIndex = n;
    }
}

