/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid.hGrid;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleState;
import oracle.ewt.UIManager;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.grid.AccessibleGrid;
import oracle.ewt.grid.Cell;
import oracle.ewt.grid.CellInputHandler;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.NullInputHandler;
import oracle.ewt.grid.ProxyInputHandler;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.PaintContextProxy;
import oracle.ewt.painter.Painter;
import oracle.ewt.util.ImmInsets;

public abstract class AbstractCellHandler
extends ProxyInputHandler
implements Painter {
    private Context _contextProxy;
    private int _indentWidth;
    private Painter _painter;
    private Painter _expandedPainter;
    private Painter _collapsedPainter;
    private boolean _consumeMouseEvents;
    private static final int _DEFAULT_INDENT_WIDTH = 18;
    private static final int _BUTTON_MARGIN = 2;
    private static final int _DEFAULT_BUTTON_SIZE = 11;

    public AbstractCellHandler() {
        this(UIManager.getPainter("DefaultCellPainter"));
    }

    public AbstractCellHandler(Painter painter) {
        this(painter, NullInputHandler.getCellInputHandler());
    }

    public AbstractCellHandler(CellInputHandler cellInputHandler) {
        this(UIManager.getPainter("DefaultCellPainter"), cellInputHandler);
    }

    public AbstractCellHandler(Painter painter, CellInputHandler cellInputHandler) {
        super(cellInputHandler);
        if (painter == null) {
            painter = NullPainter.getPainter();
        }
        this._painter = painter;
        this._expandedPainter = UIManager.getPainter("ExpandedNodePainter");
        this._collapsedPainter = UIManager.getPainter("CollapsedNodePainter");
        this._indentWidth = 18;
        this._contextProxy = new Context();
    }

    public Painter getPainter() {
        return this._painter;
    }

    public void setIndentWidth(int n) {
        this._indentWidth = n;
    }

    public int getIndentWidth() {
        return this._indentWidth;
    }

    public Painter getExpandedPainter() {
        return this._expandedPainter;
    }

    public void setExpandedPainter(Painter painter) {
        this._expandedPainter = painter;
    }

    public Painter getCollapsedPainter() {
        return this._collapsedPainter;
    }

    public void setCollapsedPainter(Painter painter) {
        this._collapsedPainter = painter;
    }

    public void mousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        if (!mouseEvent.isConsumed()) {
            this.processButtonMousePressed(mouseEvent, grid, n, n2);
        }
        if (!mouseEvent.isConsumed()) {
            super.mousePressed(mouseEvent, grid, n, n2);
        } else {
            this._consumeMouseEvents = true;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        if (this._consumeMouseEvents) {
            mouseEvent.consume();
        } else {
            super.mouseDragged(mouseEvent, grid, n, n2);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        if (this._consumeMouseEvents) {
            mouseEvent.consume();
            this._consumeMouseEvents = false;
        } else {
            super.mouseReleased(mouseEvent, grid, n, n2);
        }
    }

    public void keyPressed(KeyEvent keyEvent, Grid grid, int n, int n2) {
        super.keyPressed(keyEvent, grid, n, n2);
        if (keyEvent.isConsumed()) {
            return;
        }
        int n3 = keyEvent.getKeyCode();
        if (n3 == 37 || n3 == 39) {
            boolean bl = n3 == 39;
            boolean bl2 = this.setCellExpansionState(grid.getDataSource(), n, n2, bl);
            AccessibleGrid accessibleGrid = grid.getAccessibleGrid();
            if (accessibleGrid != null) {
                AccessibleState accessibleState;
                AccessibleState accessibleState2;
                if (bl) {
                    accessibleState2 = AccessibleState.COLLAPSED;
                    accessibleState = AccessibleState.EXPANDED;
                } else {
                    accessibleState2 = AccessibleState.EXPANDED;
                    accessibleState = AccessibleState.COLLAPSED;
                }
                int n4 = accessibleGrid.getAccessibleIndexAt(n, n2);
                Accessible accessible = accessibleGrid.getAccessibleChild(n4);
                accessibleGrid.firePropertyChange("AccessibleState", accessibleState2, accessibleState);
                accessible.getAccessibleContext().firePropertyChange("AccessibleState", accessibleState2, accessibleState);
            }
            if (bl2) {
                keyEvent.consume();
            }
        }
    }

    protected abstract boolean setCellExpansionState(TwoDDataSource var1, int var2, int var3, boolean var4);

    protected abstract boolean cellHasChildren(TwoDDataSource var1, int var2, int var3);

    protected abstract int getCellDepth(TwoDDataSource var1, int var2, int var3);

    public Rectangle getEditControlBounds(Grid grid, int n, int n2) {
        boolean bl;
        Rectangle rectangle = super.getEditControlBounds(grid, n, n2);
        int n3 = this._getIndentAt(grid, n, n2);
        boolean bl2 = bl = grid.getActualReadingDirection() == 1;
        if (n3 != 0) {
            if (rectangle == null) {
                int n4 = grid.getRowHeight(n2);
                int n5 = grid.getColumnWidth(n);
                rectangle = new Rectangle(0, 0, n5, n4);
            }
            if (bl) {
                rectangle.x += n3;
            }
            rectangle.width -= n3;
        }
        return rectangle;
    }

    public Object getWrappedData(Object object) {
        return object;
    }

    public void startEdit(Grid grid, int n, int n2, Object object) {
        super.startEdit(grid, n, n2, this.getWrappedData(object));
    }

    public Dimension getSize(PaintContext paintContext, int n, int n2) {
        return new Dimension(n, n2);
    }

    public Dimension getPreferredSize(PaintContext paintContext) {
        Context context = this._contextProxy;
        context.setPaintContext(paintContext);
        return this._addIndentDepth(this._painter.getPreferredSize(context), paintContext);
    }

    public Dimension getMinimumSize(PaintContext paintContext) {
        Context context = this._contextProxy;
        context.setPaintContext(paintContext);
        return this._addIndentDepth(this._painter.getMinimumSize(context), paintContext);
    }

    public Dimension getMaximumSize(PaintContext paintContext) {
        Context context = this._contextProxy;
        context.setPaintContext(paintContext);
        return this._addIndentDepth(this._painter.getMaximumSize(context), paintContext);
    }

    private Dimension _addIndentDepth(Dimension dimension, PaintContext paintContext) {
        TwoDDataSource twoDDataSource = (TwoDDataSource)paintContext.getPaintData("DataSource");
        Cell cell = (Cell)paintContext.getPaintData("Cell");
        int n = this.getCellDepth(twoDDataSource, cell.column, cell.row);
        int n2 = this._getIndentAtDepth(paintContext, n);
        dimension.width += n2;
        return dimension;
    }

    protected boolean isBackgroundUsed() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Object object;
        boolean bl;
        int n5 = n3;
        TwoDDataSource twoDDataSource = (TwoDDataSource)paintContext.getPaintData("DataSource");
        Cell cell = (Cell)paintContext.getPaintData("Cell");
        int n6 = this.getCellDepth(twoDDataSource, cell.column, cell.row);
        boolean bl2 = this.cellHasChildren(twoDDataSource, cell.column, cell.row);
        Object object2 = this.getWrappedData(paintContext.getPaintData(null));
        Context context = this._contextProxy;
        int n7 = this._getIndentAtDepth(paintContext, n6);
        boolean bl3 = bl = paintContext.getReadingDirection() == 1;
        if (bl) {
            n += n7;
        }
        n3 -= n7;
        Appearance appearance = null;
        Color color = null;
        ImmInsets immInsets = null;
        int n8 = paintContext.getPaintState();
        if ((n8 & 1) == 0 && (n8 & 0x80) != 0 && this.isBackgroundUsed() && (appearance = (Appearance)paintContext.getPaintData("Appearance")) != null) {
            object = graphics.getColor();
            immInsets = appearance.getInsets();
            if (immInsets == null) {
                immInsets = ImmInsets.getEmptyInsets();
            }
            color = appearance.getBackground();
            graphics.setColor(color);
            if (bl) {
                graphics.fillRect(n - n7 - immInsets.left, n2 - immInsets.top, n7 + immInsets.left, n4 + immInsets.top + immInsets.bottom);
            } else {
                graphics.fillRect(immInsets.left + n + n3, n2 - immInsets.top, n7, n4 + immInsets.top + immInsets.bottom);
            }
            graphics.setColor((Color)object);
        }
        if (bl2) {
            Object object3 = object = this.isCellExpanded(twoDDataSource, cell.column, cell.row) ? this.getExpandedPainter() : this.getCollapsedPainter();
            if (object != null) {
                int n9;
                Dimension dimension = object.getPreferredSize(paintContext);
                if (bl) {
                    n9 = n - 2 - dimension.width;
                } else {
                    n9 = n + n5 - n7 + 2;
                    n3 = n9 - n - 2;
                    if (color != null) {
                        Color color2 = graphics.getColor();
                        graphics.setColor(color);
                        graphics.fillRect(n9, n2 - immInsets.top, 2 + dimension.width + 1, n4 + immInsets.top + immInsets.bottom);
                        graphics.setColor(color2);
                    }
                }
                int n10 = n2 + (n4 - dimension.height) / 2;
                if (appearance != null) {
                    Context context2 = context;
                    synchronized (context2) {
                        Color color3 = graphics.getColor();
                        context.setPaintContext(paintContext);
                        if (this.isBackgroundUsed()) {
                            context.setPaintBackground(appearance.getBackground());
                            context.setPaintForeground(appearance.getForeground());
                        }
                        graphics.setColor(appearance.getForeground());
                        object.paint(context, graphics, n9, n10, dimension.width, dimension.height);
                        graphics.setColor(color3);
                        context.setPaintBackground(null);
                        context.setPaintForeground(null);
                    }
                } else {
                    object.paint(paintContext, graphics, n9, n10, dimension.width, dimension.height);
                }
            }
        } else if (!bl && (object = this.getExpandedPainter()) != null) {
            Dimension dimension = object.getPreferredSize(paintContext);
            n3 = n5 - n7 + 2;
        }
        object = context;
        synchronized (object) {
            context.setPaintContext(paintContext);
            this._painter.paint(context, graphics, n, n2, n3, n4);
        }
    }

    public final boolean contains(PaintContext paintContext, int n, int n2, int n3, int n4) {
        return this.getPainterAt(paintContext, n, n2, n3, n4, null) != null;
    }

    public Painter getPainterAt(PaintContext paintContext, int n, int n2, int n3, int n4, Painter painter) {
        if (n3 >= 0 && n4 >= 0 && n3 < n && n4 < n2) {
            return this;
        }
        return null;
    }

    public boolean isTransparent(PaintContext paintContext) {
        return true;
    }

    public int getRepaintFlags(PaintContext paintContext) {
        return this._painter.getRepaintFlags(paintContext) | this._expandedPainter.getRepaintFlags(paintContext) | this._collapsedPainter.getRepaintFlags(paintContext);
    }

    public int getInvalidateFlags(PaintContext paintContext) {
        return this._painter.getInvalidateFlags(paintContext) | this._expandedPainter.getInvalidateFlags(paintContext) | this._collapsedPainter.getInvalidateFlags(paintContext);
    }

    protected abstract boolean isCellExpanded(TwoDDataSource var1, int var2, int var3);

    protected void processButtonMousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        TwoDDataSource twoDDataSource = grid.getDataSource();
        if (this.cellHasChildren(twoDDataSource, n, n2)) {
            boolean bl;
            boolean bl2 = grid.getActualReadingDirection() == 1;
            int n3 = grid.getRowHeight(n2);
            int n4 = grid.getColumnWidth(n);
            int n5 = mouseEvent.getX();
            int n6 = this._getButtonWidth(grid.getPaintContext());
            int n7 = this.getCellDepth(twoDDataSource, n, n2);
            int n8 = this._getButtonX(n7);
            if (bl2) {
                bl = n5 <= n8 + n6;
            } else {
                boolean bl3 = bl = n5 >= n4 - (n8 + n6);
            }
            if (bl) {
                mouseEvent.consume();
                boolean bl4 = this.isCellExpanded(twoDDataSource, n, n2);
                this.setCellExpansionState(twoDDataSource, n, n2, !bl4);
            }
        }
    }

    protected void translateMouseEvent(MouseEvent mouseEvent, Grid grid, int n, int n2, boolean bl) {
        int n3 = this._getIndentAt(grid, n, n2);
        if (bl) {
            n3 = -n3;
        }
        mouseEvent.translatePoint(n3, 0);
    }

    private int _getButtonWidth(PaintContext paintContext) {
        return this._expandedPainter.getPreferredSize((PaintContext)paintContext).width;
    }

    private int _getIndentAt(Grid grid, int n, int n2) {
        return this._getIndentAtDepth(grid.getPaintContext(), this.getCellDepth(grid.getDataSource(), n, n2));
    }

    private int _getIndentAtDepth(PaintContext paintContext, int n) {
        return this._getButtonX(n) + this._getButtonWidth(paintContext) + 2;
    }

    private int _getButtonX(int n) {
        return n * this.getIndentWidth() + 2;
    }

    private class Context
    extends PaintContextProxy {
        private PaintContext _context;
        private Color _foreground;
        private Color _background;

        private Context() {
        }

        public void setPaintContext(PaintContext paintContext) {
            this._context = paintContext;
        }

        protected PaintContext getPaintContext() {
            return this._context;
        }

        public void setPaintBackground(Color color) {
            this._background = color;
        }

        public Color getPaintBackground() {
            if (this._background != null) {
                return this._background;
            }
            return super.getPaintBackground();
        }

        public void setPaintForeground(Color color) {
            this._foreground = color;
        }

        public Color getPaintForeground() {
            if (this._foreground != null) {
                return this._foreground;
            }
            return super.getPaintForeground();
        }

        public Object getPaintData(Object object) {
            return AbstractCellHandler.this.getWrappedData(super.getPaintData(object));
        }
    }
}

