/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dTree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.dTree.DTree;
import oracle.ewt.dTree.DTreeDecoration;
import oracle.ewt.dTree.DTreeDragSource;
import oracle.ewt.dTree.DTreeDropTarget;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeRange;
import oracle.ewt.dTree.DTreeRangeSet;
import oracle.ewt.dTree.DTreeRootItem;
import oracle.ewt.dTree.DTreeSelection;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.PaintContextProxy;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.TreeUI;
import oracle.ewt.util.ImmInsets;
import oracle.ewt.util.InputEventUtils;
import oracle.ewt.util.LocaleUtils;

public abstract class DTreeBaseItem
implements DTreeItem,
Accessible {
    private transient DTreeItem _parent;
    private transient int _index;
    private transient ProxyContext _defaultContext;
    private static final String _CLIENTPROP_EDITOR_KEY = "dTreeBaseItemEditor";
    static final int _ACTION_COUNT = 6;
    static final int _ACTION_ACTIVATE = 0;
    static final int _ACTION_TOGGLE_EXPAND = 1;
    static final int _ACTION_TOGGLE_SELECTED = 2;
    static final int _ACTION_EDIT = 3;
    static final int _ACTION_COMMIT_EDIT = 4;
    static final int _ACTION_CANCEL_EDIT = 5;
    static final String _LEVEL_LABEL = "DTREEITEM_LEVEL_LABEL";
    static final String _LEVEL_TYPE_LABEL = "DTREEITEM_LEVEL_TYPE_LABEL";
    static final String _ACCESSIBILITY_BUNDLE = "oracle.ewt.access.resource.AccessibilityBundle";
    private transient AccessibleContext _accessibleContext;
    private String _accessibleType;

    public void activate() {
        DTree dTree = this.getTree();
        dTree.itemActivate(this);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public AccessibleContext getAccessibleContext() {
        if (this._accessibleContext == null) {
            this._accessibleContext = this.createAccessibleContext();
        }
        return this._accessibleContext;
    }

    protected AccessibleContext createAccessibleContext() {
        return new AccessibleItem();
    }

    public String getAccessibleType() {
        return this._accessibleType;
    }

    public void setAccessibleType(String string) {
        if (this._accessibleType != string) {
            String string2 = this._accessibleContext == null ? null : this._accessibleContext.getAccessibleName();
            this._accessibleType = string;
            if (this._accessibleContext != null) {
                this._accessibleContext.firePropertyChange("AccessibleName", string2, this._accessibleContext.getAccessibleName());
            }
        }
    }

    public DTreeDragSource getDragSource() {
        if (this instanceof DTreeDragSource) {
            return (DTreeDragSource)((Object)this);
        }
        return null;
    }

    public DTreeDropTarget getDropTarget() {
        if (this instanceof DTreeDropTarget) {
            return (DTreeDropTarget)((Object)this);
        }
        return null;
    }

    public Rectangle getEditBounds() {
        DTree dTree = this.getTree();
        TreeUI treeUI = (TreeUI)dTree.getUI();
        return treeUI.getEditBounds(dTree, this.getPaintContext(), this);
    }

    public Dimension getSize() {
        if (this.getParent() == null) {
            return new Dimension(0, 0);
        }
        DTree dTree = this.getTree();
        TreeUI treeUI = (TreeUI)dTree.getUI();
        Painter painter = treeUI.getItemPainter(dTree, this);
        return painter.getPreferredSize(this.getPaintContext());
    }

    public final int getHeight() {
        return this.getSize().height;
    }

    public int getIndex() {
        return this._index;
    }

    public DTreeItem getItem(int n) {
        return null;
    }

    public DTreeItem getItemAt(int n, int n2) {
        if (n2 < this.getSize().height) {
            return this;
        }
        return null;
    }

    public int getItemCount() {
        return 0;
    }

    public DTreeItem getNextExpandedChild(DTreeItem dTreeItem) {
        return null;
    }

    public DTreeItem getParent() {
        return this._parent;
    }

    public int getSubTreeHeight() {
        return this.getSize().height;
    }

    public int getSubTreeWidth() {
        return this.getSize().width;
    }

    public int getSubTreeX() {
        return this.getX();
    }

    public int getSubTreeY() {
        return this.getY();
    }

    public DTree getTree() {
        DTreeItem dTreeItem = this.getParent();
        if (dTreeItem == null) {
            return null;
        }
        return dTreeItem.getTree();
    }

    public int getX() {
        int n = 0;
        for (DTreeItem dTreeItem = this.getParent(); dTreeItem != null; dTreeItem = dTreeItem.getParent()) {
            ++n;
        }
        DTree dTree = this.getTree();
        int n2 = dTree.getIndentWidth();
        int n3 = this._getRootIndentWidth(dTree, n2);
        int n4 = (n - 1) * n2 + n3;
        if (dTree.getActualReadingDirection() == 2) {
            Dimension dimension = dTree.getCanvasSize();
            if (n == 0) {
                return dimension.width - n3;
            }
            Dimension dimension2 = this.getSize();
            n4 = dimension.width - n4 - dimension2.width;
        } else if (n == 0) {
            return n3;
        }
        return n4;
    }

    public final int getWidth() {
        return this.getSize().width;
    }

    public boolean isExpandable() {
        return this.getItemCount() > 0;
    }

    public boolean isExpanded() {
        return false;
    }

    public void itemAdded(DTreeItem dTreeItem, int n) {
        this._parent = dTreeItem;
        this._index = n;
        DTree dTree = this.getTree();
        if (dTree != null) {
            dTree.__fireAccessibleEvent("AccessibleChild", null, this);
        }
    }

    public void itemRemoved() {
        DTree dTree = this.getTree();
        if (dTree != null) {
            dTree.__fireAccessibleEvent("AccessibleChild", this, null);
        }
        this._parent = null;
    }

    public void paint(Graphics graphics, boolean bl, boolean bl2, int n, int n2) {
        DTree dTree = this.getTree();
        TreeUI treeUI = (TreeUI)dTree.getUI();
        Painter painter = treeUI.getItemPainter(dTree, this);
        PaintContext paintContext = this.getPaintContext(bl, bl2);
        painter.paint(paintContext, graphics, 0, 0, n, n2);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        switch (keyEvent.getID()) {
            case 401: {
                this.keyPressed(keyEvent);
                break;
            }
            case 402: {
                this.keyReleased(keyEvent);
            }
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                this.mousePressed(mouseEvent);
            }
        }
    }

    public void setExpanded(boolean bl) {
    }

    public void setIndex(int n) {
        this._index = n;
    }

    public Component startEdit() {
        DTree dTree = this.getTree();
        if (!this.isEditable() || dTree == null) {
            return null;
        }
        LWTextField lWTextField = (LWTextField)dTree.getClientProperty(_CLIENTPROP_EDITOR_KEY);
        if (lWTextField == null) {
            lWTextField = new LWTextField();
            lWTextField.setBorderPainter(null);
            dTree.putClientProperty(_CLIENTPROP_EDITOR_KEY, lWTextField);
        }
        lWTextField.setText(this.getLabel());
        lWTextField.setCanvasOrigin(0, 0);
        lWTextField.selectAll();
        return lWTextField;
    }

    public String toString() {
        return this.getClass().getName() + "[label=" + this.getLabel() + ",index=" + this.getIndex() + "]";
    }

    protected abstract Image getIcon();

    protected abstract String getLabel();

    protected boolean isEditable() {
        DTree dTree = this.getTree();
        if (dTree != null) {
            return dTree.isEditable();
        }
        return false;
    }

    protected final PaintContext getPaintContext() {
        return this.getPaintContext(false, false);
    }

    protected PaintContext getPaintContext(boolean bl, boolean bl2) {
        if (!bl && !bl2) {
            if (this._defaultContext == null) {
                this._defaultContext = new ProxyContext(false, false);
            }
            return this._defaultContext;
        }
        return new ProxyContext(bl, bl2);
    }

    protected int getPaintState() {
        return 0;
    }

    protected void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && InputEventUtils.getMods(keyEvent) == 0) {
            keyEvent.consume();
        }
        if (this._isCollapseKey(keyEvent)) {
            if (this.isExpandable() && this.isExpanded()) {
                this.setExpanded(false);
                keyEvent.consume();
            }
        } else if (this._isExpandKey(keyEvent) && this.isExpandable() && !this.isExpanded()) {
            this.setExpanded(true);
            keyEvent.consume();
        }
        switch (keyEvent.getKeyCode()) {
            case 37: {
                break;
            }
        }
    }

    private boolean _isCollapseKey(KeyEvent keyEvent) {
        DTree dTree = this.getTree();
        int n = keyEvent.getKeyCode();
        if (dTree.getActualReadingDirection() == 2) {
            return n == 39;
        }
        return n == 37;
    }

    private boolean _isExpandKey(KeyEvent keyEvent) {
        DTree dTree = this.getTree();
        int n = keyEvent.getKeyCode();
        if (dTree.getActualReadingDirection() == 2) {
            return n == 37;
        }
        return n == 39;
    }

    protected void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && InputEventUtils.getMods(keyEvent) == 0) {
            keyEvent.consume();
            this.activate();
            if (this.isExpandable()) {
                this.setExpanded(!this.isExpanded());
            }
        }
    }

    protected void mousePressed(MouseEvent mouseEvent) {
        DTree dTree = this.getTree();
        int n = mouseEvent.getX();
        if (InputEventUtils.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() % 2 == 0 && n > 0 && n < this.getSize().width) {
            this.activate();
            if (this.isExpandable()) {
                this.setExpanded(!this.isExpanded());
            }
            mouseEvent.consume();
        }
    }

    protected AccessibleContext accessAccessibleContext() {
        return this._accessibleContext;
    }

    private int _getRootIndentWidth(DTree dTree, int n) {
        DTreeDecoration dTreeDecoration = dTree.getDecoration();
        ImmInsets immInsets = dTreeDecoration.getDecorationInsets(dTree);
        if (immInsets != null) {
            return immInsets.left;
        }
        return 0;
    }

    private int _getDepth() {
        if (this.getTree() == null) {
            return 0;
        }
        DTreeRootItem dTreeRootItem = this.getTree().getRoot();
        if (dTreeRootItem == null) {
            return 0;
        }
        int n = -1;
        DTreeItem dTreeItem = this;
        while (dTreeItem != dTreeRootItem && dTreeItem != null) {
            dTreeItem = dTreeItem.getParent();
            ++n;
        }
        return n;
    }

    private class AccessibleItem
    extends AccessibleContext
    implements AccessibleAction,
    AccessibleSelection,
    AccessibleComponent {
        private AccessibleItem() {
        }

        public String getAccessibleName() {
            String string = this.accessibleName;
            if (string == null || "".equals(string)) {
                String string2 = DTreeBaseItem.this.getAccessibleType();
                String string3 = IntegerUtils.getString((int)DTreeBaseItem.this._getDepth());
                String string4 = DTreeBaseItem.this.getLabel();
                if (string4 == null) {
                    string = null;
                } else if (string2 == null) {
                    String string5 = this._getTranslatedString(DTreeBaseItem._LEVEL_LABEL);
                    MessageFormat messageFormat = new MessageFormat(string5);
                    Object[] objectArray = new Object[]{string3, string4};
                    string = messageFormat.format(objectArray);
                } else {
                    String string6 = this._getTranslatedString(DTreeBaseItem._LEVEL_TYPE_LABEL);
                    MessageFormat messageFormat = new MessageFormat(string6);
                    Object[] objectArray = new Object[]{string3, string2, string4};
                    string = messageFormat.format(objectArray);
                }
            }
            return string;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
            DTree dTree = DTreeBaseItem.this.getTree();
            DTreeBaseItem dTreeBaseItem = DTreeBaseItem.this;
            DTreeItem dTreeItem = dTree == null ? null : dTree.getFocusedItem();
            accessibleStateSet.add(AccessibleState.TRANSIENT);
            accessibleStateSet.add(AccessibleState.VISIBLE);
            if (this.isShowing()) {
                accessibleStateSet.add(AccessibleState.SHOWING);
            }
            if (dTree != null && dTree.isEnabled()) {
                accessibleStateSet.add(AccessibleState.ENABLED);
            }
            accessibleStateSet.add(AccessibleState.FOCUSABLE);
            if (dTree != null && dTreeItem == dTreeBaseItem) {
                accessibleStateSet.add(AccessibleState.FOCUSED);
            }
            accessibleStateSet.add(AccessibleState.SELECTABLE);
            if (dTree != null && dTree.getSelection().isSelected(dTreeBaseItem)) {
                accessibleStateSet.add(AccessibleState.SELECTED);
            }
            if (DTreeBaseItem.this.isExpandable()) {
                accessibleStateSet.add(AccessibleState.EXPANDABLE);
            }
            if (DTreeBaseItem.this.isExpanded()) {
                accessibleStateSet.add(AccessibleState.EXPANDED);
            } else if (DTreeBaseItem.this.isExpandable()) {
                accessibleStateSet.add(AccessibleState.COLLAPSED);
            }
            if (dTreeBaseItem == dTreeItem) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            return accessibleStateSet;
        }

        public Accessible getAccessibleParent() {
            DTreeItem dTreeItem = DTreeBaseItem.this.getParent();
            if (dTreeItem instanceof Accessible) {
                return (Accessible)((Object)dTreeItem);
            }
            return DTreeBaseItem.this.getTree();
        }

        public int getAccessibleIndexInParent() {
            return DTreeBaseItem.this.getIndex();
        }

        public int getAccessibleChildrenCount() {
            return DTreeBaseItem.this.getItemCount();
        }

        public Accessible getAccessibleChild(int n) {
            if (n < 0 || n >= DTreeBaseItem.this.getItemCount()) {
                return null;
            }
            DTreeItem dTreeItem = DTreeBaseItem.this.getItem(n);
            if (dTreeItem instanceof Accessible) {
                return (Accessible)((Object)dTreeItem);
            }
            return null;
        }

        public Locale getLocale() {
            return DTreeBaseItem.this.getTree().getLocale();
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public int getAccessibleActionCount() {
            return 6;
        }

        public String getAccessibleActionDescription(int n) {
            String string = null;
            switch (n) {
                case 0: {
                    string = "ACTIVATE";
                    break;
                }
                case 1: {
                    string = "TOGGLE_EXPAND";
                    break;
                }
                case 2: {
                    string = "TOGGLE_SELECTED";
                    break;
                }
                case 3: {
                    string = "EDIT";
                    break;
                }
                case 4: {
                    string = "COMMIT_EDIT";
                    break;
                }
                case 5: {
                    string = "CANCEL_EDIT";
                }
            }
            return string == null ? null : this._getTranslatedString(string);
        }

        public boolean doAccessibleAction(int n) {
            boolean bl = false;
            DTree dTree = DTreeBaseItem.this.getTree();
            DTreeBaseItem dTreeBaseItem = DTreeBaseItem.this;
            switch (n) {
                case 0: {
                    DTreeBaseItem.this.activate();
                    bl = true;
                    break;
                }
                case 1: {
                    if (!DTreeBaseItem.this.isExpandable()) break;
                    boolean bl2 = DTreeBaseItem.this.isExpanded();
                    DTreeBaseItem.this.setExpanded(!bl2);
                    if (DTreeBaseItem.this.isExpanded() == bl2) break;
                    bl = true;
                    break;
                }
                case 2: {
                    dTree.getSelection().toggleItem(dTreeBaseItem);
                    break;
                }
                case 3: {
                    if (!dTree.isEditable()) break;
                    bl = dTree.startEdit(dTreeBaseItem);
                    break;
                }
                case 4: {
                    if (!dTree.isEditing()) break;
                    dTree.commitEdit();
                    bl = true;
                    break;
                }
                case 5: {
                    if (!dTree.isEditing()) break;
                    dTree.cancelEdit();
                    bl = true;
                }
            }
            return bl;
        }

        public int getAccessibleSelectionCount() {
            DTree dTree = DTreeBaseItem.this.getTree();
            DTreeBaseItem dTreeBaseItem = DTreeBaseItem.this;
            DTreeSelection dTreeSelection = dTree.getSelection();
            DTreeRangeSet dTreeRangeSet = dTreeSelection.getSelectionRanges();
            int n = dTreeRangeSet.getCount();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                DTreeRange dTreeRange = dTreeRangeSet.getRange(i);
                if (dTreeRange.getParent() == dTreeBaseItem) {
                    n2 += dTreeRange.getCount();
                    continue;
                }
                if (n2 > 0) break;
            }
            return n2;
        }

        public Accessible getAccessibleSelection(int n) {
            DTree dTree = DTreeBaseItem.this.getTree();
            DTreeBaseItem dTreeBaseItem = DTreeBaseItem.this;
            DTreeSelection dTreeSelection = dTree.getSelection();
            DTreeRangeSet dTreeRangeSet = dTreeSelection.getSelectionRanges();
            int n2 = dTreeRangeSet.getCount();
            for (int i = 0; i < n2; ++i) {
                DTreeRange dTreeRange = dTreeRangeSet.getRange(i);
                if (dTreeRange.getParent() != dTreeBaseItem) continue;
                int n3 = dTreeRange.getCount();
                if (n < n3) {
                    DTreeItem dTreeItem = DTreeBaseItem.this.getItem(dTreeRange.getStartIndex() + n);
                    if (dTreeItem instanceof Accessible) {
                        return (Accessible)((Object)dTreeItem);
                    }
                    return null;
                }
                n -= n3;
            }
            return null;
        }

        public boolean isAccessibleChildSelected(int n) {
            DTree dTree = DTreeBaseItem.this.getTree();
            DTreeBaseItem dTreeBaseItem = DTreeBaseItem.this;
            DTreeSelection dTreeSelection = dTree.getSelection();
            return dTreeSelection.isSelected(DTreeBaseItem.this.getItem(n));
        }

        public void addAccessibleSelection(int n) {
            DTreeItem dTreeItem;
            DTree dTree = DTreeBaseItem.this.getTree();
            DTreeSelection dTreeSelection = dTree.getSelection();
            if (!dTreeSelection.isSelected(dTreeItem = DTreeBaseItem.this.getItem(n))) {
                dTreeSelection.toggleItem(dTreeItem);
            }
        }

        public void removeAccessibleSelection(int n) {
            DTreeItem dTreeItem;
            DTree dTree = DTreeBaseItem.this.getTree();
            DTreeSelection dTreeSelection = dTree.getSelection();
            if (dTreeSelection.isSelected(dTreeItem = DTreeBaseItem.this.getItem(n))) {
                dTreeSelection.toggleItem(dTreeItem);
            }
        }

        public void clearAccessibleSelection() {
            DTree dTree = DTreeBaseItem.this.getTree();
            DTreeBaseItem dTreeBaseItem = DTreeBaseItem.this;
            DTreeSelection dTreeSelection = dTree.getSelection();
            DTreeRangeSet dTreeRangeSet = dTreeSelection.getSelectionRanges();
            int n = dTreeRangeSet.getCount();
            DTreeRangeSet dTreeRangeSet2 = new DTreeRangeSet();
            for (int i = 0; i < n; ++i) {
                DTreeRange dTreeRange = dTreeRangeSet.getRange(i);
                if (dTreeRange.getParent() == dTreeBaseItem) continue;
                dTreeRangeSet2.addRange(dTreeRange);
            }
            dTreeSelection.setSelectionRanges(dTreeRangeSet2);
        }

        public void selectAllAccessibleSelection() {
            DTree dTree = DTreeBaseItem.this.getTree();
            DTreeSelection dTreeSelection = dTree.getSelection();
            DTreeRangeSet dTreeRangeSet = dTreeSelection.getSelectionRanges();
            DTreeRange dTreeRange = new DTreeRange(DTreeBaseItem.this, 0, DTreeBaseItem.this.getItemCount());
            dTreeRangeSet.addRange(dTreeRange);
            dTreeSelection.setSelectionRanges(dTreeRangeSet);
        }

        public Color getBackground() {
            return DTreeBaseItem.this.getPaintContext().getPaintBackground();
        }

        public void setBackground(Color color) {
        }

        public Color getForeground() {
            return DTreeBaseItem.this.getPaintContext().getPaintForeground();
        }

        public void setForeground(Color color) {
        }

        public Cursor getCursor() {
            Cursor cursor = DTreeBaseItem.this.getTree().getCursor();
            if (cursor == null) {
                cursor = Cursor.getDefaultCursor();
            }
            return cursor;
        }

        public void setCursor(Cursor cursor) {
        }

        public Font getFont() {
            return DTreeBaseItem.this.getPaintContext().getPaintFont();
        }

        public void setFont(Font font) {
        }

        public FontMetrics getFontMetrics(Font font) {
            return DTreeBaseItem.this.getPaintContext().getFontMetrics(font);
        }

        public boolean isEnabled() {
            return (DTreeBaseItem.this.getPaintState() & 1) == 0;
        }

        public void setEnabled(boolean bl) {
        }

        public boolean isVisible() {
            return true;
        }

        public void setVisible(boolean bl) {
        }

        public boolean isShowing() {
            DTree dTree = DTreeBaseItem.this.getTree();
            if (dTree == null) {
                return false;
            }
            return dTree.isShowing() && DTree.isItemVisible(DTreeBaseItem.this);
        }

        public boolean contains(Point point) {
            Dimension dimension = this.getSize();
            if (dimension == null) {
                return false;
            }
            return point.x >= 0 && point.x < dimension.width && point.y >= 0 && point.y < dimension.height;
        }

        public Point getLocationOnScreen() {
            if (this.isShowing()) {
                DTree dTree = DTreeBaseItem.this.getTree();
                Point point = dTree.getLocationOnScreen();
                point.x += DTreeBaseItem.this.getX();
                point.y += DTreeBaseItem.this.getY();
                point.translate(dTree.getCanvasOriginX(), dTree.getCanvasOriginY());
                return point;
            }
            return null;
        }

        public Point getLocation() {
            DTreeItem dTreeItem = DTreeBaseItem.this.getParent();
            if (dTreeItem == null) {
                return new Point(0, 0);
            }
            return new Point(DTreeBaseItem.this.getX() - dTreeItem.getX(), DTreeBaseItem.this.getY() - dTreeItem.getY());
        }

        public void setLocation(Point point) {
        }

        public Rectangle getBounds() {
            if (!this.isShowing()) {
                return null;
            }
            Dimension dimension = this.getSize();
            DTreeItem dTreeItem = DTreeBaseItem.this.getParent();
            int n = 0;
            int n2 = 0;
            if (dTreeItem != null) {
                n = dTreeItem.getX();
                n2 = dTreeItem.getY();
            }
            return new Rectangle(DTreeBaseItem.this.getX() - n, DTreeBaseItem.this.getY() - n2, dimension.width, dimension.height);
        }

        public void setBounds(Rectangle rectangle) {
        }

        public Dimension getSize() {
            return DTreeBaseItem.this.getParent() == null ? DTreeBaseItem.this.getTree().getInnerSize() : DTreeBaseItem.this.getSize();
        }

        public void setSize(Dimension dimension) {
        }

        public Accessible getAccessibleAt(Point point) {
            DTree dTree = DTreeBaseItem.this.getTree();
            Point point2 = this.getLocation();
            DTreeItem dTreeItem = dTree.getItemAt(point2.x + point.x, point2.y + point.y);
            if (DTree.isItemDescendent(dTreeItem, DTreeBaseItem.this) && dTreeItem instanceof Accessible) {
                return (Accessible)((Object)dTreeItem);
            }
            return null;
        }

        public boolean isFocusTraversable() {
            return true;
        }

        public void requestFocus() {
            if (this.isFocusTraversable()) {
                DTree dTree = DTreeBaseItem.this.getTree();
                dTree.requestFocus();
                dTree.setFocusedItem(DTreeBaseItem.this);
            }
        }

        public void addFocusListener(FocusListener focusListener) {
        }

        public void removeFocusListener(FocusListener focusListener) {
        }

        private String _getTranslatedString(String string) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(DTreeBaseItem._ACCESSIBILITY_BUNDLE, LocaleUtils.getTranslationLocale(LocaleUtils.getDefaultableLocale(DTreeBaseItem.this.getTree())));
            return resourceBundle.getString(string);
        }
    }

    private class ProxyContext
    extends PaintContextProxy {
        private boolean _selected;
        private boolean _focused;

        public ProxyContext(boolean bl, boolean bl2) {
            this._selected = bl;
            this._focused = bl2;
        }

        public float getInteriorAlignmentX() {
            return 0.0f;
        }

        public float getInteriorAlignmentY() {
            return 0.5f;
        }

        public Object getPaintData(Object object) {
            if (object == null || object == PaintContext.LABEL_KEY) {
                return DTreeBaseItem.this.getLabel();
            }
            if (object == PaintContext.IMAGE_KEY) {
                return DTreeBaseItem.this.getIcon();
            }
            return super.getPaintData(object);
        }

        public int getPaintState() {
            int n = super.getPaintState() | DTreeBaseItem.this.getPaintState();
            if (this._selected) {
                n |= 0x80;
            }
            n = this._focused ? (n |= 0x20) : (n &= 0xFFFFFFDF);
            return n;
        }

        protected PaintContext getPaintContext() {
            DTree dTree = DTreeBaseItem.this.getTree();
            return dTree.getPaintContext();
        }
    }
}

