/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui.actiongroup;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JToggleButton;
import oracle.maps.core.EditableLayer;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.maps.core.LayerManager;
import oracle.maps.core.MapCanvas;
import oracle.maps.geoobject.GeometryFeature;
import oracle.maps.layer.ActiveFeaturesLayer;
import oracle.maps.layer.NewGeometryLayer;
import oracle.maps.tools.BreakLineTool;
import oracle.maps.tools.FeatureElementRemoveTool;
import oracle.maps.tools.PenTool;
import oracle.maps.tools.SplitPolygonTool;
import oracle.maps.tools.VertexAddTool;
import oracle.maps.tools.VertexMoveTool;
import oracle.maps.tools.VertexRemoveTool;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.ui.MainAppPanel;
import oracle.mdeditor.ui.actiongroup.BasicToolsPane;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.edit.util.JGeometryUtil;
import oracle.spatial.edit.layer.GeometrySetLayer;
import oracle.spatial.edit.layer.TopologyPrimitiveLayer;
import oracle.spatial.geometry.JGeometry;

public class VertexToolsPane
extends BasicToolsPane {
    private JToggleButton addvertex = new JToggleButton(Icons.getIcon("addpoint_dwn.png"));
    private JToggleButton removevertex = new JToggleButton(Icons.getIcon("removepoint_dwn.png"));
    private JToggleButton selectvertex = new JToggleButton(Icons.getIcon("selectpoint_dwn.png"));
    private JToggleButton knife = new JToggleButton(Icons.getIcon("knife_dwn.png"));
    private JToggleButton removevoid = new JToggleButton(Icons.getIcon("removevoid_dwn.png"));
    private JToggleButton breakline = new JToggleButton(Icons.getIcon("cut_dwn.png"));
    private JToggleButton splitpolygon = new JToggleButton(Icons.getIcon("splitpolygon.png"));

    public VertexToolsPane(MainAppPanel mainApp) {
        super(mainApp);
        this.buttons = new AbstractButton[]{this.addvertex, this.removevertex, this.selectvertex, this.knife, this.removevoid, this.breakline, this.splitpolygon};
        this.setName(MessagesBundle.getMessage("Vertex_tools"));
        this.addvertex.setToolTipText(MessagesBundle.getMessage("Tooltip_add_vertex"));
        this.addvertex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = VertexToolsPane.this.getMapCanvas();
                if (canvas != null) {
                    ActiveFeaturesLayer featureLayer = new ActiveFeaturesLayer(canvas);
                    VertexAddTool tool = new VertexAddTool(canvas);
                    tool.setFeatureLayer(featureLayer);
                    featureLayer.setTool(tool);
                    VertexToolsPane.this.getMainApp().setTool(featureLayer);
                }
            }
        });
        this.removevertex.setToolTipText(MessagesBundle.getMessage("Tooltip_remove_vertex"));
        this.removevertex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = VertexToolsPane.this.getMapCanvas();
                if (canvas != null) {
                    ActiveFeaturesLayer featureLayer = new ActiveFeaturesLayer(canvas);
                    VertexRemoveTool tool = new VertexRemoveTool(canvas);
                    tool.setFeatureLayer(featureLayer);
                    featureLayer.setTool(tool);
                    VertexToolsPane.this.getMainApp().setTool(featureLayer);
                }
            }
        });
        this.selectvertex.setToolTipText(MessagesBundle.getMessage("Tooltip_move_vertex"));
        this.selectvertex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = VertexToolsPane.this.getMapCanvas();
                if (canvas != null) {
                    ActiveFeaturesLayer featureLayer = new ActiveFeaturesLayer(canvas);
                    VertexMoveTool tool = new VertexMoveTool(canvas);
                    tool.setFeatureLayer(featureLayer);
                    featureLayer.setTool(tool);
                    VertexToolsPane.this.getMainApp().setTool(featureLayer);
                }
            }
        });
        this.breakline.setToolTipText(MessagesBundle.getMessage("Tooltip_break_line"));
        this.breakline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = VertexToolsPane.this.getMapCanvas();
                if (canvas != null) {
                    ActiveFeaturesLayer featureLayer = new ActiveFeaturesLayer(canvas);
                    BreakLineTool tool = new BreakLineTool(canvas);
                    tool.setFeatureLayer(featureLayer);
                    tool.setMainApp(VertexToolsPane.this.getMainApp());
                    featureLayer.setTool(tool);
                    VertexToolsPane.this.getMainApp().setTool(featureLayer);
                }
            }
        });
        this.splitpolygon.setToolTipText(MessagesBundle.getMessage("Tooltip_split_polygon"));
        this.splitpolygon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = VertexToolsPane.this.getMapCanvas();
                if (canvas != null) {
                    NewGeometryLayer newGeomLayer = new NewGeometryLayer(canvas);
                    SplitPolygonTool tool = new SplitPolygonTool(canvas);
                    tool.setMainApp(VertexToolsPane.this.getMainApp());
                    tool.setShapeDrawingLayer(newGeomLayer);
                    newGeomLayer.setTool(tool);
                    VertexToolsPane.this.getMainApp().setTool(newGeomLayer);
                }
            }
        });
        this.knife.setToolTipText(MessagesBundle.getMessage("Tooltip_add_void_polygon"));
        this.knife.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = VertexToolsPane.this.getMapCanvas();
                if (canvas != null) {
                    PenTool penTool = new PenTool(canvas);
                    penTool.setAsClosedPathAndIsVoid();
                    penTool.setModifier("knife");
                    penTool.setMainApp(VertexToolsPane.this.getMainApp());
                    VertexToolsPane.this.getMainApp().setTool(penTool);
                }
            }
        });
        this.removevoid.setToolTipText(MessagesBundle.getMessage("Tooltip_remove_void_polygon"));
        this.removevoid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = VertexToolsPane.this.getMapCanvas();
                if (canvas != null) {
                    ActiveFeaturesLayer featureLayer = new ActiveFeaturesLayer(canvas);
                    FeatureElementRemoveTool tool = new FeatureElementRemoveTool(canvas);
                    tool.setElementType(FeatureElementRemoveTool.VOID_ELEMENT);
                    tool.setFeatureLayer(featureLayer);
                    featureLayer.setTool(tool);
                    VertexToolsPane.this.getMainApp().setTool(featureLayer);
                }
            }
        });
        ButtonGroup grp = mainApp.getButtonGroup("toolsBG");
        for (AbstractButton btn : this.buttons) {
            if (btn instanceof JToggleButton) {
                grp.add(btn);
            }
            this.add(btn);
        }
        this.updateUIStatus();
    }

    @Override
    public void updateButtonsStatus() {
        MapCanvas canvas = this.getMapCanvas();
        if (canvas == null) {
            return;
        }
        LayerManager lm = canvas.getLayerManager();
        Layer targetLayer = lm.getLayerByTag("targetLayer");
        if (!(targetLayer instanceof EditableLayer) || !((EditableLayer)targetLayer).isEditable()) {
            return;
        }
        if (!(targetLayer instanceof GeometrySetLayer) && !(targetLayer instanceof TopologyPrimitiveLayer)) {
            return;
        }
        if (targetLayer instanceof GeometrySetLayer) {
            List<GeoObject> targetSelected = ((GeometrySetLayer)targetLayer).getSelection();
            if (targetSelected.size() == 1) {
                boolean hasVoid;
                GeometryFeature gf = (GeometryFeature)targetSelected.get(0);
                JGeometry geom = gf.getSpatialAttribute();
                boolean hasLine = JGeometryUtil.hasLine((JGeometry)geom);
                boolean hasPolygon = JGeometryUtil.hasPolygon((JGeometry)geom);
                boolean bl = hasVoid = hasPolygon && JGeometryUtil.hasVoidPolygon((JGeometry)geom);
                if (hasLine || hasPolygon) {
                    this.addvertex.setEnabled(true);
                    this.removevertex.setEnabled(true);
                    this.selectvertex.setEnabled(true);
                    if (hasLine && geom.getType() != 6) {
                        this.breakline.setEnabled(true);
                    }
                    if (hasPolygon) {
                        this.knife.setEnabled(true);
                        this.splitpolygon.setEnabled(true);
                        if (hasVoid) {
                            this.removevoid.setEnabled(true);
                        }
                    }
                }
            }
        } else {
            List<GeoObject> targetSelected = ((TopologyPrimitiveLayer)targetLayer).getSelection();
            if (targetSelected.size() == 1 && ((TopologyPrimitiveLayer)targetLayer).getPrimitiveType() == TopologyPrimitiveLayer.EDGE_TYPE) {
                this.addvertex.setEnabled(true);
                this.removevertex.setEnabled(true);
                this.selectvertex.setEnabled(true);
            }
        }
    }
}

