/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.maps.core.Layer;
import oracle.maps.util.StyleModelUtils;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.ui.EditSessionPanel;
import oracle.mdeditor.ui.SDEUIComponent;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class LabelingStylePicker
extends JPanel
implements SDEUIComponent,
ListSelectionListener {
    private final int TYPE_FONT = 0;
    private final int TYPE_SIZE = 1;
    private final int TYPE_COLOR = 2;
    private final int LPAD = 10;
    private final int RPAD = 10;
    private final int TPAD = 10;
    private EditSessionPanel editSessionPanel = null;
    private Hashtable<String, Color> colors = new Hashtable();
    private Hashtable<String, ImageIcon> labelIcons = new Hashtable();
    private ImageIcon fontIcon = Icons.getIcon("text.png");
    private ImageIcon colorIcon = Icons.getIcon("fill.png");
    private ImageIcon sizeIcon = Icons.getIcon("fontsize.png");
    private JLabel fontLabel = new JLabel(this.fontIcon);
    private JComboBox fontCombo = new JComboBox();
    private JLabel fillLabel = new JLabel(this.colorIcon);
    private JComboBox fillComboBox = new JComboBox();
    private JLabel sizeLabel = new JLabel(this.sizeIcon);
    private JComboBox txtsizeCombo = new JComboBox();
    private JToggleButton italButton = new JToggleButton(Icons.getIcon("italic_ena.png"));
    private JToggleButton boldButton = new JToggleButton(Icons.getIcon("bold_ena.png"));
    private String fillColor = "red";
    private JButton applyButton = new JButton(MessagesBundle.getMessage("Apply"));

    public LabelingStylePicker(EditSessionPanel editSessionPanel) {
        if (editSessionPanel == null) {
            throw new IllegalArgumentException();
        }
        this.editSessionPanel = editSessionPanel;
        editSessionPanel.getSelectionModel().addListSelectionListener(this);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName(MessagesBundle.getMessage("Labeling_properties"));
        this.setLayout(new GridBagLayout());
        this.buildColorsHash();
        this.buildIconsHash();
        this.fontCombo.setToolTipText(MessagesBundle.getMessage("Tooltip_font_name"));
        this.fontCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelingStylePicker.this.repaint();
                LabelingStylePicker.this.fontCombo_actionPerformed(e);
            }
        });
        this.fontCombo.addItem("Dialog");
        this.fontCombo.addItem("SansSerif");
        this.fontCombo.addItem("Serif");
        this.fontCombo.addItem("Monospaced");
        this.fontCombo.addItem("DialogInput");
        this.fillComboBox.setToolTipText(MessagesBundle.getMessage("Tooltip_font_color"));
        this.fillComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelingStylePicker.this.repaint();
                LabelingStylePicker.this.fillComboBox_actionPerformed(e);
            }
        });
        for (String key : this.colors.keySet()) {
            this.fillComboBox.addItem(key);
        }
        this.fillComboBox.setSelectedItem("black");
        this.txtsizeCombo.setToolTipText(MessagesBundle.getMessage("Tooltip_font_size"));
        this.txtsizeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelingStylePicker.this.repaint();
                LabelingStylePicker.this.txtsizeCombo_actionPerformed(e);
            }
        });
        this.txtsizeCombo.addItem("8");
        this.txtsizeCombo.addItem("12");
        this.txtsizeCombo.addItem("18");
        this.txtsizeCombo.addItem("24");
        this.txtsizeCombo.addItem("32");
        this.txtsizeCombo.setSelectedItem("12");
        this.italButton.setToolTipText(MessagesBundle.getMessage("Tooltip_font_italic"));
        this.italButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelingStylePicker.this.repaint();
                LabelingStylePicker.this.italButton_actionPerformed(e);
            }
        });
        this.boldButton.setToolTipText(MessagesBundle.getMessage("Tooltip_font_bold"));
        this.boldButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelingStylePicker.this.repaint();
                LabelingStylePicker.this.boldButton_actionPerformed(e);
            }
        });
        this.fontCombo.setRenderer(new ComboRenderer(0));
        this.fillComboBox.setRenderer(new ComboRenderer(2));
        this.txtsizeCombo.setRenderer(new ComboRenderer(1));
        JPanel btnPnl = new JPanel();
        btnPnl.add(this.italButton);
        btnPnl.add(this.boldButton);
        JPanel spacer = new JPanel();
        spacer.setPreferredSize(new Dimension(0, 0));
        this.applyButton.setEnabled(false);
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Layer layer = LabelingStylePicker.this.editSessionPanel.getSelectedLayer();
                if (layer == null) {
                    return;
                }
                String fontName = LabelingStylePicker.this.getFontName();
                String fColor = LabelingStylePicker.this.getFillColor();
                int fontSize = LabelingStylePicker.this.getFontSize();
                boolean isItalic = LabelingStylePicker.this.isItalic();
                boolean isBold = LabelingStylePicker.this.isBold();
                StringBuilder modelName = new StringBuilder("text");
                modelName.append("_" + fontName);
                modelName.append("_" + fColor);
                modelName.append("_" + fontSize);
                modelName.append("_" + isItalic);
                modelName.append("_" + isBold);
                layer.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.labelStyle", modelName.toString());
            }
        });
        int gridY = 0;
        this.add((Component)this.fontLabel, new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this.fontCombo, new GridBagConstraints(1, gridY++, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 10), 0, 0));
        this.add((Component)this.fillLabel, new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.fillComboBox, new GridBagConstraints(1, gridY++, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.sizeLabel, new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.txtsizeCombo, new GridBagConstraints(1, gridY++, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)btnPnl, new GridBagConstraints(0, gridY++, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)spacer, new GridBagConstraints(0, gridY++, 2, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.applyButton, new GridBagConstraints(0, gridY, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 10, 0), 0, 0));
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void updateUIStatus() {
        this.valueChanged(null);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        String labelColumn;
        if (e != null && e.getValueIsAdjusting()) {
            return;
        }
        this.applyButton.setEnabled(false);
        Layer layer = this.editSessionPanel.getSelectedLayer();
        if (layer != null && (labelColumn = layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.labelColumn")) != null) {
            this.applyButton.setEnabled(true);
            String labelStyle = layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.labelStyle");
            if (labelStyle != null) {
                this.setStyleParameters(labelStyle);
            }
        }
    }

    private void buildColorsHash() {
        this.colors.put("black", Color.black);
        this.colors.put("white", Color.white);
        this.colors.put("red", Color.red);
        this.colors.put("green", Color.green);
        this.colors.put("blue", Color.blue);
        this.colors.put("yellow", Color.yellow);
        this.colors.put("magenta", Color.magenta);
        this.colors.put("orange", Color.orange);
        this.colors.put("pink", Color.pink);
        this.colors.put("cyan", Color.cyan);
        this.colors.put("darkGray", Color.darkGray);
        this.colors.put("gray", Color.gray);
        this.colors.put("lightGray", Color.lightGray);
    }

    private void buildIconsHash() {
        this.labelIcons.put("font", Icons.getIcon("bgcolor16x16.gif"));
        this.labelIcons.put("color", Icons.getIcon("bgcolor16x16.gif"));
        this.labelIcons.put("size", Icons.getIcon("bgcolor16x16.gif"));
    }

    public String getFontName() {
        return this.fontCombo.getSelectedItem().toString();
    }

    public void setFontName(String font) {
        if (font == null) {
            return;
        }
        this.fontCombo.setSelectedItem(font);
    }

    public String getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(String color) {
        this.fillColor = color == null || this.colors.get(color) == null ? "red" : color;
        this.fillComboBox.setSelectedItem(this.fillColor);
    }

    public int getFontSize() {
        String size = this.txtsizeCombo.getSelectedItem().toString();
        try {
            return Integer.parseInt(size);
        }
        catch (Exception ex) {
            return 12;
        }
    }

    public void setTextSize(int size) {
        this.txtsizeCombo.setSelectedItem(String.valueOf(size));
    }

    public boolean isItalic() {
        return this.italButton.isSelected();
    }

    public void setItalic(boolean ital) {
        this.italButton.setSelected(ital);
    }

    public boolean isBold() {
        return this.boldButton.isSelected();
    }

    public void setBold(boolean bold) {
        this.boldButton.setSelected(bold);
    }

    private void fontCombo_actionPerformed(ActionEvent e) {
    }

    private void txtsizeCombo_actionPerformed(ActionEvent e) {
    }

    private void fillComboBox_actionPerformed(ActionEvent e) {
        this.fillColor = this.fillComboBox.getSelectedItem().toString();
    }

    private void italButton_actionPerformed(ActionEvent e) {
    }

    private void boldButton_actionPerformed(ActionEvent e) {
    }

    public String getStyleName() {
        String style = this.getFontName();
        style = style + "_" + this.getFillColor();
        style = style + "_" + this.getFontSize();
        style = style + "_" + this.isItalic();
        style = style + "_" + this.isBold();
        return style;
    }

    public void setStyleParameters(String name) {
        String[] params;
        String style = name;
        if (name == null) {
            style = StyleModelUtils.defaultTextName;
        }
        if (!(params = style.split("_"))[0].equalsIgnoreCase("text")) {
            return;
        }
        if (params.length != 6) {
            return;
        }
        this.setFontName(params[1]);
        this.setFillColor(params[2]);
        try {
            this.setTextSize(Integer.parseInt(params[3]));
        }
        catch (Exception ex) {
            this.setTextSize(12);
        }
        if (params[4].equalsIgnoreCase("true")) {
            this.setItalic(true);
        } else {
            this.setItalic(false);
        }
        if (params[5].equalsIgnoreCase("true")) {
            this.setBold(true);
        } else {
            this.setBold(false);
        }
    }

    public StyleModel getStyleModel() {
        String fontName = this.getFontName();
        String fColor = this.getFillColor();
        int fontSize = this.getFontSize();
        boolean isItalic = this.isItalic();
        boolean isBold = this.isBold();
        StringBuilder modelName = new StringBuilder("text");
        modelName.append("_" + fontName);
        modelName.append("_" + fColor);
        modelName.append("_" + fontSize);
        modelName.append("_" + isItalic);
        modelName.append("_" + isBold);
        return StyleModelUtils.getStyleModel(modelName.toString());
    }

    public void addActionListenerToApplyButton(ActionListener action) {
        if (action == null) {
            return;
        }
        this.applyButton.addActionListener(action);
    }

    public void removeActionListenerFromApplyButton(ActionListener action) {
        if (action == null) {
            return;
        }
        this.applyButton.removeActionListener(action);
    }

    public void setApplyButtonEnabled(boolean enable) {
        this.applyButton.setEnabled(enable);
    }

    public void setApplyButtonVisible(boolean visible) {
        this.applyButton.setVisible(visible);
    }

    private class ComboRenderer
    extends JLabel
    implements ListCellRenderer {
        private int type;
        private String font = "Dialog";
        private int size = 12;
        private Color color = Color.BLACK;
        private boolean bold = false;
        private boolean ital = false;

        public ComboRenderer(int type) {
            this.type = type;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            String text = value.toString();
            this.color = (Color)LabelingStylePicker.this.colors.get(LabelingStylePicker.this.getFillColor());
            this.font = LabelingStylePicker.this.getFontName();
            this.size = LabelingStylePicker.this.getFontSize();
            switch (this.type) {
                case 0: {
                    this.font = text;
                    break;
                }
                case 1: {
                    this.size = Integer.parseInt(text);
                    break;
                }
                case 2: {
                    this.color = (Color)LabelingStylePicker.this.colors.get(text);
                }
            }
            this.setText(text);
            this.setHorizontalAlignment(4);
            return this;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            if (this.type == 0) {
                int style = 0;
                if (LabelingStylePicker.this.isBold()) {
                    ++style;
                }
                if (LabelingStylePicker.this.isItalic()) {
                    style += 2;
                }
                Font tF = new Font(this.font, style, LabelingStylePicker.this.getFontSize());
                this.setFont(tF);
                this.setForeground((Color)LabelingStylePicker.this.colors.get(LabelingStylePicker.this.getFillColor()));
            }
            super.paintComponent(g2);
            int xPad = 5;
            int yPad = 3;
            switch (this.type) {
                case 1: {
                    break;
                }
                case 2: {
                    Rectangle2D textBounds = this.getFont().createGlyphVector(g2.getFontRenderContext(), "DarkGray").getVisualBounds();
                    g2.setColor(this.color);
                    g2.fillRect(xPad, yPad, (int)((double)this.getWidth() - textBounds.getWidth() - (double)(xPad * 2)), this.getHeight() - yPad * 2);
                }
            }
        }
    }
}

