/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.sqltrace.ui;

import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.raptor.TuningResources;
import oracle.dbtools.raptor.sqltrace.parser.SqlCursor;
import oracle.dbtools.raptor.sqltrace.parser.WaitSummary;
import oracle.dbtools.raptor.sqltrace.ui.renderer.SqlCursorBorderRenderer;
import oracle.dbtools.raptor.sqltrace.ui.renderer.SqlTraceNumberRenderer;
import oracle.dbtools.raptor.sqltrace.ui.renderer.SqlTraceTimeRenderer;

public class WaitSummaryTable
extends JTable {
    private long _factor;
    private SqlTraceTimeRenderer _timeRenderer;
    private ArrayList<WaitSummary> _waits;

    public WaitSummaryTable(SqlCursor sqlCursor) {
        this(sqlCursor.getWaitSummary());
    }

    public void setWaits(ArrayList<WaitSummary> arrayList) {
        this.newModel(arrayList);
        this.setName(System.currentTimeMillis() + "");
    }

    private void newModel(ArrayList<WaitSummary> arrayList) {
        if (this._waits == arrayList) {
            return;
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        if (defaultTableModel.getColumnCount() == 0) {
            defaultTableModel.addColumn(TuningResources.getString("WaitSummaryTable.1"));
            defaultTableModel.addColumn(TuningResources.getString("WaitSummaryTable.2"));
            defaultTableModel.addColumn(TuningResources.getString("WaitSummaryTable.3"));
            defaultTableModel.addColumn(TuningResources.getString("WaitSummaryTable.4"));
        }
        defaultTableModel.setRowCount(0);
        for (WaitSummary waitSummary : arrayList) {
            Vector<Object> vector = new Vector<Object>();
            vector.add(waitSummary.getName());
            vector.add(waitSummary.getCount());
            vector.add(waitSummary.getMax());
            vector.add(waitSummary.getElapsed());
            defaultTableModel.addRow(vector);
        }
        this.setIgnoreRepaint(true);
    }

    public WaitSummaryTable(ArrayList<WaitSummary> arrayList) {
        this.newModel(arrayList);
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.getColumnModel().getColumn(0).setMinWidth(180);
        this.getColumnModel().getColumn(0).setMaxWidth(180);
        this.setAutoResizeMode(4);
        this.getColumnModel().getColumn(0).setCellRenderer(new SqlCursorBorderRenderer());
        this.getTableHeader().setDefaultRenderer(new SqlCursorBorderRenderer());
        this._timeRenderer = new SqlTraceTimeRenderer();
        this.getColumnModel().getColumn(1).setCellRenderer(new SqlTraceNumberRenderer());
        this.getColumnModel().getColumn(2).setCellRenderer(this._timeRenderer);
        this.getColumnModel().getColumn(3).setCellRenderer(this._timeRenderer);
    }

    public void setTimeFactor(long l) {
        this._factor = l;
        this._timeRenderer.setTimeFactor(this._factor);
    }

    public ArrayList<WaitSummary> getWaits() {
        return this._waits;
    }
}

