/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.gui.babelfish;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import oracle.dbtools.migration.gui.babelfish.ABablefishInstallTask;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;

public class OfflineBabelfishInstallTask
extends ABablefishInstallTask {
    File _outputZipFile = null;

    public OfflineBabelfishInstallTask(DBObject dBObject, String string, String string2) {
        super("Offline SQL Translator Install", true, IRaptorTaskRunMode.MODAL_OPTIONAL);
        this._node = dBObject;
        this._userName = string;
        this._translatorType = string2;
        this.chooseExportFile((Component)Ide.getMainWindow());
    }

    private void chooseExportFile(Component component) {
        File file;
        URLFileChooser uRLFileChooser = new URLFileChooser();
        File file2 = new File(Ide.getTrueUserHomeDirectory());
        String string = null;
        if (this._translatorType.equalsIgnoreCase("Sybase SQL Translator")) {
            string = "sybase_translator.zip";
        } else if (this._translatorType.equalsIgnoreCase("SQL Server SQL Translator")) {
            string = "sqlserver_translator.zip";
        } else if (this._translatorType.equalsIgnoreCase("DB2 SQL Fingerprinter")) {
            string = "db2_fingerpinter.zip";
        }
        File file3 = new File(file2.getAbsolutePath() + File.separator + string);
        uRLFileChooser.setSelectedFile(file3);
        int n = uRLFileChooser.showSaveDialog(component);
        if (n == 1) {
            return;
        }
        this._outputZipFile = file = uRLFileChooser.getSelectedFile();
    }

    protected Void doWork() throws TaskException {
        String[] stringArray = OfflineBabelfishInstallTask.getJarFiles(this._translatorType);
        byte[] byArray = new byte[1024];
        ZipOutputStream zipOutputStream = null;
        try {
            Object object;
            zipOutputStream = new ZipOutputStream(new FileOutputStream(this._outputZipFile));
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                object = new FileInputStream(stringArray[i]);
                zipOutputStream.putNextEntry(new ZipEntry(this.getFileName(stringArray[i])));
                while ((n = ((FileInputStream)object).read(byArray)) > 0) {
                    zipOutputStream.write(byArray, 0, n);
                }
                zipOutputStream.closeEntry();
                ((FileInputStream)object).close();
            }
            String[] stringArray2 = null;
            object = "oracle/dbtools/migration/gui/babelfish/offline/";
            if (this._translatorType.equalsIgnoreCase("Sybase SQL Translator")) {
                stringArray2 = SYBASEFILES;
            } else if (this._translatorType.equalsIgnoreCase("SQL Server SQL Translator")) {
                stringArray2 = SQLSERVERFILES;
            } else if (this._translatorType.equalsIgnoreCase("DB2 SQL Fingerprinter")) {
                stringArray2 = DB2FILES;
            }
            for (String string : stringArray2) {
                int n;
                InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream((String)object + string);
                zipOutputStream.putNextEntry(new ZipEntry(string));
                while ((n = inputStream.read(byArray)) > 0) {
                    zipOutputStream.write(byArray, 0, n);
                }
                zipOutputStream.closeEntry();
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            Logger.severe(((Object)((Object)this)).getClass(), (Throwable)iOException);
            throw new TaskException((Throwable)iOException);
        }
        catch (Exception exception) {
            throw new TaskException((Throwable)exception);
        }
        finally {
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return null;
    }
}

