/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.view.View;
import oracle.javatools.buffer.GuardedTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.parser.java.v2.BindingRegistry;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasName;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaIsGeneric;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.java.v2.model.NodeBinding;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceLambdaParameter;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceThrowsClause;
import oracle.javatools.parser.java.v2.model.SourceTypeArgument;
import oracle.javatools.parser.java.v2.model.SourceTypeParameter;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.UnresolvedType;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.expression.CompiledTmpVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLambdaExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceReturnStatement;
import oracle.javatools.parser.java.v2.util.BindingContext;
import oracle.javatools.parser.java.v2.util.SourceVisitor;
import oracle.jdeveloper.java.legacy.JotNames;
import oracle.jdeveloper.java.util.SourceUtils;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.JavaHelper;

public class CodeGenUtil {
    private static final int BINDING_ELIGIBLE_LAMBDA = BindingRegistry.register((String)"eligible-lambda");

    private CodeGenUtil() {
    }

    public static String getSignature(JavaField field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(field.getName());
        buffer.append(" : ");
        buffer.append(CodeGenUtil.resolveName((JavaHasType)field, true));
        return buffer.toString();
    }

    public static String getSignature(JavaMethod method) {
        Collection parameters;
        StringBuffer buffer = new StringBuffer();
        if (!method.isConstructor()) {
            buffer.append(method.getName());
        }
        if ((parameters = method.getParameters()).isEmpty()) {
            buffer.append("()");
        } else {
            String delimiter = "(";
            Iterator p = parameters.iterator();
            while (p.hasNext()) {
                buffer.append(delimiter);
                JavaVariable parameter = (JavaVariable)p.next();
                buffer.append(CodeGenUtil.resolveName((JavaHasType)parameter, true));
                delimiter = ", ";
            }
            buffer.append(')');
        }
        if (!method.isConstructor()) {
            buffer.append(" : ");
            buffer.append(CodeGenUtil.resolveName((JavaHasType)method, true));
        }
        return buffer.toString();
    }

    public static SourceMethod implementMethod(JavaMethod method, SourceClass cls, int modifiers, boolean copyJavadoc, boolean addOverride) {
        return CodeGenUtil.implementMethod(method, cls, modifiers, copyJavadoc, addOverride, null, false);
    }

    public static SourceMethod implementMethod(JavaMethod method, SourceClass cls, int modifiers, boolean copyJavadoc, boolean addOverride, SourceElement siblingElement, boolean before) {
        SourceFile file = cls.getOwningSourceFile();
        if (file.getTransaction() == null) {
            throw new IllegalStateException("Transaction should be already begun for the transformed SourceFile");
        }
        SourceFactory factory = file.getFactory();
        BindingContext bindingContext = new BindingContext(file.getProvider(), (JavaIsGeneric)method, (JavaType)cls);
        String methodName = method.getName();
        int mods = modifiers & 0xFFFFFBFF & 0xFFFFFEFF;
        if ((modifiers & 0x200) != 512) {
            mods &= 0xFFFFFDFF;
        }
        SourceMethod newMethod = method.isConstructor() ? (siblingElement != null ? SourceUtils.addConstructor((SourceClass)cls, (int)mods, (SourceElement)siblingElement, (boolean)before) : SourceUtils.addConstructor((SourceClass)cls, (int)mods)) : (siblingElement != null ? SourceUtils.addMethod((SourceClass)cls, (String)CodeGenUtil.resolveName((JavaHasType)method, false), (String)methodName, (int)mods, (SourceElement)siblingElement, (boolean)before) : SourceUtils.addMethod((SourceClass)cls, (String)CodeGenUtil.resolveName((JavaHasType)method, false), (String)methodName, (int)mods));
        if (!JavaHelper.isRaw((JavaType)method.getOwningClass())) {
            CodeGenUtil.addTypeParameters(factory, method, newMethod);
        }
        String[] parameterNames = CodeGenUtil.addFormalParameters(method, newMethod, bindingContext);
        SourceBlock body = newMethod.getBlock();
        if (body != null) {
            SourceUtils.addLineComment((SourceBlock)body, (String)(" TODO " + JavaArb.getString(389)));
            if (method.isConstructor()) {
                if (parameterNames.length > 0 || CodeGenUtil.superHasZeroLenConstr((JavaType)cls)) {
                    SourceUtils.addMethodCallStatement((SourceBlock)body, (String)"", (String)"super", (String[])parameterNames);
                }
            } else {
                JavaClass owningClass = method.getOwningClass();
                boolean canCallSuper = owningClass != null && !owningClass.isInterface();
                JavaType returnType = method.getReturnType();
                if (returnType != null) {
                    if (returnType.getQualifiedName().equals("void")) {
                        if (!method.isAbstract() && canCallSuper) {
                            SourceUtils.addMethodCallStatement((SourceBlock)body, (String)"super", (String)methodName, (String[])parameterNames);
                        }
                    } else if (!method.isAbstract() && canCallSuper) {
                        SourceExpression initializer = SourceUtils.createMethodCall((SourceBlock)body, (String)"super", (String)methodName, (String[])parameterNames);
                        SourceReturnStatement returnStatement = factory.createReturnStatement(initializer);
                        returnStatement.addSelf((SourceElement)body);
                    } else {
                        JavaType boundType = bindingContext.bind(returnType);
                        SourceExpression initializer = JavaHelper.getDefaultInitializer(factory, boundType);
                        SourceReturnStatement returnStatement = factory.createReturnStatement(initializer);
                        returnStatement.addSelf((SourceElement)body);
                        SourceTypeReference newReturnType = factory.createType(boundType.getQualifiedName());
                        newMethod.setSourceReturnType(newReturnType);
                    }
                } else {
                    UnresolvedType unresolvedType = method.getUnresolvedType();
                    SourceExpression initializer = JavaHelper.getDefaultInitializer(factory, unresolvedType);
                    SourceReturnStatement returnStatement = factory.createReturnStatement(initializer);
                    returnStatement.addSelf((SourceElement)body);
                }
            }
        }
        CodeGenUtil.addThrowsClause(method, newMethod);
        if (copyJavadoc) {
            CodeGenUtil.addJavadocComments(method, file, newMethod);
        }
        if (addOverride && method.isAbstract()) {
            boolean addAnnotation = true;
            JavaProvider provider = file.getProvider();
            if (provider != null) {
                JdkVersion javaVersion = CommonUtilities.provider2JdkVersion((JavaProvider)provider);
                JavaClass owningClass = method.getOwningClass();
                if (owningClass.isInterface() && !javaVersion.isJdk6OrAbove() || !javaVersion.isJdk5OrAbove()) {
                    addAnnotation = false;
                }
            }
            if (addAnnotation) {
                SourceAnnotation annotation = factory.createAnnotation("Override");
                annotation.addSelf((SourceElement)newMethod);
            }
        }
        return newMethod;
    }

    private static String[] addFormalParameters(JavaMethod originalMethod, SourceMethod newMethod, BindingContext bindingContext) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        Collection parameters = originalMethod.getParameters();
        for (JavaVariable variable : parameters) {
            String parameterType;
            if (variable instanceof CompiledTmpVariable) continue;
            JavaType type = variable.getResolvedType();
            if (type != null) {
                Object boundType = bindingContext.bind(type);
                if (boundType.getElementKind() == 11) {
                    Collection bounds = ((JavaWildcardType)boundType).getLowerBounds();
                    if (bounds == null || bounds.isEmpty()) {
                        bounds = ((JavaWildcardType)boundType).getUpperBounds();
                    }
                    boundType = bounds == null || bounds.isEmpty() ? boundType.getTypeErasure() : (JavaType)bounds.iterator().next();
                }
                parameterType = boundType.getQualifiedName();
            } else {
                parameterType = variable.getUnresolvedType().getSimplifiedName();
            }
            String parameterName = CodeGenUtil.getParameterName(variable, parameterNames);
            parameterNames.add(parameterName);
            SourceUtils.addMethodParameter((SourceMethod)newMethod, (String)parameterType, (String)parameterName);
        }
        String[] names = new String[parameterNames.size()];
        return parameterNames.toArray(names);
    }

    private static void addTypeParameters(SourceFactory factory, JavaMethod originalMethod, SourceMethod newMethod) {
        for (JavaTypeVariable methodTypeParameter : originalMethod.getTypeParameters()) {
            Collection parameterBounds;
            SourceTypeReference[] newMethodParameterBounds = null;
            int counter = 0;
            SourceTypeParameter sourceElement = methodTypeParameter.getSourceElement();
            if (sourceElement != null) {
                parameterBounds = sourceElement.getSourceBounds();
                newMethodParameterBounds = new SourceTypeReference[parameterBounds.size()];
                for (SourceTypeReference parameterBound : parameterBounds) {
                    if (parameterBound.getResolvedType() != null) {
                        newMethodParameterBounds[counter++] = factory.createType(parameterBound.getResolvedType().getRawName());
                        continue;
                    }
                    newMethodParameterBounds[counter++] = factory.createType(parameterBound.getName());
                }
            } else {
                parameterBounds = methodTypeParameter.getBounds();
                newMethodParameterBounds = new SourceTypeReference[parameterBounds.size()];
                for (SourceTypeReference parameterBound : parameterBounds) {
                    newMethodParameterBounds[counter++] = factory.createType(parameterBound.getRawName());
                }
            }
            SourceTypeParameter createTypeParameter = factory.createTypeParameter(methodTypeParameter.getName(), newMethodParameterBounds);
            createTypeParameter.addSelf((SourceElement)newMethod);
        }
    }

    private static void addThrowsClause(JavaMethod originalMethod, SourceMethod newMethod) {
        Collection thrown = originalMethod.getExceptions();
        if (!thrown.isEmpty()) {
            for (JavaType excptnType : thrown) {
                SourceUtils.addThrows((SourceMethod)newMethod, (String)excptnType.getQualifiedName());
            }
        }
    }

    private static void addJavadocComments(JavaMethod method, SourceFile file, SourceMethod newMethod) {
        SourceDocComment cmt;
        SourceMethod srcMethod = method.getSourceElement();
        if (srcMethod != null && (cmt = srcMethod.getDocComment()) != null) {
            try {
                SourceDocComment sourceComment = (SourceDocComment)cmt.cloneSelf(file);
                sourceComment.addSelf((SourceElement)newMethod);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String resolveName(JavaHasType hasType, boolean simplified) {
        JavaType type = hasType.getResolvedType();
        if (type != null) {
            return simplified ? type.getUnqualifiedName() : type.getQualifiedName();
        }
        return hasType.getUnresolvedType().getSimplifiedName();
    }

    private static String getParameterName(JavaVariable variable, List paramNames) {
        String p;
        SourceVariable sourceVariable = (SourceVariable)variable.getSourceElement();
        if (sourceVariable != null) {
            String name = sourceVariable.getName();
            p = name.length() == 0 ? CodeGenUtil.getDefaultParamName(variable) : name;
        } else {
            p = variable.getName();
            if (p == null || p.trim().length() == 0) {
                p = CodeGenUtil.getDefaultParamName(variable);
            }
        }
        CodingStyleOptions prefs = CodeGenUtil.getCodingStyleOptions();
        String pName = prefs.getParameterName(p);
        if (paramNames.contains(pName)) {
            int i = 1;
            int len = p.length();
            String prefix = Character.isDigit(p.charAt(len - 1)) ? p + "_" + i : p;
            String s = prefs.getParameterName(prefix);
            while (paramNames.contains(s)) {
                s = prefix + ++i;
            }
            return s;
        }
        return pName;
    }

    private static String getDefaultParamName(JavaVariable variable) {
        String s;
        String paramName;
        JavaType type = variable.getResolvedType();
        if (type == null) {
            String typeName = variable.getUnresolvedType().getSimplifiedName();
            paramName = CodeGenUtil.toParamName(typeName);
        } else {
            int bracket;
            String qName = type.getTypeErasure().getQualifiedName();
            String typeName = CodeGenUtil.toParamName(qName);
            paramName = type.isPrimitive() ? typeName.substring(0, 1) : (type.isArray() ? ((bracket = typeName.indexOf("[")) != -1 ? typeName.substring(0, bracket) : typeName.substring(0, 1)) : typeName);
        }
        if (JotNames.isValidIdentifier(paramName)) {
            return paramName;
        }
        if (paramName.length() > 1 && JotNames.isValidIdentifier(s = paramName.substring(0, 1))) {
            return s;
        }
        return "param";
    }

    public static String getParameterName(String defaultName, Set inUse) {
        CodingStyleOptions prefs = CodeGenUtil.getCodingStyleOptions();
        String n = CodeGenUtil.trim(prefs, defaultName);
        n = prefs.getParameterName(n);
        return CodeGenUtil.generateUniqueName(n, inUse);
    }

    public static String generateUniqueName(String name, Set inUse) {
        int i = 1;
        String n = name;
        while (inUse.contains(n)) {
            n = name + i++;
        }
        return n;
    }

    public static String getFieldName(String name, SourceClass srcClass) {
        CodingStyleOptions prefs = CodeGenUtil.getCodingStyleOptions();
        String n = CodeGenUtil.trim(prefs, name);
        n = prefs.getFieldName(n);
        return srcClass != null ? CodeGenUtil.ensureNameIsUniqueInClass(n, srcClass, Collections.EMPTY_SET) : n;
    }

    public static String getStaticFieldName(String name, SourceClass srcClass) {
        CodingStyleOptions prefs = CodeGenUtil.getCodingStyleOptions();
        String n = CodeGenUtil.trim(prefs, name);
        n = prefs.getStaticFieldName(n);
        return srcClass != null ? CodeGenUtil.ensureNameIsUniqueInClass(n, srcClass, Collections.EMPTY_SET) : n;
    }

    public static String getLocalVariableName(String name, SourceClass srcClass, Set inUse) {
        CodingStyleOptions prefs = CodeGenUtil.getCodingStyleOptions();
        String n = CodeGenUtil.trim(prefs, name);
        n = prefs.getLocalVariableName(n);
        return srcClass != null ? CodeGenUtil.ensureNameIsUniqueInClass(n, srcClass, inUse) : n;
    }

    private static String ensureNameIsUniqueInClass(String name, SourceClass srcClass, Set inUse) {
        String n = name;
        int i = 1;
        while (inUse.contains(n) || srcClass.getField(n) != null) {
            n = name + i++;
        }
        return n;
    }

    private static String trim(CodingStyleOptions prefs, String name) {
        String prefix;
        String normalPrefix = prefs.getFieldPrefix();
        String normalSuffix = prefs.getFieldSuffix();
        String staticPrefix = prefs.getStaticFieldPrefix();
        String staticSuffix = prefs.getStaticFieldSuffix();
        String string = normalPrefix != null && name.startsWith(normalPrefix) ? normalPrefix : (prefix = staticPrefix != null && name.startsWith(staticPrefix) ? staticPrefix : null);
        String suffix = normalSuffix != null && name.startsWith(normalSuffix) ? normalSuffix : (staticSuffix != null && name.startsWith(staticSuffix) ? staticSuffix : null);
        return CodeGenUtil.trim(name, prefix, suffix);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String trim(String name, String prefix, String suffix) {
        if (prefix != null) {
            if (suffix == null) return name.substring(prefix.length());
            if (name.length() <= prefix.length() + suffix.length()) return name;
            return name.substring(prefix.length(), name.length() - suffix.length());
        }
        if (suffix == null) return name;
        return name.substring(0, name.length() - suffix.length());
    }

    private static CodingStyleOptions getCodingStyleOptions() {
        CodingStyleManager manager = CodingStyleManager.getCodingStyleManager();
        return manager.getCodingStyleOptions();
    }

    private static String toParamName(String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(46);
        String name = lastDot != -1 ? qualifiedName.substring(lastDot + 1) : qualifiedName;
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    public static boolean superHasZeroLenConstr(JavaType type) {
        JavaType superType = type.getSuperclass();
        if (superType != null) {
            return superType.getDeclaredConstructor(null) != null;
        }
        return false;
    }

    public static final SourceElementLocation findSourceElementLocation(Context context, SourceFile sourceFile) {
        SourceElementLocation END_OF_CLASS = new SourceElementLocation(null, false);
        if (context == null || sourceFile == null) {
            return END_OF_CLASS;
        }
        int currentOffset = CodeGenUtil.getCurrentOffset(context);
        if (currentOffset == -1) {
            return END_OF_CLASS;
        }
        EnumSet<SourceFile.ElementAtMask> mask = EnumSet.of(SourceFile.ElementAtMask.AFTER, SourceFile.ElementAtMask.ALL);
        SourceElement e = sourceFile.getElementAt(currentOffset, mask);
        SourceClass enclosingType = CommonUtilities.getEnclosingType((SourceElement)e);
        if (enclosingType == null) {
            return END_OF_CLASS;
        }
        SourceElementLocation res = END_OF_CLASS;
        SourceClassBody body = enclosingType.getSourceBody();
        List bodyChildren = body.getChildren(458752);
        GuardedTextBuffer guardedTextBuffer = CodeGenUtil.getGuardedBuffer(context);
        ListIterator iter = bodyChildren.listIterator(bodyChildren.size());
        boolean precedingElementFound = false;
        while (iter.hasPrevious()) {
            SourceElement member = (SourceElement)iter.previous();
            if ((member.getStartOffset() > currentOffset || member.getEndOffset() < currentOffset) && member.getEndOffset() >= currentOffset && (!(member instanceof SourceMemberVariable) || !((SourceMemberVariable)member).isEnumConstant())) continue;
            precedingElementFound = true;
            break;
        }
        if (!precedingElementFound) {
            SourceElement firstElement = null;
            if (iter.hasNext()) {
                firstElement = (SourceElement)iter.next();
            }
            return new SourceElementLocation(firstElement, true);
        }
        while (iter.hasNext()) {
            SourceElement sourceElement = (SourceElement)iter.next();
            if (guardedTextBuffer != null && guardedTextBuffer.isOffsetGuarded(sourceElement.getEndOffset() - 1)) continue;
            res = new SourceElementLocation(sourceElement, false);
            break;
        }
        return res;
    }

    private static GuardedTextBuffer getGuardedBuffer(Context context) {
        TextBuffer textBuffer;
        CodeEditor editor;
        BasicEditorPane basicEditorPane;
        View view = context.getView();
        if (view instanceof CodeEditor && (basicEditorPane = (editor = (CodeEditor)view).getFocusedEditorPane()) != null && (textBuffer = basicEditorPane.getTextBuffer()) instanceof GuardedTextBuffer) {
            return (GuardedTextBuffer)textBuffer;
        }
        return null;
    }

    public static int getCurrentOffset(Context context) {
        View view = context.getView();
        if (view instanceof CodeEditor) {
            CodeEditor editor = (CodeEditor)view;
            return editor.getCaretPosition();
        }
        return -1;
    }

    public static boolean isInClassBody(Context context, SourceFile sourceFile) {
        SourceElement currentElement;
        int currentOffset = CodeGenUtil.getCurrentOffset(context);
        if (currentOffset == -1) {
            return false;
        }
        for (SourceElement elem = currentElement = sourceFile.getElementAt(currentOffset); elem != null && elem.getSymbolKind() != 3; elem = elem.getParent()) {
            if (elem.getSymbolKind() != 4) continue;
            return true;
        }
        return false;
    }

    public static boolean isEligibleLambda(SourceNewClassExpression newClassExpression) {
        return new EligibleLambdaChecker(newClassExpression).isEligibleLambda();
    }

    public static SourceNewClassExpression convertLambdaToAnonymousClass(SourceLambdaExpression lambdaExpression, SourceFactory factory) {
        SourceFile sourceFile = lambdaExpression.getOwningSourceFile();
        if (sourceFile.getTransaction() == null) {
            throw new IllegalArgumentException("Transaction should be already begun for the transformed SourceFile");
        }
        SourceMember enclosingLambdaMember = CommonUtilities.getEnclosingMember((SourceElement)lambdaExpression);
        if (enclosingLambdaMember == null) {
            return null;
        }
        if (!sourceFile.isCompiled()) {
            sourceFile.compile();
        }
        if (enclosingLambdaMember.hasErrors()) {
            return null;
        }
        for (SourceLambdaParameter lambdaParameter : lambdaExpression.getFormalParameters()) {
            JavaType javaType;
            JavaType t = lambdaParameter.getResolvedType();
            JavaType javaType2 = t == null ? null : (javaType = t.isArray() ? t.getBaseComponentType() : t);
            if (javaType == null || javaType instanceof SourceTypeParameter) {
                return null;
            }
            if (!javaType.hasActualTypeArguments()) continue;
            for (JavaType actualTypeArgument : javaType.getActualTypeArguments()) {
                if (!(actualTypeArgument instanceof SourceTypeParameter)) continue;
                return null;
            }
        }
        return LambdaToAnonymousClassConvertor.convertLambdaToAnonymousClass(lambdaExpression, factory);
    }

    public static SourceLambdaExpression convertAnonymousClassToLambda(SourceNewClassExpression newClassExpression, SourceFactory factory) {
        SourceFile sourceFile = newClassExpression.getOwningSourceFile();
        if (sourceFile.getTransaction() == null) {
            throw new IllegalArgumentException("Transaction should be already begun for the transformed SourceFile");
        }
        if (!CodeGenUtil.isEligibleLambda(newClassExpression)) {
            return null;
        }
        return AnonymousClassToLambdaConvertor.convertAnonymousClassToLambda(newClassExpression, factory);
    }

    private static final class EligibleLambdaBinding
    implements NodeBinding {
        private static EligibleLambdaBinding INSTANCE_IS_ELIGIBLE;
        private static EligibleLambdaBinding INSTANCE_NOT_ELIGIBLE;
        private final boolean _isEligible;

        static EligibleLambdaBinding getIsEligibleLambdaInstance() {
            if (INSTANCE_IS_ELIGIBLE == null) {
                INSTANCE_IS_ELIGIBLE = new EligibleLambdaBinding(true);
            }
            return INSTANCE_IS_ELIGIBLE;
        }

        static EligibleLambdaBinding getNotEligibleLambdaInstance() {
            if (INSTANCE_NOT_ELIGIBLE == null) {
                INSTANCE_NOT_ELIGIBLE = new EligibleLambdaBinding(false);
            }
            return INSTANCE_NOT_ELIGIBLE;
        }

        private EligibleLambdaBinding(boolean isEligible) {
            this._isEligible = isEligible;
        }

        public int getBindingType() {
            return BINDING_ELIGIBLE_LAMBDA;
        }

        public boolean isEligibleLambda() {
            return this._isEligible;
        }
    }

    private static final class EligibleLambdaChecker {
        private final SourceNewClassExpression _newClassExpression;
        private final SourceClass _anonymousClass;

        public EligibleLambdaChecker(SourceNewClassExpression newClassExpression) {
            assert (newClassExpression != null);
            this._newClassExpression = newClassExpression;
            this._anonymousClass = this._newClassExpression == null ? null : this._newClassExpression.getAnonymousClass();
        }

        public boolean isEligibleLambda() {
            if (this._newClassExpression == null) {
                return false;
            }
            EligibleLambdaBinding alreadyCheckedEligibleLambda = (EligibleLambdaBinding)this._newClassExpression.getBinding(BINDING_ELIGIBLE_LAMBDA);
            if (alreadyCheckedEligibleLambda != null) {
                return alreadyCheckedEligibleLambda.isEligibleLambda();
            }
            boolean isEligible = this.foundJava18AndHigher() && this.foundImplementedFunctionalInterface() && !this.foundRecursiveCall() && !this.foundRefToThisOrSuper() && !this.foundRefToUninitializedVar();
            this._newClassExpression.setBinding((NodeBinding)(isEligible ? EligibleLambdaBinding.getIsEligibleLambdaInstance() : EligibleLambdaBinding.getNotEligibleLambdaInstance()));
            return isEligible;
        }

        private boolean foundJava18AndHigher() {
            return this._newClassExpression.getJdkVersion().isJdk8OrAbove();
        }

        private boolean foundImplementedFunctionalInterface() {
            if (this._anonymousClass == null) {
                return false;
            }
            JavaType javaType = this._newClassExpression.getResolvedType();
            if (!CommonUtilities.isFunctionalInterface((JavaType)javaType)) {
                return false;
            }
            List implementedMethods = this._anonymousClass.getSourceMethods();
            return implementedMethods.size() == 1;
        }

        private boolean foundRecursiveCall() {
            if (this._anonymousClass == null) {
                return false;
            }
            SourceClassBody body = this._anonymousClass.getSourceBody();
            if (body == null) {
                return false;
            }
            final SourceMethod implementedMethod = (SourceMethod)this._anonymousClass.getSourceMethods().get(0);
            final String methodName = implementedMethod.getName();
            SourceVisitor<Boolean> recursiveCallFindVisitor = new SourceVisitor<Boolean>(){

                public void whenEnterMethodCallExpression(SourceMethodCallExpression sourceMethodCallExpression) {
                    JavaMethod resolvedMethod;
                    if (methodName.equals(sourceMethodCallExpression.getName()) && implementedMethod.equals(resolvedMethod = sourceMethodCallExpression.getResolvedMethod())) {
                        this.data = Boolean.TRUE;
                        this.cancelAll();
                    }
                }
            };
            body.visitSelf((SourceVisitor)recursiveCallFindVisitor);
            return Boolean.TRUE.equals(recursiveCallFindVisitor.data);
        }

        private boolean foundRefToThisOrSuper() {
            if (this._anonymousClass == null) {
                return false;
            }
            SourceClassBody body = this._anonymousClass.getSourceBody();
            if (body == null) {
                return false;
            }
            SourceVisitor<Boolean> refToThisOrSuperFindVisitor = new SourceVisitor<Boolean>(){

                public void whenEnterClass(SourceClass sourceClass) {
                    this.cancelSubtree();
                }

                public void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
                    String simpleName = sourceSimpleNameExpression.getName();
                    if ("this".equals(simpleName) || "super".equals(simpleName)) {
                        this.data = Boolean.TRUE;
                        this.cancelAll();
                    }
                }
            };
            body.visitSelf((SourceVisitor)refToThisOrSuperFindVisitor);
            return Boolean.TRUE.equals(refToThisOrSuperFindVisitor.data);
        }

        private boolean foundRefToUninitializedVar() {
            if (this._newClassExpression == null) {
                return false;
            }
            if (this._anonymousClass == null) {
                return false;
            }
            SourceClassBody body = this._anonymousClass.getSourceBody();
            if (body == null) {
                return false;
            }
            SourceElement parentNewClassExpression = this._newClassExpression.getParent();
            if (!(parentNewClassExpression instanceof SourceFieldVariable)) {
                return false;
            }
            final SourceFieldVariable parentVariable = (SourceFieldVariable)parentNewClassExpression;
            final String fieldVariableName = parentVariable.getName();
            SourceVisitor<Boolean> fieldVariableUsedFindVisitor = new SourceVisitor<Boolean>(){

                public void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
                    JavaHasType resolvedNameExpression;
                    String simpleName = sourceSimpleNameExpression.getName();
                    if (fieldVariableName.equals(simpleName) && parentVariable.equals(resolvedNameExpression = sourceSimpleNameExpression.getResolvedObject())) {
                        this.data = Boolean.TRUE;
                        this.cancelAll();
                    }
                }
            };
            body.visitSelf((SourceVisitor)fieldVariableUsedFindVisitor);
            return Boolean.TRUE.equals(fieldVariableUsedFindVisitor.data);
        }
    }

    private static final class LambdaToAnonymousClassConvertor {
        private Map<String, JavaType> _typeParameters = new HashMap<String, JavaType>();
        private final SourceLambdaExpression _lambdaExpression;
        private final SourceFactory _factory;

        public static SourceNewClassExpression convertLambdaToAnonymousClass(SourceLambdaExpression lambdaExpression, SourceFactory factory) {
            LambdaToAnonymousClassConvertor lambdaToAnonymousClassConvertor = new LambdaToAnonymousClassConvertor(lambdaExpression, factory);
            return lambdaToAnonymousClassConvertor.createAnonymousClassFromLambda();
        }

        private LambdaToAnonymousClassConvertor(SourceLambdaExpression lambdaExpression, SourceFactory factory) {
            this._lambdaExpression = lambdaExpression;
            this._factory = factory;
        }

        private SourceNewClassExpression createAnonymousClassFromLambda() {
            JavaMethod targetMethod = this._lambdaExpression.getTargetMethod();
            if (targetMethod == null) {
                return null;
            }
            SourceClassBody body = this.createAnononymousClassBody(targetMethod);
            JavaClass functionalInterface = targetMethod.getOwningClass();
            SourceExpression lhs = null;
            SourceTypeReference type = this._factory.createType(functionalInterface.getRawName());
            this.addInterfaceTypeArgumentsIfSpecified(functionalInterface, type);
            SourceListExpression arguments = null;
            SourceNewClassExpression newAnonymousClass = this._factory.createNewClassExpression(lhs, type, arguments, body);
            return newAnonymousClass;
        }

        private SourceClassBody createAnononymousClassBody(JavaMethod targetMethod) {
            SourceTypeReference returnType = this.createReturnType(targetMethod, this._lambdaExpression);
            SourceFormalParameterList parameters = this.createMethodParameters(targetMethod);
            SourceThrowsClause throwsClause = null;
            SourceBlock block = this.createMethodSourceBlock(targetMethod);
            String methodName = targetMethod.getName();
            SourceTypeParameter[] tyParameters = null;
            SourceMethod newMethodInAnonymousClass = this._factory.createMethod(tyParameters, returnType, methodName, parameters, throwsClause, block);
            newMethodInAnonymousClass.setModifiers(1);
            SourceAnnotation annotation = this._factory.createAnnotation("Override");
            annotation.addSelf((SourceElement)newMethodInAnonymousClass);
            SourceClassBody anonymousClassBody = this._factory.createClassBody((SourceMember)newMethodInAnonymousClass);
            return anonymousClassBody;
        }

        private SourceTypeReference createReturnType(JavaMethod targetMethod, SourceLambdaExpression lambdaExpression) {
            JavaType anonMethodReturnBaseType;
            JavaType t = targetMethod.getReturnType();
            JavaType origReturnBaseType = t.isArray() ? t.getBaseComponentType() : t;
            JavaType anonMethodReturnType = lambdaExpression.getResolvedType();
            assert (anonMethodReturnType != null);
            JavaType javaType = anonMethodReturnBaseType = anonMethodReturnType.isArray() ? anonMethodReturnType.getBaseComponentType() : anonMethodReturnType;
            if (origReturnBaseType instanceof SourceTypeParameter) {
                this._typeParameters.put(origReturnBaseType.getName(), anonMethodReturnBaseType);
            } else if (origReturnBaseType.hasActualTypeArguments()) {
                Collection returnTypeArguments = origReturnBaseType.getActualTypeArguments();
                int returnTypeArgumentsSize = returnTypeArguments.size();
                if (anonMethodReturnBaseType.getActualTypeArguments().size() == returnTypeArgumentsSize) {
                    JavaType[] returnTypeArgumentsArray = returnTypeArguments.toArray(new JavaType[returnTypeArgumentsSize]);
                    JavaType[] foundTypeArgumentsArray = anonMethodReturnBaseType.getActualTypeArguments().toArray(new JavaType[returnTypeArgumentsSize]);
                    for (int i = 0; i < returnTypeArgumentsSize; ++i) {
                        this._typeParameters.put(returnTypeArgumentsArray[i].getName(), foundTypeArgumentsArray[i]);
                    }
                }
            }
            SourceTypeReference returnType = this.createTypeReference(this._factory, anonMethodReturnType);
            return returnType;
        }

        private SourceFormalParameterList createMethodParameters(JavaMethod targetMethod) {
            JavaType[] origMethodParameterTypes = targetMethod.getParameterTypes();
            List lambdaParameters = this._lambdaExpression.getFormalParameters();
            SourceFormalParameter[] methodParameters = new SourceFormalParameter[origMethodParameterTypes.length];
            for (int i = 0; i < origMethodParameterTypes.length; ++i) {
                SourceLambdaParameter lambdaParameter = (SourceLambdaParameter)lambdaParameters.get(i);
                JavaType lambdaParam = lambdaParameter.getResolvedType();
                assert (lambdaParam != null);
                JavaType origMethodParam = origMethodParameterTypes[i];
                if (origMethodParam instanceof SourceTypeParameter) {
                    this._typeParameters.put(origMethodParam.getName(), lambdaParam);
                }
                SourceTypeReference newParamType = this.createTypeReference(this._factory, lambdaParam);
                SourceLocalVariable paramLocalVariable = this._factory.createLocalVariable(newParamType, ((SourceLambdaParameter)this._lambdaExpression.getFormalParameters().get(i)).getName());
                methodParameters[i] = this._factory.createFormalParameter(paramLocalVariable);
            }
            SourceFormalParameterList parameters = this._factory.createFormalParameterList(methodParameters);
            return parameters;
        }

        private SourceBlock createMethodSourceBlock(JavaMethod targetMethod) {
            SourceBlock block;
            SourceElement lambdaBody = this._lambdaExpression.getBody();
            if (lambdaBody.getSymbolKind() == 2) {
                block = (SourceBlock)lambdaBody.cloneSelf(this._factory.getSourceFile());
            } else {
                SourceElement clonedBodyElement = lambdaBody.cloneSelf(this._factory.getSourceFile());
                JavaType targetMethodReturnType = targetMethod.getReturnType();
                Object bodyElement = targetMethodReturnType != null && !"void".equals(targetMethodReturnType.getName()) ? this._factory.createReturnStatement((SourceExpression)clonedBodyElement) : this._factory.createExpressionStatement((SourceExpression)clonedBodyElement);
                block = this._factory.createBlock(new SourceElement[]{bodyElement});
            }
            return block;
        }

        private SourceTypeReference createTypeReference(SourceFactory factory, JavaType origJavaType) {
            if (origJavaType.isArray()) {
                return factory.createType(origJavaType.getBaseComponentType().getQualifiedName(), origJavaType.getArrayDimensions());
            }
            return factory.createType(origJavaType.getQualifiedName());
        }

        private void addInterfaceTypeArgumentsIfSpecified(JavaClass functionalInterface, SourceTypeReference type) {
            if (functionalInterface.hasTypeParameters()) {
                ArrayList<SourceTypeArgument> typeArguments = new ArrayList<SourceTypeArgument>();
                for (JavaTypeVariable origClassTypeParam : functionalInterface.getTypeParameters()) {
                    JavaType actualTypeArgument = this._typeParameters.get(origClassTypeParam.getName());
                    if (actualTypeArgument == null) {
                        block1: for (JavaTypeVariable otherTypeParameter : functionalInterface.getTypeParameters()) {
                            if (otherTypeParameter.equals(origClassTypeParam)) continue;
                            Iterator iJavaTypeBound = otherTypeParameter.getBounds().iterator();
                            while (actualTypeArgument == null && iJavaTypeBound.hasNext()) {
                                JavaType typeBound = (JavaType)iJavaTypeBound.next();
                                if (!typeBound.getName().equals(origClassTypeParam.getName()) || (actualTypeArgument = this._typeParameters.get(otherTypeParameter.getName())) == null) continue;
                                break block1;
                            }
                        }
                    }
                    String actualTypeArgumentName = actualTypeArgument != null ? actualTypeArgument.getName() : "java.lang.Object";
                    SourceTypeArgument typeArgument = this._factory.createTypeArgumentFromText(actualTypeArgumentName);
                    typeArguments.add(typeArgument);
                }
                if (!typeArguments.isEmpty()) {
                    type.setTypeArguments(typeArguments);
                }
            }
        }
    }

    private static final class AnonymousClassToLambdaConvertor {
        private static final int BINDING_ANONYMOUS_TO_LAMBDA_RENAME = BindingRegistry.register((String)"transform-anonymous-to-lambda");
        private final SourceNewClassExpression newClassExpression;
        private final SourceFactory factory;
        private final Set<String> excludedNames = new HashSet<String>();
        private final List<SourceHasName> declarationsWithCollidingName = new ArrayList<SourceHasName>();
        private final Collection<SourceHasName> declarationsToRename = new ArrayList<SourceHasName>();

        public static SourceLambdaExpression convertAnonymousClassToLambda(SourceNewClassExpression newClassExpression, SourceFactory factory) {
            return new AnonymousClassToLambdaConvertor(newClassExpression, factory).convertAnonymousClassToLambda();
        }

        private AnonymousClassToLambdaConvertor(SourceNewClassExpression newClassExpression, SourceFactory factory) {
            this.newClassExpression = newClassExpression;
            this.factory = factory;
        }

        private SourceLambdaExpression convertAnonymousClassToLambda() {
            SourceClass anonymousClass = this.newClassExpression.getAnonymousClass();
            SourceMethod sourceMethod = (SourceMethod)anonymousClass.getSourceMethods().iterator().next();
            this.gatherExcludedNames((SourceClass)sourceMethod.getParent().getParent());
            this.goThroughMethodParametersNames(sourceMethod);
            SourceBlock block = sourceMethod.getBlock();
            this.goThroughDeclarationNames(block);
            this.solveCollidingNamesDeclarations();
            this.updateNameReferences(block);
            this.renameDeclarations();
            SourceLambdaParameter[] lambdaParameters = this.createLambdaParameters(sourceMethod);
            SourceElement lambdaBody = this.createLambdaBody(block, this.factory.getSourceFile());
            SourceLambdaExpression lambdaExpression = this.factory.createLambdaExpression(lambdaParameters, lambdaBody);
            return lambdaExpression;
        }

        private void renameDeclarations() {
            for (SourceHasName elementToRename : this.declarationsToRename) {
                AnonymousToLambdaRenameBinding binding = (AnonymousToLambdaRenameBinding)elementToRename.getBinding(BINDING_ANONYMOUS_TO_LAMBDA_RENAME);
                if (binding == null) continue;
                elementToRename.setName(binding.getSuggestedName());
                elementToRename.clearBinding(BINDING_ANONYMOUS_TO_LAMBDA_RENAME);
            }
            this.declarationsToRename.clear();
        }

        private SourceLambdaParameter[] createLambdaParameters(SourceMethod sourceMethod) {
            List methodParameters = sourceMethod.getSourceParameters();
            SourceLambdaParameter[] res = new SourceLambdaParameter[methodParameters.size()];
            int i = 0;
            for (SourceVariable methodParameter : methodParameters) {
                SourceLambdaParameter lambdaParameter;
                String qualifiedParameterType = AnonymousClassToLambdaConvertor.getQualifiedTypeName((JavaHasType)methodParameter);
                SourceTypeReference methodParameterType = this.factory.createType(qualifiedParameterType);
                String parameterName = methodParameter.getName();
                res[i] = lambdaParameter = this.factory.createLambdaParameter(0, methodParameterType, parameterName);
                ++i;
            }
            return res;
        }

        private static String getQualifiedTypeName(JavaHasType javaHasType) {
            JavaType resolvedType = javaHasType.getResolvedType();
            if (resolvedType != null) {
                return resolvedType.getQualifiedName();
            }
            UnresolvedType unresolvedType = javaHasType.getUnresolvedType();
            return unresolvedType.getSimplifiedName();
        }

        private void goThroughMethodParametersNames(SourceMethod sourceMethod) {
            List sourceParameters = sourceMethod.getSourceParameters();
            if (sourceParameters == null) {
                return;
            }
            for (SourceVariable methodParameter : sourceParameters) {
                this.verifyDeclarationName((SourceHasName)methodParameter);
            }
        }

        private SourceElement createLambdaBody(SourceBlock sourceBlock, SourceFile targetFile) {
            List blockChildrenElements = sourceBlock.getChildren(458752);
            if (blockChildrenElements.size() != 1) {
                return AnonymousClassToLambdaConvertor.cloneElement(sourceBlock, targetFile);
            }
            SourceElement oneBlockElement = (SourceElement)blockChildrenElements.get(0);
            switch (oneBlockElement.getSymbolKind()) {
                case 52: {
                    return AnonymousClassToLambdaConvertor.cloneElement(((SourceExpressionStatement)oneBlockElement).getExpression(), targetFile);
                }
                case 56: {
                    return AnonymousClassToLambdaConvertor.cloneElement(((SourceReturnStatement)oneBlockElement).getExpression(), targetFile);
                }
            }
            return AnonymousClassToLambdaConvertor.cloneElement(sourceBlock, targetFile);
        }

        private void goThroughDeclarationNames(SourceBlock sourceBlock) {
            SourceVisitor renameLocalVariableVisitor = new SourceVisitor(){

                public void whenEnterLocalVariable(SourceLocalVariable localVariable) {
                    this.renameSourceVariable((SourceVariable)localVariable);
                }

                public void whenEnterFieldVariable(SourceFieldVariable sourceFieldVariable) {
                    this.renameSourceVariable((SourceVariable)sourceFieldVariable);
                }

                private void renameSourceVariable(SourceVariable sourceVariable) {
                    this.verifyDeclarationName((SourceHasName)sourceVariable);
                }
            };
            sourceBlock.visitSelf(renameLocalVariableVisitor);
        }

        private void verifyDeclarationName(SourceHasName sourceHasName) {
            String originalVariableName = sourceHasName.getName();
            if (this.excludedNames.add(originalVariableName)) {
                sourceHasName.setBinding((NodeBinding)new AnonymousToLambdaRenameBinding(originalVariableName));
            } else {
                this.declarationsWithCollidingName.add(sourceHasName);
            }
            this.declarationsToRename.add(sourceHasName);
        }

        private void solveCollidingNamesDeclarations() {
            for (SourceHasName sourceHasName : this.declarationsWithCollidingName) {
                String suggestedVariableName = this.suggestParameterOrVariableName(sourceHasName.getName());
                sourceHasName.setBinding((NodeBinding)new AnonymousToLambdaRenameBinding(suggestedVariableName));
            }
            this.declarationsWithCollidingName.clear();
        }

        private void updateNameReferences(SourceBlock sourceBlock) {
            SourceVisitor renameParameterVisitor = new SourceVisitor(){

                public void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
                    JavaHasType resolvedNameExpression = sourceSimpleNameExpression.getResolvedObject();
                    if (resolvedNameExpression == null) {
                        return;
                    }
                    SourceElement sourceResolvedNameExpression = resolvedNameExpression.getSourceElement();
                    if (sourceResolvedNameExpression == null) {
                        return;
                    }
                    AnonymousToLambdaRenameBinding binding = (AnonymousToLambdaRenameBinding)sourceResolvedNameExpression.getBinding(BINDING_ANONYMOUS_TO_LAMBDA_RENAME);
                    if (binding != null) {
                        sourceSimpleNameExpression.setName(binding.getSuggestedName());
                    }
                }
            };
            sourceBlock.visitSelf(renameParameterVisitor);
        }

        private void gatherExcludedNames(SourceClass sourceClass) {
            CallerContext callerContext = CallerContext.createContext((SourceElement)sourceClass);
            CallerContext.InputOptions inputOptions = new CallerContext.InputOptions();
            inputOptions.input = 8;
            CallerContext.Output listNames = callerContext.listNames((JavaHasType)null, inputOptions);
            ArrayList list = listNames.all;
            for (JavaElement elem : list) {
                if (!(elem instanceof JavaHasName)) continue;
                this.excludedNames.add(((JavaHasName)elem).getName());
            }
        }

        private String suggestParameterOrVariableName(String originalName) {
            for (int i = 0; i < 100; ++i) {
                String suggestedName = AnonymousClassToLambdaConvertor.suggestName(originalName, i);
                if (!this.excludedNames.add(suggestedName)) continue;
                return suggestedName;
            }
            return AnonymousClassToLambdaConvertor.suggestName(originalName, System.currentTimeMillis());
        }

        private static String suggestName(String originalName, long suffix) {
            boolean hasNumberSuffix;
            if (suffix == 0L) {
                return originalName;
            }
            int last_ = originalName.lastIndexOf(95);
            boolean bl = hasNumberSuffix = last_ != -1;
            if (hasNumberSuffix) {
                for (char ch : originalName.substring(last_ + 1).toCharArray()) {
                    if (Character.isDigit(ch)) continue;
                    hasNumberSuffix = false;
                    break;
                }
            }
            if (hasNumberSuffix) {
                return originalName.substring(0, last_) + '_' + suffix;
            }
            return originalName + '_' + suffix;
        }

        private static <T extends SourceElement> T cloneElement(T elementToClone, SourceFile targetFile) {
            return (T)elementToClone.cloneSelf(targetFile);
        }

        private static final class AnonymousToLambdaRenameBinding
        implements NodeBinding {
            private final String suggestedName;

            public AnonymousToLambdaRenameBinding(String suggestedName) {
                this.suggestedName = suggestedName;
            }

            public int getBindingType() {
                return BINDING_ANONYMOUS_TO_LAMBDA_RENAME;
            }

            public String getSuggestedName() {
                return this.suggestedName;
            }
        }
    }

    public static final class SourceElementLocation {
        public final SourceElement sibling;
        public final boolean addBefore;

        public SourceElementLocation(SourceElement sibling, boolean addBefore) {
            this.sibling = sibling;
            this.addBefore = addBefore;
        }
    }
}

