/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.build;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ide.Context;
import oracle.ide.compiler.BuildLog;
import oracle.ide.compiler.BuildSystemListener;
import oracle.ide.compiler.BuildSystemListener2;
import oracle.ide.compiler.CompileArguments;
import oracle.ide.compiler.Compiler;
import oracle.ide.file.ProjectCache;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.LockFailedException;
import oracle.ide.index.QueryCriteria;
import oracle.ide.index.QueryFailedException;
import oracle.ide.index.keyword.KeywordCriteria;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.jdevimpl.build.BuildQueue;
import oracle.jdevimpl.compiler.JCompilerUtils;
import oracle.jdevimpl.javacompiler.JavaDependencyProvider;

class BuildQueueBuilder
extends Thread {
    private Map<Workspace, List<BuildContext>> changedBuildContexts;
    private Map<Project, BuildContext> dependentBuildContexts;
    private int projectCounter;
    private int projectsToCompile;
    private boolean shutDown;
    private boolean canceled;
    private Context currentCompilerContext;

    BuildQueueBuilder(ClassLoader classLoader) {
        this.setContextClassLoader(classLoader);
    }

    void shutDown() {
        this.shutDown = true;
        Compiler.getCompiler().cancelCompileOrClean(this.currentCompilerContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        BuildSystemListener2 buildSystemListener;
        block29: {
            JavaDependencyProviderListener javaDependencyProviderListener = null;
            buildSystemListener = null;
            try {
                UnifiedBuildSystem.logger.trace("BuildQueueBuilder.run()");
                javaDependencyProviderListener = new JavaDependencyProviderListener();
                JavaDependencyProvider.addListener((JavaDependencyProvider.Listener)javaDependencyProviderListener);
                buildSystemListener = new BuildSystemListener2(){

                    public void workspaceBuildWillStart(Workspace workspace) {
                    }

                    public void workspaceBuildFinished(Workspace workspace) {
                    }

                    public void workspaceCleanWillStart(Workspace workspace) {
                    }

                    public void workspaceCleanFinished(Workspace workspace) {
                    }

                    public void projectBuildWillStart(Workspace workspace, Project project) {
                    }

                    public void projectBuildFinished(Workspace workspace, Project project) {
                    }

                    public void projectCleanWillStart(Workspace workspace, Project project) {
                    }

                    public void projectCleanFinished(Workspace workspace, Project project) {
                    }

                    public void setBuildLog(BuildLog buildLog) {
                    }

                    public void buildWillStart(Context context) {
                    }

                    public void buildFinished(int errorCount, int warningCount, int infoCount) {
                    }

                    public void cleanWillStart(Context context) {
                    }

                    public void cleanFinished(Context context) {
                    }

                    public void buildCanceled(Context context) {
                        BuildQueueBuilder.this.canceled = true;
                    }
                };
                Compiler.getCompiler().addBuildSystemListener((BuildSystemListener)buildSystemListener);
                boolean clearLogBeforeCompile = true;
                while (true) {
                    BuildContext buildContext;
                    if ((buildContext = this.getNextBuildContext()) == null || this.shutDown || this.canceled) {
                        if (buildContext != null) break;
                        UnifiedBuildSystem.logger.trace("BuildQueueBuilder.run(): done, no more buildContext");
                        break;
                    }
                    if (!this.checkWorkspaceProjectExist(buildContext)) continue;
                    try {
                        String msg = CompArb.format(124, this.projectCounter, this.projectsToCompile);
                        Compiler.getCompiler().logOutMsg("\n" + msg + "\n\n");
                        this.currentCompilerContext = new Context(buildContext.workspace, buildContext.project);
                        List<Node> nodes = buildContext.nodes;
                        Element[] nodeArray = (Element[])nodes.toArray(new Node[nodes.size()]);
                        this.currentCompilerContext.setSelection(nodeArray);
                        this.currentCompilerContext.setProperty("BuildQueueBuilderContext", (Object)"");
                        CompileArguments compileArguments = new CompileArguments(this.currentCompilerContext);
                        compileArguments.setCompileDependencies(false);
                        compileArguments.setRebuildAllSources(buildContext.forceRebuild);
                        compileArguments.setSaveBeforeCompiling(false);
                        compileArguments.setWaitForTermination(true);
                        compileArguments.setClearLogBeforeCompile(clearLogBeforeCompile);
                        compileArguments.setWaitOnConcurrentCleanOrCompile(true);
                        clearLogBeforeCompile = false;
                        if (this.shutDown || this.canceled) break;
                        Compiler compiler = Compiler.getCompiler();
                        UnifiedBuildSystem.logger.trace("BuildQueueBuilder.run(): compile");
                        boolean result = compiler.compile(compileArguments);
                        UnifiedBuildSystem.logger.trace("BuildQueueBuilder.run(): compile done");
                        if (this.shutDown || this.canceled) break;
                        boolean contextExists = this.checkWorkspaceProjectExist(buildContext);
                        if (!(contextExists && result || !buildContext.collectDependentProjects || this.dependentBuildContexts == null)) {
                            this.dependentBuildContexts.clear();
                            this.dependentBuildContexts = null;
                        }
                        if (contextExists && result && buildContext.collectDependentProjects) {
                            this.addDependentProjects(buildContext, javaDependencyProviderListener.getChangedClassNames());
                        }
                        javaDependencyProviderListener.clear();
                        UnifiedBuildSystem.logger.trace("BuildQueueBuilder.run(): continue looking for next build context");
                        continue;
                    }
                    finally {
                        this.currentCompilerContext = null;
                        continue;
                    }
                    break;
                }
                if (this.canceled) {
                    UnifiedBuildSystem.logger.trace("BuildQueueBuilder.run(): done, canceled");
                } else if (this.shutDown) {
                    UnifiedBuildSystem.logger.trace("BuildQueueBuilder.run(): done, shutDown");
                }
                if (javaDependencyProviderListener == null) break block29;
            }
            catch (Throwable t2) {
                block30: {
                    try {
                        Assert.printStackTrace((Throwable)t2);
                        if (javaDependencyProviderListener == null) break block30;
                    }
                    catch (Throwable throwable) {
                        if (javaDependencyProviderListener != null) {
                            JavaDependencyProvider.removeListener(javaDependencyProviderListener);
                        }
                        if (buildSystemListener != null) {
                            Compiler.getCompiler().removeBuildSystemListener(buildSystemListener);
                        }
                        Class<BuildQueue> clazz = BuildQueue.class;
                        synchronized (BuildQueue.class) {
                            BuildQueue.queueBuildFinished();
                            // ** MonitorExit[var16_19] (shouldn't be in output)
                            String msg = CompArb.getString(125);
                            Compiler.getCompiler().logOutMsg("\n" + msg + "\n\n");
                            throw throwable;
                        }
                    }
                    JavaDependencyProvider.removeListener((JavaDependencyProvider.Listener)javaDependencyProviderListener);
                }
                if (buildSystemListener != null) {
                    Compiler.getCompiler().removeBuildSystemListener(buildSystemListener);
                }
                Class<BuildQueue> t2 = BuildQueue.class;
                synchronized (BuildQueue.class) {
                    BuildQueue.queueBuildFinished();
                    // ** MonitorExit[t] (shouldn't be in output)
                    String msg = CompArb.getString(125);
                    Compiler.getCompiler().logOutMsg("\n" + msg + "\n\n");
                    return;
                }
            }
            JavaDependencyProvider.removeListener((JavaDependencyProvider.Listener)javaDependencyProviderListener);
        }
        if (buildSystemListener != null) {
            Compiler.getCompiler().removeBuildSystemListener((BuildSystemListener)buildSystemListener);
        }
        Class<BuildQueue> clearLogBeforeCompile = BuildQueue.class;
        synchronized (BuildQueue.class) {
            BuildQueue.queueBuildFinished();
            // ** MonitorExit[clearLogBeforeCompile] (shouldn't be in output)
            String msg = CompArb.getString(125);
            Compiler.getCompiler().logOutMsg("\n" + msg + "\n\n");
            return;
        }
    }

    private boolean checkWorkspaceProjectExist(BuildContext buildContext) {
        Workspace workspace = buildContext.workspace;
        Project project = buildContext.project;
        URL workspaceUrl = workspace.getURL();
        URL projectUrl = project.getURL();
        if (!URLFileSystem.exists((URL)workspaceUrl) || !URLFileSystem.exists((URL)projectUrl)) {
            UnifiedBuildSystem.logger.trace("Workspace {0} and/or Project {1} doesn't exist", (Object)URLFileSystem.getPath((URL)workspaceUrl), (Object)URLFileSystem.getPath((URL)projectUrl));
            return false;
        }
        return true;
    }

    private BuildContext getNextBuildContext() {
        UnifiedBuildSystem.logger.trace("BuildQueueBuilder.getNextBuildContext()");
        if (this.shutDown || this.canceled) {
            return null;
        }
        this.queueWaitingFiles();
        if (this.changedBuildContexts != null || this.dependentBuildContexts != null) {
            String msg = CompArb.getString(126);
            Compiler.getCompiler().logOutMsg("\n" + msg + "\n\n");
        }
        if (this.changedBuildContexts != null) {
            UnifiedBuildSystem.logger.trace("BuildQueueBuilder.getNextBuildContext(), handling changedBuildContexts");
            Iterator<Workspace> iterator = this.changedBuildContexts.keySet().iterator();
            Workspace workspace = iterator.next();
            List<BuildContext> buildContexts = this.changedBuildContexts.get(workspace);
            BuildContext buildContext = buildContexts.remove(0);
            if (buildContexts.isEmpty()) {
                this.changedBuildContexts.remove(workspace);
                if (this.changedBuildContexts.isEmpty()) {
                    this.changedBuildContexts = null;
                }
            }
            ++this.projectCounter;
            UnifiedBuildSystem.logger.trace("BuildQueueBuilder.getNextBuildContext(), returning changedBuildContexts");
            return buildContext;
        }
        while (this.dependentBuildContexts != null) {
            UnifiedBuildSystem.logger.trace("BuildQueueBuilder.getNextBuildContext(), handling dependentBuildContexts");
            Project project = this.dependentBuildContexts.keySet().iterator().next();
            BuildContext buildContext = this.dependentBuildContexts.remove(project);
            if (this.dependentBuildContexts.isEmpty()) {
                this.dependentBuildContexts = null;
            }
            ++this.projectCounter;
            if (!this.contextHasBuildableNodes(buildContext)) continue;
            UnifiedBuildSystem.logger.trace("BuildQueueBuilder.getNextBuildContext(), returning dependentBuildContext");
            return buildContext;
        }
        UnifiedBuildSystem.logger.trace("BuildQueueBuilder.getNextBuildContext(), return null");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDependentProjects(BuildContext buildContext, Set<String> changedClassNames) {
        try {
            Collection projects;
            if (changedClassNames.isEmpty()) {
                return;
            }
            try (ProjectCache projectCache = null;){
                projectCache = ProjectCache.getInstance((Workspace)buildContext.workspace);
                projects = projectCache.getDownstreamDependencies(buildContext.project);
                if (projects.isEmpty()) {
                    return;
                }
            }
            HashSet<String> shortChangedClassNames = new HashSet<String>();
            for (String name : changedClassNames) {
                int index = name.lastIndexOf(46);
                if (index > 0) {
                    shortChangedClassNames.add(name.substring(index + 1));
                    continue;
                }
                if (index >= 0) continue;
                shortChangedClassNames.add(name);
            }
            if (this.dependentBuildContexts == null) {
                this.dependentBuildContexts = new LinkedHashMap<Project, BuildContext>();
            }
            for (Project project : projects) {
                BuildContext dependent = this.dependentBuildContexts.get(project);
                if (dependent == null) {
                    dependent = new BuildContext();
                    dependent.workspace = buildContext.workspace;
                    dependent.project = project;
                    dependent.forceRebuild = true;
                    this.dependentBuildContexts.put(project, dependent);
                    ++this.projectsToCompile;
                }
                if (dependent.changedClassNames == null) {
                    dependent.changedClassNames = shortChangedClassNames;
                    continue;
                }
                dependent.changedClassNames.addAll(shortChangedClassNames);
            }
        }
        catch (InterruptedException projectCache) {
        }
        catch (Exception ex) {
            Assert.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean contextHasBuildableNodes(BuildContext buildContext) {
        Workspace workspace = buildContext.workspace;
        Project project = buildContext.project;
        Set<String> changedClassNames = buildContext.changedClassNames;
        QueryCriteria criteria = KeywordCriteria.get((String[])changedClassNames.toArray(new String[changedClassNames.size()]));
        ArrayList<Node> nodes = new ArrayList<Node>();
        Index index = null;
        try {
            index = IndexManager.getIndexManager().getIndex(workspace, project);
            index.lock();
            URL[] dependentNodes = index.blockingQuery(criteria);
            if (dependentNodes != null && dependentNodes.length > 0) {
                for (URL dependentNode : dependentNodes) {
                    if (!dependentNode.getPath().endsWith(".java")) continue;
                    try {
                        Node node = NodeFactory.findOrCreate((URL)dependentNode);
                        if (node == null) continue;
                        nodes.add(node);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            buildContext.nodes = nodes;
            boolean bl = !nodes.isEmpty();
            return bl;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (LockFailedException lockFailedException) {
        }
        catch (QueryFailedException queryFailedException) {
        }
        finally {
            if (index != null) {
                index.unlock();
                index.release();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueWaitingFiles() {
        List<BuildContext> files = BuildQueue.getWaitingFiles();
        if (files != null) {
            Workspace previousWorkspace = null;
            try (ProjectCache projectCache = null;){
                for (BuildContext buildContext : files) {
                    Workspace workspace = buildContext.workspace;
                    if (previousWorkspace != workspace && projectCache != null) {
                        projectCache.close();
                        projectCache = null;
                    }
                    if (!this.checkWorkspaceProjectExist(buildContext)) continue;
                    if (projectCache == null) {
                        projectCache = ProjectCache.getInstance((Workspace)workspace);
                    }
                    this.addNextChangedBuildContext(buildContext, projectCache);
                    previousWorkspace = workspace;
                }
            }
        }
    }

    private void addNextChangedBuildContext(BuildContext nextBuildContext, ProjectCache projectCache) {
        List<BuildContext> buildContexts;
        Workspace workspace = nextBuildContext.workspace;
        Project project = nextBuildContext.project;
        if (this.changedBuildContexts == null) {
            this.changedBuildContexts = new LinkedHashMap<Workspace, List<BuildContext>>();
        }
        if ((buildContexts = this.changedBuildContexts.get(workspace)) == null) {
            buildContexts = new ArrayList<BuildContext>();
            this.changedBuildContexts.put(workspace, buildContexts);
        }
        BuildContext buildContext = null;
        for (BuildContext oneBuildContext : buildContexts) {
            if (!oneBuildContext.project.equals((Object)project)) continue;
            buildContext = oneBuildContext;
            break;
        }
        if (buildContext == null) {
            buildContext = nextBuildContext;
            buildContext.collectDependentProjects = JCompilerUtils.isBuildProjectAndDependentsAfterSave();
            Collection dependsOn = projectCache.getDirectDependencies(project);
            int x = -1;
            for (x = buildContexts.size() - 1; x >= 0 && !dependsOn.contains(buildContexts.get((int)x).project); --x) {
            }
            buildContexts.add(x + 1, buildContext);
            ++this.projectsToCompile;
        }
        if (buildContext.nodes == null) {
            buildContext.nodes = new ArrayList<Node>();
        }
        buildContext.nodes.add(nextBuildContext.node);
    }

    static class BuildContext {
        Workspace workspace;
        Project project;
        List<Node> nodes;
        Node node;
        boolean forceRebuild;
        boolean collectDependentProjects;
        Set<String> changedClassNames;

        BuildContext() {
        }
    }

    private static class JavaDependencyProviderListener
    implements JavaDependencyProvider.Listener {
        private Set<String> changedClassNames = new HashSet<String>();

        private JavaDependencyProviderListener() {
        }

        public void classSignaturesChanged(List<String> classNames) {
            this.changedClassNames.addAll(classNames);
        }

        private Set<String> getChangedClassNames() {
            return this.changedClassNames;
        }

        private void clear() {
            this.changedClassNames.clear();
        }
    }
}

