/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.compiler.CompileArguments;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogPage;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.JarIndex;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemStorage;
import oracle.ide.net.URLPath;
import oracle.ide.runner.SimpleProcess;
import oracle.ide.util.Assert;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.util.PlatformUtils;
import oracle.jdeveloper.compiler.BuildSystemConfiguration;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.Helpers;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdeveloper.compiler.PatchClassFile;
import oracle.jdeveloper.compiler.SourceMap;
import oracle.jdeveloper.compiler.Translator;
import oracle.jdeveloper.compiler.Translator2;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.buildtools.WorkspaceConfiguration;
import oracle.jdevimpl.compiler.BuildSystemUtilities;
import oracle.jdevimpl.compiler.CompilerOptionManager;
import oracle.jdevimpl.compiler.JCompilerUtils;
import oracle.jdevimpl.compiler.OjcRedefineMap;
import oracle.jdevimpl.javacompiler.FileListener;
import oracle.jdevimpl.javacompiler.JDevJavaCompiler;
import oracle.jdevimpl.javacompiler.JDevJavaFileManager;
import oracle.jdevimpl.javacompiler.JavaCompilerLog;
import oracle.jdevimpl.javacompiler.JavaDependencyProvider;
import oracle.jdevimpl.javacompiler.StorageJavaFileObject;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.FileStorage;

public class Ojc
implements Translator2 {
    private final String javacOptionsFromSystemProperty = "oracle.jdevbuild.extra.javac.options";
    private final String eolSeparator = System.getProperty("line.separator");
    private Translator.Log _log = null;
    private static File tmpJavacFile = null;
    private Map<String, String> additionalCompilerOptions;
    private final Pattern javacErrorPattern = Pattern.compile("^(.*):([0-9]+):([\\s\\S]*)$");
    private final Pattern javacWarningPatternExactLine = Pattern.compile("^(.*):([0-9]+):([\\s\\p{L}\\d]+:[\\s]*)(\\[.+\\][\\s\\S]*)$");
    private final Pattern javacWarningPatternExactLineJpCn = Pattern.compile("^(.*):([0-9]+):(.*\u8b66\u544a.*)(\\[.+\\][\\s\\S]*)$");
    private final Pattern javacWarningPatternNoLine = Pattern.compile("^(.+:[\\s]*)(\\[[\\p{L}]+\\][\\s\\S]*$)");
    private final Pattern javacWarningPatternNoLineJpCn = Pattern.compile("^(.*\u8b66\u544a.*)(\\[[\\p{L}]+\\][\\s\\S]*$)");
    private Workspace workspace;
    private Map<Storage, StorageJavaFileObject> storageJavaFileObjects = new HashMap<Storage, StorageJavaFileObject>();
    private boolean isJdevadfWorkspace;

    @Override
    public void setWorkspace(Workspace workspace) {
        this.isJdevadfWorkspace = false;
        this.workspace = workspace;
        if (workspace != null) {
            WorkspaceConfiguration workspaceConfig = WorkspaceConfiguration.getWorkspaceConfiguration((Workspace)workspace);
            this.isJdevadfWorkspace = workspaceConfig.isModularBuildWorkspace();
        }
    }

    @Override
    public String getName() {
        return "Ojc";
    }

    @Override
    public ArrayList<String> getInputTypes() {
        ArrayList<String> v = new ArrayList<String>(1);
        v.add(".java");
        return v;
    }

    @Override
    public ArrayList<String> getOutputTypes() {
        ArrayList<String> v = new ArrayList<String>(1);
        v.add(".class");
        return v;
    }

    @Override
    public boolean canBuild(Storage store) {
        return store.getName().endsWith(".java");
    }

    @Override
    public boolean needToBuild(Storage store) {
        return false;
    }

    @Override
    public void setLog(Translator.Log log) {
        this._log = log;
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.startsWith("JavacOption:")) {
            if (this.additionalCompilerOptions == null) {
                this.additionalCompilerOptions = new LinkedHashMap<String, String>();
            }
            this.additionalCompilerOptions.put(name.substring(12), value);
        }
    }

    @Override
    public void setProject(Project project) {
    }

    @Override
    public void updateProject(Project project) {
    }

    private static String getOutputDirectory(Project prj) {
        File outFile;
        URL outUrl = JavaProject.getInstance((Project)prj).getOutputDirectory();
        File file = outFile = outUrl != null ? new File(outUrl.getPath()) : new File(prj.getURL().getPath()).getParentFile();
        if (!outFile.exists()) {
            outFile.mkdirs();
        }
        return outFile.getPath();
    }

    private static int positionToLine(int position) {
        return position >>> 16;
    }

    private static int positionToColumn(int position) {
        return position & 0xFFFF;
    }

    private static int lineColumnToPosition(int line, int column) {
        return line << 16 | column & 0xFFFF;
    }

    private static String stringize(String str) {
        if (!(str.startsWith("\"") || str.indexOf(32) < 0 && str.indexOf(9) < 0)) {
            return "\"" + str + "\"";
        }
        return str;
    }

    private void addSMAPs(List<Storage> sources, String outPath) {
        HashMap<String, File[]> classDirectoryMap = new HashMap<String, File[]>();
        for (Storage stor : sources) {
            SourceMap sourceMap = (SourceMap)stor.getProperty("sourceMap");
            if (sourceMap == null) continue;
            try {
                String qualifiedClassName = sourceMap.getQualifiedClassName().replace('.', File.separatorChar) + ".class";
                File qualifiedClassFile = new File(outPath + File.separatorChar + qualifiedClassName);
                if (!qualifiedClassFile.exists()) continue;
                this.patchAndMoveClassFiles(qualifiedClassFile, qualifiedClassName, sourceMap, stor, outPath, classDirectoryMap);
            }
            catch (IOException e) {
                Assert.printStackTrace((Throwable)e);
            }
            catch (ClassFormatError e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
    }

    private void patchAndMoveClassFiles(File qualifiedClassFile, String qualifiedClassName, SourceMap sourceMap, Storage stor, String outPath, HashMap<String, File[]> classDirectoryMap) throws IOException, ClassFormatError {
        String destOutPath = (String)stor.getProperty("outputDirectory");
        boolean moveClassFiles = destOutPath != null && !destOutPath.equals(outPath);
        ArrayList<File> classFileList = new ArrayList<File>();
        classFileList.add(qualifiedClassFile);
        int separatorIndex = qualifiedClassName.lastIndexOf(File.separatorChar);
        String qualifiedPackageName = separatorIndex > 0 ? qualifiedClassName.substring(0, separatorIndex + 1) : "";
        File classDirectory = qualifiedClassFile.getParentFile();
        String classNamePrefix = qualifiedClassFile.getName();
        int dotIndex = classNamePrefix.lastIndexOf(46);
        classNamePrefix = dotIndex > 0 ? classNamePrefix.substring(0, dotIndex) + "$" : null;
        if (classDirectory != null && classNamePrefix != null) {
            File[] children = classDirectoryMap.get(classDirectory.getPath());
            if (children == null) {
                children = classDirectory.listFiles();
                classDirectoryMap.put(classDirectory.getPath(), children);
            }
            for (int x = 0; x < children.length; ++x) {
                String childName = children[x].getName();
                if (!childName.endsWith(".class") || !childName.startsWith(classNamePrefix)) continue;
                classFileList.add(children[x]);
            }
        }
        for (int x = 0; x < classFileList.size(); ++x) {
            File classFile = (File)classFileList.get(x);
            PatchClassFile.addSMAP(classFile, sourceMap.getSMAP());
            if (!moveClassFiles) continue;
            String className = classFile.getName();
            File dest = new File(destOutPath + File.separatorChar + qualifiedPackageName + className);
            if (dest.exists()) {
                dest.delete();
            }
            classFile.renameTo(dest);
        }
    }

    private void logMessage(Translator.Log log, Storage source, int pos, int errCode, String errMsg, boolean error) {
        SourceMap sourceMap;
        int line = Ojc.positionToLine(pos);
        int col = Ojc.positionToColumn(pos);
        if (source != null && (sourceMap = (SourceMap)source.getProperty("sourceMap")) != null) {
            int[] data = new int[]{line, col};
            Storage[] stor = new Storage[]{null};
            boolean translated = sourceMap.translateLocation(data, stor);
            line = data[0];
            col = data[1];
            source = stor[0];
            if (source != null && J2eeSettings.isCompilableJsp((String)source.getName()) && log instanceof IdeLog) {
                String path;
                URL htmlRootDirURL;
                URL newPathURL;
                String newPath;
                File f;
                if (!translated && !error) {
                    return;
                }
                Project project = ((IdeLog)log).getProject();
                if (project != null && (f = new File(newPath = URLFileSystem.getPlatformPathName((URL)(newPathURL = URLFactory.newURL((URL)(htmlRootDirURL = J2eeSettings.getInstance((Project)project).getHtmlRootDirectory()), (String)(path = source.getPath())))))).exists()) {
                    source = Helpers.createFileStorage(f);
                }
            }
        }
        if (error) {
            log.error(source, line, col, errCode, errMsg);
        } else {
            log.warning(source, line, col, errCode, errMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runJavacInProcess(Project jprj, File inProcessToolsJar, CompilerOptionManager optionManager, List<Storage> sources, final ArrayList<Storage> results, final Translator.Log log, String sourcePath) {
        int result;
        URLPath modulePath;
        String path;
        final OjcRedefineMap rm = new OjcRedefineMap();
        final String outPath = Ojc.getOutputDirectory(jprj);
        final LinkedHashMap<String, Storage> sourcesBeingCompiled = new LinkedHashMap<String, Storage>(sources.size());
        final LinkedHashMap<URI, StorageJavaFileObject> fileObjects = new LinkedHashMap<URI, StorageJavaFileObject>();
        BuildSystemConfiguration buildSysConfig = BuildSystemConfiguration.getInstance((PropertyStorage)jprj);
        boolean isJdk9OrHigher = buildSysConfig.isJDK9OrHigher();
        ArrayList<Object> otherOptions = new ArrayList<Object>();
        boolean hasProfileOption = false;
        boolean hasReleaseOption = false;
        boolean reallyVerboseOutput = false;
        String[] projectOptions = optionManager.getCompilerOptionsAsArray("Javac");
        for (int x = 0; x < projectOptions.length; ++x) {
            Object projectOption = projectOptions[x];
            if ("-profile".equals(projectOption)) {
                hasProfileOption = true;
            } else if ("-release".equals(projectOption)) {
                hasReleaseOption = true;
            } else if ("-cp".equals(projectOption)) {
                projectOption = "-classpath";
            } else if ("-bootclasspath".equals(projectOption)) {
                if (this.isJdevadfWorkspace && x < projectOptions.length - 1) {
                    try {
                        URL wsURL;
                        URL oracleViewRoot;
                        URL uRL;
                        String value = projectOptions[x + 1];
                        if (value.indexOf("$(JDK7)") >= 0 && URLFileSystem.exists((URL)(uRL = URLFactory.newDirURL((URL)(oracleViewRoot = URLFileSystem.getParent((URL)URLFileSystem.getParent((URL)(wsURL = this.workspace.getURL())))), (String)"jdk7")))) {
                            String jdk7Path = uRL.getPath();
                            if (jdk7Path.endsWith("/") || jdk7Path.endsWith("\\")) {
                                jdk7Path = jdk7Path.substring(0, jdk7Path.length() - 1);
                            }
                            otherOptions.add(projectOption);
                            value = value.replace("$(JDK7)", jdk7Path);
                            value = value.replace("$(SEP)", File.pathSeparator);
                            otherOptions.add(value);
                            ++x;
                            continue;
                        }
                    }
                    catch (Exception ex) {
                        FeedbackManager.reportException((Throwable)ex);
                    }
                }
            } else if ("-p".equals(projectOption)) {
                projectOption = "--module-path";
            } else if ("-verbose".equals(projectOption)) {
                reallyVerboseOutput = true;
            }
            otherOptions.add(projectOption);
        }
        if (this.additionalCompilerOptions != null) {
            Set<Map.Entry<String, String>> entrySet = this.additionalCompilerOptions.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                String option = entry.getKey();
                if ("-profile".equals(option)) {
                    hasProfileOption = true;
                } else if ("-release".equals(option)) {
                    hasReleaseOption = true;
                } else if ("-cp".equals(option)) {
                    option = "-classpath";
                } else if ("-p".equals(option)) {
                    option = "--module-path";
                } else if ("-verbose".equals(option)) {
                    reallyVerboseOutput = true;
                }
                otherOptions.add(option);
                if (entry.getValue() == null) continue;
                otherOptions.add(entry.getValue());
            }
        }
        List<String> systemPropertyOptions = this.getOptionsFromSystemProperty();
        for (String option : systemPropertyOptions) {
            if ("-profile".equals(option)) {
                hasProfileOption = true;
            } else if ("-release".equals(option)) {
                hasReleaseOption = true;
            } else if ("-cp".equals(option)) {
                option = "-classpath";
            } else if ("-p".equals(option)) {
                option = "--module-path";
            } else if ("-verbose".equals(option)) {
                reallyVerboseOutput = true;
            }
            otherOptions.add(option);
        }
        Map<String, String> defaultOptions = this.getDefaultOptions(buildSysConfig, jprj, outPath, false, sourcePath, hasProfileOption, hasReleaseOption, reallyVerboseOutput);
        PathsConfiguration pathsConfiguration = PathsConfiguration.getInstance((Project)jprj);
        if (UnifiedBuildSystem.showCompileProgress) {
            URLPath classPath;
            if (hasProfileOption) {
                classPath = new URLPath(pathsConfiguration.getJdkClassPath());
                classPath.add(pathsConfiguration.getRunClassPath());
            } else {
                classPath = pathsConfiguration.getRunClassPath();
            }
            if (!buildSysConfig.isJDK9OrHigher()) {
                classPath.add(pathsConfiguration.getModulePath(false, false));
            }
            if (!(path = Helpers.urlPathAndDependantPathToString(reallyVerboseOutput, this._log, classPath, sources, File.pathSeparator)).isEmpty()) {
                defaultOptions.put("-classpath", path);
            }
        }
        if (buildSysConfig.isJDK9OrHigher() && !(path = Helpers.urlPathAndDependantPathToString(reallyVerboseOutput, this._log, modulePath = pathsConfiguration.getModulePath(false, false), sources, File.pathSeparator)).isEmpty()) {
            defaultOptions.put("--module-path", path);
        }
        for (Object otherOption : otherOptions) {
            defaultOptions.remove(otherOption);
        }
        ArrayList<String> finalOptions = new ArrayList<String>();
        for (Map.Entry entry : defaultOptions.entrySet()) {
            finalOptions.add((String)entry.getKey());
            if (entry.getValue() == null) continue;
            finalOptions.add((String)entry.getValue());
        }
        boolean classpathOverride = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (int optionIndex = 0; optionIndex < otherOptions.size(); ++optionIndex) {
            String otherOption = (String)otherOptions.get(optionIndex);
            if (otherOption.equals("-classpath")) {
                classpathOverride = true;
            } else if (otherOption.equals("-endorseddirs")) {
                if (optionIndex + 1 < otherOptions.size()) {
                    String argument = (String)otherOptions.get(optionIndex + 1);
                    stringBuilder.append(argument);
                    stringBuilder.append(File.pathSeparatorChar);
                    ++optionIndex;
                    continue;
                }
            } else if (otherOption.equals("-clearjarindexcache")) {
                JarIndex.clearCache();
                continue;
            }
            finalOptions.add(otherOption);
        }
        this.addEndorsedDirs(finalOptions, jprj, stringBuilder, isJdk9OrHigher, false, reallyVerboseOutput);
        this.filterOutIncompatibleOptions(isJdk9OrHigher, finalOptions, log, hasProfileOption, hasReleaseOption);
        JDevJavaCompiler jdevJavaCompiler = new JDevJavaCompiler();
        for (int x = 0; x < sources.size(); ++x) {
            Storage storage = sources.get(x);
            String storagePath = storage.getPath().replace('\\', '/');
            if (sourcesBeingCompiled.put(storagePath, storage) != null) continue;
            log.clear(storage);
            StorageJavaFileObject storageJavaFileObject = this.storageJavaFileObjects.get(storage);
            if (storageJavaFileObject == null) {
                storageJavaFileObject = new StorageJavaFileObject(null, storage, buildSysConfig.getCurrentEncoding());
            }
            fileObjects.put(storageJavaFileObject.toUri(), storageJavaFileObject);
        }
        if (Thread.currentThread().isInterrupted()) {
            return 0;
        }
        if (UnifiedBuildSystem.showCompileProgress) {
            this.showJavacInProcessCmdLine(jprj, finalOptions, sources);
        }
        class JavacCompilerLog
        implements JavaCompilerLog<JavaFileObject> {
            private String outputDirectory;
            private boolean reallyVerboseOutput;

            JavacCompilerLog(String outputDirectory, boolean reallyVerboseOutput) {
                this.outputDirectory = outputDirectory;
                this.reallyVerboseOutput = reallyVerboseOutput;
            }

            public void println(String line) {
                if (UnifiedBuildSystem.showCompileProgress) {
                    if (line.startsWith("[")) {
                        if (this.reallyVerboseOutput) {
                            JCompiler.getInstance().getOutputLog().log((Object)(line + Ojc.this.eolSeparator));
                        }
                        return;
                    }
                    JCompiler.getInstance().getOutputLog().log((Object)(line + Ojc.this.eolSeparator));
                }
            }

            public void error(JavaFileObject source, long line, long col, int errNumber, String errMsg) {
                String msg = errMsg;
                msg = Ojc.this.replaceEolSeparator(msg, ';');
                Matcher matcher = Ojc.this.javacErrorPattern.matcher(msg);
                msg = matcher.matches() && matcher.groupCount() == 3 ? matcher.group(3) : this.shortenFileName(source, msg);
                int pos = Ojc.lineColumnToPosition((int)line, (int)col);
                Ojc.this.logMessage(log, this.getStorage(source), pos, errNumber, msg, true);
            }

            private String shortenFileName(JavaFileObject source, String msg) {
                Storage storage = this.getStorage(source);
                if (storage != null) {
                    String longName = storage.getPath().replace('\\', '/');
                    String newMsg = msg.replace('\\', '/');
                    return newMsg.replace(longName, storage.getName());
                }
                return msg;
            }

            public void warning(JavaFileObject source, long line, long col, int warnNumber, String warnMsg) {
                String msg = Ojc.this.replaceEolSeparator(warnMsg, ';');
                boolean matched = false;
                Matcher warningMatcher = Ojc.this.javacWarningPatternExactLineJpCn.matcher(msg);
                if (warningMatcher.matches() && warningMatcher.groupCount() == 4) {
                    msg = warningMatcher.group(4);
                    matched = true;
                }
                if (!matched && (warningMatcher = Ojc.this.javacWarningPatternExactLine.matcher(msg)).matches() && warningMatcher.groupCount() == 4) {
                    msg = warningMatcher.group(4);
                    matched = true;
                }
                if (!matched && (warningMatcher = Ojc.this.javacWarningPatternNoLineJpCn.matcher(msg)).matches() && warningMatcher.groupCount() == 2) {
                    msg = warningMatcher.group(2);
                    matched = true;
                }
                if (!matched && (warningMatcher = Ojc.this.javacWarningPatternNoLine.matcher(msg)).matches() && warningMatcher.groupCount() == 2) {
                    msg = warningMatcher.group(2);
                    matched = true;
                }
                if (!matched) {
                    msg = this.shortenFileName(source, msg);
                    matched = true;
                }
                int pos = Ojc.lineColumnToPosition((int)line, (int)col);
                Ojc.this.logMessage(log, this.getStorage(source), pos, warnNumber, msg, false);
            }

            private Storage getStorage(JavaFileObject javaFileObject) {
                if (javaFileObject == null) {
                    return null;
                }
                if (javaFileObject instanceof StorageJavaFileObject) {
                    return ((StorageJavaFileObject)javaFileObject).getStorage();
                }
                StorageJavaFileObject storageJavaFileObject = (StorageJavaFileObject)fileObjects.get(javaFileObject.toUri());
                return storageJavaFileObject == null ? null : storageJavaFileObject.getStorage();
            }

            public void clear(JavaFileObject source) {
            }

            public int nerrors() {
                return log.nerrors();
            }

            public int nwarnings() {
                return log.nwarnings();
            }
        }
        JavacCompilerLog javacCompilerLog = new JavacCompilerLog(outPath, reallyVerboseOutput);
        JDevJavaFileManager fileManager = new JDevJavaFileManager(){

            protected Storage getOutputPathStorage(String outputPath) {
                URL url = URLFactory.newDirURL((String)outputPath);
                if (url != null && URLFileSystem.mkdirs((URL)url)) {
                    return new URLFileSystemStorage(url);
                }
                return null;
            }
        };
        fileManager.setLog((JavaCompilerLog)javacCompilerLog);
        fileManager.setVerbose(reallyVerboseOutput);
        if (hasProfileOption) {
            URLPath urlClassPath = pathsConfiguration.getJdkClassPath();
            String path2 = Helpers.urlPathAndDependantPathToString(reallyVerboseOutput, this._log, urlClassPath, sources, File.pathSeparator);
            fileManager.setProfileJdkClassPath(path2);
        }
        if (!classpathOverride) {
            URLPath classPath = pathsConfiguration.getRunClassPath();
            if (!buildSysConfig.isJDK9OrHigher()) {
                classPath.add(pathsConfiguration.getModulePath(false, false));
            }
            Storage[] classPathStorages = Helpers.urlPathAndDependantPathToStorageArray(reallyVerboseOutput, this._log, classPath, sources);
            fileManager.setClassPath(classPathStorages);
        }
        fileManager.registerFileListener(new FileListener(){

            public void outputFile(String outputPath) {
                rm.redefineClass(outputPath, outPath);
                results.add(new FileStorage(new File(outputPath)));
                if (UnifiedBuildSystem.showCompileProgress) {
                    String msg = "  " + CompArb.format(111, outputPath) + "\n";
                    JCompiler.getInstance().getOutputLog().log((Object)msg);
                }
            }

            public void inputFile(String inputPath) {
                if (!inputPath.endsWith(".java")) {
                    return;
                }
                String name = inputPath.replace('\\', '/');
                Storage source = (Storage)sourcesBeingCompiled.get(name);
                if (source == null) {
                    source = new FileStorage(new File(name));
                    sourcesBeingCompiled.put(name, source);
                    log.clear(source);
                }
                if (UnifiedBuildSystem.showCompileProgress) {
                    String msg = "  " + CompArb.format(112, inputPath) + "\n";
                    JCompiler.getInstance().getOutputLog().log((Object)msg);
                }
            }
        });
        try {
            result = jdevJavaCompiler.compile(inProcessToolsJar, (JavaFileManager)fileManager, fileObjects.values(), finalOptions, (JavaCompilerLog)javacCompilerLog);
        }
        finally {
            try {
                if (fileManager != null) {
                    fileManager.close();
                }
            }
            catch (IOException ioe) {
                FeedbackManager.reportException((Throwable)ioe);
            }
        }
        rm.redefineClassMap(jprj, log);
        this.addSMAPs(sources, outPath);
        UnifiedBuildSystem buildSystem = UnifiedBuildSystem.getInstance();
        for (Storage storage : sourcesBeingCompiled.values()) {
            buildSystem.markTranslated(this, storage);
        }
        sourcesBeingCompiled.clear();
        return result == 0 ? result : (log.nerrors() > 0 ? log.nerrors() : 1);
    }

    private void addEndorsedDirs(List<String> options, Project jprj, StringBuilder endorsedDirs, boolean isJdk9OrHigher, boolean stringize, boolean reallyVerboseOutput) {
        if (!isJdk9OrHigher) {
            String endorsedDirsArgument;
            String endorsedDirsSetting = this.getEndorsedDirsSetting(reallyVerboseOutput, jprj);
            if (endorsedDirsSetting != null) {
                endorsedDirs.append(endorsedDirsSetting);
            }
            if ((endorsedDirsArgument = endorsedDirs.toString().trim()).length() > 0) {
                options.add("-endorseddirs");
                options.add(stringize ? Ojc.stringize(endorsedDirsArgument) : endorsedDirsArgument);
            }
        }
    }

    private void filterOutIncompatibleOptions(boolean isJdk9OrHigher, List<String> options, Translator.Log log, boolean hasProfileOption, boolean hasReleaseOption) {
        if (hasReleaseOption || hasProfileOption || isJdk9OrHigher) {
            Iterator<String> iter = options.iterator();
            while (iter.hasNext()) {
                String option = iter.next();
                int warning = -1;
                int remove = -1;
                switch (option) {
                    case "-source": {
                        if (!hasReleaseOption) break;
                        warning = 168;
                        remove = 2;
                        break;
                    }
                    case "-target": {
                        if (!hasReleaseOption) break;
                        warning = 169;
                        remove = 2;
                        break;
                    }
                    case "-bootclasspath": {
                        if (!isJdk9OrHigher) break;
                        warning = 173;
                        remove = 2;
                        break;
                    }
                    case "-endorseddirs": {
                        if (!isJdk9OrHigher) break;
                        warning = 170;
                        remove = 2;
                        break;
                    }
                    case "-extdirs": {
                        if (!hasReleaseOption) break;
                        warning = 171;
                        remove = 2;
                        break;
                    }
                    default: {
                        if (option.startsWith("-Xbootclasspath:")) {
                            if (isJdk9OrHigher) {
                                warning = 173;
                                remove = 1;
                                break;
                            }
                            if (!hasProfileOption) break;
                            warning = 172;
                            remove = 1;
                            break;
                        }
                        if (option.startsWith("-Xbootclasspath/a:") || option.startsWith("-Xbootclasspath/p:")) {
                            if (!isJdk9OrHigher) break;
                            warning = 173;
                            remove = 1;
                            break;
                        }
                        if (option.startsWith("-Djava.endorsed.dirs=")) {
                            if (!isJdk9OrHigher) break;
                            warning = 170;
                            remove = 1;
                            break;
                        }
                        if (!option.startsWith("-Djava.ext.dirs=") || !isJdk9OrHigher) break;
                        warning = 171;
                        remove = 1;
                    }
                }
                if (warning < 0) continue;
                log.warning(null, 0, 0, 0, CompArb.getString(warning));
                iter.remove();
                if (remove <= 1 || !iter.hasNext()) continue;
                option = iter.next();
                iter.remove();
            }
        }
    }

    private String getEndorsedDirsSetting(boolean reallyVerboseOutput, Project prj) {
        URLPath urlPath = PathsConfiguration.getInstance((Project)prj).getEndorsedStandardsDirectories();
        if (urlPath.size() > 0) {
            return Helpers.urlPathToString(reallyVerboseOutput, this._log, urlPath, File.pathSeparator);
        }
        return null;
    }

    private Map<String, String> getDefaultOptions(BuildSystemConfiguration buildSysConfig, Project jprj, String outPath, boolean stringize, String sourcePath, boolean hasProfileOption, boolean hasReleaseOption, boolean reallyVerboseOutput) {
        LinkedHashMap<String, String> defaultOptions = new LinkedHashMap<String, String>();
        if (!hasReleaseOption) {
            String target;
            String source;
            if (buildSysConfig.isJDK14OrHigher() && !(source = buildSysConfig.getSource()).equals("Default")) {
                defaultOptions.put("-source", source);
            }
            if (!(target = buildSysConfig.getTarget()).equals("Default")) {
                defaultOptions.put("-target", target);
            }
        }
        if (UnifiedBuildSystem.showCompileProgress) {
            defaultOptions.put("-verbose", null);
        }
        defaultOptions.put("-encoding", buildSysConfig.getCurrentEncoding());
        if (!(buildSysConfig.isJDK9OrHigher() || hasProfileOption || hasReleaseOption)) {
            URLPath bootPath = null;
            JDK jdk = JProjectLibraries.getInstance((PropertyStorage)jprj).getJDK();
            if (jdk != null) {
                bootPath = jdk.getClassPath();
            }
            if (bootPath != null) {
                String bootPathString = Helpers.urlPathToString(reallyVerboseOutput, this._log, bootPath, File.pathSeparator);
                if (stringize) {
                    bootPathString = Ojc.stringize(bootPathString);
                }
                if (bootPathString.length() > 0) {
                    defaultOptions.put("-bootclasspath", bootPathString);
                }
            }
        }
        if (!sourcePath.isEmpty()) {
            if (stringize) {
                sourcePath = Ojc.stringize(sourcePath);
            }
            defaultOptions.put("-sourcepath", sourcePath);
        }
        defaultOptions.put("-d", stringize ? Ojc.stringize(outPath) : outPath);
        return defaultOptions;
    }

    private List<String> getOptionsFromSystemProperty() {
        ArrayList<String> extraOptions = new ArrayList<String>();
        String javacOptions = System.getProperty("oracle.jdevbuild.extra.javac.options");
        if (javacOptions == null) {
            return extraOptions;
        }
        CompileArguments helper = new CompileArguments(new Context());
        helper.addJavaCompilerOptions(javacOptions);
        Map translatedOptions = helper.getJavaCompilerOptions();
        for (String entry : translatedOptions.keySet()) {
            extraOptions.add(entry);
            assert (translatedOptions.get(entry) == null) : "Options are only in keys, not in values";
        }
        return extraOptions;
    }

    private void showJavacInProcessCmdLine(Project jprj, List<String> options, List<Storage> sources) {
        URL javacURL;
        StringBuilder cmdBuf = new StringBuilder();
        String javacExe = null;
        JDK jdk = JProjectLibraries.getInstance((PropertyStorage)jprj).getJDK();
        URL uRL = javacURL = jdk != null ? jdk.getSDKBinDir() : null;
        if (javacURL != null) {
            javacURL = URLFactory.newURL((URL)javacURL, (String)"javac");
            javacExe = URLFileSystem.getPlatformPathName((URL)javacURL);
        }
        if (javacExe == null) {
            javacExe = "<path to java executable>";
        }
        cmdBuf.append(javacExe);
        cmdBuf.append(' ');
        boolean skipOption = false;
        for (String option : options) {
            if (skipOption) {
                skipOption = false;
                continue;
            }
            if (option.equals("-version") || option.equals("-et") || option.equals("-rebuild")) continue;
            if (option.indexOf(47) >= 0 || option.indexOf(92) >= 0) {
                cmdBuf.append(Ojc.stringize(option));
            } else {
                cmdBuf.append(option);
            }
            cmdBuf.append(' ');
        }
        for (Storage storage : sources) {
            cmdBuf.append(Ojc.stringize(storage.getPath()));
            cmdBuf.append(' ');
        }
        String cmdLine = cmdBuf.toString();
        if (System.getProperty("COMPILER.COMPILE.PRETTIFY_CMDLINE") != null) {
            cmdLine = this.prettifyCommandLine(cmdLine);
        }
        JCompiler.getInstance().getOutputLog().log((Object)(cmdLine + "\n"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private int runJavacOutOfProcess(Project jprj, CompilerOptionManager optionManager, List<Storage> sources, final List<Storage> results, final Translator.Log log, String sourcePath) {
        String forwardStorPath;
        URLPath moduleURLPath;
        String modulePath;
        String path;
        URLPath classPath;
        final OjcRedefineMap rm = new OjcRedefineMap();
        final LinkedHashMap<String, Storage> sourcesBeingCompiled = new LinkedHashMap<String, Storage>();
        final HashSet sourcesParsed = new HashSet();
        boolean printMoreExtensiveOutput = false;
        String javacString = null;
        try {
            JDK jdk = JProjectLibraries.getInstance((PropertyStorage)jprj).getJDK();
            URL javaExec = jdk != null ? jdk.getJavaExecutable() : null;
            String string = javacString = javaExec != null ? javaExec.getPath() : "";
            if (javacString.endsWith("jre/bin/java.exe")) {
                javacString = javacString.substring(0, javacString.length() - 16) + (File.separatorChar == '/' ? "bin/javac" : "bin/javac.exe");
            } else if (javacString.endsWith("java.exe")) {
                javacString = javacString.substring(0, javacString.length() - 4) + (File.separatorChar == '/' ? "c" : "c.exe");
            } else if (javacString.endsWith("jre/bin/java")) {
                javacString = javacString.substring(0, javacString.length() - 12) + (File.separatorChar == '/' ? "bin/javac" : "bin/javac.exe");
            } else if (javacString.endsWith("java")) {
                javacString = javacString + (File.separatorChar == '/' ? "c" : "c.exe");
            } else {
                throw new Throwable();
            }
            File javacFile = new File(javacString);
            if (!javacFile.exists()) {
                throw new Throwable();
            }
            javacString = Ojc.stringize(javacFile.getPath());
        }
        catch (Throwable t) {
            log.error(null, 0, 0, 0, CompArb.getString(130));
            return 1;
        }
        BuildSystemConfiguration buildSysConfig = BuildSystemConfiguration.getInstance((PropertyStorage)jprj);
        boolean isJdk9OrHigher = buildSysConfig.isJDK9OrHigher();
        ArrayList<String> javacVmCommands = new ArrayList<String>();
        StringTokenizer vmArgs = new StringTokenizer(buildSysConfig.getOutOfProcessJavaOptions());
        while (vmArgs.hasMoreTokens()) {
            javacVmCommands.add("-J" + vmArgs.nextToken());
        }
        String outPath = Ojc.getOutputDirectory(jprj);
        boolean hasProfileOption = false;
        boolean hasReleaseOption = false;
        boolean reallyVerboseOutput = false;
        ArrayList<Object> otherOptions = new ArrayList<Object>();
        String[] compilerOptions = optionManager.getCompilerOptionsAsArray("Javac");
        for (int x = 0; x < compilerOptions.length; ++x) {
            Object compilerOption = compilerOptions[x];
            if ("-profile".equals(compilerOption)) {
                hasProfileOption = true;
            } else if ("-release".equals(compilerOption)) {
                hasReleaseOption = true;
            } else if ("-cp".equals(compilerOption)) {
                compilerOption = "-classpath";
            } else if ("-bootclasspath".equals(compilerOption)) {
                if (this.isJdevadfWorkspace && x < compilerOptions.length - 1) {
                    try {
                        URL wsURL;
                        URL oracleViewRoot;
                        URL jdk7Root;
                        String value = compilerOptions[x];
                        if (value.indexOf("$(JDK7)") >= 0 && URLFileSystem.exists((URL)(jdk7Root = URLFactory.newDirURL((URL)(oracleViewRoot = URLFileSystem.getParent((URL)URLFileSystem.getParent((URL)(wsURL = this.workspace.getURL())))), (String)"jdk7")))) {
                            otherOptions.add(compilerOption);
                            value = value.replace("$(JDK7)", jdk7Root.getPath());
                            value = value.replace("$(SEP)", File.pathSeparator);
                            otherOptions.add(value);
                            ++x;
                            continue;
                        }
                    }
                    catch (Exception ex) {
                        FeedbackManager.reportException((Throwable)ex);
                    }
                }
            } else if ("-p".equals(compilerOption)) {
                compilerOption = "--module-path";
            } else if ("-verbose".equals(compilerOption)) {
                reallyVerboseOutput = true;
            }
            otherOptions.add(compilerOption);
        }
        if (this.additionalCompilerOptions != null) {
            Set<Map.Entry<String, String>> entrySet = this.additionalCompilerOptions.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                String option = entry.getKey();
                if ("-cp".equals(option)) {
                    option = "-classpath";
                } else if ("-profile".equals(option)) {
                    hasProfileOption = true;
                } else if ("-release".equals(option)) {
                    hasReleaseOption = true;
                } else if ("-p".equals(option)) {
                    option = "--module-path";
                } else if ("-verbose".equals(option)) {
                    reallyVerboseOutput = true;
                }
                otherOptions.add(option);
                if (entry.getValue() == null) continue;
                otherOptions.add(entry.getValue());
            }
        }
        List<String> systemPropertyOptions = this.getOptionsFromSystemProperty();
        for (String option : systemPropertyOptions) {
            if ("-profile".equals(option)) {
                hasProfileOption = true;
            } else if ("-release".equals(option)) {
                hasReleaseOption = true;
            } else if ("-cp".equals(option)) {
                option = "-classpath";
            } else if ("-p".equals(option)) {
                option = "--module-path";
            } else if ("-verbose".equals(option)) {
                reallyVerboseOutput = true;
            }
            otherOptions.add(option);
        }
        Map<String, String> defaultOptions = this.getDefaultOptions(buildSysConfig, jprj, outPath, true, sourcePath, hasProfileOption, hasReleaseOption, reallyVerboseOutput);
        PathsConfiguration pathsConfiguration = PathsConfiguration.getInstance((Project)jprj);
        if (hasProfileOption) {
            classPath = new URLPath(pathsConfiguration.getJdkClassPath());
            classPath.add(pathsConfiguration.getRunClassPath());
        } else {
            classPath = pathsConfiguration.getRunClassPath();
        }
        if (!buildSysConfig.isJDK9OrHigher()) {
            classPath.add(pathsConfiguration.getModulePath(false, false));
        }
        if (!(path = Helpers.urlPathAndDependantPathToString(reallyVerboseOutput, this._log, classPath, sources, File.pathSeparator)).isEmpty()) {
            defaultOptions.put("-classpath", Ojc.stringize(path));
        }
        if (buildSysConfig.isJDK9OrHigher() && !(modulePath = Helpers.urlPathAndDependantPathToString(reallyVerboseOutput, this._log, moduleURLPath = pathsConfiguration.getModulePath(false, false), sources, File.pathSeparator)).isEmpty()) {
            defaultOptions.put("--module-path", modulePath);
        }
        for (Object otherOption : otherOptions) {
            defaultOptions.remove(otherOption);
        }
        ArrayList<String> cmd = new ArrayList<String>();
        for (Map.Entry entry : defaultOptions.entrySet()) {
            cmd.add((String)entry.getKey());
            if (entry.getValue() == null) continue;
            cmd.add((String)entry.getValue());
        }
        StringBuilder endorsedDirsOptions = new StringBuilder();
        Object var29_35 = null;
        for (int x = 0; x < otherOptions.size(); ++x) {
            void var29_36;
            String otherOption = (String)otherOptions.get(x);
            if (otherOption.equals("-Xprint") || otherOption.equals("-XprintRounds") || otherOption.equals("-XprintProcessorInf")) {
                printMoreExtensiveOutput = true;
            } else if (otherOption.equals("-endorseddirs")) {
                if (x + 1 >= otherOptions.size()) continue;
                endorsedDirsOptions.append((String)otherOptions.get(x + 1));
                endorsedDirsOptions.append(File.pathSeparatorChar);
                ++x;
                continue;
            }
            if (otherOption.startsWith("-")) {
                cmd.add(otherOption);
            } else if ("-classpath".equals(var29_36)) {
                if (hasProfileOption && !hasReleaseOption && !isJdk9OrHigher) {
                    URLPath uRLPath = pathsConfiguration.getJdkClassPath();
                    String classPathString = Ojc.stringize(Helpers.urlPathAndDependantPathToString(reallyVerboseOutput, this._log, uRLPath, null, File.pathSeparator));
                    if (classPathString == null) {
                        classPathString = "";
                    }
                    if (classPathString.length() > 0) {
                        classPathString = classPathString + File.pathSeparator;
                    }
                    classPathString = classPathString + Ojc.stringize(otherOption);
                    cmd.add(classPathString);
                } else {
                    cmd.add(Ojc.stringize(otherOption));
                }
            } else {
                cmd.add(Ojc.stringize(otherOption));
            }
            String string = otherOption;
        }
        this.addEndorsedDirs(cmd, jprj, endorsedDirsOptions, isJdk9OrHigher, true, reallyVerboseOutput);
        this.filterOutIncompatibleOptions(isJdk9OrHigher, cmd, log, hasProfileOption, hasReleaseOption);
        try {
            void var32_52;
            if (tmpJavacFile == null) {
                tmpJavacFile = File.createTempFile("javac", null, null);
                tmpJavacFile.deleteOnExit();
            }
            try (BufferedWriter bw = null;){
                bw = new BufferedWriter(new FileWriter(tmpJavacFile), 16384);
                for (String string : cmd) {
                    bw.write(string.replace('\\', '/'));
                    bw.write("\n");
                }
                boolean isBuggedJavac = PlatformUtils.isWindows() && buildSysConfig.isJDK15();
                for (Storage stor : sources) {
                    forwardStorPath = stor.getPath().replace('\\', '/');
                    if (sourcesBeingCompiled.put(forwardStorPath, stor) != null) continue;
                    log.clear(stor);
                    String fileName = isBuggedJavac && stor.getName().equals("package-info.java") ? Ojc.stringize(stor.getPath().replace('/', '\\')) : Ojc.stringize(forwardStorPath);
                    cmd.add(fileName.replace('/', File.separatorChar));
                    bw.write(fileName);
                    bw.write("\n");
                }
            }
            StringBuilder commandLineBuf = new StringBuilder();
            commandLineBuf.append(javacString);
            commandLineBuf.append(' ');
            for (String vmCommand : javacVmCommands) {
                commandLineBuf.append(vmCommand);
                commandLineBuf.append(' ');
            }
            for (String oneCmd : cmd) {
                commandLineBuf.append(oneCmd);
                commandLineBuf.append(' ');
            }
            commandLineBuf.append('\n');
            String string = commandLineBuf.toString();
            if (System.getProperty("COMPILER.COMPILE.PRETTIFY_CMDLINE") != null) {
                String string2 = this.prettifyCommandLine(string);
            }
            JCompiler.getInstance().getOutputLog().log((Object)var32_52);
            cmd.clear();
            cmd.add(javacString);
            cmd.addAll(javacVmCommands);
            cmd.add(Ojc.stringize("@" + tmpJavacFile.getPath()));
        }
        catch (Throwable t) {
            log.error(null, 0, 0, 0, CompArb.getString(131));
            return 1;
        }
        SimpleProcess javacProcess = new SimpleProcess(cmd.toArray(new String[cmd.size()]));
        javacProcess.setAddToProcessesFolder(false);
        javacProcess.setAddToTerminateMenu(false);
        javacProcess.setLogCommandString(false);
        class JavacLogInfo
        extends AbstractLogPage {
            final StringBuffer sb;
            final String outPath;
            final SimpleProcess javacProcess;
            int logLine;
            boolean reallyVerboseOutput;
            boolean startedParsing;
            boolean errorsAtStartup;
            boolean printMoreExtensiveOutput;

            JavacLogInfo(String outp, SimpleProcess prc, boolean reallyVerboseOutput, boolean printMoreExtensiveOutput) {
                super(new ViewId("BuildSystemJavacBufferPage", "BuildSystemJavacBufferPage"), null, false);
                this.sb = new StringBuffer(1024);
                this.logLine = 0;
                this.outPath = outp;
                this.javacProcess = prc;
                this.reallyVerboseOutput = reallyVerboseOutput;
                this.startedParsing = false;
                this.errorsAtStartup = false;
                this.printMoreExtensiveOutput = printMoreExtensiveOutput;
            }

            private Storage getStorageBeingCompiled(String sourceFile) {
                Storage source = (Storage)sourcesBeingCompiled.get(sourceFile.replace('\\', '/'));
                if (source == null) {
                    source = new FileStorage(new File(sourceFile));
                }
                return source;
            }

            public void log(Object msg) {
                String line;
                this.sb.append(msg.toString());
                while ((line = this.getLine(this.sb)) != null) {
                    String sourceFileName;
                    int lineno;
                    String lowerCaseLine = line.toLowerCase();
                    this.checkForTermination();
                    if (++this.logLine == 1) {
                        if (!Ide.getEnvironOptions().getSaveBeforeCompile()) {
                            log.error(null, 0, 0, 0, CompArb.getString(75));
                        }
                        if (UnifiedBuildSystem.showCompileProgress) {
                            JCompiler.getInstance().getOutputLog().log((Object)(CompArb.getString(94) + Ojc.this.eolSeparator));
                        }
                    }
                    boolean warningAtPreciseLine = false;
                    Matcher matcher = Ojc.this.javacWarningPatternExactLineJpCn.matcher(line);
                    if (matcher.matches()) {
                        warningAtPreciseLine = true;
                    } else {
                        matcher = Ojc.this.javacWarningPatternExactLine.matcher(line);
                        if (matcher.matches()) {
                            warningAtPreciseLine = true;
                        }
                    }
                    if (warningAtPreciseLine) {
                        try {
                            lineno = Integer.parseInt(matcher.group(2));
                        }
                        catch (NumberFormatException e) {
                            lineno = 0;
                        }
                        String warnMsg = matcher.group(4);
                        Ojc.this.logMessage(log, this.getStorageBeingCompiled(matcher.group(1)), Ojc.lineColumnToPosition(lineno, 0), 0, warnMsg, false);
                        if (!this.printMoreExtensiveOutput) continue;
                        JCompiler.getInstance().getOutputLog().log((Object)(line + Ojc.this.eolSeparator));
                        continue;
                    }
                    matcher = Ojc.this.javacErrorPattern.matcher(line);
                    if (matcher.matches()) {
                        try {
                            lineno = Integer.parseInt(matcher.group(2));
                        }
                        catch (NumberFormatException e) {
                            lineno = 0;
                        }
                        String errmsg = matcher.group(3);
                        boolean isError = !errmsg.toLowerCase().startsWith(" warning:");
                        Ojc.this.logMessage(log, this.getStorageBeingCompiled(matcher.group(1)), Ojc.lineColumnToPosition(lineno, 0), 0, isError ? errmsg : errmsg.substring(9), isError);
                        if (!this.printMoreExtensiveOutput) continue;
                        JCompiler.getInstance().getOutputLog().log((Object)(line + Ojc.this.eolSeparator));
                        continue;
                    }
                    boolean warningNoLine = false;
                    matcher = Ojc.this.javacWarningPatternNoLineJpCn.matcher(line);
                    if (matcher.matches()) {
                        warningNoLine = true;
                    } else {
                        matcher = Ojc.this.javacWarningPatternNoLine.matcher(line);
                        if (matcher.matches()) {
                            warningNoLine = true;
                        }
                    }
                    if (warningNoLine) {
                        log.warning(null, 0, 0, 0, matcher.group(2));
                        if (!this.printMoreExtensiveOutput) continue;
                        JCompiler.getInstance().getOutputLog().log((Object)(line + Ojc.this.eolSeparator));
                        continue;
                    }
                    String classFileName = Ojc.this.getFileNameFromOutput(line, ".class");
                    if (classFileName != null && line.indexOf("wrote ") >= 0 && classFileName.indexOf(this.outPath + File.separator) >= 0) {
                        results.add(new FileStorage(new File(classFileName)));
                        rm.redefineClass(classFileName, this.outPath);
                        if (!UnifiedBuildSystem.showCompileProgress) continue;
                        String writeMsg = "  " + CompArb.format(111, classFileName) + Ojc.this.eolSeparator;
                        JCompiler.getInstance().getOutputLog().log((Object)writeMsg);
                        continue;
                    }
                    String string = sourceFileName = classFileName == null ? Ojc.this.getFileNameFromOutput(line, ".java") : null;
                    if (sourceFileName != null) {
                        String sourceNameForwardSlashes = sourceFileName.replace('\\', '/');
                        Storage source = (Storage)sourcesBeingCompiled.get(sourceNameForwardSlashes);
                        if (source != null) {
                            this.startedParsing = true;
                        } else {
                            source = new FileStorage(new File(sourceNameForwardSlashes));
                            sourcesBeingCompiled.put(sourceNameForwardSlashes, source);
                            log.clear(source);
                        }
                        if (!sourcesParsed.add(sourceNameForwardSlashes) || !UnifiedBuildSystem.showCompileProgress) continue;
                        String compileMsg = "  " + CompArb.format(112, sourceFileName) + Ojc.this.eolSeparator;
                        JCompiler.getInstance().getOutputLog().log((Object)compileMsg);
                        continue;
                    }
                    if (lowerCaseLine.startsWith("javac:")) {
                        log.error(null, 0, 0, 0, line);
                        JCompiler.getInstance().getOutputLog().log((Object)(line + Ojc.this.eolSeparator));
                        continue;
                    }
                    if (lowerCaseLine.startsWith("javac ")) {
                        JCompiler.getInstance().getOutputLog().log((Object)(line + Ojc.this.eolSeparator));
                        continue;
                    }
                    if (line.startsWith("[")) {
                        if (!this.reallyVerboseOutput) continue;
                        JCompiler.getInstance().getOutputLog().log((Object)(line + Ojc.this.eolSeparator));
                        continue;
                    }
                    if (!this.startedParsing && lowerCaseLine.startsWith("could ") || lowerCaseLine.startsWith("error") || lowerCaseLine.startsWith("unrecognized") || lowerCaseLine.startsWith("invalid")) {
                        if (!this.errorsAtStartup) {
                            log.error(null, 0, 0, 0, line);
                        }
                        this.errorsAtStartup = true;
                        JCompiler.getInstance().getOutputLog().log((Object)(line + Ojc.this.eolSeparator));
                        continue;
                    }
                    if (this.startedParsing && !this.printMoreExtensiveOutput) continue;
                    JCompiler.getInstance().getOutputLog().log((Object)(line + Ojc.this.eolSeparator));
                }
                this.checkForTermination();
            }

            private String getLine(StringBuffer sb) {
                char c;
                int j;
                char c2;
                int i;
                for (i = 0; i < sb.length() && ((c2 = sb.charAt(i)) == '\r' || c2 == '\n'); ++i) {
                }
                for (j = i; j < sb.length() && (c = sb.charAt(j)) != '\r' && c != '\n'; ++j) {
                }
                String result = i == j ? null : sb.substring(i, j);
                sb.delete(0, j);
                return result;
            }

            private void checkForTermination() {
                if (Thread.currentThread().isInterrupted()) {
                    new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            SimpleProcess simpleProcess = javacProcess;
                            synchronized (simpleProcess) {
                                if (javacProcess != null) {
                                    javacProcess.getRunProcess().terminate();
                                }
                            }
                        }
                    }.start();
                }
            }

            public Component getGUI() {
                return null;
            }

            protected void requestShow() {
            }

            public void show() {
            }

            public boolean isVisible() {
                return true;
            }
        }
        JavacLogInfo javacLogInfo = new JavacLogInfo(outPath, javacProcess, reallyVerboseOutput, printMoreExtensiveOutput);
        javacProcess.setLogPage((LogPage)javacLogInfo);
        int n = javacProcess.execAndWait();
        SimpleProcess jProcess = javacProcess;
        forwardStorPath = javacProcess;
        synchronized (forwardStorPath) {
            jProcess = null;
        }
        if (n < 0) {
            log.error(null, 0, 0, 0, CompArb.getString(123));
        }
        rm.redefineClassMap(jprj, log);
        this.addSMAPs(sources, outPath);
        UnifiedBuildSystem buildSystem = UnifiedBuildSystem.getInstance();
        for (Storage storage : sourcesBeingCompiled.values()) {
            buildSystem.markTranslated(this, storage);
        }
        sourcesBeingCompiled.clear();
        return n == 0 ? n : (log.nerrors() > 0 ? log.nerrors() : 1);
    }

    private String getFileNameFromOutput(String line, String extension) {
        int endIndex = line.indexOf(extension);
        if (endIndex > 0) {
            endIndex += extension.length();
            String changedLine = line.replace('\\', '/');
            int startIndex = changedLine.indexOf(47);
            if (startIndex >= 0) {
                char c;
                while (startIndex >= 0 && (c = changedLine.charAt(startIndex)) != '[' && !Character.isWhitespace(c)) {
                    --startIndex;
                }
                return line.substring(++startIndex, endIndex);
            }
        }
        return null;
    }

    private ArrayList<Storage> checkDependencies(Project jprj, JavaDependencyProvider dp, File depFile, ArrayList<Storage> sources, boolean rebuild, String sourcePath) {
        File file;
        if (depFile.exists()) {
            try {
                dp.load(depFile);
            }
            catch (IOException e) {
                dp.reinit();
            }
        }
        ArrayList fileList = new ArrayList();
        ArrayList<StorageJavaFileObject> javaFileObjects = new ArrayList<StorageJavaFileObject>();
        HashMap<File, Storage> sourceMap = new HashMap<File, Storage>(sources.size());
        BuildSystemConfiguration buildSysConfig = BuildSystemConfiguration.getInstance((PropertyStorage)jprj);
        for (Storage s : sources) {
            String p = s.getPath();
            file = new File(p);
            sourceMap.put(file, s);
            fileList.add(file);
            StorageJavaFileObject storageJavaFileObject = new StorageJavaFileObject(null, s, buildSysConfig.getCurrentEncoding());
            this.storageJavaFileObjects.put(s, storageJavaFileObject);
            javaFileObjects.add(storageJavaFileObject);
        }
        fileList = dp.updateData(fileList, javaFileObjects, rebuild, sourcePath);
        sources.clear();
        ArrayList c = rebuild ? fileList : dp.getDependants(fileList, true);
        for (Object ofile : c) {
            file = (File)ofile;
            Storage stor = (Storage)sourceMap.get(file);
            if (stor != null) {
                sources.add(stor);
                continue;
            }
            sources.add((Storage)new FileStorage(file));
        }
        return sources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int translate(Project prj, boolean rebuild, ArrayList<Storage> sources, ArrayList<Storage> results) {
        try {
            int n = this.translateImpl(prj, rebuild, sources, results);
            return n;
        }
        finally {
            this.additionalCompilerOptions = null;
            this.storageJavaFileObjects.clear();
        }
    }

    public int translateImpl(Project prj, boolean rebuild, ArrayList<Storage> sources, ArrayList<Storage> results) {
        UnifiedBuildSystem.getInstance().beginMarking(this);
        Translator.Log log = this._log;
        Project jprj = prj;
        CompilerOptionManager optionManager = CompilerOptionManager.getInstance((PropertyStorage)jprj);
        JDK jdk = JProjectLibraries.getInstance((PropertyStorage)jprj).getJDK();
        BuildSystemConfiguration buildSystemConfiguration = BuildSystemConfiguration.getInstance((PropertyStorage)jprj);
        if (optionManager.getCurrentCompiler().equalsIgnoreCase("javac")) {
            int compileResult;
            File depFile = BuildSystemUtilities.getCdiFile(prj);
            String encoding = buildSystemConfiguration.getCurrentEncoding();
            boolean cdiHashCodes = JCompilerUtils.isBuildProjectAndDependentsAfterSave();
            JavaDependencyProvider dp = new JavaDependencyProvider(encoding, cdiHashCodes);
            String source = buildSystemConfiguration.getSource();
            if (!source.equals("Default")) {
                dp.setSourceJdk(source);
            }
            Assert.println((String)("**** rebuild value is " + rebuild));
            String sourcePath = Helpers.urlPathToString(false, log, PathsConfiguration.getInstance((Project)jprj).getProjectSourcePath(), File.pathSeparator);
            sourcePath = sourcePath.trim();
            sources = this.checkDependencies(jprj, dp, depFile, sources, rebuild, sourcePath);
            if (sources.size() <= 0) {
                JCompiler.getInstance().getOutputLog().log((Object)(CompArb.getString(45) + "\n"));
                return 0;
            }
            int errCnt = log.nerrors();
            boolean useInProcess = false;
            File toolsJarWithJavac = null;
            if (!buildSystemConfiguration.getOutOfProcess()) {
                boolean isJdk9OrAfter;
                useInProcess = this.canUseInProcessJavac(jprj);
                VersionNumber versionNumber = jdk != null ? jdk.getJavaVersion() : null;
                boolean bl = isJdk9OrAfter = versionNumber != null && versionNumber.isAfter(new VersionNumber("1.9"), true);
                if (!useInProcess && !isJdk9OrAfter) {
                    toolsJarWithJavac = this.getProjectsToolJarWithJavac(jdk);
                    if (toolsJarWithJavac != null) {
                        useInProcess = this.canUseProjectsJavac(jdk, toolsJarWithJavac);
                    } else if (!PlatformUtils.isMac() || versionNumber != null && versionNumber.isAfter(new VersionNumber("1.7"), true)) {
                        log.warning(null, 0, 0, 0, CompArb.getString(110));
                    } else {
                        log.warning(null, 0, 0, 0, CompArb.getString(129));
                    }
                }
            }
            if ((compileResult = !useInProcess ? this.runJavacOutOfProcess(jprj, optionManager, sources, results, log, sourcePath) : this.runJavacInProcess(jprj, toolsJarWithJavac, optionManager, sources, results, log, sourcePath)) == 0) {
                if (errCnt == log.nerrors()) {
                    try {
                        File dir = depFile.getParentFile();
                        if (!dir.exists()) {
                            dir.mkdirs();
                        }
                        dp.save(depFile);
                    }
                    catch (IOException e) {
                        new Exception("Dependency provider error, " + depFile.getPath() + " may be readonly").printStackTrace();
                    }
                }
                return 0;
            }
            if (compileResult != 0 && log.nerrors() == 0) {
                log.error(null, 0, 0, 0, CompArb.getString(155));
            }
            return 1;
        }
        log.error(null, 0, 0, 0, CompArb.getString(117));
        return log.nerrors();
    }

    private boolean canUseInProcessJavac(Project jprj) {
        JDK jdk = JProjectLibraries.getInstance((PropertyStorage)jprj).getJDK();
        if (jdk == JLibraryManager.getDefaultJDK()) {
            return ToolProvider.getSystemJavaCompiler() != null;
        }
        return false;
    }

    private File getProjectsToolJarWithJavac(JDK jdk) {
        URL url;
        if (jdk != null && (url = jdk.getSDKBinDir()) != null) {
            String path = URLFileSystem.getPath((URL)url);
            String[] relativePaths = new String[]{"../lib/tools.jar", "../../Classes/classes.jar"};
            for (int x = 0; x < 2; ++x) {
                File jarWithJavac = new File(path, relativePaths[x]);
                try {
                    jarWithJavac = jarWithJavac.getCanonicalFile();
                    if (jarWithJavac.exists()) {
                        return jarWithJavac;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!PlatformUtils.isMac()) break;
            }
        }
        return null;
    }

    private boolean canUseProjectsJavac(JDK jdk, File toolsJarWithJavac) {
        JdkVersion defaultJdkVersion;
        JdkVersion projectJdkVersion;
        VersionNumber defaultJdkVersionNumber;
        VersionNumber projectJdkVersionNumber = jdk == null ? null : jdk.getJavaVersion();
        JDK defaultJdk = JLibraryManager.getDefaultJDK();
        VersionNumber versionNumber = defaultJdkVersionNumber = defaultJdk == null ? null : defaultJdk.getJavaVersion();
        if (projectJdkVersionNumber != null && defaultJdkVersionNumber != null ? (projectJdkVersion = JdkVersion.getJdkVersion((String)projectJdkVersionNumber.toString())).isLowerOrEqualVersion(defaultJdkVersion = JdkVersion.getJdkVersion((String)defaultJdkVersionNumber.toString())) : JDevJavaCompiler.canCompileInProcess((File)toolsJarWithJavac)) {
            return true;
        }
        JCompiler.getInstance().getOutputLog().log((Object)(CompArb.getString(121) + this.eolSeparator));
        return false;
    }

    private String prettifyCommandLine(String cmdLine) {
        String[] tokens = this.tokenizeCommandLine(cmdLine);
        return JDevJavaCompiler.prettifyCommandLine(Arrays.asList(tokens));
    }

    private String[] tokenizeCommandLine(String cmdLine) {
        StringBuilder buf = new StringBuilder();
        ArrayList<String> tokens = new ArrayList<String>();
        int len = cmdLine.length();
        boolean inString = false;
        for (int pointer = 0; pointer < len; ++pointer) {
            char c = cmdLine.charAt(pointer);
            if (c == '\"') {
                if (!inString) {
                    if (buf.length() > 0) {
                        tokens.add(buf.toString());
                        buf.setLength(0);
                    }
                    buf.append(c);
                    inString = true;
                    continue;
                }
                buf.append(c);
                tokens.add(buf.toString());
                buf.setLength(0);
                inString = false;
                continue;
            }
            if (inString) {
                if (c == '\\' && pointer < len - 1) {
                    buf.append(c);
                    c = cmdLine.charAt(++pointer);
                }
                buf.append(c);
                continue;
            }
            if (!Character.isWhitespace(c)) {
                buf.append(c);
                continue;
            }
            if (buf.length() <= 0) continue;
            tokens.add(buf.toString());
            buf.setLength(0);
        }
        if (buf.length() > 0) {
            tokens.add(buf.toString());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private String replaceEolSeparator(String str, char newChar) {
        StringBuilder buf = new StringBuilder();
        int len = str.length();
        boolean doReplacement = true;
        for (int index = 0; index < len; ++index) {
            char c = str.charAt(index);
            if (c != '\n' && c != '\r') {
                buf.append(c);
                doReplacement = true;
                continue;
            }
            if (!doReplacement) continue;
            buf.append(newChar);
            doReplacement = false;
        }
        return buf.toString();
    }
}

