/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.cssbeans;

import com.ibm.icu.util.ULocale;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.IlvResourceUtil;
import ilog.views.util.css.IlvCSSModel;
import ilog.views.util.styling.IlvCSSFunction;
import ilog.views.util.styling.runtime.IlvExpressionEvaluation;
import java.util.ResourceBundle;

public class FormatFunctions
extends IlvCSSFunction {
    static ResourceBundle a() {
        return IlvResourceUtil.getBundle("ilog.views.util.css.css", IlvLocaleUtil.getCurrentLocale(), IlvCSSModel.class.getClassLoader());
    }

    @Override
    public String getName() {
        return "customFormat";
    }

    @Override
    public String getShortDescription() {
        return FormatFunctions.a().getString("IlvCSSBeans.function.shortDescr.customFormat");
    }

    @Override
    public float getImportance() {
        return 0.62f;
    }

    @Override
    public String getDelimiters() {
        return ",";
    }

    @Override
    public boolean returnDelimitersAsToken() {
        return false;
    }

    @Override
    public Object call(Object[] objectArray, Class clazz, IlvCSSModel ilvCSSModel, Object object, Object object2, Object object3) {
        int n = objectArray.length;
        if (n > 1) {
            Object[] objectArray2 = new Object[n - 1];
            System.arraycopy(objectArray, 1, objectArray2, 0, n - 1);
            return IlvExpressionEvaluation.customFormat(objectArray[0], objectArray2);
        }
        throw new IllegalArgumentException("too few arguments");
    }

    public static class MessageFormatFunction
    extends FormatFunctions {
        @Override
        public Object call(Object[] objectArray, Class clazz, IlvCSSModel ilvCSSModel, Object object, Object object2, Object object3) {
            if (objectArray.length == 0) {
                throw new IllegalArgumentException("no parameter");
            }
            Object[] objectArray2 = new Object[objectArray.length - 1];
            System.arraycopy(objectArray, 1, objectArray2, 0, objectArray2.length);
            ULocale uLocale = ilvCSSModel.getULocale(object);
            if (uLocale == null) {
                uLocale = IlvLocaleUtil.getCurrentULocale();
            }
            return IlvExpressionEvaluation.messageFormat(objectArray[0], objectArray2, uLocale);
        }

        @Override
        public String getName() {
            return "messageFormat";
        }

        @Override
        public String getShortDescription() {
            return FormatFunctions.a().getString("IlvCSSBeans.function.shortDescr.messageFormat");
        }
    }

    public static class DecimalFormatFunction
    extends FormatFunctions {
        @Override
        public Object call(Object[] objectArray, Class clazz, IlvCSSModel ilvCSSModel, Object object, Object object2, Object object3) {
            if (objectArray.length == 2 || objectArray.length == 3) {
                ULocale uLocale = ilvCSSModel.getULocale(object);
                if (uLocale == null) {
                    uLocale = IlvLocaleUtil.getCurrentULocale();
                }
                String string = objectArray.length > 2 ? IlvExpressionEvaluation.convertToString(objectArray[2]) : null;
                return IlvExpressionEvaluation.decimalFormat(objectArray[0], objectArray[1], uLocale, string);
            }
            throw new IllegalArgumentException("syntax: \"@|decimalFormat(<pattern>,<java.lang.Number>[,<numberSystem>]);\" expected");
        }

        @Override
        public String getName() {
            return "decimalFormat";
        }

        @Override
        public String getShortDescription() {
            return FormatFunctions.a().getString("IlvCSSBeans.function.shortDescr.decimalFormat");
        }
    }

    public static class SimpleDateFormatFunction
    extends FormatFunctions {
        @Override
        public Object call(Object[] objectArray, Class clazz, IlvCSSModel ilvCSSModel, Object object, Object object2, Object object3) {
            if (objectArray.length >= 2 && objectArray.length <= 3) {
                Object object4 = objectArray.length >= 3 ? objectArray[2] : null;
                ULocale uLocale = ilvCSSModel.getULocale(object);
                if (uLocale == null) {
                    uLocale = IlvLocaleUtil.getCurrentULocale();
                }
                return IlvExpressionEvaluation.simpleDateFormat(objectArray[0], objectArray[1], object4, uLocale);
            }
            throw new IllegalArgumentException("syntax: \"@|simpleDateFormat(<pattern>,<java.util.Date>);\" expected");
        }

        @Override
        public String getName() {
            return "simpleDateFormat";
        }

        @Override
        public String getShortDescription() {
            return FormatFunctions.a().getString("IlvCSSBeans.function.shortDescr.simpleDateFormat");
        }
    }
}

