/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.print;

import ilog.views.IlvManagerView;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.print.IlvManagerPageBreakPreview;
import ilog.views.print.IlvMessagesSupport;
import ilog.views.print.IlvPrintableManagerArea;
import ilog.views.util.print.IlvFlow;
import ilog.views.util.print.IlvFooter;
import ilog.views.util.print.IlvPage;
import ilog.views.util.print.IlvPrintableDocument;
import ilog.views.util.print.IlvPrintableObject;
import ilog.views.util.print.IlvUnit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;

public class IlvManagerPrintableDocument
extends IlvPrintableDocument {
    private final IlvMessagesSupport a = new IlvMessagesSupport();
    private IlvManagerView b;
    private boolean c;
    private double d;
    private double e;
    private IlvTransformer f;
    private boolean g;
    private IlvRect h;
    private float i = 0.0f;
    private float j = 0.0f;
    private float k = 0.0f;
    private float l = 0.0f;
    private int m = 1;
    private int n = 1;
    private boolean o;
    private IlvManagerPageBreakPreview p;
    private IlvRect q;

    public IlvManagerPrintableDocument(String string, IlvManagerView ilvManagerView, PageFormat pageFormat) {
        super(string, pageFormat);
        this.a(ilvManagerView);
    }

    public IlvManagerPrintableDocument(String string, IlvManagerView ilvManagerView, int n, Paper paper) {
        super(string, n, paper);
        this.a(ilvManagerView);
    }

    public IlvManagerPrintableDocument(String string, IlvManagerView ilvManagerView, int n) {
        super(string, n);
        this.a(ilvManagerView);
    }

    public IlvManagerPrintableDocument(String string, IlvManagerView ilvManagerView) {
        super(string);
        this.a(ilvManagerView);
    }

    private void a(IlvManagerView ilvManagerView) {
        if (ilvManagerView == null) {
            throw new IllegalArgumentException("The view must not be null");
        }
        this.b = ilvManagerView;
        this.f = null;
        this.c = true;
        this.d = Math.min(ilvManagerView.getMaxZoomXFactor(), ilvManagerView.getMaxZoomYFactor());
        this.e = Math.max(ilvManagerView.getMinZoomXFactor(), ilvManagerView.getMinZoomYFactor());
        this.h = null;
        this.f();
        this.g();
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                block3: {
                    block2: {
                        String string = propertyChangeEvent.getPropertyName();
                        if (string.equals("header")) break block2;
                        if (string.equals("footer")) break block2;
                        if (string.equals("orientation")) break block2;
                        if (string.equals("paperFormat")) break block2;
                        if (string.equals("pageFormat")) break block2;
                        if (string.equals("columnCount")) break block2;
                        if (string.equals("rowCount")) break block2;
                        if (string.equals("printArea")) break block2;
                        if (string.equals("pageOrder")) break block2;
                        if (string.equals("zoomTransformer")) break block2;
                        if (string.equals("automaticZoomLevel")) break block2;
                        if (string.equals("maximumZoomLevel")) break block2;
                        if (string.equals("minimumZoomLevel")) break block2;
                        if (!string.equals("zoomLevel")) break block3;
                    }
                    IlvManagerPrintableDocument.this.invalidatePages();
                }
            }
        });
    }

    private void f() {
        this.setFooter(new IlvFooter(null, this.a.getMessage("IlvManagerPrintableDocument.PageXOfY"), null, this.getView().getULocale()));
    }

    private void g() {
        this.n = 1;
        this.m = 1;
    }

    private double h() {
        return this.getImageableBounds().getWidthAs(IlvUnit.POINTS);
    }

    private double i() {
        return this.getImageableBounds().getHeightAs(IlvUnit.POINTS);
    }

    private double j() {
        return this.getImageableBounds().getXAs(IlvUnit.POINTS);
    }

    private double k() {
        return this.getImageableBounds().getYAs(IlvUnit.POINTS);
    }

    public IlvManagerView getView() {
        return this.b;
    }

    public boolean isAutomaticZoomLevel() {
        return this.c;
    }

    public void setAutomaticZoomLevel(boolean bl) {
        if (bl != this.c) {
            Boolean bl2 = this.c;
            Boolean bl3 = bl;
            this.c = bl;
            this.firePropertyChange("automaticZoomLevel", bl2, bl3);
        }
    }

    public double getMaximumZoomLevel() {
        return this.d;
    }

    public void setMaximumZoomLevel(double d) {
        if (d != this.d) {
            Double d2 = new Double(this.d);
            Double d3 = new Double(d);
            this.d = d;
            this.firePropertyChange("maximumZoomLevel", d2, d3);
        }
    }

    public double getMinimumZoomLevel() {
        return this.e;
    }

    public void setMinimumZoomLevel(double d) {
        if (d != this.d) {
            Double d2 = new Double(this.e);
            Double d3 = new Double(d);
            this.e = d;
            this.firePropertyChange("minimumZoomLevel", d2, d3);
        }
    }

    public IlvTransformer getZoomTransformer() {
        if (this.f == null) {
            return null;
        }
        return new IlvTransformer(this.f);
    }

    public void setZoomTransformer(IlvTransformer ilvTransformer) {
        if (!(this.f == ilvTransformer || ilvTransformer != null && ilvTransformer.equals(this.f))) {
            IlvTransformer ilvTransformer2 = this.f;
            this.f = ilvTransformer;
            this.firePropertyChange("zoomTransformer", ilvTransformer2, ilvTransformer);
        }
    }

    private IlvTransformer l() {
        IlvTransformer ilvTransformer = this.f == null ? this.getView().getTransformer() : this.f;
        double d = ilvTransformer.zoomFactor();
        if (d < this.getMinimumZoomLevel()) {
            return new IlvTransformer(this.getMinimumZoomLevel(), 0.0, 0.0, this.getMinimumZoomLevel(), 0.0, 0.0);
        }
        if (d > this.getMaximumZoomLevel()) {
            return new IlvTransformer(this.getMaximumZoomLevel(), 0.0, 0.0, this.getMaximumZoomLevel(), 0.0, 0.0);
        }
        return ilvTransformer;
    }

    public double getZoomLevel() {
        return this.l().zoomFactor();
    }

    public void setZoomLevel(double d) {
        if (d != this.getZoomLevel()) {
            Double d2 = new Double(this.getZoomLevel());
            this.setZoomTransformer(new IlvTransformer(d, 0.0, 0.0, d, 0.0, 0.0));
            Double d3 = new Double(this.getZoomLevel());
            if (d2.doubleValue() != d3.doubleValue()) {
                this.firePropertyChange("zoomLevel", d2, d3);
            }
        }
    }

    public boolean isZoomLevelModificationEnabled() {
        return this.g;
    }

    public void setZoomLevelModificationEnabled(boolean bl) {
        this.g = bl;
    }

    public boolean isPrintingAllManagerBBox() {
        return this.h == null;
    }

    public IlvRect getTotalManagerPrintableArea() {
        IlvTransformer ilvTransformer = this.l();
        IlvRect ilvRect = this.b.computeBBox(ilvTransformer);
        ilvTransformer.boundingBox(ilvRect, true);
        return ilvRect;
    }

    public IlvRect getPrintArea() {
        if (this.h == null) {
            return this.getTotalManagerPrintableArea();
        }
        return new IlvRect(this.h);
    }

    public void setPrintArea(IlvRect ilvRect) {
        if (ilvRect == null && this.h == null) {
            return;
        }
        if (this.h == null || !this.h.equals(ilvRect)) {
            IlvRect ilvRect2 = this.h;
            IlvRect ilvRect3 = this.h = ilvRect == null ? null : new IlvRect(ilvRect);
            if (this.o) {
                this.a(this.h != null);
            } else if (this.h == null) {
                this.a(false);
            }
            this.firePropertyChange("printArea", ilvRect2, this.h);
        }
    }

    private boolean m() {
        IlvRect ilvRect = this.getPrintArea();
        return (double)ilvRect.height * this.h() > (double)ilvRect.width * this.i();
    }

    private float n() {
        return this.i;
    }

    private float o() {
        return this.j;
    }

    private float p() {
        return this.k;
    }

    private float q() {
        return this.l;
    }

    int d() {
        return this.m;
    }

    @Override
    public int getColumnCount() {
        if (this.n == 0) {
            return this.m;
        }
        if (this.m == 0 || this.m()) {
            IlvRect ilvRect = this.getPrintArea();
            double d = this.h();
            int n = (int)Math.ceil(((double)ilvRect.width * this.s() / (double)ilvRect.height + (double)this.p() + (double)this.q()) / d);
            return n;
        }
        return this.m;
    }

    @Override
    public void setColumnCount(int n) {
        if (n != this.m) {
            if (n == 0 && this.n == 0) {
                this.n = 1;
            }
            int n2 = this.m;
            this.m = n;
            this.firePropertyChange("columnCount", new Integer(n2), new Integer(this.m));
        }
    }

    int e() {
        return this.n;
    }

    public int getRowCount() {
        if (this.m == 0) {
            return this.n;
        }
        if (this.n == 0 || !this.m()) {
            IlvRect ilvRect = this.getPrintArea();
            double d = this.i();
            int n = (int)Math.ceil(((double)ilvRect.height * this.r() / (double)ilvRect.width + (double)this.n() + (double)this.o()) / d);
            return n;
        }
        return this.n;
    }

    public void setRowCount(int n) {
        if (n != this.n) {
            if (n == 0 && this.m == 0) {
                this.m = 1;
            }
            int n2 = this.n;
            this.n = n;
            this.firePropertyChange("rowCount", new Integer(n2), new Integer(this.n));
        }
    }

    private double r() {
        double d = this.h();
        return (double)this.getColumnCount() * d - (double)this.p() - (double)this.q();
    }

    private double s() {
        double d = this.i();
        return (double)this.getRowCount() * d - (double)this.n() - (double)this.o();
    }

    public void setPageBreakPreviewVisible(boolean bl) {
        this.o = bl;
        this.a(bl);
    }

    void a(boolean bl) {
        if (!bl) {
            if (this.p != null) {
                this.b.removeViewDecoration(this.p);
            }
        } else if (this.h != null) {
            if (this.p == null) {
                this.p = this.createPageBreakPreview();
            }
            int n = this.b.getViewDecorationCount();
            boolean bl2 = false;
            for (int i = 0; i < n; ++i) {
                if (this.b.getViewDecoration(i) != this.p) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                this.b.addViewDecoration(this.p);
            }
        }
    }

    protected IlvManagerPageBreakPreview createPageBreakPreview() {
        return new IlvManagerPageBreakPreview(this);
    }

    @Override
    public IlvFlow getFlow() {
        throw new IllegalArgumentException("cannot use the flow of this document.");
    }

    @Override
    protected void prepareDocument() {
        Cloneable cloneable;
        super.prepareDocument();
        boolean bl = false;
        if (this.h == null) {
            cloneable = this.getPrintArea();
            if (this.q == null || !this.q.equals(cloneable)) {
                bl = true;
            }
        }
        if (!((IlvTransformer)(cloneable = this.b.getTransformer())).equals(this.l())) {
            bl = true;
        }
        if (bl) {
            this.invalidatePages();
        }
    }

    @Override
    protected IlvPage[] createPages() {
        double d = this.j();
        double d2 = this.k();
        double d3 = this.h();
        double d4 = this.i();
        int n = this.getRowCount();
        int n2 = this.getColumnCount();
        boolean bl = this.t();
        IlvRect ilvRect = this.getPrintArea();
        this.q = new IlvRect(ilvRect);
        Vector<IlvPage> vector = new Vector<IlvPage>();
        double d5 = ilvRect.y;
        for (int i = 0; i < n; ++i) {
            double d6 = ilvRect.x;
            double d7 = 0.0;
            for (int j = 0; j < n2; ++j) {
                double d8;
                IlvPage ilvPage = new IlvPage();
                double d9 = 0.0;
                double d10 = 0.0;
                if (bl && i == 0) {
                    d9 = (this.s() - (double)ilvRect.height * this.r() / (double)ilvRect.width) / 2.0;
                } else if (!bl && j == 0) {
                    d10 = (this.r() - (double)ilvRect.width * this.s() / (double)ilvRect.height) / 2.0;
                }
                double d11 = d10 + d + (double)(j == 0 ? this.p() : 0.0f);
                double d12 = d9 + d2 + (double)(i == 0 ? this.n() : 0.0f);
                double d13 = d3;
                if (j == 0) {
                    d13 -= (double)this.p() + d10;
                }
                if (j + 1 == n2) {
                    d13 -= (double)this.q();
                }
                double d14 = d4;
                if (i == 0) {
                    d14 -= (double)this.n() + d9;
                }
                if (i + 1 == n) {
                    d14 -= (double)this.o();
                }
                if (bl) {
                    d8 = d13 / this.r() * (double)ilvRect.width;
                    d7 = d8 * (d14 / d13);
                    if ((float)(d5 + d7) > ilvRect.y + ilvRect.height) {
                        d7 = (double)(ilvRect.y + ilvRect.height) - d5;
                        d14 = d7 * d13 / d8;
                    }
                } else {
                    d7 = d14 / this.s() * (double)ilvRect.height;
                    d8 = d7 * (d13 / d14);
                    if ((float)(d6 + d8) > ilvRect.x + ilvRect.width) {
                        d8 = (double)(ilvRect.x + ilvRect.width) - d6;
                        d13 = d8 * d14 / d7;
                    }
                }
                IlvRect ilvRect2 = new IlvRect((float)d6, (float)d5, (float)d8, (float)d7);
                d6 += d8;
                IlvUnit.Rectangle rectangle = new IlvUnit.Rectangle(d11, d12, d13, d14, IlvUnit.POINTS);
                IlvPrintableManagerArea ilvPrintableManagerArea = this.createPrintableManagerArea(rectangle, ilvRect2);
                ilvPage.addPrintableObject(ilvPrintableManagerArea);
                vector.add(ilvPage);
            }
            d5 += d7;
        }
        IlvPage[] ilvPageArray = new IlvPage[vector.size()];
        int n3 = 0;
        if (this.getPageOrder() == 0) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    ilvPageArray[n3++] = (IlvPage)vector.elementAt(j * n2 + i);
                }
            }
        } else {
            vector.toArray(ilvPageArray);
        }
        return ilvPageArray;
    }

    private boolean t() {
        if (this.n == 0) {
            return true;
        }
        if (this.m == 0) {
            return false;
        }
        return !this.m();
    }

    protected IlvPrintableManagerArea createPrintableManagerArea(IlvUnit.Rectangle rectangle, IlvRect ilvRect) {
        IlvTransformer ilvTransformer = this.l();
        if (this.isAutomaticZoomLevel()) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle.getXAs(IlvUnit.POINTS), rectangle.getYAs(IlvUnit.POINTS), rectangle.getWidthAs(IlvUnit.POINTS), rectangle.getHeightAs(IlvUnit.POINTS));
            AffineTransform affineTransform = IlvPrintableManagerArea.getPrintTransformer(double_, ilvRect, null);
            ilvTransformer = new IlvTransformer(affineTransform);
        }
        return new IlvPrintableManagerArea(this.getView(), rectangle, ilvRect, ilvTransformer);
    }

    private IlvPrintableManagerArea a(IlvPage ilvPage) {
        for (int i = 0; i < ilvPage.getPrintableCount(); ++i) {
            IlvPrintableObject ilvPrintableObject = ilvPage.getPrintableObject(i);
            if (!(ilvPrintableObject instanceof IlvPrintableManagerArea)) continue;
            return (IlvPrintableManagerArea)ilvPrintableObject;
        }
        return null;
    }

    public IlvRect getPrintArea(int n) {
        IlvPage ilvPage = this.getPage(n);
        IlvPrintableManagerArea ilvPrintableManagerArea = this.a(ilvPage);
        return ilvPrintableManagerArea.getPrintArea();
    }
}

