/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.svg.batik;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public class DVTSVGLoaderUtils {
    public static GraphicsNode getRootNode(String url) throws IOException {
        SAXSVGDocumentFactory svgDocFactory = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());
        SVGDocument svgDoc = (SVGDocument)svgDocFactory.createDocument(url);
        BridgeContext bridgeContext = new BridgeContext((UserAgent)new UserAgentAdapter());
        GVTBuilder builder = new GVTBuilder();
        return builder.build(bridgeContext, (Document)svgDoc);
    }

    public static Rectangle2D getSVGDimensions(String url) throws IOException {
        GraphicsNode rootSvgNode = DVTSVGLoaderUtils.getRootNode(url);
        return rootSvgNode.getPrimitiveBounds();
    }

    public static Image loadSVGImage(String url) throws IOException {
        GraphicsNode rootSvgNode = DVTSVGLoaderUtils.getRootNode(url);
        Rectangle2D dims = rootSvgNode.getPrimitiveBounds();
        BufferedImage image = new BufferedImage((int)Math.round(dims.getWidth()), (int)Math.round(dims.getHeight()), 2);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        rootSvgNode.paint(g2d);
        g2d.dispose();
        return image;
    }

    public static Image getImage(String url) throws IOException {
        Image image = null;
        if (url != null && (image = ImageIO.read(new URL(url))) == null) {
            image = DVTSVGLoaderUtils.loadSVGImage(url.toString());
        }
        return image;
    }
}

