/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.legend.shared;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dss.legend.shared.CompositeLegendItem;
import oracle.dss.legend.shared.LegendItem;
import oracle.dss.legend.shared.LegendSeparator;
import oracle.dss.legend.shared.text.LegendTitle;
import oracle.dss.legend.shared.visit.LegendVisitContext;
import oracle.dss.legend.shared.visit.LegendVisitor;
import oracle.dss.util.shapes.DrawableObject;
import oracle.dss.util.shapes.Fill;
import oracle.dss.util.shapes.FillColor;
import oracle.dss.util.shapes.Stroke;

public class Legend
extends CompositeLegendItem<LegendItem> {
    private LegendTitle m_title;
    private float borderWidth = 1.0f;

    @Override
    public void internalAccept(LegendVisitor visitor, LegendVisitContext context) {
        visitor.visit(this, context);
        if (this.m_title != null) {
            this.m_title.accept(visitor, context);
        }
        super.internalAccept(visitor, context);
    }

    public LegendTitle getTitle() {
        return this.m_title;
    }

    public void setTitle(LegendTitle title) {
        this.m_title = title;
    }

    @Override
    public void calc() {
        int calculatedWidth = this.calcLayout();
        this.m_width = Math.min(calculatedWidth, this.m_width);
    }

    @Override
    public void calcFinal() {
        int allocWidth = this.m_width - 12;
        int titleHeight = 0;
        if (this.m_title != null) {
            titleHeight = this.m_title.getHeight();
        }
        int runningHeight = titleHeight;
        boolean separatorFound = false;
        for (int i = 0; i < this.m_items.size(); ++i) {
            LegendItem item = (LegendItem)this.m_items.get(i);
            if (item instanceof LegendSeparator) {
                separatorFound = true;
                continue;
            }
            if (i > 0 || i == 0 && this.m_title != null) {
                if (separatorFound) {
                    runningHeight += 6;
                    separatorFound = false;
                } else {
                    runningHeight += 2;
                }
            }
            item.setWidth(allocWidth);
            item.calcFinal();
            int itemHeight = item.getHeight();
            runningHeight += itemHeight;
        }
        this.m_height = runningHeight + 12;
    }

    @Override
    public List<DrawableObject> render() {
        ArrayList<DrawableObject> section = new ArrayList<DrawableObject>();
        oracle.dss.util.shapes.Rectangle box = new oracle.dss.util.shapes.Rectangle(this.m_x, this.m_y, (float)this.m_width - 2.0f * this.borderWidth, (float)this.m_height - 2.0f * this.borderWidth);
        box.setFill(this.getInstanceFill());
        box.setStroke(this.getInstanceBorder());
        section.add(box);
        boolean isBidi = this.m_settings.isBidi();
        int curr_x = (int)((float)this.m_x - this.borderWidth);
        int curr_y = (int)((float)this.m_y - this.borderWidth);
        int titleHeight = 0;
        curr_x = isBidi ? (curr_x += this.m_width - 6) : (curr_x += 6);
        curr_y += 6;
        int separatorWidth = (int)((float)this.m_width - 2.0f * this.borderWidth);
        if (this.m_title != null) {
            titleHeight = this.m_title.getHeight();
            int titleX = curr_x;
            if (isBidi) {
                this.m_title.setPosition(titleX - this.m_title.getWidth(), curr_y);
            } else {
                this.m_title.setPosition(titleX, curr_y);
            }
            curr_y += titleHeight;
            section.addAll(this.m_title.render());
        }
        boolean separatorFound = false;
        for (int i = 0; i < this.m_items.size(); ++i) {
            LegendItem item = (LegendItem)this.m_items.get(i);
            if (item instanceof LegendSeparator) {
                LegendSeparator separator = (LegendSeparator)item;
                separator.setPosition(this.m_x + 1, curr_y + 3);
                separator.setWidth(separatorWidth);
                section.addAll(separator.render());
                separatorFound = true;
                continue;
            }
            if (i > 0 || i == 0 && this.m_title != null) {
                if (separatorFound) {
                    curr_y += 6;
                    separatorFound = false;
                } else {
                    curr_y += 2;
                }
            }
            item.setWidth(this.m_width - 12);
            if (isBidi) {
                item.setPosition(curr_x - item.getWidth(), curr_y);
            } else {
                item.setPosition(curr_x, curr_y);
            }
            List<DrawableObject> drawables = item.render();
            curr_y += item.getHeight();
            section.addAll(drawables);
        }
        return section;
    }

    public void setBounds(Rectangle bounds) {
        this.m_x = bounds.x;
        this.m_y = bounds.y;
        this.m_width = bounds.width;
        this.m_height = bounds.height;
    }

    private int calcLayout() {
        HashMap<Integer, Integer> columnWidths = new HashMap<Integer, Integer>();
        int curr_h = 0;
        int titleHeight = 0;
        int titleWidth = 0;
        int allocWidth = this.m_width - 12;
        if (this.m_title != null) {
            this.m_title.setWidth(allocWidth);
            this.m_title.calc();
            titleHeight = this.m_title.getHeight();
            titleWidth = this.m_title.getWidth();
            curr_h = titleHeight;
        }
        for (int i = 0; i < this.m_items.size(); ++i) {
            LegendItem item = (LegendItem)this.m_items.get(i);
            if (item instanceof LegendSeparator) {
                item.calc();
                continue;
            }
            item.setWidth(allocWidth);
            item.setHeight(this.m_height - titleHeight);
            item.calc();
        }
        int currentColumn = 0;
        int currentColumnWidth = 0;
        for (LegendItem item : this.m_items) {
            if (item instanceof LegendSeparator) continue;
            int itemWidth = item.getWidth();
            currentColumnWidth = Math.max(currentColumnWidth, itemWidth);
            columnWidths.put(currentColumn, currentColumnWidth);
        }
        int columnWidthSum = 0;
        for (Integer width : columnWidths.values()) {
            columnWidthSum += width.intValue();
        }
        return Math.max(titleWidth, columnWidthSum) + 12;
    }

    @Override
    public Fill getDefaultFill() {
        return new FillColor(this.m_settings.getStyles().getBackgroundColor());
    }

    @Override
    public Stroke getDefaultBorder() {
        Stroke border = new Stroke();
        border.setColor(this.m_settings.getStyles().getBorderColor());
        border.setWidth(this.borderWidth);
        return border;
    }
}

