/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.DataFormat;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.JChart_2D_BLA;
import oracle.dss.graph.pfj.JChart_2D_BoxPlot;
import oracle.dss.graph.pfj.JChart_2D_Circular;
import oracle.dss.graph.pfj.JChart_2D_Funnel;
import oracle.dss.graph.pfj.JChart_2D_Hilo;
import oracle.dss.graph.pfj.JChart_2D_Hist;
import oracle.dss.graph.pfj.JChart_2D_Pareto;
import oracle.dss.graph.pfj.JChart_2D_Pie;
import oracle.dss.graph.pfj.JChart_2D_PieBar;
import oracle.dss.graph.pfj.JChart_2D_Polar;
import oracle.dss.graph.pfj.JChart_2D_Radar;
import oracle.dss.graph.pfj.JChart_2D_Scat;
import oracle.dss.graph.pfj.JChart_2D_Spec;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.JChart_3D;
import oracle.dss.graph.pfj.JChart_3D_Surf;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.TDGMouseState;
import oracle.dss.graph.pfj.TDGNumberFormat;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.ObjectString;
import oracle.dss.graph.pfj.utilities.TDGTimer;
import oracle.javatools.annotations.Concealed;

public class ToolTips {
    static final int DATA_VALUE_ABS = 3;
    static final int DATA_VALUE_FORMATTED = 4;
    static final int DATA_VALUE_OPEN = 5;
    static final int DATA_VALUE_HI = 6;
    static final int DATA_VALUE_LOW = 7;
    static final int DATA_VALUE_CLOSE = 8;
    static final int DATA_VALUE_VOLUME = 9;
    static final int DATA_VALUE_X = 10;
    static final int DATA_VALUE_Y = 11;
    static final int DATA_VALUE_Z = 12;
    public static final String RETURN_MACRO = "[R]";
    public static final String OBJECT_NAME_MACRO = "[ON]";
    public static final String OBJECT_DESCRIPTION_MACRO = "[OD]";
    public static final String OBJECT_ID_MACRO = "[OID]";
    public static final String OBJECT_INSTANCE_MACRO = "[OIN]";
    public static final String SERIES_LABEL_MACRO = "[SL]";
    public static final String GROUP_LABEL_MACRO = "[GL]";
    public static final String CUMULATIVE_STACKED_VALUE_MACRO = "[CUMSTKV]";
    public static final String CUMULATIVE_PERCENTAGE_VALUE_MACRO = "[CUMPCTV]";
    public static final String PIE_PERCENTAGE_VALUE_MACRO = "[PIEPCTV]";
    public static final String RING_TOTAL_VALUE_MACRO = "[RINGTOTV]";
    public static final String PIEBAR_TOTAL_VALUE_MACRO = "[PIETOTV]";
    public static final String PERCENTAGE_VALUE_MACRO = "[PCTV]";
    public static final String HILO_HIGH_VALUE_MACRO = "[HV]";
    public static final String HILO_LOW_VALUE_MACRO = "[LV]";
    public static final String HILO_OPEN_VALUE_MACRO = "[OV]";
    public static final String HILO_CLOSE_VALUE_MACRO = "[CV]";
    public static final String HILO_VOLUME_VALUE_MACRO = "[VV]";
    public static final String X_VALUE_MACRO = "[XV]";
    public static final String Y_VALUE_MACRO = "[YV]";
    public static final String Z_VALUE_MACRO = "[ZV]";
    public static final String X_MEMBER_MACRO = "[XM]";
    public static final String Y_MEMBER_MACRO = "[YM]";
    public static final String Z_MEMBER_MACRO = "[ZM]";
    public static final String HILO_HIGH_MEMBER_MACRO = "[HM]";
    public static final String HILO_LOW_MEMBER_MACRO = "[LM]";
    public static final String HILO_OPEN_MEMBER_MACRO = "[OM]";
    public static final String HILO_CLOSE_MEMBER_MACRO = "[CM]";
    public static final String FUNNEL_ACTUAL_VALUE_MACRO = "[AV]";
    public static final String FUNNEL_TARGET_VALUE_MACRO = "[TV]";
    public static final String FUNNEL_THRESHOLD_TEXT_MACRO = "[TT]";
    public static final String BOXPLOT_MIN_VALUE_MACRO = "[MIV]";
    public static final String BOXPLOT_TEN_VALUE_MACRO = "[TEV]";
    public static final String BOXPLOT_Q1_VALUE_MACRO = "[Q1V]";
    public static final String BOXPLOT_MEDIAN_VALUE_MACRO = "[MEV]";
    public static final String BOXPLOT_Q3_VALUE_MACRO = "[Q3V]";
    public static final String BOXPLOT_NINETY_VALUE_MACRO = "[NIV]";
    public static final String BOXPLOT_MAX_VALUE_MACRO = "[MAV]";
    static final int MIN_TOOLTIPWIDTH = 40;
    static final int MIN_TOOLTIPHEIGHT = 12;
    static final int DROPSHADOW_SIZE = 4;
    static final int WIDTH_FUDGE_FACTOR = 6;
    private ArrayList<String> m_TipStrings = new ArrayList();
    protected boolean m_bSeriesRelatedObject = false;
    protected boolean m_bDataRelatedObject = false;
    protected boolean m_bDrawCustomToolTip = false;
    protected boolean m_bReferenceLineRelatedObject = false;
    protected Rectangle m_RectTipShape = new Rectangle();
    protected Perspective m_Perspective;
    protected DetObj m_detObj = null;
    protected MouseEvent m_mouseEvt = null;
    protected TDGMouseState m_mouseState = null;
    protected Font m_ToolTipFont;
    protected Color m_ToolTipFontColor = Color.black;
    protected Color m_ToolTipFillColor = Color.yellow;
    protected Color m_ToolTipBorderColor = Color.black;
    private String m_nullString = null;
    protected int m_nToolTipX;
    protected int m_nToolTipY;
    protected int m_nNumToolTipLines;
    protected JChart_Base m_Chart;
    protected String m_strCustomToolTipUser = "";
    protected String m_strCustomToolTipDeveloper = "";
    protected String m_strDynamicToolTip = null;
    TDGTimer timeOutTimer;

    public ToolTips(Perspective a_context) {
        this.m_Perspective = a_context;
        this.m_ToolTipFont = new Font("SansSerif", 0, 10);
    }

    public void initializeFontStyle() {
        Font tooltipfont;
        IdentObj tooltip = this.m_Perspective.getToolTip();
        int fontsize = this.m_Perspective.getFontSize(tooltip);
        boolean bold = (this.m_Perspective.getFontStyle(tooltip) & 2) != 0;
        boolean italic = (this.m_Perspective.getFontStyle(tooltip) & 1) != 0;
        boolean underline = (this.m_Perspective.getFontStyle(tooltip) & 4) != 0;
        String fontname = this.m_Perspective.getFontName(tooltip);
        HashMap<TextAttribute, Object> attributeMap = new HashMap<TextAttribute, Object>();
        attributeMap.put(TextAttribute.FAMILY, fontname);
        attributeMap.put(TextAttribute.SIZE, fontsize);
        if (bold) {
            attributeMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (italic) {
            attributeMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        if (underline) {
            attributeMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        this.m_ToolTipFont = tooltipfont = new Font(attributeMap);
    }

    public void releaseReferences() {
        if (this.timeOutTimer != null) {
            this.timeOutTimer.stop();
            this.timeOutTimer.finalize();
            this.timeOutTimer = null;
        }
        this.m_Perspective = null;
        this.m_Chart = null;
    }

    public void setUserToolTipDefault() {
        this.m_strCustomToolTipUser = "";
    }

    public void setUserToolTip(String CustomToolTip) {
        this.m_strCustomToolTipUser = CustomToolTip;
    }

    public void setDeveloperToolTipDefault() {
        this.m_strCustomToolTipDeveloper = "";
    }

    public void setDeveloperToolTip(String CustomToolTip) {
        this.m_strCustomToolTipDeveloper = CustomToolTip;
    }

    public void setDynamicToolTip(String aToolTip) {
        this.m_strDynamicToolTip = aToolTip;
    }

    public void setDetObject(DetObj theDetObj) {
        this.m_detObj = theDetObj;
    }

    public void setToolTip(TDGMouseState mouseState, DetObj theDetObj) {
        this.m_mouseState = mouseState;
        this.m_nToolTipX = mouseState.getMouseX();
        this.m_nToolTipY = mouseState.getMouseY();
        this.m_mouseEvt = mouseState.getMouseEvent();
        this.m_detObj = theDetObj;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    void clearToolTip() {
        this.m_TipStrings.clear();
        if (this.timeOutTimer != null) {
            this.timeOutTimer.stop();
            this.timeOutTimer.finalize();
            this.timeOutTimer = null;
        }
    }

    public void drawAlignedString(Graphics gos, FontMetrics fm, String strInput, int x, int y, int nAlign) {
        int nDrawX = x;
        int nDrawY = y;
        if (nAlign != 2) {
            int nStrWidth = this.m_Perspective.getFontMetricsResolver().stringWidth(strInput, fm);
            if (nAlign == 0) {
                nDrawX += (this.m_RectTipShape.width - nStrWidth) / 2;
            } else if (nAlign == 4) {
                nDrawX = nDrawX + this.m_RectTipShape.width - nStrWidth;
            }
        }
        if (nAlign == 2) {
            ++nDrawX;
        }
        if (nAlign == 4) {
            --nDrawX;
        }
        gos.drawString(strInput, nDrawX, nDrawY);
    }

    public int drawDescription(Graphics gos, FontMetrics fm, String strDescription, int xStart, int yStart) {
        int nFromIndex = 0;
        int pos = 0;
        String text = strDescription;
        int baseline = this.m_Perspective.getFontMetricsResolver().getMaxAscent(fm);
        int nMaxXWidth = this.m_RectTipShape.width;
        int nMaxYHeight = this.m_bDrawCustomToolTip ? yStart + this.m_RectTipShape.height : (this.m_Perspective.getToolTipMode() ? yStart + this.m_RectTipShape.height - this.m_Perspective.getFontMetricsResolver().getHeight(fm) : yStart + this.m_RectTipShape.height);
        int nUpperLeftX = xStart;
        int nUpperLeftY = yStart;
        while (nUpperLeftY + this.m_Perspective.getFontMetricsResolver().getHeight(fm) <= nMaxYHeight && nFromIndex != -1) {
            while (nFromIndex < text.length() && text.charAt(nFromIndex) == ' ' && ++nFromIndex < text.length()) {
            }
            int bestpos = -1;
            String strLargest = null;
            for (pos = nFromIndex; pos >= nFromIndex; ++pos) {
                String strSub = (pos = text.indexOf(32, pos)) == -1 ? text.substring(nFromIndex) : text.substring(nFromIndex, pos);
                if (this.m_Perspective.getFontMetricsResolver().stringWidth(strSub, fm) < nMaxXWidth) {
                    strLargest = strSub;
                    bestpos = pos;
                    if (pos != -1) continue;
                    break;
                }
                int totalWidth = 0;
                int oneCharWidth = 0;
                for (pos = nFromIndex; pos < text.length() && totalWidth + (oneCharWidth = this.m_Perspective.getFontMetricsResolver().charWidth(text.charAt(pos), fm)) < nMaxXWidth; ++pos) {
                    totalWidth += oneCharWidth;
                }
                this.drawAlignedString(gos, fm, text.substring(nFromIndex, pos), nUpperLeftX, nUpperLeftY, 2);
                nFromIndex = pos;
                strLargest = null;
                break;
            }
            if (strLargest != null) {
                this.drawAlignedString(gos, fm, strLargest, nUpperLeftX, nUpperLeftY, 2);
                nFromIndex = bestpos;
            }
            nUpperLeftY += this.m_Perspective.getFontMetricsResolver().getHeight(fm);
        }
        return nUpperLeftY;
    }

    public void drawToolTip(Graphics g, FontMetrics fm, int nCornerX, int nCornerY) {
        block10: {
            block11: {
                block9: {
                    g.setColor(this.m_Perspective.getFillColor(this.m_Perspective.getToolTip()));
                    CommonGraph commonGraph = this.m_Perspective.getCommonGraph();
                    if (commonGraph != null && commonGraph.getThickDataview() != null) {
                        if (this.m_Perspective.getToolTipTimeOutEnabled()) {
                            this.timeOutTimer = new TDGTimer(5000, true);
                            this.timeOutTimer.start();
                            SymAction lSymAction = new SymAction();
                            this.timeOutTimer.addActionListener(lSymAction);
                        } else if (this.timeOutTimer != null) {
                            this.timeOutTimer.stop();
                        }
                    }
                    if (!this.m_bDrawCustomToolTip) break block9;
                    int nNextLine = nCornerY + this.m_Perspective.getFontMetricsResolver().getHeight(fm) - 2;
                    for (int i = 0; i < this.m_nNumToolTipLines; ++i) {
                        if (this.m_TipStrings.get(i).length() <= 0) continue;
                        nNextLine = this.drawDescription(g, fm, this.m_TipStrings.get(i), nCornerX + 2, nNextLine);
                    }
                    break block10;
                }
                if (this.m_bSeriesRelatedObject && this.m_bDataRelatedObject) break block11;
                this.drawAlignedString(g, fm, this.m_TipStrings.get(0), nCornerX + 2, nCornerY + this.m_Perspective.getFontMetricsResolver().getHeight(fm) - 2, 2);
                if (this.m_TipStrings.get(1).length() <= 0) break block10;
                this.drawDescription(g, fm, this.m_TipStrings.get(1), nCornerX + 2, nCornerY + this.m_Perspective.getFontMetricsResolver().getHeight(fm) * 2 - 2);
                break block10;
            }
            if (this.m_Perspective.getToolTipMode()) {
                this.drawAlignedString(g, fm, this.m_TipStrings.get(0), nCornerX + 2, nCornerY + this.m_Perspective.getFontMetricsResolver().getHeight(fm) - 2, 2);
                int nNextLine = this.drawDescription(g, fm, this.m_TipStrings.get(1), nCornerX + 2, nCornerY + this.m_Perspective.getFontMetricsResolver().getHeight(fm) * 2 - 2);
                int n = 0;
                for (int i = 0; i < this.m_nNumToolTipLines; ++i) {
                    if (this.m_TipStrings.get(i + 2).length() <= 0) continue;
                    this.drawAlignedString(g, fm, this.m_TipStrings.get(i + 2), nCornerX + 2, nNextLine + this.m_Perspective.getFontMetricsResolver().getHeight(fm) * n - 2, 0);
                    ++n;
                }
            } else {
                int n = 0;
                for (int i = 0; i < this.m_nNumToolTipLines; ++i) {
                    if (this.m_TipStrings.get(i).length() <= 0) continue;
                    this.drawAlignedString(g, fm, this.m_TipStrings.get(i), nCornerX + 2, nCornerY + this.m_Perspective.getFontMetricsResolver().getHeight(fm) * (n + 1) - 2, 0);
                    ++n;
                }
            }
        }
    }

    public void paint(Graphics g2) {
        boolean bToolTip;
        g2.setFont(this.m_ToolTipFont);
        FontMetrics fm = g2.getFontMetrics(this.m_ToolTipFont);
        if (this.m_detObj != null && (bToolTip = this.prepareToolTip(fm))) {
            int nOutsideTopY;
            Image img = this.m_Perspective.createOffscreenImage(this.m_RectTipShape.width + 6, this.m_RectTipShape.height);
            Graphics g = img.getGraphics();
            g.setFont(this.m_ToolTipFont);
            this.m_RectTipShape.x = this.m_nToolTipX;
            this.m_RectTipShape.y = this.m_nToolTipY - this.m_RectTipShape.height;
            Rectangle rectFitWithin = this.m_Perspective.getThickPFJ().getBounds();
            int nOutsideRightX = this.m_RectTipShape.x + this.m_RectTipShape.width - rectFitWithin.width;
            if (nOutsideRightX > 0) {
                this.m_RectTipShape.x -= nOutsideRightX;
            }
            if ((nOutsideTopY = this.m_RectTipShape.y) < 0) {
                this.m_RectTipShape.y -= nOutsideTopY;
            }
            this.m_RectTipShape.width += 6;
            g.setColor(Color.black);
            g.fillRect(0, 0, this.m_RectTipShape.width, this.m_RectTipShape.height);
            this.m_RectTipShape.x -= 4;
            this.m_RectTipShape.y -= 4;
            g.setColor(this.m_Perspective.getFillColor(this.m_Perspective.getToolTipFrame()));
            g.fillRect(0, 0, this.m_RectTipShape.width, this.m_RectTipShape.height);
            g.setColor(this.m_Perspective.getBorderColor(this.m_Perspective.getToolTipFrame()));
            g.drawRect(0, 0, this.m_RectTipShape.width - 1, this.m_RectTipShape.height - 1);
            this.drawToolTip(g, fm, 0, 0);
            this.m_Perspective.getThickPFJ().drawImage(img, this.m_RectTipShape.x, this.m_RectTipShape.y, g2);
            img = null;
        }
    }

    public boolean prepareToolTip(FontMetrics fm) {
        boolean bToolTip;
        this.m_RectTipShape.width = 0;
        this.m_RectTipShape.height = 0;
        this.m_bReferenceLineRelatedObject = false;
        this.clearToolTip();
        this.m_bDataRelatedObject = this.isDataRelatedObj();
        if (!this.m_Perspective.getToolTipMode() && !this.m_bDataRelatedObject) {
            bToolTip = false;
        } else {
            bToolTip = true;
            this.m_Chart = this.m_Perspective.getGraphObject();
            JGraphType aGraphType = this.m_Perspective.getJGraphType();
            DataFormat aDataFormat = aGraphType.getDataFormat();
            int nObjID = this.m_detObj.getIdentIDRef().stripExceptional().getObjectID();
            String strObjName = ObjectString.objectName(nObjID);
            String strObjDesc = "";
            if (this.m_Perspective.getToolTipMode()) {
                this.m_TipStrings.add("");
                this.m_TipStrings.add(strObjDesc);
                this.m_RectTipShape.width = this.m_Perspective.getFontMetricsResolver().stringWidth(strObjName, fm) > this.m_RectTipShape.width ? this.m_Perspective.getFontMetricsResolver().stringWidth(strObjName, fm) + 6 : this.m_RectTipShape.width;
                this.m_RectTipShape.height = this.m_Perspective.getFontMetricsResolver().getHeight(fm) + (this.m_Perspective.getFontMetricsResolver().stringWidth(strObjDesc, fm) / this.m_RectTipShape.width + 1) * this.m_Perspective.getFontMetricsResolver().getHeight(fm);
            } else {
                this.m_TipStrings.add(strObjDesc);
                this.m_RectTipShape.width = this.m_Perspective.getFontMetricsResolver().stringWidth(strObjDesc, fm) > this.m_RectTipShape.width ? this.m_Perspective.getFontMetricsResolver().stringWidth(strObjDesc, fm) + 6 : this.m_RectTipShape.width;
                this.m_RectTipShape.height = this.m_Perspective.getFontMetricsResolver().getHeight(fm) + (this.m_Perspective.getFontMetricsResolver().stringWidth(strObjDesc, fm) / this.m_RectTipShape.width + 1) * this.m_Perspective.getFontMetricsResolver().getHeight(fm);
            }
            this.m_nNumToolTipLines = 0;
            this.m_bSeriesRelatedObject = this.isSeriesRelatedObj();
            bToolTip = this.processCustomToolTips(aDataFormat, fm);
            if (!this.m_bDrawCustomToolTip) {
                if (this.m_bDataRelatedObject && this.m_bReferenceLineRelatedObject) {
                    if (this.m_Perspective.getToolTipMode()) {
                        this.processDeveloperReferenceObjToolTip(aDataFormat, fm);
                    } else {
                        this.processUserReferenceObjToolTip(aDataFormat, fm);
                    }
                }
                if (this.m_bSeriesRelatedObject && this.m_bDataRelatedObject) {
                    if (this.m_Perspective.getToolTipMode()) {
                        this.processDeveloperSeriesObjToolTip(aDataFormat, fm);
                    } else {
                        this.processUserSeriesObjToolTip(aDataFormat, fm);
                    }
                }
            }
            this.m_RectTipShape.width = this.m_RectTipShape.width > 40 ? this.m_RectTipShape.width : 40;
            this.m_RectTipShape.height = this.m_RectTipShape.height > 12 ? this.m_RectTipShape.height : 12;
        }
        return bToolTip;
    }

    private boolean isSeriesRelatedObj() {
        boolean bSeriesRelated = this.m_detObj.getIdentIDRef().stripExceptional().isSeriesRelated();
        int nObjID = this.m_detObj.getObjectID();
        switch (nObjID) {
            case 14: 
            case 270: 
            case 310: {
                bSeriesRelated = true;
            }
        }
        return bSeriesRelated;
    }

    private boolean isDataRelatedObj() {
        boolean bDataRelated = this.m_detObj.getSeriesID() >= 0 || this.m_detObj.getGroupID() >= 0;
        int nObjID = this.m_detObj.getObjectID();
        switch (nObjID) {
            case 358: 
            case 503: 
            case 504: {
                this.m_bDataRelatedObject = true;
                this.m_bReferenceLineRelatedObject = true;
            }
        }
        return bDataRelated;
    }

    void justifyLabelsAndValues(FontMetrics fm) {
        for (int i = 2; i < this.m_nNumToolTipLines; ++i) {
            if (this.m_TipStrings.get(i).length() <= 0) continue;
            int nFirstSpace = this.m_TipStrings.get(i).indexOf(" ");
            String strLeftHalf = this.m_TipStrings.get(i).substring(0, nFirstSpace);
            String strRightHalf = this.m_TipStrings.get(i).substring(nFirstSpace, this.m_TipStrings.get(i).length());
            nFirstSpace = 1;
            String strTest = strLeftHalf + " " + strRightHalf;
            while (this.m_Perspective.getFontMetricsResolver().stringWidth(strTest, fm) < this.m_RectTipShape.width - 6) {
                strTest = strLeftHalf;
                for (int j = 0; j < nFirstSpace; ++j) {
                    strTest = strTest + " ";
                }
                strTest = strTest + strRightHalf;
                ++nFirstSpace;
            }
            this.m_TipStrings.set(i, strTest);
        }
    }

    void processDeveloperReferenceObjToolTip(DataFormat aDataFormat, FontMetrics fm) {
    }

    void processUserReferenceObjToolTip(DataFormat aDataFormat, FontMetrics fm) {
        if (this.m_detObj.getObjectID() == 504) {
            this.FmtUserReferenceLineID(fm);
        }
        if (this.m_detObj.getObjectID() == 358) {
            this.UserFmtReferenceLineGENERAL(fm);
        }
    }

    void processUserSeriesObjToolTip(DataFormat aDataFormat, FontMetrics fm) {
        this.m_RectTipShape.width = 0;
        this.m_RectTipShape.height = 0;
        this.FmtUserSeriesAndGroupID(fm);
        if (aDataFormat == DataFormat.DF_GENERAL) {
            this.UserFmtGENERAL(fm);
        } else if (aDataFormat == DataFormat.DF_XY) {
            this.UserFmtXY(fm);
        } else if (aDataFormat == DataFormat.DF_XY_LBL) {
            this.UserFmtXY_LBL(fm);
        } else if (aDataFormat == DataFormat.DF_XYZ) {
            this.UserFmtXYZ(fm);
        } else if (aDataFormat != DataFormat.DF_XYZ_LBL) {
            if (aDataFormat == DataFormat.DF_GANTT) {
                this.UserFmtGANTT(fm);
            } else if (aDataFormat == DataFormat.DF_HL) {
                this.UserFmtHL(fm);
            } else if (aDataFormat == DataFormat.DF_HLC) {
                this.UserFmtHLC(fm);
            } else if (aDataFormat == DataFormat.DF_OHLC) {
                this.UserFmtOHLC(fm);
            } else if (aDataFormat == DataFormat.DF_HL_VOL) {
                this.UserFmtHL_VOL(fm);
            } else if (aDataFormat == DataFormat.DF_HLC_VOL) {
                this.UserFmtHLC_VOL(fm);
            } else if (aDataFormat == DataFormat.DF_OHLC_VOL) {
                this.UserFmtOHLC_VOL(fm);
            }
        }
        this.UserSetToolTipHeight(fm);
        this.justifyLabelsAndValues(fm);
    }

    void processDeveloperSeriesObjToolTip(DataFormat aDataFormat, FontMetrics fm) {
        if (this.m_Perspective.getJGraphType().isParetoType() && this.ParetoRelated()) {
            this.FmtDevelopersPareto(fm);
        } else {
            this.FmtDeveloperSeriesAndGroupID(fm);
        }
        if (aDataFormat == DataFormat.DF_GENERAL) {
            this.DeveloperFmtGENERAL(fm);
        } else if (aDataFormat == DataFormat.DF_XY) {
            this.DeveloperFmtXY(fm);
        } else if (aDataFormat == DataFormat.DF_XY_LBL) {
            this.DeveloperFmtXY_LBL(fm);
        } else if (aDataFormat == DataFormat.DF_XYZ) {
            this.DeveloperFmtXYZ(fm);
        } else if (aDataFormat != DataFormat.DF_XYZ_LBL && aDataFormat != DataFormat.DF_GANTT) {
            if (aDataFormat == DataFormat.DF_HL) {
                this.DeveloperFmtHL(fm);
            } else if (aDataFormat == DataFormat.DF_HLC) {
                this.DeveloperFmtHLC(fm);
            } else if (aDataFormat == DataFormat.DF_OHLC) {
                this.DeveloperFmtOHLC(fm);
            } else if (aDataFormat == DataFormat.DF_HL_VOL) {
                this.DeveloperFmtHL_VOL(fm);
            } else if (aDataFormat == DataFormat.DF_HLC_VOL) {
                this.DeveloperFmtHLC_VOL(fm);
            } else if (aDataFormat == DataFormat.DF_OHLC_VOL) {
                this.DeveloperFmtOHLC_VOL(fm);
            }
        }
        this.DeveloperSetToolTipHeight(fm, this.m_TipStrings.get(1), this.m_RectTipShape.width, this.m_nNumToolTipLines);
    }

    boolean processCustomToolTips(DataFormat aDataFormat, FontMetrics fm) {
        boolean bToolTip = true;
        String strCustomToolTip = "";
        if (this.m_Perspective.isToolTipCallBack()) {
            this.m_bDrawCustomToolTip = true;
            if (this.m_strDynamicToolTip != null) {
                strCustomToolTip = this.m_strDynamicToolTip;
                this.m_strDynamicToolTip = null;
            } else {
                strCustomToolTip = this.m_Perspective.getDynamicToolTip(this.m_mouseState);
            }
        } else if (!this.m_Perspective.getToolTipMode()) {
            if (this.m_strCustomToolTipUser.length() > 0) {
                this.m_bDrawCustomToolTip = true;
                strCustomToolTip = this.m_strCustomToolTipUser;
            } else {
                this.m_bDrawCustomToolTip = false;
            }
        } else if (this.m_strCustomToolTipDeveloper.length() > 0) {
            this.m_bDrawCustomToolTip = true;
            strCustomToolTip = this.m_strCustomToolTipDeveloper;
        } else {
            this.m_bDrawCustomToolTip = false;
        }
        if (this.m_bDrawCustomToolTip) {
            if (strCustomToolTip == null || strCustomToolTip.length() < 1) {
                bToolTip = false;
            } else {
                this.m_TipStrings.set(1, "");
                this.m_nNumToolTipLines = ToolTips.CustomToolTipIntoLines(strCustomToolTip, this.m_TipStrings);
                this.setTooltipNullString(null);
                this.CustomToolTipMacros(aDataFormat, this.m_detObj.getSeriesID(), this.m_detObj.getGroupID(), this.m_detObj);
                this.m_RectTipShape.width = this.CustomSetToolTipWidth(fm);
                this.m_RectTipShape.height = this.CustomSetToolTipHeight(fm, this.m_RectTipShape.width);
            }
        }
        return bToolTip;
    }

    public static int CustomToolTipIntoLines(String strCustomToolTip, ArrayList<String> tipStrings) {
        String remainingString = strCustomToolTip;
        String currentString = strCustomToolTip;
        if (remainingString.indexOf(RETURN_MACRO) != -1) {
            int nPosition;
            while ((nPosition = remainingString.indexOf(RETURN_MACRO)) != -1) {
                currentString = remainingString.substring(0, nPosition);
                remainingString = remainingString.substring(nPosition + RETURN_MACRO.length(), remainingString.length());
                tipStrings.add(currentString);
            }
            tipStrings.add(remainingString);
        } else {
            tipStrings.add(currentString);
        }
        return tipStrings.size();
    }

    void CustomToolTipMacros(DataFormat aDataFormat, int nSeries, int nGroup, DetObj obj) {
        for (int nLine = 0; nLine < this.m_TipStrings.size(); ++nLine) {
            boolean bSeriesGroupValid;
            if (this.m_TipStrings.get(nLine).length() <= 0) continue;
            this.CustomLabelMacros(nLine, nSeries, nGroup, obj);
            boolean bl = bSeriesGroupValid = nSeries > -1 && nGroup > -1;
            if (this.m_Chart instanceof JChart_2D_PieBar && nSeries > -1) {
                bSeriesGroupValid = true;
            }
            if (this.m_Chart instanceof JChart_2D_Pareto && nGroup > -1) {
                nSeries = this.m_Perspective.getDisplayParetoSeries();
                bSeriesGroupValid = true;
            }
            if (this.m_Chart instanceof JChart_2D_Funnel && nGroup > -1) {
                bSeriesGroupValid = true;
            }
            if (!bSeriesGroupValid) continue;
            int nObjectID = 0;
            nObjectID = obj != null ? obj.getObjectID() : (this.m_Chart instanceof JChart_2D_Pareto ? 474 : 602);
            this.CustomValueMacros(aDataFormat, nLine, nSeries, nGroup, nObjectID);
        }
    }

    void CustomLabelMacros(int nLine, int nSeries, int nGroup, DetObj obj) {
        if (obj != null) {
            this.m_TipStrings.set(nLine, this.CustomReplaceMacro(this.m_TipStrings.get(nLine), OBJECT_NAME_MACRO, ObjectString.objectName(obj.getIdentIDRef().stripExceptional().getObjectID())));
            this.m_TipStrings.set(nLine, this.CustomReplaceMacro(this.m_TipStrings.get(nLine), OBJECT_DESCRIPTION_MACRO, ObjectString.objectDescription(obj.getIdentIDRef().stripExceptional().getObjectID())));
            this.m_TipStrings.set(nLine, this.CustomReplaceMacro(this.m_TipStrings.get(nLine), OBJECT_ID_MACRO, new Integer(obj.getObjectID()).toString()));
            this.m_TipStrings.set(nLine, this.CustomReplaceMacro(this.m_TipStrings.get(nLine), OBJECT_INSTANCE_MACRO, new Integer(obj.getMiscID()).toString()));
        }
        if (nSeries > -1) {
            this.m_TipStrings.set(nLine, this.CustomReplaceMacro(this.m_TipStrings.get(nLine), SERIES_LABEL_MACRO, this.m_Perspective.getSeriesLabel(nSeries)));
        }
        if (nGroup > -1) {
            this.m_TipStrings.set(nLine, this.CustomReplaceMacro(this.m_TipStrings.get(nLine), GROUP_LABEL_MACRO, this.m_Perspective.getGroupLabel(nGroup)));
        }
    }

    void CustomValueMacros(DataFormat aDataFormat, int nLine, int nSeries, int nGroup, int nObjectID) {
        double fDataValue;
        Point2D pt2D;
        double fZValue;
        double fYValue;
        double fXValue;
        boolean nullValue;
        if (this.m_Chart instanceof JChart_2D_Scat) {
            nullValue = false;
            try {
                fXValue = ((JChart_2D_Scat)this.m_Chart).getXValue(nSeries, nGroup);
                nullValue = false;
            }
            catch (AssertionException e) {
                fXValue = 0.0;
                nullValue = true;
            }
            if (this.m_Perspective.isMixedFreqTimeAxis()) {
                String date = this.m_Perspective.getToolTipCallBack().convertDateToString(new Date((long)fXValue));
                this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(date, this.m_TipStrings.get(nLine), X_VALUE_MACRO, "XVALUE", nullValue));
            } else {
                this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fXValue, this.m_TipStrings.get(nLine), X_VALUE_MACRO, "XVALUE", nSeries, nGroup, nullValue));
            }
            try {
                fYValue = ((JChart_2D_Scat)this.m_Chart).getYValue(nSeries, nGroup);
                nullValue = false;
            }
            catch (AssertionException e) {
                fYValue = 0.0;
                nullValue = true;
            }
            this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fYValue, this.m_TipStrings.get(nLine), Y_VALUE_MACRO, "YVALUE", nSeries, nGroup, nullValue));
            try {
                fZValue = ((JChart_2D_Scat)this.m_Chart).getXYZ_ZValue(nSeries, nGroup);
                nullValue = false;
            }
            catch (AssertionException e) {
                fZValue = 0.0;
                nullValue = true;
            }
            this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fZValue, this.m_TipStrings.get(nLine), Z_VALUE_MACRO, "ZVALUE", nSeries, nGroup, nullValue));
        }
        if (this.m_Chart instanceof JChart_2D_Polar) {
            nullValue = false;
            try {
                fXValue = ((JChart_2D_Polar)this.m_Chart).getXValue(nSeries, nGroup);
                nullValue = false;
            }
            catch (AssertionException e) {
                fXValue = 0.0;
                nullValue = true;
            }
            this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fXValue, this.m_TipStrings.get(nLine), X_VALUE_MACRO, "XVALUE", nSeries, nGroup, nullValue));
            try {
                fYValue = ((JChart_2D_Polar)this.m_Chart).getYValue(nSeries, nGroup);
                nullValue = false;
            }
            catch (AssertionException e) {
                fYValue = 0.0;
                nullValue = true;
            }
            this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fYValue, this.m_TipStrings.get(nLine), Y_VALUE_MACRO, "YVALUE", nSeries, nGroup, nullValue));
            try {
                fZValue = ((JChart_2D_Polar)this.m_Chart).getXYZ_ZValue(nSeries, nGroup);
                nullValue = false;
            }
            catch (AssertionException e) {
                fZValue = 0.0;
                nullValue = true;
            }
            this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fZValue, this.m_TipStrings.get(nLine), Z_VALUE_MACRO, "ZVALUE", nSeries, nGroup, nullValue));
        }
        if (this.m_Chart instanceof JChart_2D_Pareto) {
            nullValue = false;
            if (nObjectID != 358) {
                try {
                    if (this.ParetoRelated(nObjectID)) {
                        double percent;
                        fYValue = ((JChart_2D_Standard)this.m_Chart).getDataValue((int)nSeries, (int)nGroup).m_fValue;
                        nullValue = !((JChart_2D_Standard)this.m_Chart).getDataValue((int)nSeries, (int)nGroup).m_bOK;
                        this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fYValue, this.m_TipStrings.get(nLine), Y_VALUE_MACRO, "YVALUE", nSeries, nGroup, nullValue));
                        int numGroups = this.m_Perspective.getNumTotalGroups();
                        double fCumValue = ((JChart_2D_Standard)this.m_Chart).getParetoValue(nSeries, nGroup);
                        double fTotal = ((JChart_2D_Standard)this.m_Chart).getParetoValue(nSeries, numGroups - 1);
                        if (fTotal > 0.0) {
                            percent = fCumValue / fTotal;
                            String percentStr = this.m_Perspective.getToolTipCallBack().getFormattedValue(percent, 51, true, false);
                            this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(percentStr, this.m_TipStrings.get(nLine), CUMULATIVE_PERCENTAGE_VALUE_MACRO, null));
                        } else {
                            percent = 0.0;
                            String percentStr = this.m_Perspective.getToolTipCallBack().getFormattedValue(percent, 51, true, false);
                            this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(percentStr, this.m_TipStrings.get(nLine), CUMULATIVE_PERCENTAGE_VALUE_MACRO, null, true));
                        }
                        this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fCumValue, this.m_TipStrings.get(nLine), CUMULATIVE_STACKED_VALUE_MACRO, null, nSeries, nGroup));
                    }
                }
                catch (AssertionException numGroups) {
                    // empty catch block
                }
            }
        }
        if (this.m_Chart instanceof JChart_2D_PieBar) {
            nullValue = false;
            if (nGroup < 0) {
                double fSeriesTotal = ((JChart_2D_Pie)this.m_Chart).getSeriesTotal(nSeries);
                this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fSeriesTotal, this.m_TipStrings.get(nLine), Y_VALUE_MACRO, "YVALUE", nSeries, nGroup));
            } else {
                int pieBarSlice = this.m_Perspective.getPieBarSeries();
                nullValue = !this.m_Chart.getDataValue((int)pieBarSlice, (int)nGroup).m_bOK;
                double fGroupValue = ((JChart_2D_PieBar)this.m_Chart).getGroupValueForBar(nGroup);
                this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fGroupValue, this.m_TipStrings.get(nLine), Y_VALUE_MACRO, "PIE_BAR_VALUE", nSeries, nGroup, nullValue));
            }
        } else if (this.m_Chart instanceof JChart_2D_BLA || this.m_Chart instanceof JChart_2D_Circular || this.m_Chart instanceof JChart_2D_Hist || this.m_Chart instanceof JChart_2D_Pie || this.m_Chart instanceof JChart_2D_Radar || this.m_Chart instanceof JChart_2D_Spec || this.m_Chart instanceof JChart_3D || this.m_Chart instanceof JChart_3D_Surf || this.m_Chart instanceof JChart_2D_Pareto) {
            nullValue = false;
            if (nObjectID != 358) {
                try {
                    pt2D = this.m_Chart.getDataValuesXY(nSeries, nGroup);
                    nullValue = false;
                }
                catch (AssertionException e) {
                    pt2D = new Point2D.Double();
                    nullValue = true;
                }
                if (this.m_Perspective.isMixedFreqTimeAxis()) {
                    DatumObj dObj = this.m_Chart.getDataValue(nSeries, nGroup);
                    nullValue = !dObj.m_bOK;
                    String date = this.m_Perspective.getToolTipCallBack().convertDateToString(new Date((long)pt2D.getX()));
                    this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(date, this.m_TipStrings.get(nLine), X_VALUE_MACRO, "XVALUE", nullValue));
                } else {
                    this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(pt2D.getX(), this.m_TipStrings.get(nLine), X_VALUE_MACRO, "XVALUE", nSeries, nGroup, nullValue));
                }
                this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(pt2D.getY(), this.m_TipStrings.get(nLine), Y_VALUE_MACRO, "YVALUE", nSeries, nGroup, nullValue));
            }
        }
        if (this.m_Chart instanceof JChart_2D_BLA) {
            nullValue = false;
            if (nObjectID != 358) {
                nullValue = false;
                double fTmpCumulValue = ((JChart_2D_Standard)this.m_Chart).getStackedCumulativeValue(nSeries, nGroup);
                this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fTmpCumulValue, this.m_TipStrings.get(nLine), CUMULATIVE_STACKED_VALUE_MACRO, null, nSeries, nGroup, nullValue));
                double fPercentValue = ((JChart_2D_Standard)this.m_Chart).getPercentCumulativeValue(nSeries, nGroup);
                this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fPercentValue, this.m_TipStrings.get(nLine), CUMULATIVE_PERCENTAGE_VALUE_MACRO, "PERCENTAGE_VALUE", nSeries, nGroup, nullValue));
                fPercentValue = ((JChart_2D_Standard)this.m_Chart).getPercentValue(nSeries, nGroup);
                this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fPercentValue, this.m_TipStrings.get(nLine), PERCENTAGE_VALUE_MACRO, "PERCENTAGE_VALUE", nSeries, nGroup));
            }
        }
        if (this.m_Chart instanceof JChart_2D_PieBar) {
            if (nGroup >= 0) {
                double fGroupTotal = ((JChart_2D_Pie)this.m_Chart).getGroupTotal(nGroup);
                double fSeriesTotal = ((JChart_2D_Pie)this.m_Chart).getSeriesTotal(nSeries);
                double fSumTotal = ((JChart_2D_Pie)this.m_Chart).getSumTotal();
                double fPercentage = fGroupTotal / fSumTotal;
                this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fPercentage, this.m_TipStrings.get(nLine), PIE_PERCENTAGE_VALUE_MACRO, "PIE_PERCENTAGE_VALUE", nSeries, nGroup));
                this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fSumTotal, this.m_TipStrings.get(nLine), RING_TOTAL_VALUE_MACRO, null, nSeries, nGroup));
            } else {
                double fSeriesTotal = ((JChart_2D_Pie)this.m_Chart).getSeriesTotal(nSeries);
                double fSumTotal = ((JChart_2D_PieBar)this.m_Chart).getSumTotal();
                double fPercentage = fSeriesTotal / fSumTotal;
                this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fPercentage, this.m_TipStrings.get(nLine), PIE_PERCENTAGE_VALUE_MACRO, "PIE_PERCENTAGE_VALUE", nSeries, nGroup));
            }
        } else if (this.m_Chart instanceof JChart_2D_Pie) {
            nullValue = false;
            try {
                pt2D = this.m_Chart.getDataValuesXY(nSeries, nGroup);
                nullValue = false;
            }
            catch (AssertionException e) {
                pt2D = new Point2D.Double();
                nullValue = true;
            }
            double fGroupTotal = ((JChart_2D_Pie)this.m_Chart).getGroupTotal(nGroup);
            double fPercentage = pt2D.getY() / fGroupTotal;
            this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fPercentage, this.m_TipStrings.get(nLine), PIE_PERCENTAGE_VALUE_MACRO, "PIE_PERCENTAGE_VALUE", nSeries, nGroup, nullValue));
            this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fGroupTotal, this.m_TipStrings.get(nLine), RING_TOTAL_VALUE_MACRO, null, nSeries, nGroup));
        }
        if (this.m_Chart instanceof JChart_2D_Hilo) {
            boolean nullValue2 = false;
            if (((JChart_2D_Hilo)this.m_Chart).hasHighValue(aDataFormat) && nObjectID != 310) {
                try {
                    fDataValue = ((JChart_2D_Hilo)this.m_Chart).getHighValue(nSeries, nGroup);
                    nullValue2 = false;
                }
                catch (AssertionException e) {
                    fDataValue = 0.0;
                    nullValue2 = true;
                }
                this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fDataValue, this.m_TipStrings.get(nLine), HILO_HIGH_VALUE_MACRO, "HIGH", nSeries, nGroup, nullValue2));
            }
            if (((JChart_2D_Hilo)this.m_Chart).hasLowValue(aDataFormat) && nObjectID != 310) {
                try {
                    fDataValue = ((JChart_2D_Hilo)this.m_Chart).getLowValue(nSeries, nGroup);
                    nullValue2 = false;
                }
                catch (AssertionException e) {
                    fDataValue = 0.0;
                    nullValue2 = true;
                }
                this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fDataValue, this.m_TipStrings.get(nLine), HILO_LOW_VALUE_MACRO, "LOW", nSeries, nGroup, nullValue2));
            }
            if (((JChart_2D_Hilo)this.m_Chart).hasOpenValue(aDataFormat) && nObjectID != 310) {
                try {
                    fDataValue = ((JChart_2D_Hilo)this.m_Chart).getOpenValue(nSeries, nGroup);
                    nullValue2 = false;
                    this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fDataValue, this.m_TipStrings.get(nLine), HILO_OPEN_VALUE_MACRO, "OPEN", nSeries, nGroup, nullValue2));
                }
                catch (AssertionException e) {
                    nullValue2 = true;
                    if (!this.m_Perspective.getJGraphType().isStockCandleType()) {
                        this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro("", this.m_TipStrings.get(nLine), HILO_OPEN_VALUE_MACRO, "OPEN", nullValue2));
                    }
                    this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(0.0, this.m_TipStrings.get(nLine), HILO_OPEN_VALUE_MACRO, "OPEN", nSeries, nGroup, nullValue2));
                }
            }
            if (((JChart_2D_Hilo)this.m_Chart).hasCloseValue(aDataFormat) && nObjectID != 310) {
                try {
                    fDataValue = ((JChart_2D_Hilo)this.m_Chart).getCloseValue(nSeries, nGroup);
                    nullValue2 = false;
                    this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fDataValue, this.m_TipStrings.get(nLine), HILO_CLOSE_VALUE_MACRO, "CLOSE", nSeries, nGroup, nullValue2));
                }
                catch (AssertionException e) {
                    nullValue2 = true;
                    if (!this.m_Perspective.getJGraphType().isStockCandleType()) {
                        this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro("", this.m_TipStrings.get(nLine), HILO_CLOSE_VALUE_MACRO, "CLOSE", nullValue2));
                    }
                    this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(0.0, this.m_TipStrings.get(nLine), HILO_CLOSE_VALUE_MACRO, "CLOSE", nSeries, nGroup, nullValue2));
                }
            }
            if (((JChart_2D_Hilo)this.m_Chart).hasVolumeValue(aDataFormat)) {
                try {
                    nSeries = 0;
                    fDataValue = ((JChart_2D_Hilo)this.m_Chart).getVolumeValue(nSeries, nGroup);
                    nullValue2 = false;
                }
                catch (AssertionException e) {
                    fDataValue = 0.0;
                    nullValue2 = true;
                }
                this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fDataValue, this.m_TipStrings.get(nLine), HILO_VOLUME_VALUE_MACRO, "VOLUME", nSeries, nGroup, nullValue2));
            }
        }
        if (this.m_Chart instanceof JChart_2D_BoxPlot) {
            boolean nullValue3 = false;
            try {
                fDataValue = ((JChart_2D_BoxPlot)this.m_Chart).getMaxValue(nSeries, nGroup);
                nullValue3 = false;
            }
            catch (AssertionException e) {
                fDataValue = 0.0;
                nullValue3 = true;
            }
            this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fDataValue, this.m_TipStrings.get(nLine), BOXPLOT_MAX_VALUE_MACRO, "YVALUE", nSeries, nGroup, nullValue3));
            try {
                fDataValue = ((JChart_2D_BoxPlot)this.m_Chart).getQ3Value(nSeries, nGroup);
                nullValue3 = false;
            }
            catch (AssertionException e) {
                fDataValue = 0.0;
                nullValue3 = true;
            }
            this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fDataValue, this.m_TipStrings.get(nLine), BOXPLOT_Q3_VALUE_MACRO, "YVALUE", nSeries, nGroup, nullValue3));
            try {
                fDataValue = ((JChart_2D_BoxPlot)this.m_Chart).getMedianValue(nSeries, nGroup);
                nullValue3 = false;
            }
            catch (AssertionException e) {
                fDataValue = 0.0;
                nullValue3 = true;
            }
            this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fDataValue, this.m_TipStrings.get(nLine), BOXPLOT_MEDIAN_VALUE_MACRO, "YVALUE", nSeries, nGroup, nullValue3));
            try {
                fDataValue = ((JChart_2D_BoxPlot)this.m_Chart).getQ1Value(nSeries, nGroup);
                nullValue3 = false;
            }
            catch (AssertionException e) {
                fDataValue = 0.0;
                nullValue3 = true;
            }
            this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fDataValue, this.m_TipStrings.get(nLine), BOXPLOT_Q1_VALUE_MACRO, "YVALUE", nSeries, nGroup, nullValue3));
            try {
                fDataValue = ((JChart_2D_BoxPlot)this.m_Chart).getMinValue(nSeries, nGroup);
                nullValue3 = false;
            }
            catch (AssertionException e) {
                fDataValue = 0.0;
                nullValue3 = true;
            }
            this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fDataValue, this.m_TipStrings.get(nLine), BOXPLOT_MIN_VALUE_MACRO, "YVALUE", nSeries, nGroup, nullValue3));
            if (((JChart_2D_BoxPlot)this.m_Chart).isSevenValueBoxPlot(aDataFormat)) {
                try {
                    fDataValue = ((JChart_2D_BoxPlot)this.m_Chart).getNinetyValue(nSeries, nGroup);
                    nullValue3 = false;
                }
                catch (AssertionException e) {
                    fDataValue = 0.0;
                    nullValue3 = true;
                }
                this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fDataValue, this.m_TipStrings.get(nLine), BOXPLOT_NINETY_VALUE_MACRO, "YVALUE", nSeries, nGroup, nullValue3));
                try {
                    fDataValue = ((JChart_2D_BoxPlot)this.m_Chart).getTenValue(nSeries, nGroup);
                    nullValue3 = false;
                }
                catch (AssertionException e) {
                    fDataValue = 0.0;
                    nullValue3 = true;
                }
                this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fDataValue, this.m_TipStrings.get(nLine), BOXPLOT_TEN_VALUE_MACRO, "YVALUE", nSeries, nGroup, nullValue3));
            }
        }
        if (this.m_Chart instanceof JChart_2D_Funnel) {
            boolean targetNull;
            boolean actualNull;
            boolean nullValue4 = false;
            SeriesEnumerator sEnum = this.m_Chart.getResetSeriesEnumerator();
            int s = sEnum.getAbsoluteSeries(0);
            nullValue4 = actualNull = !this.m_Chart.getDataValue((int)s, (int)nGroup).m_bOK;
            double fActualValue = ((JChart_2D_Funnel)this.m_Chart).getActualValue(nGroup);
            this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fActualValue, this.m_TipStrings.get(nLine), FUNNEL_ACTUAL_VALUE_MACRO, "YVALUE", nSeries, nGroup, nullValue4));
            s = sEnum.getAbsoluteSeries(1);
            nullValue4 = targetNull = !this.m_Chart.getDataValue((int)s, (int)nGroup).m_bOK;
            double fTargetValue = ((JChart_2D_Funnel)this.m_Chart).getTargetValue(nGroup);
            this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fTargetValue, this.m_TipStrings.get(nLine), FUNNEL_TARGET_VALUE_MACRO, "YVALUE", nSeries, nGroup, nullValue4));
            nullValue4 = actualNull || targetNull;
            String thresholdText = this.m_Perspective.getThresholdText(((JChart_2D_Funnel)this.m_Chart).getThresholdId(nGroup));
            this.m_TipStrings.set(nLine, this.CustomReplaceMacro(this.m_TipStrings.get(nLine), FUNNEL_THRESHOLD_TEXT_MACRO, thresholdText, nullValue4));
            double fPercentValue = fActualValue / fTargetValue;
            if (fTargetValue == 0.0) {
                nullValue4 = true;
            }
            this.m_TipStrings.set(nLine, this.CustomReplaceValueMacro(fPercentValue, this.m_TipStrings.get(nLine), PERCENTAGE_VALUE_MACRO, "PERCENTAGE_VALUE", nSeries, nGroup, nullValue4));
        }
    }

    String CustomReplaceMacro(String strSource, String strMacro, String strReplacement) {
        return this.CustomReplaceMacro(strSource, strMacro, strReplacement, false);
    }

    String CustomReplaceMacro(String strSource, String strMacro, String strReplacement, boolean nullValue) {
        int nPosition;
        StringBuilder strProcessed = DataviewUtils.getSharedStringBuilder(strSource);
        while ((nPosition = strProcessed.indexOf(strMacro)) != -1) {
            StringBuilder strTmp = DataviewUtils.getSharedStringBuilder2(strProcessed.substring(0, nPosition));
            if (!nullValue || this.m_nullString == null) {
                strTmp.append(strReplacement);
            } else {
                strTmp.append(this.m_nullString);
            }
            strTmp.append(strProcessed.substring(nPosition += strMacro.length(), strProcessed.length()));
            strProcessed = strTmp;
        }
        return strProcessed.toString();
    }

    String CustomReplaceValueMacro(double fDataValue, String strSource, String strMacro, String valueType, int nSeries, int nGroup) {
        return this.CustomReplaceValueMacro(fDataValue, strSource, strMacro, valueType, nSeries, nGroup, false);
    }

    String CustomReplaceValueMacro(double fDataValue, String strSource, String strMacro, String valueType, int nSeries, int nGroup, boolean nullValue) {
        int nPosition;
        StringBuilder strProcessed = DataviewUtils.getSharedStringBuilder(strSource);
        while ((nPosition = strProcessed.indexOf(strMacro)) != -1) {
            String strFormattedValue = !nullValue || this.m_nullString == null ? ToolTips.FormatValue(this.m_Perspective, nSeries, nGroup, fDataValue, valueType) : this.m_nullString;
            StringBuilder strTmp = DataviewUtils.getSharedStringBuilder2(strProcessed.substring(0, nPosition));
            strTmp.append(strFormattedValue);
            strTmp.append(strProcessed.substring(nPosition += strMacro.length(), strProcessed.length()));
            strProcessed = strTmp;
        }
        return strProcessed.toString();
    }

    String CustomReplaceValueMacro(String value, String strSource, String strMacro, String valueType) {
        return this.CustomReplaceValueMacro(value, strSource, strMacro, valueType, false);
    }

    String CustomReplaceValueMacro(String value, String strSource, String strMacro, String valueType, boolean nullValue) {
        int nPosition;
        StringBuilder strProcessed = DataviewUtils.getSharedStringBuilder(strSource);
        while ((nPosition = strProcessed.indexOf(strMacro)) != -1) {
            String strFormattedValue = !nullValue || this.m_nullString == null ? value : this.m_nullString;
            StringBuilder strTmp = DataviewUtils.getSharedStringBuilder2(strProcessed.substring(0, nPosition));
            strTmp.append(strFormattedValue);
            strTmp.append(strProcessed.substring(nPosition += strMacro.length(), strProcessed.length()));
            strProcessed = strTmp;
        }
        return strProcessed.toString();
    }

    int CustomSetToolTipWidth(FontMetrics fm) {
        int resultWidth = 0;
        for (int i = 0; i < this.m_TipStrings.size(); ++i) {
            if (this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(i), fm) <= resultWidth) continue;
            resultWidth = this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(i), fm);
        }
        return resultWidth;
    }

    int CustomSetToolTipHeight(FontMetrics fm, int TipWidth) {
        int resultHeight = 0;
        for (int i = 0; i < this.m_TipStrings.size(); ++i) {
            double fFlooredQuotient;
            if (this.m_TipStrings.get(i).length() <= 0) continue;
            if (this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(i), fm) < TipWidth) {
                resultHeight += this.m_Perspective.getFontMetricsResolver().getHeight(fm);
                continue;
            }
            double fQuotient = (double)this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(i), fm) / (double)TipWidth;
            if (fQuotient - (fFlooredQuotient = Math.floor(fQuotient)) > 0.1) {
                fFlooredQuotient += 1.0;
            }
            resultHeight = (int)((double)resultHeight + fFlooredQuotient * (double)this.m_Perspective.getFontMetricsResolver().getHeight(fm));
        }
        return resultHeight += 2;
    }

    public static String FormatValue(Perspective p, int series, int group, double fValue, String strSource) {
        String strFormattedValue = "";
        if (p.isNumberFormatCallBack()) {
            p.getNumberFormatCallBack().setState(4, series, group, strSource, -1, -3);
            strFormattedValue = p.getNumberFormatCallBack().toString(fValue);
        } else {
            strFormattedValue = TDGNumberFormat.toString(p, p.getDataTextFormat(), fValue, p.getDataTextFormatPattern());
        }
        return strFormattedValue;
    }

    String FmtValue(double fValue, String strSource) {
        return ToolTips.FormatValue(this.m_Perspective, this.m_detObj.getSeriesID(), this.m_detObj.getGroupID(), fValue, strSource);
    }

    void FmtSingleValue(FontMetrics fm, int nLineNum, String strLabel, double theValue) {
        this.m_TipStrings.set(nLineNum, strLabel + "COLON" + " ");
        String strFormattedValue = this.FmtValue(theValue, strLabel);
        this.m_TipStrings.set(nLineNum, this.m_TipStrings.get(nLineNum) + strFormattedValue);
        this.m_RectTipShape.width = this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(nLineNum), fm) > this.m_RectTipShape.width - 6 ? this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(nLineNum), fm) + 6 : this.m_RectTipShape.width;
    }

    void FmtDeveloperSeriesAndGroupID(FontMetrics fm) {
        int LineNo = 2;
        this.m_TipStrings.set(LineNo, "SERIESCOLON ");
        this.m_TipStrings.set(LineNo, this.m_TipStrings.get(LineNo) + this.m_detObj.getSeriesID());
        this.m_RectTipShape.width = this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(LineNo), fm) > this.m_RectTipShape.width - 6 ? this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(LineNo), fm) + 6 : this.m_RectTipShape.width;
        LineNo = 3;
        this.m_TipStrings.set(LineNo, "GROUPCOLON ");
        this.m_TipStrings.set(LineNo, this.m_TipStrings.get(LineNo) + this.m_detObj.getGroupID());
        this.m_RectTipShape.width = this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(LineNo), fm) > this.m_RectTipShape.width - 6 ? this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(LineNo), fm) + 6 : this.m_RectTipShape.width;
    }

    void FmtUserSeriesAndGroupID(FontMetrics fm) {
        int LineNo = 0;
        this.m_TipStrings.set(LineNo, this.m_Perspective.getSeriesLabel(this.m_detObj.getSeriesID()));
        this.m_RectTipShape.width = this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(LineNo), fm) > this.m_RectTipShape.width - 6 ? this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(LineNo), fm) + 6 : this.m_RectTipShape.width;
        LineNo = 1;
        this.m_TipStrings.set(LineNo, this.m_Perspective.getGroupLabel(this.m_detObj.getGroupID()));
        this.m_RectTipShape.width = this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(LineNo), fm) > this.m_RectTipShape.width - 6 ? this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(LineNo), fm) + 6 : this.m_RectTipShape.width;
    }

    void FmtUserReferenceLineID(FontMetrics fm) {
        this.m_RectTipShape.width = 0;
        this.m_RectTipShape.height = 0;
        int LineNo = 0;
        this.m_TipStrings.set(LineNo, this.m_detObj.getReferenceLabel());
        if (this.m_TipStrings.get(LineNo) != null) {
            this.m_RectTipShape.width = this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(LineNo), fm) > this.m_RectTipShape.width - 6 ? this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(LineNo), fm) + 6 : this.m_RectTipShape.width;
        }
    }

    void FmtDevelopersPareto(FontMetrics fm) {
        int LineNo = 2;
        this.m_TipStrings.set(LineNo, "SERIESCOLON ");
        this.m_TipStrings.set(LineNo, this.m_TipStrings.get(LineNo) + this.m_Perspective.getDisplayParetoSeries());
        this.m_RectTipShape.width = this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(LineNo), fm) > this.m_RectTipShape.width - 6 ? this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(LineNo), fm) + 6 : this.m_RectTipShape.width;
        LineNo = 3;
        this.m_TipStrings.set(LineNo, "GROUPCOLON ");
        this.m_TipStrings.set(LineNo, this.m_TipStrings.get(LineNo) + this.m_detObj.getGroupID());
        this.m_RectTipShape.width = this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(LineNo), fm) > this.m_RectTipShape.width - 6 ? this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(LineNo), fm) + 6 : this.m_RectTipShape.width;
    }

    void DeveloperSetToolTipHeight(FontMetrics fm, String Description, int TipWidth, int nRemainingSingleLines) {
        int nHeight = this.m_Perspective.getFontMetricsResolver().getHeight(fm);
        if (this.m_Perspective.getFontMetricsResolver().stringWidth(Description, fm) < TipWidth) {
            nHeight += this.m_Perspective.getFontMetricsResolver().getHeight(fm);
        } else {
            double fFlooredQuotient;
            double quotient = (double)this.m_Perspective.getFontMetricsResolver().stringWidth(Description, fm) / (double)TipWidth;
            if (quotient - (fFlooredQuotient = Math.floor(quotient)) > 0.1) {
                fFlooredQuotient += 1.0;
            }
            nHeight = (int)((double)nHeight + fFlooredQuotient * (double)this.m_Perspective.getFontMetricsResolver().getHeight(fm));
        }
        nHeight += this.m_Perspective.getFontMetricsResolver().getHeight(fm) * nRemainingSingleLines;
        this.m_RectTipShape.height = nHeight += 2;
    }

    void DeveloperFmtGENERAL(FontMetrics fm) {
        int LineNo;
        double fValue;
        block13: {
            fValue = 0.0;
            LineNo = 4;
            if (this.m_Chart instanceof JChart_2D_Pareto) {
                try {
                    int gpID = this.m_detObj.getGroupID();
                    int nSeries = this.m_Perspective.getDisplayParetoSeries();
                    if (gpID < 0) break block13;
                    if (this.ParetoRelated()) {
                        fValue = ((JChart_2D_Standard)this.m_Chart).getParetoValue(nSeries, gpID);
                    } else {
                        fValue = this.m_Perspective.getDataAsDouble(nSeries, this.m_detObj.getGroupID());
                        if (Double.isNaN(fValue)) {
                            fValue = 0.0;
                        }
                    }
                }
                catch (AssertionException e) {
                    fValue = 0.0;
                }
            } else if (this.m_Chart instanceof JChart_2D_PieBar) {
                if (this.m_detObj.getGroupID() <= 0) {
                    fValue = ((JChart_2D_Pie)this.m_Chart).getSeriesTotal(this.m_detObj.getSeriesID());
                }
            } else {
                try {
                    fValue = this.m_Perspective.getDataAsDouble(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
                    if (Double.isNaN(fValue)) {
                        fValue = 0.0;
                    }
                }
                catch (AssertionException e) {
                    fValue = 0.0;
                }
            }
        }
        this.m_TipStrings.set(LineNo, "VALUECOLON ");
        this.m_TipStrings.set(LineNo, this.m_TipStrings.get(LineNo) + Double.toString(fValue));
        this.m_RectTipShape.width = this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(LineNo), fm) > this.m_RectTipShape.width - 6 ? this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(LineNo), fm) + 6 : this.m_RectTipShape.width;
        this.m_nNumToolTipLines = 3;
    }

    void DeveloperFmtXY(FontMetrics fm) {
        double theValue;
        int LineNo = 4;
        try {
            theValue = ((JChart_2D_Scat)this.m_Chart).getXValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "XVALUE", theValue);
        LineNo = 5;
        try {
            theValue = ((JChart_2D_Scat)this.m_Chart).getYValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "YVALUE", theValue);
        this.m_nNumToolTipLines = 4;
    }

    void DeveloperFmtXY_LBL(FontMetrics fm) {
        String strLabel;
        double theValue;
        int LineNo = 4;
        try {
            theValue = ((JChart_2D_Scat)this.m_Chart).getLabelXValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "XVALUE", theValue);
        LineNo = 5;
        try {
            theValue = ((JChart_2D_Scat)this.m_Chart).getLabelYValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "YVALUE", theValue);
        LineNo = 6;
        try {
            strLabel = ((JChart_2D_Scat)this.m_Chart).getLabelValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            strLabel = "";
        }
        this.m_TipStrings.set(LineNo, "LABELCOLON " + strLabel);
        this.m_RectTipShape.width = this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(LineNo), fm) > this.m_RectTipShape.width - 6 ? this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(LineNo), fm) + 6 : this.m_RectTipShape.width;
        this.m_nNumToolTipLines = 5;
    }

    void DeveloperFmtXYZ(FontMetrics fm) {
        double theValue;
        int LineNo = 4;
        try {
            theValue = ((JChart_2D_Scat)this.m_Chart).getXYZ_XValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "XVALUE", theValue);
        LineNo = 5;
        try {
            theValue = ((JChart_2D_Scat)this.m_Chart).getXYZ_YValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "YVALUE", theValue);
        LineNo = 6;
        try {
            theValue = ((JChart_2D_Scat)this.m_Chart).getXYZ_ZValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "ZVALUE", theValue);
        this.m_nNumToolTipLines = 5;
    }

    void DeveloperFmtHL(FontMetrics fm) {
        double theValue;
        int LineNo = 4;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "HIGH", theValue);
        LineNo = 5;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "LOW", theValue);
        this.m_nNumToolTipLines = 4;
    }

    void DeveloperFmtHLC(FontMetrics fm) {
        double theValue;
        int LineNo = 4;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "HIGH", theValue);
        LineNo = 5;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "LOW", theValue);
        LineNo = 6;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getCloseValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "CLOSE", theValue);
        this.m_nNumToolTipLines = 5;
    }

    void DeveloperFmtOHLC(FontMetrics fm) {
        double theValue;
        int LineNo = 4;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getOpenValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "OPEN", theValue);
        LineNo = 5;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "HIGH", theValue);
        LineNo = 6;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "LOW", theValue);
        LineNo = 7;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getCloseValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "CLOSE", theValue);
        this.m_nNumToolTipLines = 6;
    }

    void DeveloperFmtHL_VOL(FontMetrics fm) {
        double theValue;
        int LineNo = 4;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "HIGH", theValue);
        LineNo = 5;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "LOW", theValue);
        LineNo = 6;
        try {
            int nSeries = 0;
            theValue = ((JChart_2D_Hilo)this.m_Chart).getVolumeValue(nSeries, this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "VOLUME", theValue);
        this.m_nNumToolTipLines = 5;
    }

    void DeveloperFmtHLC_VOL(FontMetrics fm) {
        double theValue;
        int LineNo = 4;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "HIGH", theValue);
        LineNo = 5;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "LOW", theValue);
        LineNo = 6;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getCloseValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "CLOSE", theValue);
        LineNo = 7;
        try {
            int nSeries = 0;
            theValue = ((JChart_2D_Hilo)this.m_Chart).getVolumeValue(nSeries, this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "VOLUME", theValue);
        this.m_nNumToolTipLines = 6;
    }

    void DeveloperFmtOHLC_VOL(FontMetrics fm) {
        double theValue;
        int LineNo = 4;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getOpenValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "OPEN", theValue);
        LineNo = 5;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "HIGH", theValue);
        LineNo = 6;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "LOW", theValue);
        LineNo = 7;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getCloseValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "CLOSE", theValue);
        LineNo = 8;
        try {
            int nSeries = 0;
            theValue = ((JChart_2D_Hilo)this.m_Chart).getVolumeValue(nSeries, this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "VOLUME", theValue);
        this.m_nNumToolTipLines = 7;
    }

    void UserSetToolTipHeight(FontMetrics fm) {
        this.m_RectTipShape.height = 0;
        for (int nIdx = 0; nIdx < this.m_nNumToolTipLines; ++nIdx) {
            if (this.m_TipStrings.get(nIdx).length() <= 0) continue;
            this.m_RectTipShape.height += this.m_Perspective.getFontMetricsResolver().getHeight(fm);
        }
    }

    void UserFmtReferenceLineGENERAL(FontMetrics fm) {
        this.m_RectTipShape.width = 0;
        this.m_RectTipShape.height = 0;
        double theValue = 0.0;
        int LineNo = 0;
        theValue = this.m_detObj.getReferenceData();
        this.FmtSingleValue(fm, LineNo, "VALUE", theValue);
        this.m_nNumToolTipLines = 1;
    }

    void UserFmtGENERAL(FontMetrics fm) {
        int nSeries = this.m_detObj.getSeriesID();
        int nGroup = this.m_detObj.getGroupID();
        int LineNo = 2;
        double theValue = 0.0;
        if (this.m_Chart instanceof JChart_2D_PieBar) {
            if (nGroup <= 0) {
                try {
                    theValue = ((JChart_2D_Pie)this.m_Chart).getSeriesTotal(nSeries);
                    this.FmtSingleValue(fm, LineNo, "VALUE", theValue);
                }
                catch (AssertionException e) {
                    theValue = 0.0;
                }
            }
        } else if (this.m_Chart instanceof JChart_2D_Pareto) {
            nSeries = this.m_Perspective.getDisplayParetoSeries();
            try {
                if (this.ParetoRelated()) {
                    theValue = ((JChart_2D_Standard)this.m_Chart).getParetoValue(nSeries, nGroup);
                } else {
                    theValue = this.m_Perspective.getDataAsDouble(nSeries, nGroup);
                    if (Double.isNaN(theValue)) {
                        theValue = 0.0;
                    }
                }
            }
            catch (AssertionException e) {
                theValue = 0.0;
            }
            this.FmtSingleValue(fm, LineNo, "VALUE", theValue);
        } else {
            try {
                theValue = this.m_Perspective.getDataAsDouble(nSeries, nGroup);
                if (Double.isNaN(theValue)) {
                    theValue = 0.0;
                }
                this.FmtSingleValue(fm, LineNo, "VALUE", theValue);
            }
            catch (AssertionException e) {
                theValue = 0.0;
            }
        }
        this.m_nNumToolTipLines = 3;
    }

    void UserFmtXY(FontMetrics fm) {
        double theValue;
        int LineNo = 2;
        try {
            theValue = this.m_Chart instanceof JChart_2D_Scat ? ((JChart_2D_Scat)this.m_Chart).getXValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : (this.m_Chart instanceof JChart_2D_Polar ? ((JChart_2D_Polar)this.m_Chart).getXValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0);
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "XVALUE", theValue);
        LineNo = 3;
        try {
            theValue = this.m_Chart instanceof JChart_2D_Scat ? ((JChart_2D_Scat)this.m_Chart).getYValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : (this.m_Chart instanceof JChart_2D_Polar ? ((JChart_2D_Polar)this.m_Chart).getYValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0);
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "YVALUE", theValue);
        this.m_nNumToolTipLines = 4;
    }

    void UserFmtXY_LBL(FontMetrics fm) {
        String strLabel;
        double theValue;
        int LineNo = 2;
        try {
            theValue = ((JChart_2D_Scat)this.m_Chart).getLabelXValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "XVALUE", theValue);
        LineNo = 3;
        try {
            theValue = ((JChart_2D_Scat)this.m_Chart).getLabelYValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "YVALUE", theValue);
        LineNo = 4;
        try {
            strLabel = ((JChart_2D_Scat)this.m_Chart).getLabelValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            strLabel = "";
        }
        this.m_TipStrings.set(LineNo, "LABELCOLON " + strLabel);
        this.m_RectTipShape.width = this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(LineNo), fm) > this.m_RectTipShape.width - 6 ? this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(LineNo), fm) + 6 : this.m_RectTipShape.width;
        this.m_nNumToolTipLines = 5;
    }

    void UserFmtXYZ(FontMetrics fm) {
        double theValue;
        int LineNo = 2;
        try {
            theValue = ((JChart_2D_Scat)this.m_Chart).getXYZ_XValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "XVALUE", theValue);
        LineNo = 3;
        try {
            theValue = ((JChart_2D_Scat)this.m_Chart).getXYZ_YValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "YVALUE", theValue);
        LineNo = 4;
        try {
            theValue = ((JChart_2D_Scat)this.m_Chart).getXYZ_ZValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "ZVALUE", theValue);
        this.m_nNumToolTipLines = 5;
    }

    void UserFmtHL(FontMetrics fm) {
        double theValue;
        int LineNo = 2;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "HIGH", theValue);
        LineNo = 3;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "LOW", theValue);
        this.m_nNumToolTipLines = 4;
    }

    void UserFmtHLC(FontMetrics fm) {
        double theValue;
        int LineNo = 2;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "HIGH", theValue);
        LineNo = 3;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "LOW", theValue);
        LineNo = 4;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getCloseValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "CLOSE", theValue);
        this.m_nNumToolTipLines = 5;
    }

    void UserFmtOHLC(FontMetrics fm) {
        double theValue;
        int LineNo = 2;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getOpenValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "OPEN", theValue);
        LineNo = 3;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "HIGH", theValue);
        LineNo = 4;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "LOW", theValue);
        LineNo = 5;
        try {
            theValue = ((JChart_2D_Hilo)this.m_Chart).getCloseValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "CLOSE", theValue);
        this.m_nNumToolTipLines = 6;
    }

    void UserFmtHL_VOL(FontMetrics fm) {
        double theValue;
        int LineNo = 2;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "HIGH", theValue);
        LineNo = 3;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "LOW", theValue);
        LineNo = 4;
        try {
            int nSeries = 0;
            theValue = ((JChart_2D_Hilo)this.m_Chart).getVolumeValue(nSeries, this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "VOLUME", theValue);
        this.m_nNumToolTipLines = 5;
    }

    void UserFmtHLC_VOL(FontMetrics fm) {
        double theValue;
        int LineNo = 2;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "HIGH", theValue);
        LineNo = 3;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "LOW", theValue);
        LineNo = 4;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getCloseValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "CLOSE", theValue);
        LineNo = 5;
        try {
            int nSeries = 0;
            theValue = ((JChart_2D_Hilo)this.m_Chart).getVolumeValue(nSeries, this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "VOLUME", theValue);
        this.m_nNumToolTipLines = 6;
    }

    void UserFmtOHLC_VOL(FontMetrics fm) {
        double theValue;
        int LineNo = 2;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getOpenValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "OPEN", theValue);
        LineNo = 3;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "HIGH", theValue);
        LineNo = 4;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "LOW", theValue);
        LineNo = 5;
        try {
            theValue = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getCloseValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "CLOSE", theValue);
        LineNo = 6;
        try {
            int nSeries = 0;
            theValue = ((JChart_2D_Hilo)this.m_Chart).getVolumeValue(nSeries, this.m_detObj.getGroupID());
        }
        catch (AssertionException e) {
            theValue = 0.0;
        }
        this.FmtSingleValue(fm, LineNo, "VOLUME", theValue);
        this.m_nNumToolTipLines = 7;
    }

    void UserFmtGANTT(FontMetrics fm) {
        int LineNo = 0;
        this.m_TipStrings.set(LineNo, this.m_Perspective.getAlertLabel(this.m_detObj.getSeriesID()));
        this.m_RectTipShape.width = this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(LineNo), fm) > this.m_RectTipShape.width - 6 ? this.m_Perspective.getFontMetricsResolver().stringWidth(this.m_TipStrings.get(LineNo), fm) + 6 : this.m_RectTipShape.width;
        this.m_nNumToolTipLines = 1;
    }

    public String[] getUserTooltipStrings(DetObj obj) {
        String[] strArray = null;
        if (this.m_Perspective.isToolTipCallBack()) {
            JGraphType aGraphType = this.m_Perspective.getJGraphType();
            DataFormat aDataFormat = aGraphType.getDataFormat();
            this.m_Chart = this.m_Perspective.getGraphObject();
            this.m_detObj = obj;
            TDGMouseState state = new TDGMouseState(null, obj);
            String strCustomToolTip = this.m_Perspective.getToolTipCallBack().getDynamicToolTip(state, this.m_Perspective.getToolTipMode());
            if (strCustomToolTip != null && strCustomToolTip.length() > 0) {
                this.clearToolTip();
                this.m_nNumToolTipLines = ToolTips.CustomToolTipIntoLines(strCustomToolTip, this.m_TipStrings);
                this.setTooltipNullString(null);
                this.CustomToolTipMacros(aDataFormat, obj.getSeriesID(), obj.getGroupID(), obj);
                strArray = new String[this.m_nNumToolTipLines];
                for (int i = 0; i < this.m_nNumToolTipLines; ++i) {
                    strArray[i] = this.m_TipStrings.get(i);
                }
            }
            this.m_detObj = null;
        }
        return strArray;
    }

    @Concealed
    public String[] getCustomTooltipStrings(int nSeries, int nGroup, String tokens) {
        String[] strArray = null;
        if (this.m_Perspective.isToolTipCallBack()) {
            JGraphType aGraphType = this.m_Perspective.getJGraphType();
            DataFormat aDataFormat = aGraphType.getDataFormat();
            this.m_Chart = this.m_Perspective.getGraphObject();
            if (tokens != null && tokens.length() > 0) {
                this.clearToolTip();
                this.m_nNumToolTipLines = ToolTips.CustomToolTipIntoLines(tokens, this.m_TipStrings);
                this.CustomToolTipMacros(aDataFormat, nSeries, nGroup, null);
                strArray = new String[this.m_nNumToolTipLines];
                for (int i = 0; i < this.m_nNumToolTipLines; ++i) {
                    strArray[i] = this.m_TipStrings.get(i);
                }
            }
        }
        return strArray;
    }

    @Concealed
    public void setTooltipNullString(String nullString) {
        this.m_nullString = nullString;
    }

    public boolean ParetoRelated() {
        return this.ParetoRelated(this.m_detObj.getObjectID());
    }

    private boolean ParetoRelated(int objectID) {
        return objectID == 473 || objectID == 474 || objectID == 475 || objectID == 476;
    }

    void timeOutTimer_TimerEvent(ActionEvent event) {
        this.timeOutTimer.stop();
        if (this.m_Perspective.getToolTipDisplay()) {
            this.m_Perspective.toolTipRepaint(false);
        }
    }

    @Concealed
    public static String convertMarkerTooltipTemplate(String template) {
        if (template == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(template);
        ToolTips.replace(sb, "NEW_LINE", RETURN_MACRO);
        ToolTips.replace(sb, "SERIES_LABEL", SERIES_LABEL_MACRO);
        ToolTips.replace(sb, "GROUP_LABEL", GROUP_LABEL_MACRO);
        ToolTips.replace(sb, "X_VALUE", X_VALUE_MACRO);
        ToolTips.replace(sb, "Y_VALUE", Y_VALUE_MACRO);
        ToolTips.replace(sb, "Z_VALUE", Z_VALUE_MACRO);
        ToolTips.replace(sb, "PIE_VALUE", Y_VALUE_MACRO);
        ToolTips.replace(sb, "PIE_PERCENT", PIE_PERCENTAGE_VALUE_MACRO);
        ToolTips.replace(sb, "ACTUAL_VALUE", FUNNEL_ACTUAL_VALUE_MACRO);
        ToolTips.replace(sb, "TARGET_VALUE", FUNNEL_TARGET_VALUE_MACRO);
        ToolTips.replace(sb, "HIGH_VALUE", HILO_HIGH_VALUE_MACRO);
        ToolTips.replace(sb, "LOW_VALUE", HILO_LOW_VALUE_MACRO);
        ToolTips.replace(sb, "CLOSE_VALUE", HILO_CLOSE_VALUE_MACRO);
        ToolTips.replace(sb, "OPEN_VALUE", HILO_OPEN_VALUE_MACRO);
        ToolTips.replace(sb, "VOLUME_VALUE", HILO_VOLUME_VALUE_MACRO);
        ToolTips.replace(sb, "CUM_VALUE", CUMULATIVE_STACKED_VALUE_MACRO);
        ToolTips.replace(sb, "CUM_PERCENT", CUMULATIVE_PERCENTAGE_VALUE_MACRO);
        ToolTips.replace(sb, "MIN_VALUE", BOXPLOT_MIN_VALUE_MACRO);
        ToolTips.replace(sb, "TEN_VALUE", BOXPLOT_TEN_VALUE_MACRO);
        ToolTips.replace(sb, "Q1_VALUE", BOXPLOT_Q1_VALUE_MACRO);
        ToolTips.replace(sb, "MEDIAN_VALUE", BOXPLOT_MEDIAN_VALUE_MACRO);
        ToolTips.replace(sb, "Q3_VALUE", BOXPLOT_Q3_VALUE_MACRO);
        ToolTips.replace(sb, "NINETY_VALUE", BOXPLOT_NINETY_VALUE_MACRO);
        ToolTips.replace(sb, "MAX_VALUE", BOXPLOT_MAX_VALUE_MACRO);
        return sb.toString();
    }

    private static void replace(StringBuilder str, String target, String replacement) {
        int targetLength = target.length();
        int index = str.indexOf(target);
        while (index >= 0) {
            str.replace(index, index + targetLength, replacement);
            index = str.indexOf(target);
        }
    }

    public static boolean useMarkerTooltipTemplate(int objectID, int graphType) {
        switch (objectID) {
            case 277: 
            case 312: 
            case 313: {
                if (graphType == 96) {
                    return false;
                }
            }
            case 259: 
            case 298: 
            case 299: 
            case 300: 
            case 303: 
            case 306: 
            case 307: 
            case 308: 
            case 319: 
            case 320: 
            case 474: 
            case 602: 
            case 606: 
            case 621: {
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (ToolTips.this.timeOutTimer != null && object == ToolTips.this.timeOutTimer) {
                ToolTips.this.timeOutTimer_TimerEvent(event);
            }
        }
    }
}

