/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import oracle.dss.graph.pfj.GraphExportXMLWriter;
import oracle.dss.graph.pfj.GraphSVGWriter;
import oracle.dss.graph.pfj.ObjClassID;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.presutil.PresUtils;

public abstract class DetObj
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final int SLOP_THICKNESS = 5;
    protected IdentObj m_id;
    protected BlackBoxIF m_blackBox;
    protected boolean m_bDetectable;
    protected boolean m_bHiliteable;
    private boolean m_bMoveable;
    private double m_nData;
    protected String m_szRefLabel;
    protected Detectiv m_Detectiv;
    protected List m_groups = null;
    protected Map m_visualEffectsMap;
    private boolean m_bReferenceObj = false;

    protected DetObj(Detectiv detectiv, IdentObj id, BlackBoxIF blackBox) {
        this(detectiv, id, blackBox, false, true, true);
    }

    protected DetObj(Detectiv detectiv, IdentObj id, BlackBoxIF blackBox, boolean bMoveable, boolean bDetectable) {
        this(detectiv, id, blackBox, bMoveable, bDetectable, true);
    }

    protected DetObj(Detectiv detectiv, IdentObj id, BlackBoxIF blackBox, boolean bMoveable, boolean bDetectable, boolean bHiliteable) {
        IdentObj erID;
        this.m_id = id;
        this.m_blackBox = blackBox;
        this.m_bMoveable = bMoveable;
        this.m_bDetectable = bDetectable;
        this.m_bHiliteable = bHiliteable;
        this.m_Detectiv = detectiv;
        this.m_bReferenceObj = false;
        if (this.m_Detectiv.m_bExceptionalFlag && id.canBeExceptional() && this.m_Detectiv.isExceptionalAllowed() && (erID = this.m_Detectiv.getExceptionalID(id)) != null) {
            int oExceptional = ObjClassID.addExceptionalOffset(0);
            this.m_id = new IdentObj(oExceptional, id.getSeriesID(), id.getGroupID());
            this.m_blackBox = new BlackBoxObj(this.m_Detectiv.getPerspective(), erID);
            oExceptional = ObjClassID.addExceptionalOffset(id.getObjectID());
            this.m_id = new IdentObj(oExceptional, id.getSeriesID(), id.getGroupID());
            this.m_id.setMiscID(id.getMiscID());
        }
        this.m_Detectiv.insertDetNode(this);
    }

    public BlackBoxIF getBlackBox() {
        return this.m_blackBox;
    }

    public int getGroupID() {
        return this.m_id.m_groupID;
    }

    public IdentObj getIdentID() {
        return new IdentObj(this.m_id);
    }

    public IdentObj getIdentIDRef() {
        return this.m_id;
    }

    public Rectangle getLooseBounds() {
        return this.getBounds();
    }

    public List getGroupList() {
        return this.m_groups;
    }

    public int getObjectID() {
        return this.m_id.m_objectID;
    }

    public int getSeriesID() {
        return this.m_id.m_seriesID;
    }

    public int getMiscID() {
        return this.m_id.m_miscID;
    }

    public int getStackID() {
        return this.m_id.m_stackID;
    }

    public boolean idMatchExactly(IdentObj id) {
        return this.m_id.equals(id);
    }

    public boolean isDetectable() {
        return this.m_bDetectable;
    }

    public boolean isExceptional() {
        return this.m_id.isExceptional();
    }

    public boolean isHiliteable() {
        return this.m_bHiliteable;
    }

    public boolean isMoveable() {
        return this.m_bMoveable;
    }

    public boolean isSelRelated(DetObj dto, int nColorMode) {
        boolean bRelated = false;
        if (nColorMode == 3) {
            if (this.getIdentID().isColorByHeightRelated()) {
                if (dto.getIdentID().isColorByHeightRelated()) {
                    bRelated = this.m_blackBox.equals(dto.m_blackBox);
                }
            } else {
                bRelated = this.getObjectID() == dto.getObjectID() && dto.isDetectable();
            }
        } else if (this.getIdentID().isSeriesRelated()) {
            if (dto.getIdentID().isSeriesRelated()) {
                bRelated = nColorMode == 2 ? this.getGroupID() == dto.getGroupID() : this.getSeriesID() == dto.getSeriesID();
            }
        } else {
            bRelated = this.getIdentID().isGroupRelated() ? dto.getIdentID().isGroupRelated() && this.getGroupID() == dto.getGroupID() : this.getObjectID() == dto.getObjectID() && dto.isDetectable();
        }
        return bRelated;
    }

    public void paint(Graphics g, VC vc) {
        switch (this.getIdentID().getObjectID()) {
            case 3006: 
            case 3012: 
            case 3018: 
            case 3024: {
                return;
            }
        }
        if (!this.m_Detectiv.getPerspective().isScrollBarsOn()) {
            switch (this.getIdentID().getObjectID()) {
                case 3000: 
                case 3001: 
                case 3002: 
                case 3003: 
                case 3004: 
                case 3005: 
                case 3007: 
                case 3008: 
                case 3009: 
                case 3010: 
                case 3011: 
                case 3013: 
                case 3014: 
                case 3015: 
                case 3016: 
                case 3017: 
                case 3019: 
                case 3020: 
                case 3021: 
                case 3022: 
                case 3023: 
                case 3025: {
                    return;
                }
            }
        }
        if (!this.m_Detectiv.getPerspective().isScrollBarsOn()) {
            switch (this.getIdentID().getObjectID()) {
                case 3000: 
                case 3001: 
                case 3002: 
                case 3003: 
                case 3004: 
                case 3005: 
                case 3007: 
                case 3008: 
                case 3009: 
                case 3010: 
                case 3011: 
                case 3013: 
                case 3014: 
                case 3015: 
                case 3016: 
                case 3017: 
                case 3019: 
                case 3020: 
                case 3021: 
                case 3022: 
                case 3023: 
                case 3025: {
                    return;
                }
            }
        }
        this.paintIt(g, vc);
    }

    public void renderSVG(Map context) throws IOException, Exception {
        GraphSVGWriter writer = (GraphSVGWriter)context.get("svgWriter");
        int mode = (Integer)context.get("svgMode");
        IdentObj id = this.getIdentID();
        if ((mode & 0x40) != 0 && writer.isDataScrollingSupported() && this.m_Detectiv.getPerspective().isGroupScrollerPresent() && (id.equals(this.m_Detectiv.getPerspective().getGroupScroller()) || id.equals(this.m_Detectiv.getPerspective().getGroupScrollerThumb()) || id.equals(this.m_Detectiv.getPerspective().getGroupScrollerEditBox()) || id.equals(this.m_Detectiv.getPerspective().getGroupScrollerEditLeft()) || id.equals(this.m_Detectiv.getPerspective().getGroupScrollerEditThumb()) || id.equals(this.m_Detectiv.getPerspective().getGroupScrollerEditRight()))) {
            return;
        }
        switch (id.getObjectID()) {
            case 3000: 
            case 3001: 
            case 3002: 
            case 3003: 
            case 3004: 
            case 3005: 
            case 3006: 
            case 3007: 
            case 3008: 
            case 3009: 
            case 3010: 
            case 3011: 
            case 3012: 
            case 3013: 
            case 3014: 
            case 3015: 
            case 3016: 
            case 3017: 
            case 3018: 
            case 3019: 
            case 3020: 
            case 3021: 
            case 3022: 
            case 3023: 
            case 3024: 
            case 3025: {
                return;
            }
        }
        writer.init(this);
        this.renderItToSVG(context);
    }

    public void renderXML(Map context) throws IOException, Exception {
        GraphExportXMLWriter writer = (GraphExportXMLWriter)context.get("xmlWriter");
        writer.init(this);
        this.renderItToXML(context);
    }

    public String toString() {
        return this.m_id.toString();
    }

    public Polygon rectToPoly(Rectangle rect) {
        return PresUtils.rectToPoly(rect);
    }

    public void setReferenceData(double data) {
        this.m_nData = data;
    }

    public void setReferenceLabel(String str) {
        this.m_szRefLabel = str;
    }

    public double getReferenceData() {
        return this.m_nData;
    }

    public String getReferenceLabel() {
        return this.m_szRefLabel;
    }

    public boolean IsReferenceObject() {
        return this.m_bReferenceObj;
    }

    public void setReferenceObject() {
        this.m_bReferenceObj = true;
    }

    public boolean getReferenceObject() {
        return this.m_bReferenceObj;
    }

    public void setVisualEffectsMap(Map map) {
        if (this.m_Detectiv.getPerspective().getDepthRadius() > 0 && this.m_Detectiv.getPerspective().getDepthAngle() > 0) {
            return;
        }
        if (this.m_Detectiv.getPerspective().getVisualEffects() != 0) {
            this.m_visualEffectsMap = map;
        }
    }

    public Map getVisualEffectsMap() {
        return this.m_visualEffectsMap;
    }

    public abstract Rectangle getBounds();

    public abstract void hilite(Graphics var1, VC var2);

    public abstract boolean isPointInObj(int var1, int var2, VC var3);

    public boolean isPointInObj(Point pt, VC vc) {
        return this.isPointInObj(pt.x, pt.y, vc);
    }

    public abstract void paintIt(Graphics var1, VC var2);

    public abstract void renderItToSVG(Map var1) throws IOException, Exception;

    public abstract void renderItToXML(Map var1) throws IOException, Exception;

    public abstract void setBounds(Rectangle var1);

    public abstract Polygon getShape(VC var1);
}

