/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import oracle.dss.graph.pfj.Access;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.Axis2DObj;
import oracle.dss.graph.pfj.AxisTemplate;
import oracle.dss.graph.pfj.CircularAxisObj;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.ObjClassID;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.RangeSlider;
import oracle.dss.graph.pfj.SmartAxisBase;
import oracle.dss.graph.pfj.TDGNestedLabel;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.SimpleBlackBoxObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;
import oracle.dss.graph.pfj.event.TDGEventManager;
import oracle.dss.presutil.PresUtils;

public abstract class AxisObj
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final int kNOSKIP = 0;
    protected static final int kAUTOSKIP = 1;
    protected static final int kMANUALSKIP = 2;
    protected static final int GRID_TICK_NORMAL = 0;
    protected static final int GRID_TICK_NORMAL_WITH_TICK = 1;
    protected static final int GRID_TICK_INSIDE = 2;
    protected static final int GRID_TICK_OUTSIDE = 3;
    protected static final int GRID_TICK_SPANNING = 4;
    protected static final int GRID_TICK_AUTOMATIC = 5;
    protected static final int GRID_TICK_NONE = 6;
    protected static final int MAX_TITLE_HEIGHT = 2300;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_TOPLEFT = 2;
    public static final int ALIGN_TOP = 3;
    public static final int ALIGN_TOPRIGHT = 4;
    public static final int ALIGN_RIGHT = 5;
    public static final int ALIGN_BOTTOMRIGHT = 6;
    public static final int ALIGN_BOTTOM = 7;
    public static final int ALIGN_BOTTOMLEFT = 8;
    protected static final int AXISSIDE_LEFT = 0;
    protected static final int AXISSIDE_RIGHT = 1;
    protected static final int AXISSIDE_BOTH = 2;
    protected static final int CENTER_LINE_MISC_OFFSET = 1000;
    protected static final int NEXTLEVEL_LINE_MISC_OFFSET = 2000;
    protected static final int LEVEL_MISC_OFFSET = 1000;
    protected Perspective m_Perspective;
    protected Access m_Access;
    protected AxisTemplate m_template;
    protected boolean m_bAscending;
    protected int m_numSeries;
    protected int m_numGroups;
    protected int m_numTotalSeries;
    protected int m_numTotalGroups;
    protected boolean m_bReverseGroups;
    protected boolean m_bReverseSeries;
    protected int m_nAxisObjectID;
    protected boolean m_bDelayGridCalc;
    protected boolean m_bDrawGrids;
    protected double m_fAxisLengthRel;
    protected double m_fAxisPositionRel;
    protected boolean m_bDelayCalcLabels;
    protected int m_nAutoSkip;
    protected int m_nLabelBegin;
    protected int m_nSkipFactor = 0;
    protected boolean m_bSkippedLabels;
    protected int m_axisLabelTextSizeVC;
    protected int m_nOrdinalAxisType;
    protected int m_nNestingLevel;
    protected int m_nTopNestingLevel;
    protected boolean m_bNestedLabelBrackets;
    protected TDGNestedLabel m_cbO1Labels;
    protected SmartAxisBase m_SmartAxis;
    protected boolean m_continuousTimeAxis = false;
    JGraphType m_gt;
    protected boolean m_polarExcludeX1LastLabel = false;
    RangeSlider axisRS = null;

    public AxisObj(Perspective perspective, Access access, AxisTemplate template, boolean ascending, int nAxisOffset, int nAxisSize) {
        this.m_Perspective = perspective;
        this.m_gt = this.m_Perspective.getJGraphType();
        this.m_Access = access;
        this.m_template = template;
        this.m_bAscending = ascending;
        this.m_numSeries = access.getNumNonIgnoredSeries();
        this.m_numGroups = access.getNumGroups();
        this.m_numTotalSeries = access.getNumTotalSeries();
        this.m_numTotalGroups = access.getNumTotalGroups();
        this.m_bReverseGroups = this.m_Perspective.getReverseGroups();
        this.m_bReverseSeries = this.m_Perspective.getReverseSeries();
        this.m_nAxisObjectID = this.m_template.getAxis().getObjectID();
        this.m_fAxisLengthRel = (double)nAxisSize / 100.0;
        this.m_fAxisPositionRel = (double)nAxisOffset / 100.0;
        this.m_bDelayCalcLabels = false;
        this.m_bDrawGrids = true;
        this.m_axisLabelTextSizeVC = this.m_Perspective.getAxisTextAutofitMin();
        if (this.m_axisLabelTextSizeVC <= 10) {
            this.m_axisLabelTextSizeVC = 10;
        }
        this.m_nNestingLevel = 0;
        this.m_cbO1Labels = this.m_Perspective.getO1LabelCallBack();
        this.m_nTopNestingLevel = this.isO1WithNestedLabels() ? this.m_cbO1Labels.getNumLevels() - 1 : 0;
        this.m_bNestedLabelBrackets = this.m_Perspective.getDisplay(this.m_Perspective.getNestedO1LabelLine());
        this.m_SmartAxis = new SmartAxisBase();
    }

    public void calc() {
        this.m_SmartAxis.preCalc(this, this.m_Perspective);
        if (!this.m_bDelayCalcLabels) {
            try {
                this.calcLabels();
            }
            catch (Throwable e) {
                this.m_Perspective.getErrorHandler().error(e, this.getClass().getName(), "calc()");
            }
        }
        if (this.m_template.getAxisObjID() == 0 || this.m_template.getAxisObjID() == 1) {
            if (this.m_gt.isParetoType() || !this.m_gt.isBLAType()) {
                this.calculateGrid();
            }
        } else {
            this.calculateGrid();
        }
    }

    public void calculateGrid() {
        boolean bGridsDrawn;
        if (this.m_bDrawGrids && !(this instanceof CircularAxisObj) && !(bGridsDrawn = this.m_SmartAxis.calcGrids())) {
            this.calcGrids();
        }
    }

    protected void calcGrids() {
        SimpleBlackBoxObj blackbox;
        int nMajorGridLines = this.getNumMajorGrids();
        if (!this.m_bDrawGrids) {
            return;
        }
        if (this.getMinorGridDisplay(this.m_template)) {
            IdentObj newID;
            blackbox = new SimpleBlackBoxObj(this.m_Perspective, this.m_template.getMinor(), true);
            int nMisc = -3;
            double fPos = 0.0;
            IdentObj id = new IdentObj(this.m_template.getMinor());
            int nMinorGridLines = 0;
            if (this.isNumericAxis() && !this.isLogScale() && this.isMinorGridStepTypeAbsolute()) {
                nMinorGridLines = this.getNumMinorGridsAbsolute();
                for (int nMinor = 0; nMinor < nMinorGridLines; ++nMinor) {
                    newID = new IdentObj(id);
                    newID.setMiscID(nMisc++);
                    fPos = this.getMinorGridPosAbsolute(nMinor);
                    if (!(fPos > 0.0) || !(fPos < 1.0)) continue;
                    this.calcMinorGridLine(newID, fPos, blackbox);
                }
            } else {
                nMinorGridLines = this.getNumMinorGrids();
                for (int nMajor = 0; nMajor <= nMajorGridLines; ++nMajor) {
                    for (int nMinor = 0; nMinor < nMinorGridLines; ++nMinor) {
                        newID = new IdentObj(id);
                        newID.setMiscID(nMisc++);
                        fPos = this.getMinorGridPos(nMajor, nMinor);
                        if (!(fPos > 0.0) || !(fPos < 1.0)) continue;
                        this.calcMinorGridLine(newID, fPos, blackbox);
                    }
                }
            }
        }
        if (this.getMajorGridDisplay(this.m_template)) {
            blackbox = new SimpleBlackBoxObj(this.m_Perspective, this.m_template.getMajor(), true);
            IdentObj id = new IdentObj(this.m_template.getMajor());
            boolean startSkip = false;
            boolean SkipCount = false;
            for (int i = 0; i < nMajorGridLines; ++i) {
                boolean bIgnoreGridSkip;
                boolean bExpressGrid = true;
                if ((this.m_nAutoSkip == 1 || this.m_nAutoSkip == 2) && this.m_bSkippedLabels) {
                    bExpressGrid = i >= this.m_nLabelBegin && (i - this.m_nLabelBegin) % (this.m_nSkipFactor + 1) == 0;
                }
                boolean bl = bIgnoreGridSkip = this.m_Perspective.getIgnoreGridSkip() || this.m_template.isNumeric();
                if (bIgnoreGridSkip) {
                    bExpressGrid = true;
                }
                if (this.isO1WithNestedLabels()) {
                    List v;
                    bExpressGrid = false;
                    if (this.m_cbO1Labels.getNumLevels() > 1 && (v = this.m_cbO1Labels.getAllLabels(1)).size() > 1) {
                        for (int j = 1; j < v.size(); ++j) {
                            if (this.m_cbO1Labels.getParentIndex(j, 1) != i) continue;
                            bExpressGrid = true;
                        }
                    }
                }
                if (!bExpressGrid) continue;
                IdentObj newID = new IdentObj(id);
                newID.setMiscID(i - 3);
                this.calcMajorGridLine(newID, this.getMajorGridPos(i), blackbox);
            }
        }
    }

    protected void calcLabels() {
        Graphics gx = this.m_Perspective.getGraphicsContext();
        int nSide = this.getAxisSide();
        if (!this.m_Perspective.getDisplay(this.m_template.getLabel())) {
            if (this.m_bDrawGrids && this instanceof CircularAxisObj) {
                boolean bGridsDrawn = this.m_SmartAxis.calcGrids();
                if (!bGridsDrawn) {
                    this.calcGrids();
                }
            } else {
                this.drawAxisTitleWhenNoLabels(nSide, gx);
            }
            return;
        }
        int nNumLabels = this.getNumLabels();
        if (nNumLabels <= 0) {
            this.drawAxisTitleWhenNoLabels(nSide, gx);
            return;
        }
        IdentObj idLabel = this.m_template.getLabel();
        boolean bAutofit = this.m_Perspective.getAutofit(idLabel);
        int nAutoSkip = this.m_Perspective.getAutoSkip(idLabel);
        if (this.isO1WithNestedLabels()) {
            this.drawNestedO1Labels(gx, nSide);
            return;
        }
        ArrayList rVectLabels = new ArrayList(nNumLabels);
        List strVectLabels = this.getLabels();
        PfjAssert.pfjAssert(strVectLabels.size() == nNumLabels);
        VC vc = this.getAxisVC();
        int nLabelBegin = 0;
        int nSkipFactor = 0;
        boolean bLabelFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(idLabel);
        int nFontSizeVC = bLabelFontSizeAbsolute ? vc.destToVirtHeight(this.m_Perspective.getFontSize(idLabel)) : this.m_Perspective.getFontSizeVC(idLabel);
        int rotation = this.m_Perspective.getTextRotation(idLabel);
        int just = 1;
        if (!this.isVertical() && (rotation == 90 || rotation == 270) || this.isVertical() && rotation == 0) {
            just = 0;
        } else if (this.isVertical() && rotation == 90) {
            just = 3;
        }
        TextStyleObj textStyle = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(idLabel), this.m_Perspective.getFontStyle(idLabel), bLabelFontSizeAbsolute, this.m_Perspective.getFontSize(idLabel), nFontSizeVC, rotation, this.m_Perspective.getTextJustHoriz(idLabel), just, false, false, this.m_Perspective.getTextWrap(idLabel), this.m_Perspective.getLocale());
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, idLabel);
        List nVectRelLabelPos = this.getRelLabelPos(nNumLabels);
        int nO1LabelAutoAngle = this.m_Perspective.getO1LabelAutoAngle();
        if (nO1LabelAutoAngle != 0 && !this.isVertical()) {
            nAutoSkip = this.O1LabelAutoRotate(gx, 0, nNumLabels, rVectLabels, nVectRelLabelPos, blackBox, bAutofit, nAutoSkip, nLabelBegin, nSkipFactor, nFontSizeVC, textStyle, strVectLabels);
        }
        switch (nAutoSkip) {
            case 2: {
                this.m_bSkippedLabels = true;
                this.calcLabelsManualSkip(nSide, nNumLabels, nVectRelLabelPos, nFontSizeVC, textStyle, gx, bAutofit, nAutoSkip, blackBox);
                break;
            }
            case 1: {
                this.m_bSkippedLabels = this.calcLabelsAutoSkip(nSide, nNumLabels, nVectRelLabelPos, nFontSizeVC, textStyle, gx, bAutofit, nAutoSkip, blackBox);
                break;
            }
            default: {
                this.m_bSkippedLabels = false;
                this.calcLabelsNoSkip(nSide, nNumLabels, nVectRelLabelPos, nFontSizeVC, textStyle, gx, bAutofit, nAutoSkip, blackBox, rVectLabels, strVectLabels);
            }
        }
    }

    private void calcLabelsNoSkip(int nSide, int nNumLabels, List nVectRelLabelPos, int nFontSizeVC, TextStyleObj textStyle, Graphics gx, boolean bAutofit, int nAutoSkip, BlackBoxObj blackBox, List rVectLabels, List strVectLabels) {
        int nLabelBegin = 0;
        int nSkipFactor = 0;
        List nVectIdents = this.getLabelIdents();
        if ((nSide == 0 || nSide == 2) && this.isAxisLabelVisible(0)) {
            this.calcLabelsOneSide(gx, 0, nNumLabels, rVectLabels, nVectRelLabelPos, blackBox, bAutofit, nAutoSkip, nLabelBegin, nSkipFactor, nFontSizeVC, textStyle, strVectLabels, nVectIdents);
        }
        if (this.m_SmartAxis.isInQALabelMode()) {
            nNumLabels = strVectLabels.size();
        }
        if ((nSide == 1 || nSide == 2) && this.isAxisLabelVisible(1)) {
            this.calcLabelsOneSide(gx, 1, nNumLabels, rVectLabels, nVectRelLabelPos, blackBox, bAutofit, nAutoSkip, nLabelBegin, nSkipFactor, nFontSizeVC, textStyle, strVectLabels, nVectIdents);
        }
    }

    private boolean calcLabelsAutoSkip(int nSide, int nNumLabels, List nVectRelLabelPos, int nFontSizeVC, TextStyleObj textStyle, Graphics gx, boolean bAutofit, int nAutoSkip, BlackBoxObj blackBox) {
        boolean bSkippedLabels = false;
        if (this.m_template.isNumeric() || !(this instanceof Axis2DObj) || !this.isO1Axis()) {
            bSkippedLabels = this.calcLabelsAutoSkip3D(nSide, nNumLabels, nVectRelLabelPos, nFontSizeVC, textStyle, gx, bAutofit, nAutoSkip, blackBox);
        } else {
            if ((nSide == 0 || nSide == 2) && this.isAxisLabelVisible(0)) {
                bSkippedLabels = this.isVertical() ? this.calcLabelsAutoSkipFrameHeight(nSide, nNumLabels, nVectRelLabelPos, nFontSizeVC, textStyle, gx, bAutofit, nAutoSkip, blackBox) : this.calcLabelsAutoSkipFrameWidth(nSide, nNumLabels, nVectRelLabelPos, nFontSizeVC, textStyle, gx, bAutofit, nAutoSkip, blackBox);
            }
            if ((nSide == 1 || nSide == 2) && this.isAxisLabelVisible(1)) {
                bSkippedLabels = this.isVertical() ? this.calcLabelsAutoSkipFrameHeight(nSide, nNumLabels, nVectRelLabelPos, nFontSizeVC, textStyle, gx, bAutofit, nAutoSkip, blackBox) : this.calcLabelsAutoSkipFrameWidth(nSide, nNumLabels, nVectRelLabelPos, nFontSizeVC, textStyle, gx, bAutofit, nAutoSkip, blackBox);
            }
        }
        return bSkippedLabels;
    }

    private boolean calcLabelsAutoSkip3D(int nSide, int nNumLabels, List nVectLabelPos, int nFontSizeVC, TextStyleObj textStyle, Graphics gx, boolean bAutofit, int nAutoSkip, BlackBoxObj blackBox) {
        boolean bSkippedLabels = false;
        ArrayList rVectLabels = new ArrayList(nNumLabels);
        List sVectLabels = this.getLabels();
        List nVectIdents = this.getLabelIdents();
        ArrayList sVectSkipLabels = new ArrayList(nNumLabels);
        ArrayList sVectSkipIdents = null;
        if (!this.m_template.isNumeric()) {
            sVectSkipIdents = new ArrayList(nNumLabels);
        }
        ArrayList nVectSkipLabelPos = new ArrayList(nNumLabels);
        int nLabelBegin = 0;
        int nSkipFactor = 0;
        int nSkipLabels = 0;
        int nTextLargerThanBox = 0;
        int nAutoSkipMax = 25;
        boolean bOldTestLabelCalc = this.m_Perspective.getTestLabelCalc();
        this.m_Perspective.setTestLabelCalc(true);
        int nStopLoop = 0;
        while (nStopLoop < nAutoSkipMax) {
            boolean bLabelRotated;
            int j;
            ++nStopLoop;
            sVectSkipLabels.clear();
            if (sVectSkipIdents != null) {
                sVectSkipIdents.clear();
            }
            nVectSkipLabelPos.clear();
            nSkipLabels = 0;
            for (j = 0; j < nNumLabels; ++j) {
                sVectSkipLabels.add(sVectLabels.get(j));
                if (sVectSkipIdents != null) {
                    sVectSkipIdents.add(nVectIdents.get(j));
                }
                nVectSkipLabelPos.add(nVectLabelPos.get(j));
                ++nSkipLabels;
            }
            nTextLargerThanBox = this.calcLabelsOneSide(gx, nSide, nSkipLabels, rVectLabels, nVectSkipLabelPos, blackBox, bAutofit, nAutoSkip, nLabelBegin, nSkipFactor, nFontSizeVC, textStyle, sVectSkipLabels, sVectSkipIdents);
            if (nTextLargerThanBox != 0) {
                nLabelBegin = this.m_Perspective.getSkipBegin(this.m_template.getLabel());
                if (nLabelBegin < 0) {
                    nLabelBegin = 0;
                }
                if (nLabelBegin > nNumLabels - 1) {
                    nLabelBegin = nNumLabels - 1;
                }
                if (nSkipFactor == 0) {
                    nLabelBegin = 0;
                }
                if (nLabelBegin > nSkipFactor) {
                    nLabelBegin = 0;
                }
                bSkippedLabels = true;
                sVectSkipLabels.clear();
                if (sVectSkipIdents != null) {
                    sVectSkipIdents.clear();
                }
                nVectSkipLabelPos.clear();
                nSkipLabels = 0;
                for (j = 0; j < nNumLabels; ++j) {
                    if (j < nLabelBegin || (j - nLabelBegin) % (nSkipFactor + 1) != 0) continue;
                    sVectSkipLabels.add(sVectLabels.get(j));
                    if (sVectSkipIdents != null) {
                        sVectSkipIdents.add(nVectIdents.get(j));
                    }
                    nVectSkipLabelPos.add(nVectLabelPos.get(j));
                    ++nSkipLabels;
                }
                nTextLargerThanBox = this.calcLabelsOneSide(gx, nSide, nSkipLabels, rVectLabels, nVectSkipLabelPos, blackBox, bAutofit, nAutoSkip, nLabelBegin, nSkipFactor, nFontSizeVC, textStyle, sVectSkipLabels, sVectSkipIdents);
            }
            boolean bl = bLabelRotated = textStyle.getRotationAngle() != 0;
            if (this.isVertical() ? (bLabelRotated ? nTextLargerThanBox != 2 && nTextLargerThanBox != 3 : nTextLargerThanBox != 1 && nTextLargerThanBox != 3) : (bLabelRotated ? nTextLargerThanBox != 1 && nTextLargerThanBox != 3 : nTextLargerThanBox != 2 && nTextLargerThanBox != 3)) break;
            ++nSkipFactor;
        }
        this.m_Perspective.setTestLabelCalc(bOldTestLabelCalc);
        this.calcLabelsOneSide(gx, nSide, nSkipLabels, rVectLabels, nVectSkipLabelPos, blackBox, bAutofit, nAutoSkip, nLabelBegin, nSkipFactor, nFontSizeVC, textStyle, sVectSkipLabels, sVectSkipIdents);
        return bSkippedLabels;
    }

    private int O1LabelAutoRotate(Graphics gx, int nSide, int nNumLabels, List rVectLabels, List nVectLabelPos, BlackBoxObj blackBox, boolean bAutofit, int nAutoSkip, int nLabelBegin, int nSkipFactor, int nFontSizeVC, TextStyleObj textStyle, List sVectLabels) {
        VC vc = this.getAxisVC();
        if ((this.m_gt.isBLAType() || this.m_gt.isStockType()) && !this.m_gt.isOrientHorz() && this.isO1Axis()) {
            int nTextLargerThanBox = this.labelsOverlap(gx, 0, nNumLabels, rVectLabels, nVectLabelPos, blackBox, bAutofit, nAutoSkip, nLabelBegin, nSkipFactor, nFontSizeVC, textStyle, sVectLabels);
            Dimension dimLargestOverlapLabel = textStyle.getDimLargeTextVC(vc);
            TDGEventManager evtMgr = this.m_Perspective.getEventManager();
            switch (nTextLargerThanBox) {
                case 0: {
                    if (nAutoSkip != 1) break;
                    nAutoSkip = 0;
                    break;
                }
                case 1: {
                    dimLargestOverlapLabel.width = 0;
                    evtMgr.notifyPerspectiveListener((Object)this.m_Perspective, 3982, dimLargestOverlapLabel);
                    break;
                }
                case 2: 
                case 3: {
                    evtMgr.notifyPerspectiveListener((Object)this.m_Perspective, 3982, dimLargestOverlapLabel);
                    int nO1LabelAutoAngle = this.m_Perspective.getO1LabelAutoAngle();
                    textStyle.setRotationAngle(nO1LabelAutoAngle);
                }
            }
            rVectLabels = new ArrayList(nNumLabels);
        }
        return nAutoSkip;
    }

    private int labelsOverlap(Graphics gx, int nSide, int nNumLabels, List rVectLabels, List nVectLabelPos, BlackBoxObj blackBox, boolean bAutofit, int nAutoSkip, int nLabelBegin, int nSkipFactor, int nFontSizeVC, TextStyleObj textStyleLabel, List sVectLabels) {
        VC vc = this.getAxisVC();
        Rectangle rTitle = null;
        ArrayList nVectAlign = new ArrayList(nNumLabels);
        IdentObj title = this.getTitle();
        boolean bTitleRectAssigned = false;
        boolean bMovableAxisTitles = this.m_Perspective.getMoveAxisTitles();
        Rectangle rTitleInLook = null;
        if (this.m_Perspective.getDisplay(title)) {
            if (bMovableAxisTitles) {
                rTitleInLook = this.m_Perspective.getRect(title);
                if (rTitleInLook == null) {
                    bTitleRectAssigned = false;
                    rTitle = new Rectangle(0, 0, 0, 0);
                } else if (rTitleInLook.width == 0 && rTitleInLook.height == 0) {
                    bTitleRectAssigned = false;
                    rTitle = new Rectangle(0, 0, 0, 0);
                } else {
                    bTitleRectAssigned = true;
                }
            } else {
                rTitle = new Rectangle(0, 0, 0, 0);
            }
        }
        boolean bLabelRotated = textStyleLabel.getRotationAngle() != 0;
        this.getLabelAndTitlePos(nSide, nNumLabels, rVectLabels, nVectLabelPos, nVectAlign, rTitle, bLabelRotated, nAutoSkip, nLabelBegin, nSkipFactor, textStyleLabel);
        if (bMovableAxisTitles && bTitleRectAssigned) {
            rTitleInLook = this.m_Perspective.getRect(title);
            rTitle = new Rectangle(rTitleInLook);
        }
        Dimension dimSmallestLabel = this.getSmallestLabel(rVectLabels, nNumLabels);
        int nAutofitMin = this.getAutofitMinConstrained(bAutofit);
        int nAutofitMax = this.getAutofitMaxConstrained(bAutofit);
        int nTextLargerThanBox = textStyleLabel.formatAndAutofit(gx, this.m_Perspective, bAutofit, nAutofitMin, nAutofitMax, nFontSizeVC, sVectLabels, dimSmallestLabel, vc);
        return nTextLargerThanBox;
    }

    private boolean calcLabelsAutoSkipFrameWidth(int nSide, int nNumLabels, List nVectLabelPos, int nFontSizeVC, TextStyleObj textStyle, Graphics gx, boolean bAutofit, int nAutoSkip, BlackBoxObj blackBox) {
        VC vc = this.getAxisVC();
        boolean bSkippedLabels = false;
        Rectangle rFrame = ((Axis2DObj)this).getFrameRect();
        boolean bLabelRotated = textStyle.getRotationAngle() != 0;
        Dimension dimMaxVC = new Dimension(rFrame.width / nNumLabels, rFrame.height);
        Dimension dimMaxDC = vc.virtToDest(dimMaxVC);
        List strVectLabels = this.getLabels();
        Dimension dimLabelDC = this.findLargestLabelFastest(gx, nNumLabels, dimMaxDC, strVectLabels, nFontSizeVC, textStyle, bLabelRotated);
        int nLabelSizeDC = bLabelRotated ? dimLabelDC.height : dimLabelDC.width;
        int nLabelSpaceTotalDC = nLabelSizeDC * nNumLabels;
        int nLabelBegin = this.m_Perspective.getSkipBegin(this.m_template.getLabel());
        int nTotalSpaceAvail = vc.virtToDestWidth(rFrame.width);
        int nSkipFactor = this.calcSkipFactor(nLabelSizeDC, nNumLabels, nLabelBegin, nLabelSpaceTotalDC, nTotalSpaceAvail);
        this.skipAndDrawLabels(nSide, nNumLabels, nVectLabelPos, nFontSizeVC, textStyle, gx, bAutofit, nAutoSkip, blackBox, strVectLabels, nLabelBegin, nSkipFactor);
        if (nSkipFactor > 0) {
            bSkippedLabels = true;
        }
        return bSkippedLabels;
    }

    private boolean calcLabelsAutoSkipFrameHeight(int nSide, int nNumLabels, List nVectLabelPos, int nFontSizeVC, TextStyleObj textStyle, Graphics gx, boolean bAutofit, int nAutoSkip, BlackBoxObj blackBox) {
        VC vc = this.getAxisVC();
        boolean bSkippedLabels = false;
        Rectangle rFrame = ((Axis2DObj)this).getFrameRect();
        boolean bLabelRotated = textStyle.getRotationAngle() != 0;
        Dimension dimMax = new Dimension(rFrame.height / nNumLabels, rFrame.width);
        dimMax = vc.virtToDest(dimMax);
        List strVectLabels = this.getLabels();
        Dimension dimLabelDC = this.findLargestLabelFastest(gx, nNumLabels, dimMax, strVectLabels, nFontSizeVC, textStyle, bLabelRotated);
        int nLabelSizeDC = bLabelRotated ? dimLabelDC.width : dimLabelDC.height;
        int nLabelSpaceTotalDC = nLabelSizeDC * nNumLabels;
        int nLabelBegin = this.m_Perspective.getSkipBegin(this.m_template.getLabel());
        int nTotalSpaceAvail = vc.virtToDestWidth(rFrame.height);
        int nSkipFactor = this.calcSkipFactor(nLabelSizeDC, nNumLabels, nLabelBegin, nLabelSpaceTotalDC, nTotalSpaceAvail);
        this.skipAndDrawLabels(nSide, nNumLabels, nVectLabelPos, nFontSizeVC, textStyle, gx, bAutofit, nAutoSkip, blackBox, strVectLabels, nLabelBegin, nSkipFactor);
        if (nSkipFactor > 0) {
            bSkippedLabels = true;
        }
        return bSkippedLabels;
    }

    private int calcSkipFactor(int nLabelSize, int nNumLabels, int nLabelBegin, int nLabelSpaceTotal, int nTotalSpaceAvail) {
        int nSkipFactor = 0;
        if (nLabelSpaceTotal > nTotalSpaceAvail) {
            if (nLabelSize >= nTotalSpaceAvail) {
                nSkipFactor = nNumLabels - nLabelBegin;
            } else {
                int nNumLabelsShown;
                nSkipFactor = 0;
                do {
                    nLabelSpaceTotal = 0;
                    nNumLabelsShown = (nNumLabels + ++nSkipFactor) / (nSkipFactor + 1);
                    for (int i = 0; i < nNumLabels; ++i) {
                        int nSpace = i >= nLabelBegin && (i - nLabelBegin) % (nSkipFactor + 1) == 0 ? nLabelSize : 0;
                        nLabelSpaceTotal += nSpace;
                    }
                } while (nLabelSpaceTotal > nTotalSpaceAvail && nNumLabelsShown >= 2);
            }
        }
        return nSkipFactor;
    }

    private void skipAndDrawLabels(int nSide, int nNumLabels, List nVectLabelPos, int nFontSizeVC, TextStyleObj textStyle, Graphics gx, boolean bAutofit, int nAutoSkip, BlackBoxObj blackBox, List strVectLabels, int nLabelBegin, int nSkipFactor) {
        int nSkipLabels = 0;
        List nVectIdents = this.getLabelIdents();
        ArrayList rVectLabels = new ArrayList(nNumLabels);
        ArrayList nVectSkipLabelPos = new ArrayList(nNumLabels);
        ArrayList sVectSkipLabels = new ArrayList(nNumLabels);
        ArrayList sVectSkipIdents = new ArrayList(nNumLabels);
        for (int j = 0; j < nNumLabels; ++j) {
            if (j < nLabelBegin || (j - nLabelBegin) % (nSkipFactor + 1) != 0) continue;
            sVectSkipLabels.add(strVectLabels.get(j));
            sVectSkipIdents.add(nVectIdents.get(j));
            nVectSkipLabelPos.add(nVectLabelPos.get(j));
            ++nSkipLabels;
        }
        this.calcLabelsOneSide(gx, nSide, nSkipLabels, rVectLabels, nVectSkipLabelPos, blackBox, bAutofit, nAutoSkip, nLabelBegin, nSkipFactor, nFontSizeVC, textStyle, sVectSkipLabels, sVectSkipIdents);
    }

    private void calcLabelsManualSkip(int nSide, int nNumLabels, List nVectLabelPos, int nFontSizeVC, TextStyleObj textStyle, Graphics gx, boolean bAutofit, int nAutoSkip, BlackBoxObj blackBox) {
        ArrayList rVectLabels = new ArrayList(nNumLabels);
        List sVectLabels = this.getLabels();
        List nVectIndents = this.getLabelIdents();
        ArrayList sVectSkipLabels = new ArrayList(nNumLabels);
        ArrayList nVectSkipIdents = null;
        ArrayList nVectSkipLabelPos = new ArrayList(nNumLabels);
        if (!this.m_template.isNumeric()) {
            nVectSkipIdents = new ArrayList(nNumLabels);
        }
        int nSkipLabels = 0;
        int nLabelBegin = 0;
        int nSkipFactor = 0;
        nSkipFactor = this.m_Perspective.getSkipCount(this.m_template.getLabel());
        nLabelBegin = this.m_Perspective.getSkipBegin(this.m_template.getLabel());
        if (nLabelBegin < 0) {
            nLabelBegin = 0;
        }
        if (nLabelBegin > nNumLabels - 1) {
            nLabelBegin = nNumLabels - 1;
        }
        if (nSkipFactor < 0) {
            nSkipFactor = 0;
        }
        if (nSkipFactor == 0) {
            nLabelBegin = 0;
        }
        if (nLabelBegin > nSkipFactor) {
            nLabelBegin = 0;
        }
        int nMod = nSkipFactor + 1;
        for (int j = 0; j < nNumLabels; ++j) {
            if (j < nLabelBegin || (j - nLabelBegin) % nMod != 0) continue;
            sVectSkipLabels.add(sVectLabels.get(j));
            nVectSkipLabelPos.add(nVectLabelPos.get(j));
            ++nSkipLabels;
            if (this.m_template.isNumeric()) continue;
            nVectSkipIdents.add(nVectIndents.get(j));
        }
        if ((nSide == 0 || nSide == 2) && this.isAxisLabelVisible(0)) {
            this.calcLabelsOneSide(gx, 0, nSkipLabels, rVectLabels, nVectSkipLabelPos, blackBox, bAutofit, nAutoSkip, nLabelBegin, nSkipFactor, nFontSizeVC, textStyle, sVectSkipLabels, nVectSkipIdents);
        }
        if ((nSide == 1 || nSide == 2) && this.isAxisLabelVisible(1)) {
            this.calcLabelsOneSide(gx, 1, nSkipLabels, rVectLabels, nVectSkipLabelPos, blackBox, bAutofit, nAutoSkip, nLabelBegin, nSkipFactor, nFontSizeVC, textStyle, sVectSkipLabels, nVectSkipIdents);
        }
    }

    private void drawNestedO1Labels(Graphics gx, int nSide) {
        IdentObj idLabel = this.m_template.getLabel();
        boolean bAutofit = this.m_Perspective.getAutofit(idLabel);
        if (this.m_cbO1Labels == null) {
            return;
        }
        VC vc = this.getAxisVC();
        boolean bNestedLabelFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(idLabel);
        int nFontSizeVC = bNestedLabelFontSizeAbsolute ? vc.destToVirtHeight(this.m_Perspective.getFontSize(idLabel)) : this.m_Perspective.getFontSizeVC(idLabel);
        TextStyleObj textStyle = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(idLabel), this.m_Perspective.getFontStyle(idLabel), bNestedLabelFontSizeAbsolute, this.m_Perspective.getFontSize(idLabel), nFontSizeVC, this.m_Perspective.getTextRotation(idLabel), this.m_Perspective.getTextJustHoriz(idLabel), this.m_Perspective.getTextJustVert(idLabel), false, false, this.m_Perspective.getTextWrap(idLabel), this.m_Perspective.getLocale());
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, idLabel);
        int nLevels = this.m_cbO1Labels.getNumLevels();
        for (int iLevel = 0; iLevel < nLevels; ++iLevel) {
            this.m_nNestingLevel = iLevel;
            int nObjectID = ObjClassID.getObjectFromLevel(iLevel);
            if (!this.m_Perspective.isContinuousTimeAxis()) {
                this.calcOrdinalScale();
            }
            int nNumLabels = this.m_cbO1Labels.getNumLabelsOnLevel(this.m_nNestingLevel);
            ArrayList rLabels = new ArrayList(nNumLabels);
            ArrayList szLabels = this.getLabels();
            ArrayList nVectLabelPos = this.getRelLabelPos(nNumLabels);
            int skipCount = this.m_Perspective.getNestedSkipCount(this.m_nNestingLevel);
            ArrayList nVectIndents = this.getLabelIdents();
            ArrayList sVectSkipLabels = null;
            ArrayList nVectSkipIdents = null;
            ArrayList nVectSkipLabelPos = null;
            if (skipCount > 0) {
                sVectSkipLabels = new ArrayList(nNumLabels);
                nVectSkipLabelPos = new ArrayList(nNumLabels);
                int nLabelBegin = 0;
                nVectSkipIdents = new ArrayList(nNumLabels);
                int nSkipLabels = 0;
                int nSkipFactor = skipCount;
                int nMod = nSkipFactor + 1;
                boolean bIrregularSkipping = (this.m_Perspective.isTimeAxis() || this.m_continuousTimeAxis) && this.isO1WithNestedLabels() && this.m_Perspective.isIrregularO1Skipping() && this.m_nNestingLevel == 0;
                int relIndex = -1;
                for (int j = 0; j < nNumLabels; ++j) {
                    boolean bIncludeLabel = j >= nLabelBegin && (j - nLabelBegin) % nMod == 0;
                    Object label = szLabels.get(j);
                    if (bIrregularSkipping) {
                        if (label == null || ((String)label).length() < 1) {
                            bIncludeLabel = false;
                        } else {
                            boolean bl = bIncludeLabel = j >= nLabelBegin && ++relIndex % nMod == 0;
                        }
                    }
                    if (!bIncludeLabel) continue;
                    sVectSkipLabels.add(szLabels.get(j));
                    nVectSkipLabelPos.add(nVectLabelPos.get(j));
                    ++nSkipLabels;
                    nVectSkipIdents.add(nVectIndents.get(j));
                }
                nVectIndents = nVectSkipIdents;
                szLabels = sVectSkipLabels;
                nVectLabelPos = nVectSkipLabelPos;
                nNumLabels = nSkipLabels;
            }
            if ((nSide == 0 || nSide == 2) && this.isAxisLabelVisible(0)) {
                this.calcLabelsOneSide(gx, 0, nNumLabels, rLabels, nVectLabelPos, blackBox, bAutofit, 0, 0, skipCount, nFontSizeVC, textStyle, szLabels, nVectIndents);
            }
            if (nSide != 1 && nSide != 2 || !this.isAxisLabelVisible(1)) continue;
            this.calcLabelsOneSide(gx, 1, nNumLabels, rLabels, nVectLabelPos, blackBox, bAutofit, 0, 0, skipCount, nFontSizeVC, textStyle, szLabels, nVectIndents);
        }
        this.m_nNestingLevel = 0;
        if (!this.m_continuousTimeAxis) {
            this.calcOrdinalScale();
        }
    }

    private int getAutofitMinConstrained(boolean bAutofit) {
        int nAutofitMin = this.m_Perspective.getAxisTextAutofitMin();
        if (bAutofit) {
            switch (this.m_Perspective.getAxisTextAutofitMode()) {
                case 1: {
                    nAutofitMin = this.m_Perspective.getMinimumAxisTextSizeVC();
                    break;
                }
                case 2: {
                    double newAutofitPivotPoint = this.m_Perspective.getMinimumAxisTextSizeVC();
                    nAutofitMin = (int)(newAutofitPivotPoint - newAutofitPivotPoint * ((double)this.m_Perspective.getAxisTextAutofitPercent() / 100.0));
                }
            }
            if (nAutofitMin < this.m_Perspective.getAxisTextAutofitMin()) {
                nAutofitMin = this.m_Perspective.getAxisTextAutofitMin();
            }
        }
        return nAutofitMin;
    }

    private int getAutofitMaxConstrained(boolean bAutofit) {
        int nAutofitMax = this.m_Perspective.getAxisTextAutofitMax();
        if (bAutofit) {
            switch (this.m_Perspective.getAxisTextAutofitMode()) {
                case 1: {
                    nAutofitMax = this.m_Perspective.getMinimumAxisTextSizeVC();
                    break;
                }
                case 2: {
                    double newAutofitPivotPoint = this.m_Perspective.getMinimumAxisTextSizeVC();
                    nAutofitMax = (int)(newAutofitPivotPoint + newAutofitPivotPoint * ((double)this.m_Perspective.getAxisTextAutofitPercent() / 100.0));
                }
            }
            if (nAutofitMax > this.m_Perspective.getAxisTextAutofitMax()) {
                nAutofitMax = this.m_Perspective.getAxisTextAutofitMax();
            }
        }
        return nAutofitMax;
    }

    private Dimension getSmallestLabel(List rVectLabels, int nNumLabels) {
        Dimension dimSmallestLabel = new Dimension(1000000, 1000000);
        for (int i = 0; i < nNumLabels; ++i) {
            Rectangle r = (Rectangle)rVectLabels.get(i);
            dimSmallestLabel.width = Math.min(dimSmallestLabel.width, r.width);
            dimSmallestLabel.height = Math.min(dimSmallestLabel.height, r.height);
        }
        return dimSmallestLabel;
    }

    private int calcLabelsOneSide(Graphics gx, int nSide, int nNumLabels, List rVectLabels, List nVectLabelPos, BlackBoxObj blackBox, boolean bAutofit, int nAutoSkip, int nLabelBegin, int nSkipFactor, int nFontSizeVC, TextStyleObj textStyle, List sVectLabels, List vectIDObj) {
        boolean bGridsDrawn;
        VC vc = this.getAxisVC();
        boolean bLabelRotated = textStyle.getRotationAngle() != 0;
        boolean bWordWrap = textStyle.getWordWrap();
        Rectangle rTitle = null;
        ArrayList nVectAlign = new ArrayList(nNumLabels);
        IdentObj title = this.getTitle();
        boolean bTitleRectAssigned = false;
        boolean bMovableAxisTitles = this.m_Perspective.getMoveAxisTitles();
        Rectangle rTitleInLook = null;
        if (this.m_Perspective.getDisplay(title)) {
            if (bMovableAxisTitles) {
                rTitleInLook = this.m_Perspective.getRect(title);
                if (rTitleInLook == null) {
                    bTitleRectAssigned = false;
                    rTitle = new Rectangle(0, 0, 0, 0);
                } else if (rTitleInLook.width == 0 && rTitleInLook.height == 0) {
                    bTitleRectAssigned = false;
                    rTitle = new Rectangle(0, 0, 0, 0);
                } else {
                    bTitleRectAssigned = true;
                }
            } else {
                rTitle = new Rectangle(0, 0, 0, 0);
            }
        }
        this.getLabelAndTitlePos(nSide, nNumLabels, rVectLabels, nVectLabelPos, nVectAlign, rTitle, bLabelRotated, nAutoSkip, nLabelBegin, nSkipFactor, textStyle);
        if (bMovableAxisTitles && bTitleRectAssigned) {
            rTitleInLook = this.m_Perspective.getRect(title);
            rTitle = new Rectangle(rTitleInLook);
        }
        Dimension dimSmallestLabel = this.getSmallestLabel(rVectLabels, nNumLabels);
        int nAutofitMin = this.getAutofitMinConstrained(bAutofit);
        int nAutofitMax = this.getAutofitMaxConstrained(bAutofit);
        int nTextLargerThanBox = 0;
        if (bAutofit || this.m_gt.is3DType() || this.m_template.isNumeric()) {
            nTextLargerThanBox = textStyle.formatAndAutofit(gx, this.m_Perspective, bAutofit, nAutofitMin, nAutofitMax, nFontSizeVC, sVectLabels, dimSmallestLabel, vc);
        }
        if (nAutoSkip == 1 || nAutoSkip == 2) {
            this.m_nAutoSkip = nAutoSkip;
            this.m_nLabelBegin = nLabelBegin;
            if (nSkipFactor > this.m_nSkipFactor) {
                this.m_nSkipFactor = nSkipFactor;
            }
        }
        if (this.m_SmartAxis.isInQALabelMode() && nNumLabels > 2) {
            Object rFirst = rVectLabels.get(0);
            Object rLast = rVectLabels.get(nNumLabels - 1);
            rVectLabels.clear();
            rVectLabels.add(rFirst);
            rVectLabels.add(rLast);
            Object szFirst = sVectLabels.get(0);
            Object szLast = sVectLabels.get(nNumLabels - 1);
            sVectLabels.clear();
            sVectLabels.add(szFirst);
            sVectLabels.add(szLast);
            Object aFirst = nVectAlign.get(0);
            Object aLast = nVectAlign.get(nNumLabels - 1);
            nVectAlign.clear();
            nVectAlign.add(aFirst);
            nVectAlign.add(aLast);
            vectIDObj = null;
            nNumLabels = 2;
        }
        if (this instanceof CircularAxisObj && textStyle.getWordWrap() && textStyle.getRotationAngle() == 0) {
            dimSmallestLabel.height *= 2;
        }
        Dimension dimLargestLabel = this.alignLabelsOneSide(nSide, nNumLabels, dimSmallestLabel, rVectLabels, sVectLabels, nVectAlign, vectIDObj, nFontSizeVC, textStyle, gx, bLabelRotated, bAutofit, blackBox);
        int nLevels = this.m_cbO1Labels != null && this.isO1Axis() ? this.m_cbO1Labels.getNumLevels() : 1;
        if (rTitle != null && !rTitle.isEmpty() && this.m_nNestingLevel == nLevels - 1) {
            this.drawAxisTitle(nSide, bTitleRectAssigned, rTitle, rVectLabels, gx);
        }
        if (this.m_bDrawGrids && this instanceof CircularAxisObj && !(bGridsDrawn = this.m_SmartAxis.calcGrids())) {
            this.calcGrids();
        }
        this.drawAxisLabels(nNumLabels, rVectLabels, sVectLabels, vectIDObj, textStyle, blackBox, gx, rTitle);
        if (this.isO1WithNestedLabels() && !this.m_Perspective.getTestLabelCalc() && this.m_bNestedLabelBrackets && this.m_nNestingLevel < this.m_nTopNestingLevel) {
            this.drawNestedLabelBrackets(nNumLabels, rVectLabels);
        }
        return nTextLargerThanBox;
    }

    protected TextStyleObj getTitleTextStyle(int nSide) {
        IdentObj title = this.getTitle();
        boolean bAutofit = this.m_Perspective.getAutofit(title);
        int nTitleFontSizeVC = this.getTitleFontSizeVC();
        boolean bTitleFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(title);
        TextStyleObj titleTextStyle = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(title), this.m_Perspective.getFontStyle(title), bTitleFontSizeAbsolute, this.m_Perspective.getFontSize(title), nTitleFontSizeVC, this.getTitleRotation(this.m_template, nSide), this.m_Perspective.getTextJustHoriz(title), this.m_Perspective.getTextJustVert(title), bAutofit, false, this.m_Perspective.getTextWrap(title), this.m_Perspective.getLocale());
        if (title.getObjectID() == 232 || title.getObjectID() == 233) {
            int fontSize = this.m_Perspective.m_VC.virtToDestHeight(nTitleFontSizeVC);
            if (fontSize < 18 && TextStyleObj.SMALL_DRILL_IMAGE == null) {
                TextStyleObj.SMALL_DRILL_IMAGE = TextStyleObj.getImageResource(TextStyleObj.class, "images/graph_drill_up.gif");
            } else if (fontSize >= 18 && TextStyleObj.LARGE_DRILL_IMAGE == null) {
                TextStyleObj.LARGE_DRILL_IMAGE = TextStyleObj.getImageResource(TextStyleObj.class, "images/large_drill_up.gif");
            }
            titleTextStyle.setDisplayDrillIcon(true);
        }
        return titleTextStyle;
    }

    protected int getTitleFontSizeVC() {
        IdentObj title = this.getTitle();
        boolean bTitleFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(title);
        int nTitleFontSizeVC = bTitleFontSizeAbsolute ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(title)) : this.m_Perspective.getFontSizeVC(title);
        return nTitleFontSizeVC;
    }

    protected void drawAxisTitleWhenNoLabels(int nSide, Graphics gx) {
        Rectangle rTitle = null;
        IdentObj title = this.getTitle();
        boolean bTitleRectAssigned = false;
        Object rTitleInLook = null;
        Point frameDepthOffset = this.m_Perspective.getFrameDepthOffset();
        if (this.m_Perspective.getDisplay(title)) {
            String strTitle = this.m_Perspective.getTextString(title);
            if (strTitle.length() == 0) {
                return;
            }
            rTitle = new Rectangle(0, 0, 0, 0);
            Rectangle rSpace = this.getSpaceAvailable(nSide, this.m_Perspective.m_VC);
            boolean bLeftDepthWall = frameDepthOffset.x >= 0;
            Dimension dimTitle = new Dimension(0, 0);
            TextStyleObj titleTextStyle = this.getTitleTextStyle(nSide);
            int nTitleFontSizeVC = this.getTitleFontSizeVC();
            int nDestTitleFontSize = this.m_Perspective.m_VC.virtToDestHeight(nTitleFontSizeVC);
            Dimension dimMax = new Dimension(16000, 16000);
            dimMax = this.m_Perspective.m_VC.virtToDest(dimMax);
            Dimension dimTitleDC = titleTextStyle.getTextSizeDC(gx, strTitle, nDestTitleFontSize, this.m_Perspective.m_VC, dimMax, null, this.m_Perspective.getFontMetricsResolver());
            if (this.isVertical()) {
                dimTitle.width = this.m_Perspective.m_VC.destToVirtHeight(dimTitleDC.width);
                dimTitle.height = this.m_Perspective.m_VC.destToVirtWidth(dimTitleDC.height);
            } else {
                dimTitle.width = this.m_Perspective.m_VC.destToVirtWidth(dimTitleDC.width);
                dimTitle.height = this.m_Perspective.m_VC.destToVirtHeight(dimTitleDC.height);
            }
            Rectangle rFrame = this.m_Perspective.getFrameRect(false);
            if (rTitle != null) {
                if (this.isVertical()) {
                    rTitle.y = this.isNumericAxis() ? (int)Math.min(this.getMinCoord(), this.getMaxCoord()) : Math.min(rFrame.y, rFrame.y + rFrame.height);
                    if (nSide == 0 && bLeftDepthWall) {
                        rTitle.y -= frameDepthOffset.y;
                    }
                    rTitle.width = dimTitle.height;
                    rTitle.height = rFrame.height;
                    rTitle.x = nSide == 0 ? rSpace.x : rSpace.x + rSpace.width - dimTitle.height;
                } else {
                    rTitle.x = this.isNumericAxis() ? (int)Math.min(this.getMinCoord(), this.getMaxCoord()) : Math.min(rFrame.x, rFrame.x + rFrame.width);
                    if (nSide == 0) {
                        rTitle.x -= frameDepthOffset.x;
                    }
                    rTitle.height = dimTitle.height;
                    rTitle.width = rFrame.width;
                    rTitle.y = nSide == 0 ? rSpace.y : rSpace.y + rSpace.height - dimTitle.height;
                }
            }
            if (rTitle != null && !rTitle.isEmpty()) {
                this.drawAxisTitle(nSide, bTitleRectAssigned, rTitle, null, gx);
            }
        }
    }

    protected abstract double getMinCoord();

    protected abstract double getMaxCoord();

    protected Rectangle getSpaceAvailable(int nSide, VC vc) {
        return null;
    }

    protected void drawAxisTitle(int nSide, boolean bTitleRectAssigned, Rectangle rTitle, List rLabels, Graphics gx) {
        IdentObj title = this.getTitle();
        boolean bAutofit = this.m_Perspective.getAutofit(title);
        if (!bTitleRectAssigned && rLabels != null) {
            this.adjustTitlePosPass1(nSide, rLabels, rTitle);
        }
        TextStyleObj titleTextStyle = this.getTitleTextStyle(nSide);
        int nTitleFontSizeVC = this.getTitleFontSizeVC();
        Dimension dimTitle = new Dimension(rTitle.width, rTitle.height);
        ArrayList<String> vectStrTitle = new ArrayList<String>();
        vectStrTitle.add(this.m_Perspective.getTextString(title));
        if (bAutofit || this.m_gt.is3DType() || this.m_gt.isPolar() || this.m_gt.isRadarType()) {
            titleTextStyle.formatAndAutofit(gx, this.m_Perspective, bAutofit, this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), nTitleFontSizeVC, vectStrTitle, dimTitle, this.m_Perspective.m_VC);
        }
        if (!bTitleRectAssigned) {
            this.adjustTitlePosPass2(title, nSide, rTitle, dimTitle);
        }
        BlackBoxObj titleBlackBox = new BlackBoxObj(this.m_Perspective, title);
        if (!this.m_Perspective.getTestLabelCalc()) {
            boolean isRSVisible;
            Rectangle rRangeSlider = (Rectangle)this.m_Perspective.getFromLook(this.m_template.getAxis(), Attr.RangeSliderRect);
            boolean bl = isRSVisible = this.axisRS != null && (this.axisRS.isVisible() || this.axisRS.isReserved());
            if (isRSVisible && this.m_Perspective.isUseRangeSlider() && rRangeSlider != null) {
                int xTitle;
                if (this.m_template.getAxisObjID() != 1) {
                    if (this.isVertical()) {
                        xTitle = rTitle.x;
                        rTitle.x = rRangeSlider.x;
                        rRangeSlider.x = xTitle + rTitle.width - rRangeSlider.width;
                    } else {
                        rTitle.y = rRangeSlider.y;
                        int margin = this.getAxisVC().destToVirtHeight(this.m_Perspective.updateMargin(10, true));
                        rRangeSlider.y += rTitle.height + margin;
                    }
                } else if (this.isVertical()) {
                    xTitle = rTitle.x;
                    rTitle.x = rRangeSlider.x - rTitle.width + rRangeSlider.width;
                    rRangeSlider.x = xTitle;
                } else {
                    int yTitle = rTitle.y;
                    rTitle.y = rRangeSlider.y - rTitle.height + rRangeSlider.height;
                    rRangeSlider.y = yTitle;
                }
                this.m_Perspective.putToLookNoCalc(new IdentObj(this.m_template.getAxis()), Attr.RangeSliderRect, rRangeSlider, true);
            }
            if (this.doDisplayOnCalc()) {
                IdentObj idBox = this.getTitleBox();
                BlackBoxObj bbBox = new BlackBoxObj(this.m_Perspective, idBox);
                if (this.m_Perspective.getDisplay(idBox)) {
                    new DetRect(this.m_Perspective.getDetectiv(), idBox, rTitle.x, rTitle.y, rTitle.width, rTitle.height, bbBox, null, false, true, true);
                }
                String titleText = this.m_Perspective.getTextString(title);
                int fontSize = !this.m_Perspective.getFontSizeAbsolute(title) ? (this.isVertical() ? this.m_Perspective.getVC().virtToDestWidth(this.m_Perspective.getFontSizeVC(title)) : this.m_Perspective.getVC().virtToDestHeight(this.m_Perspective.getFontSizeVC(title))) : this.m_Perspective.getFontSize(title);
                int fontStyle = TextStyleObj.getJavaFontStyle(this.m_Perspective.getFontStyle(title));
                String fontName = this.m_Perspective.getFontName(title);
                Graphics g = this.m_Perspective.getGraphicsContext();
                Font font = new Font(fontName, fontStyle, fontSize);
                FontMetrics fm = g.getFontMetrics(font);
                int rectLength = this.isVertical() ? this.m_Perspective.getVC().virtToDestHeight(rTitle.height) : this.m_Perspective.getVC().virtToDestWidth(rTitle.width);
                String displayText = titleText;
                if (!this.m_Perspective.getTextWrap(title) && rectLength < this.m_Perspective.getFontMetricsResolver().stringWidth(titleText, fm)) {
                    displayText = PresUtils.truncateText(titleText, fm, 2, rectLength, this.m_Perspective.getFontMetricsResolver());
                    this.m_Perspective.setAxisTitleTruncated(true, this.m_template.getAxisObjID(), title);
                }
                IdentObj idLegend = this.m_Perspective.getLegendArea();
                if (this.m_Perspective.m_chart != null && this.m_Perspective.m_chart.wantLegend() && this.m_Perspective.getDisplay(idLegend) && this.m_Perspective.getCommonGraph().getLegendArea().getPosition() == 1) {
                    Rectangle bottomRect = this.m_Perspective.getRect(idLegend);
                    if (bottomRect != null && !bottomRect.isEmpty()) {
                        rTitle.y = Math.max(rTitle.y, bottomRect.y + bottomRect.height + 5);
                    }
                } else {
                    Rectangle bottomRect;
                    IdentObj idFootnote = this.m_Perspective.getFootnote();
                    if (this.m_Perspective.m_chart != null && this.m_Perspective.getDisplay(idFootnote) && (bottomRect = this.m_Perspective.getRect(idFootnote)) != null && !bottomRect.isEmpty()) {
                        rTitle.y = Math.max(rTitle.y, bottomRect.y + bottomRect.height + 5);
                    }
                }
                new DetLabel(this.m_Perspective.getDetectiv(), title, displayText, titleText, rTitle, titleTextStyle, titleBlackBox, this.m_Perspective.getMoveAxisTitles());
            }
        }
    }

    private void drawNestedLabelBrackets(int nNumLabels, List rLabels) {
        int x1Ctr = 0;
        int y1Ctr = 0;
        IdentObj idBracket = this.m_Perspective.getNestedO1LabelLine();
        BlackBoxObj bbBracket = new BlackBoxObj(this.m_Perspective, idBracket);
        int nLWBracket = this.m_Perspective.getLineWidth(this.m_Perspective.getNestedO1LabelLine());
        boolean bVertScale = this.isVertical();
        int nOffset = this.m_Perspective.getEffectiveGroupOffset();
        int iBracket = 0;
        for (int i = 0; i < nNumLabels; ++i) {
            int y2;
            int y1;
            int x2;
            int x1;
            int nNumInBracket = this.m_cbO1Labels.getLabelGrouping(i + nOffset, this.m_nNestingLevel);
            Rectangle rLabel = (Rectangle)rLabels.get(i);
            if (rLabel == null || rLabel.isEmpty()) continue;
            if (bVertScale) {
                x1 = rLabel.x;
                x2 = rLabel.x - rLabel.width / 4;
                y2 = y1 = rLabel.y + rLabel.height / 2;
            } else {
                x2 = x1 = rLabel.x + rLabel.width / 2;
                y1 = rLabel.y;
                y2 = rLabel.y - rLabel.height / 4;
            }
            IdentObj newId = new IdentObj(idBracket);
            newId.setMiscID(i);
            new DetLine(this.m_Perspective.getDetectiv(), newId, x1, y1, x2, y2, (BlackBoxIF)bbBracket, null, nLWBracket);
            if (iBracket == 0) {
                x1Ctr = x2;
                y1Ctr = y2;
            }
            if (iBracket == nNumInBracket - 1) {
                int y2Next;
                int y1Next;
                int x2Next;
                int x1Next;
                int x2Ctr = x2;
                int y2Ctr = y2;
                newId = new IdentObj(idBracket);
                newId.setMiscID(i + 1000);
                new DetLine(this.m_Perspective.getDetectiv(), newId, x1Ctr, y1Ctr, x2Ctr, y2Ctr, (BlackBoxIF)bbBracket, null, nLWBracket);
                if (bVertScale) {
                    x1Next = x1Ctr;
                    x2Next = x1Ctr - rLabel.width / 4;
                    y2Next = y1Next = (y1Ctr + y2Ctr) / 2;
                } else {
                    x2Next = x1Next = (x1Ctr + x2Ctr) / 2;
                    y1Next = (y1Ctr + y2Ctr) / 2;
                    y2Next = y1Next - rLabel.height / 4;
                }
                newId = new IdentObj(idBracket);
                newId.setMiscID(i + 2000);
                new DetLine(this.m_Perspective.getDetectiv(), newId, x1Next, y1Next, x2Next, y2Next, (BlackBoxIF)bbBracket, null, nLWBracket);
                iBracket = 0;
                continue;
            }
            ++iBracket;
        }
    }

    protected void alignTop(Rectangle rLabel, Dimension dimLargestLabelVC) {
        rLabel.y = rLabel.y + rLabel.height - dimLargestLabelVC.height;
    }

    protected void alignBottom(Rectangle rLabel, Dimension dimLargestLabelVC) {
    }

    private Dimension alignLabelsOneSide(int nSide, int nNumLabels, Dimension dimSmallestLabel, List rVectLabels, List sVectLabels, List nVectAlign, List nVectIdents, int nFontSizeVC, TextStyleObj textStyle, Graphics g, boolean bLabelRotated, boolean bAutofit, BlackBoxObj blackBox) {
        VC vc = this.getAxisVC();
        Dimension dimHorizLargestLabel = new Dimension(0, 0);
        Dimension dimLargestLabelDC = this.findLargestLabelFastest(g, nNumLabels, dimSmallestLabel, sVectLabels, nFontSizeVC, textStyle, bLabelRotated);
        if (bLabelRotated) {
            int nHeight = dimLargestLabelDC.height;
            dimLargestLabelDC.height = dimLargestLabelDC.width;
            dimLargestLabelDC.width = nHeight;
        }
        Dimension dimLargestLabelVC = vc.destToVirt(dimLargestLabelDC);
        Rectangle firstRectangle = null;
        this.m_polarExcludeX1LastLabel = false;
        for (int i = 0; i < nNumLabels; ++i) {
            boolean bSkipLabel = this.skipFirstOrLastLabel(i, nNumLabels);
            if (bSkipLabel) continue;
            Rectangle rLabel = (Rectangle)rVectLabels.get(i);
            switch ((Integer)nVectAlign.get(i)) {
                case 1: {
                    rLabel.y += (rLabel.height - dimLargestLabelVC.height) / 2;
                    break;
                }
                case 2: {
                    this.alignTop(rLabel, dimLargestLabelVC);
                    break;
                }
                case 3: {
                    if (this.m_nNestingLevel != 1) {
                        rLabel.x += (rLabel.width - dimLargestLabelVC.width) / 2;
                    }
                    this.alignTop(rLabel, dimLargestLabelVC);
                    break;
                }
                case 4: {
                    rLabel.x = rLabel.x + rLabel.width - dimLargestLabelVC.width;
                    this.alignTop(rLabel, dimLargestLabelVC);
                    break;
                }
                case 5: {
                    rLabel.x = rLabel.x + rLabel.width - dimLargestLabelVC.width;
                    rLabel.y += (rLabel.height - dimLargestLabelVC.height) / 2;
                    break;
                }
                case 6: {
                    rLabel.x = rLabel.x + rLabel.width - dimLargestLabelVC.width;
                    this.alignBottom(rLabel, dimLargestLabelVC);
                    break;
                }
                case 7: {
                    rLabel.x += (rLabel.width - dimLargestLabelVC.width) / 2;
                    this.alignBottom(rLabel, dimLargestLabelVC);
                    break;
                }
                case 8: {
                    this.alignBottom(rLabel, dimLargestLabelVC);
                }
            }
            rLabel.width = dimLargestLabelVC.width;
            rLabel.height = dimLargestLabelVC.height;
            if (this.m_gt.isPolar() && this.m_template.getLabel().getObjectID() == 280) {
                if (i == 0) {
                    firstRectangle = rLabel;
                }
                if (i == nNumLabels - 1 && firstRectangle != null && rLabel.intersects(firstRectangle)) {
                    this.m_polarExcludeX1LastLabel = true;
                    continue;
                }
            }
            this.adjustLabelPos(nSide, nNumLabels, rVectLabels);
            this.m_axisLabelTextSizeVC = textStyle.getFontSizeVC(vc);
            dimHorizLargestLabel.width = Math.max(dimHorizLargestLabel.width, rLabel.width);
            dimHorizLargestLabel.height = Math.max(dimHorizLargestLabel.height, rLabel.height);
        }
        JGraphType gt = this.m_Perspective.getJGraphType();
        if (this.isO1Axis() && gt.isOrientHorz()) {
            TDGEventManager evtMgr = this.m_Perspective.getEventManager();
            evtMgr.notifyPerspectiveListener((Object)this.m_Perspective, 3982, dimHorizLargestLabel);
        }
        return dimLargestLabelVC;
    }

    private void fitLeft(Rectangle rect, Rectangle leftRect) {
        int xright = rect.x + rect.width;
        rect.x = Math.max(rect.x, -15900);
        if (leftRect != null && !leftRect.isEmpty()) {
            rect.x = Math.max(rect.x, leftRect.x + leftRect.width);
        }
        rect.width = xright - rect.x;
    }

    private void fitRight(Rectangle rect, Rectangle rightRect) {
        rect.width = Math.min(rect.width, 15900 - rect.x);
        if (rightRect != null && !rightRect.isEmpty()) {
            rect.width = Math.min(rect.width, rightRect.x - rect.x);
        }
    }

    private void fitBottom(Rectangle rect, Rectangle bottomRect) {
        int ytop = rect.y + rect.height;
        rect.y = Math.max(rect.y, -15900);
        if (bottomRect != null && !bottomRect.isEmpty()) {
            rect.y = Math.max(rect.y, bottomRect.y + bottomRect.height);
        }
        rect.height = ytop - rect.y;
    }

    private void drawAxisLabels(int nNumLabels, List rVectLabels, List sVectLabels, List vectIDObj, TextStyleObj textStyle, BlackBoxObj blackBox, Graphics g, Rectangle rTitle) {
        boolean labelsTruncated = false;
        boolean truncateCheckForRangeSlider = this.m_nAxisObjectID == 2001 && this.axisRS != null && this.m_Perspective.getAutoSkip(this.m_template.getLabel()) == 0 && (this.m_Perspective.isChartOrientHorz() && textStyle.getRotationAngle() == 0 || !this.m_Perspective.isChartOrientHorz() && textStyle.getRotationAngle() != 0);
        VC vc = this.getAxisVC();
        for (int i = 0; i < nNumLabels; ++i) {
            IdentObj newID;
            String sLabel;
            Rectangle rect;
            int idLabel;
            String fullText = null;
            boolean bSkipLabel = this.skipFirstOrLastLabel(i, nNumLabels);
            if (bSkipLabel) continue;
            Object label = sVectLabels.get(i);
            if (this.m_Perspective.isTimeAxis() && this.isO1WithNestedLabels() && this.m_Perspective.isIrregularO1Skipping() && (label == null || ((String)label).length() < 1)) continue;
            Rectangle rLabel = (Rectangle)rVectLabels.get(i);
            if (this.m_template.isNumeric() && (i == 0 || i == nNumLabels - 1)) {
                Rectangle rLegend;
                IdentObj idLegend;
                idLabel = this.m_template.getLabel().getObjectID();
                rect = new Rectangle(rLabel);
                if (!this.isVertical()) {
                    sLabel = (String)label;
                    FontMetrics fm = this.m_Perspective.getFontMetrics(new IdentObj(idLabel));
                    int nLabelWidthVC = vc.destToVirtWidth(this.m_Perspective.getFontMetricsResolver().stringWidth(sLabel, fm));
                    rect.x = rect.x + rect.width / 2 - nLabelWidthVC / 2 - 1;
                    rect.width = nLabelWidthVC + 2;
                } else {
                    int nDescent = vc.destToVirtHeight((int)Math.ceil(this.m_Perspective.getTextDescent(new IdentObj(idLabel))));
                    rect.y += nDescent;
                    rect.height -= nDescent;
                }
                Rectangle rBounds = vc.getVirtCoords();
                if (!rBounds.contains(rect) || this.m_Perspective.getDisplay(idLegend = this.m_Perspective.getLegendArea()) && this.m_Perspective.m_chart != null && this.m_Perspective.m_chart.wantLegend() && rect.intersects(rLegend = this.m_Perspective.getRect(idLegend))) continue;
            }
            idLabel = this.m_template.getLabel().getObjectID();
            rect = new Rectangle(rLabel);
            sLabel = (String)label;
            int rotationAngle = textStyle.getRotationAngle();
            FontMetrics fm = this.m_Perspective.getFontMetrics(new IdentObj(idLabel));
            int labelWidth = this.m_Perspective.getFontMetricsResolver().stringWidth(sLabel, fm);
            if (this.isVertical() && !textStyle.getWordWrap()) {
                if (this.getAxisSide() == 0) {
                    this.fitLeft(rect, rTitle);
                } else if (this.getAxisSide() == 1) {
                    this.fitRight(rect, rTitle);
                }
                int containerWidth = vc.virtToDestWidth(rect.width);
                int containerHeight = vc.virtToDestHeight(rect.height);
                if ((rotationAngle == 0 || rotationAngle == 180) && labelWidth > containerWidth + 1) {
                    String truncatedSLabel = PresUtils.truncateText(sLabel, fm, 2, containerWidth, this.m_Perspective.getFontMetricsResolver());
                    fullText = sLabel;
                    sVectLabels.set(i, truncatedSLabel);
                } else if ((rotationAngle == 90 || rotationAngle == 270) && labelWidth > containerHeight + 1) {
                    String truncatedSLabel = PresUtils.truncateText(sLabel, fm, 2, containerHeight, this.m_Perspective.getFontMetricsResolver());
                    fullText = sLabel;
                    sVectLabels.set(i, truncatedSLabel);
                }
            } else if (!this.isVertical() && !textStyle.getWordWrap()) {
                String truncatedSLabel;
                IdentObj idLegend = this.m_Perspective.getLegendArea();
                if (this.m_Perspective.m_chart != null && this.m_Perspective.m_chart.wantLegend() && this.m_Perspective.getDisplay(idLegend) && this.m_Perspective.getCommonGraph().getLegendArea().getPosition() == 1) {
                    this.fitBottom(rect, this.m_Perspective.getRect(idLegend));
                }
                this.fitBottom(rect, rTitle);
                int containerWidth = vc.virtToDestWidth(rect.width);
                int containerHeight = vc.virtToDestHeight(rect.height);
                if ((rotationAngle == 0 || rotationAngle == 180) && labelWidth > containerWidth + 1) {
                    truncatedSLabel = PresUtils.truncateText(sLabel, fm, 2, containerWidth, this.m_Perspective.getFontMetricsResolver());
                    fullText = sLabel;
                    sVectLabels.set(i, truncatedSLabel);
                } else if ((rotationAngle == 90 || rotationAngle == 270) && labelWidth > containerHeight + 1) {
                    String truncatedSLabel2 = PresUtils.truncateText(sLabel, fm, 2, containerHeight, this.m_Perspective.getFontMetricsResolver());
                    fullText = sLabel;
                    sVectLabels.set(i, truncatedSLabel2);
                }
                if (rotationAngle % 90 != 0) {
                    if (labelWidth > containerHeight) {
                        truncatedSLabel = PresUtils.truncateText(sLabel, fm, 2, containerHeight, this.m_Perspective.getFontMetricsResolver());
                        fullText = sLabel;
                        sVectLabels.set(i, truncatedSLabel);
                        labelWidth = containerHeight;
                    }
                    int textAngle = rotationAngle > 180 ? 360 - rotationAngle : rotationAngle;
                    rLabel.y = (int)((double)rLabel.y - (double)vc.destToVirtHeight(labelWidth) * 0.5 * Math.sin(Math.toRadians(textAngle)));
                }
            }
            if (vectIDObj != null && vectIDObj.get(i) != null) {
                IdentObj idFromVector = (IdentObj)vectIDObj.get(i);
                int s = idFromVector.getSeriesID();
                int gg = idFromVector.getGroupID();
                if (this.m_nNestingLevel > 0) {
                    gg = this.m_cbO1Labels.getParentIndex(i, this.m_nNestingLevel);
                }
                newID = new IdentObj(this.m_template.getLabel().getObjectID(), s, gg);
                if (s == -3 && gg == -3) {
                    newID.setMiscID(i + 1000 * this.m_nNestingLevel);
                }
                if (this.m_Perspective.getDrillCallback().isDrillingEnabled()) {
                    int underline = this.m_Perspective.getFontStyle(newID) & 4;
                    textStyle.setFontStyle(textStyle.getFontStyle() & 0xFFFFFFFB | underline);
                }
                if (this.isO1WithNestedLabels()) {
                    newID.setMiscID(this.m_nTopNestingLevel - this.m_nNestingLevel);
                }
            } else {
                newID = new IdentObj(this.m_template.getLabel());
                newID.setMiscID(i + 1000 * this.m_nNestingLevel);
            }
            if (this.m_nNestingLevel == 1) {
                textStyle.setHorizAlign(2);
                if (this.m_Perspective.getDrillCallback().isDrillingEnabled()) {
                    int style = textStyle.getFontStyle();
                    textStyle.setFontStyle(style &= 0xFFFFFFFB);
                }
            }
            if (this.m_Perspective.getTestLabelCalc() || !this.doDisplayOnCalc()) continue;
            String szLabel = (String)sVectLabels.get(i);
            if (this instanceof CircularAxisObj && textStyle.getRotationAngle() == 0 && this.m_nAxisObjectID == 2001) {
                Rectangle legendRect = this.m_Perspective.getRect(this.m_Perspective.getLegendArea());
                Rectangle frameRect = this.m_Perspective.getRect(this.m_Perspective.getFrame());
                boolean leftPos = false;
                boolean rightPos = false;
                if (this.m_Perspective.getDisplay(this.m_Perspective.getLegendArea())) {
                    if (legendRect.x < frameRect.x && legendRect.y + legendRect.height > frameRect.y) {
                        leftPos = true;
                    } else if (legendRect.x + legendRect.width > frameRect.x + frameRect.width && legendRect.y + legendRect.height > frameRect.y) {
                        rightPos = true;
                    }
                }
                int leftX = -16000;
                int rightX = 16000;
                if (leftPos) {
                    leftX = legendRect.x + legendRect.width;
                }
                if (rightPos) {
                    rightX = legendRect.x;
                }
                boolean wordwrap = textStyle.getWordWrap();
                boolean truncate = true;
                if (!this.m_Perspective.getFontSizeAbsolute(newID) && this.m_Perspective.getLegendTextAutofit()) {
                    truncate = false;
                }
                int fontSize = !this.m_Perspective.getFontSizeAbsolute(newID) ? vc.virtToDestHeight(this.m_Perspective.getFontSizeVC(newID)) : this.m_Perspective.getFontSize(newID);
                int fontStyle = TextStyleObj.getJavaFontStyle(this.m_Perspective.getFontStyle(newID));
                String fontName = this.m_Perspective.getFontName(newID);
                Font font = new Font(fontName, fontStyle, fontSize);
                int fontHeight = TextStyleObj.getFontHeight(fm, this.m_Perspective.getFontMetricsResolver());
                int fontHeightVc = vc.destToVirtHeight(fontHeight);
                int space = 0;
                int vSpace = 0;
                if (rLabel.x < frameRect.x) {
                    rLabel.width -= leftX - rLabel.x;
                    rLabel.x = leftX;
                }
                if (rLabel.x > frameRect.x) {
                    rLabel.width -= rLabel.x + rLabel.width - rightX;
                }
                if (rLabel.x < frameRect.x) {
                    textStyle.setHorizAlign(4);
                } else if (rLabel.x > frameRect.x) {
                    textStyle.setHorizAlign(2);
                }
                if (rLabel.y > frameRect.y + frameRect.height / 2) {
                    textStyle.setVertAlign(3);
                } else {
                    textStyle.setVertAlign(1);
                }
                space = vc.virtToDestWidth(rLabel.width);
                vSpace = rLabel.width;
                if (truncate && !wordwrap) {
                    labelWidth = vc.destToVirtWidth(this.m_Perspective.getFontMetricsResolver().stringWidth(szLabel, fm));
                    if (fm != null && szLabel != null && vSpace < labelWidth) {
                        szLabel = PresUtils.truncateText(szLabel, fm, 2, space, this.m_Perspective.getFontMetricsResolver());
                        labelsTruncated = true;
                    }
                }
                if (truncate && wordwrap) {
                    int displayLines = 2;
                    ArrayList strs = new ArrayList();
                    int actualLines = textStyle.extractLinesWordWrap(szLabel, strs, vc.virtToDestWidth(rLabel.width), fm, this.m_Perspective.getFontMetricsResolver());
                    if (textStyle.isTextTruncated()) {
                        labelsTruncated = true;
                    }
                    if (displayLines < actualLines) {
                        textStyle.setTextTruncate(true, displayLines, 2);
                        labelsTruncated = true;
                    }
                }
                this.m_Perspective.setO1LabelsTruncated(labelsTruncated);
            }
            if (truncateCheckForRangeSlider) {
                if (this.m_Perspective.isChartOrientHorz()) {
                    int maxX = this.axisRS.getRect().x + this.axisRS.getRect().width;
                    int diffW = maxX - rLabel.x;
                    if (diffW > 0 && diffW < rLabel.width) {
                        rLabel.width -= diffW;
                        rLabel.x = maxX;
                        if (fullText == null) {
                            fullText = szLabel;
                        }
                        szLabel = PresUtils.truncateText(szLabel, this.m_Perspective.getFontMetrics(this.m_template.getLabel()), 2, vc.virtToDestWidth(rLabel.width), this.m_Perspective.getFontMetricsResolver());
                    }
                } else {
                    int maxY = this.axisRS.getRect().y + this.axisRS.getRect().height;
                    int diffH = maxY - rLabel.y;
                    if (diffH > 0 && diffH < rLabel.height) {
                        rLabel.height -= diffH;
                        rLabel.y = maxY;
                        if (fullText == null) {
                            fullText = szLabel;
                        }
                        szLabel = PresUtils.truncateText(szLabel, this.m_Perspective.getFontMetrics(this.m_template.getLabel()), 2, vc.virtToDestHeight(rLabel.height), this.m_Perspective.getFontMetricsResolver());
                    }
                }
            }
            if (fullText == null || fullText.equals("")) {
                new DetLabel(this.m_Perspective.getDetectiv(), newID, szLabel, rLabel, textStyle, blackBox, false);
            } else {
                new DetLabel(this.m_Perspective.getDetectiv(), newID, szLabel, fullText, rLabel, textStyle, blackBox, false);
            }
            if (this.m_Perspective.getZoomAndScroll() != 0 || this.axisRS == null || this.m_nNestingLevel != 0) continue;
            this.axisRS.calcLabelClip(rLabel);
        }
    }

    private boolean skipFirstOrLastLabel(int i, int nNumLabels) {
        if (i != 0 && i != nNumLabels - 1) {
            return false;
        }
        boolean excludeMin = this.m_Perspective.getExcludeMinLabel(this.m_template.getLabel());
        if (i == 0 && excludeMin) {
            return true;
        }
        if (i != nNumLabels - 1) {
            return false;
        }
        boolean excludeMax = !excludeMin && this.m_template.getLabel().getObjectID() == 280 && this.m_polarExcludeX1LastLabel || this.m_Perspective.getExcludeMaxLabel(this.m_template.getLabel());
        return excludeMax;
    }

    public List getRelLabelPos(int nNumLabels) {
        ArrayList<Double> nVectLabelPos = new ArrayList<Double>(nNumLabels);
        int nAxisID = this.m_nAxisObjectID;
        int nAxisO1ID = 2001;
        int nAxisO2ID = 2002;
        boolean bReverse = false;
        if (this.m_gt.is3DType() && !this.m_gt.is3DSurface()) {
            if (nAxisID == nAxisO1ID && !this.m_bReverseGroups) {
                bReverse = true;
            }
            if (nAxisID == nAxisO2ID && this.m_bReverseSeries) {
                bReverse = true;
            }
        } else {
            if (nAxisID == nAxisO1ID && this.m_bReverseGroups) {
                bReverse = true;
            }
            if (nAxisID == nAxisO2ID && this.m_bReverseSeries) {
                bReverse = true;
            }
        }
        for (int i = 0; i < nNumLabels; ++i) {
            int nIdx = bReverse ? nNumLabels - i - 1 : i;
            nVectLabelPos.add(new Double(this.getLabelRelPos(nIdx)));
        }
        return nVectLabelPos;
    }

    public int getAxisTextLabelSizeVC() {
        return this.m_axisLabelTextSizeVC;
    }

    public int getAxisObjID() {
        return this.m_template.getAxisObjID();
    }

    public AxisTemplate getAxisTemplate() {
        return this.m_template;
    }

    public IdentObj getAxisIdentObj() {
        return this.m_template.getAxis();
    }

    public double getAutoLowerSplitValue() {
        return this.m_SmartAxis.getAutoLowerSplitValue();
    }

    public double getAutoHigherSplitValue() {
        return this.m_SmartAxis.getAutoHigherSplitValue();
    }

    public boolean isAscending() {
        return this.m_bAscending;
    }

    public boolean isDescending() {
        return !this.m_bAscending;
    }

    public boolean isO1WithNestedLabels() {
        if (this.m_cbO1Labels == null) {
            return false;
        }
        if (!this.m_Perspective.getNestedLabels()) {
            return false;
        }
        if (this.m_continuousTimeAxis) {
            return true;
        }
        boolean bO1Axis = this.isO1Axis();
        return bO1Axis;
    }

    public boolean isO1Axis() {
        boolean bO1Axis = this.m_nAxisObjectID == 2001;
        return bO1Axis;
    }

    public boolean isY2Axis() {
        boolean bY2Axis = this.m_nAxisObjectID == 2005;
        return bY2Axis;
    }

    public boolean isY3Axis() {
        boolean bY3Axis = this.m_nAxisObjectID == 2012;
        return bY3Axis;
    }

    public boolean isY4Axis() {
        boolean bY4Axis = this.m_nAxisObjectID == 2013;
        return bY4Axis;
    }

    public boolean isY5Axis() {
        boolean bY5Axis = this.m_nAxisObjectID == 2014;
        return bY5Axis;
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }

    public void setDrawGrids(boolean bDrawGrids) {
        this.m_bDrawGrids = bDrawGrids;
    }

    protected IdentObj getTitle() {
        block5: {
            block4: {
                if (this.m_template.getAxisObjID() == 5) break block4;
                if (this.m_template.getAxisObjID() != 6) break block5;
            }
            if (this.m_Perspective.getDrillCallback().isDrillingEnabled() && this.m_Perspective.getTextString(this.m_template.getDrillLabel()) != null && this.m_Perspective.getDisplay(this.m_template.getDrillLabel())) {
                return this.m_template.getDrillLabel();
            }
        }
        return this.m_template.getTitle();
    }

    protected IdentObj getTitleBox() {
        block5: {
            block4: {
                if (this.m_template.getAxisObjID() == 5) break block4;
                if (this.m_template.getAxisObjID() != 6) break block5;
            }
            if (this.m_Perspective.getDrillCallback().isDrillingEnabled() && this.m_Perspective.getTextString(this.m_template.getDrillLabel()) != null && this.m_Perspective.getDisplay(this.m_template.getDrillLabel())) {
                return this.m_template.getDrillLabelBox();
            }
        }
        return this.m_template.getTitleBox();
    }

    private Dimension findLargestLabelFastest(Graphics g, int nNumLabels, Dimension dimLabelMaxVC, List sVectLabels, int nFontSizeVC, TextStyleObj textStyle, boolean bRotated) {
        VC vc = this.getAxisVC();
        Dimension dimLargestLabelDC = new Dimension(0, 0);
        int nFontSizeDC = vc.virtToDestHeight(nFontSizeVC);
        Dimension dimLabelMaxDC = vc.virtToDest(dimLabelMaxVC);
        int idLabel = this.m_template.getLabel().getObjectID();
        FontMetrics fm = this.m_Perspective.getFontMetrics(new IdentObj(idLabel));
        if (bRotated) {
            int nSaveWidth = dimLabelMaxDC.width;
            dimLabelMaxDC.width = dimLabelMaxDC.height;
            dimLabelMaxDC.height = nSaveWidth;
        }
        for (int i = 0; i < nNumLabels; ++i) {
            boolean bSkipLabel = this.skipFirstOrLastLabel(i, nNumLabels);
            if (bSkipLabel) continue;
            String strLabel = (String)sVectLabels.get(i);
            Dimension dimLabel = textStyle.getTextSizeDC(g, strLabel, nFontSizeDC, vc, dimLabelMaxDC, null, this.m_Perspective.getFontMetricsResolver());
            if (!textStyle.getWordWrap()) {
                int labelWidth;
                dimLabel.width = labelWidth = this.m_Perspective.getFontMetricsResolver().stringWidth(strLabel, fm);
            }
            if (dimLabel.width > dimLargestLabelDC.width) {
                dimLargestLabelDC.width = dimLabel.width;
            }
            if (dimLabel.height <= dimLargestLabelDC.height) continue;
            dimLargestLabelDC.height = dimLabel.height;
        }
        return dimLargestLabelDC;
    }

    public void setRangeSlider(RangeSlider rs) {
        this.axisRS = rs;
    }

    protected abstract boolean isVertical();

    protected abstract void adjustTitlePosPass1(int var1, List var2, Rectangle var3);

    protected abstract void adjustTitlePosPass2(IdentObj var1, int var2, Rectangle var3, Dimension var4);

    protected abstract void adjustLabelPos(int var1, int var2, List var3);

    protected abstract boolean isAxisLabelVisible(int var1);

    protected abstract boolean doDisplayOnCalc();

    protected abstract void calcMajorGridLine(IdentObj var1, double var2, BlackBoxIF var4);

    protected abstract void calcMinorGridLine(IdentObj var1, double var2, BlackBoxIF var4);

    protected abstract int getAxisSide();

    protected abstract void getLabelAndTitlePos(int var1, int var2, List var3, List var4, List var5, Rectangle var6, boolean var7, int var8, int var9, int var10, TextStyleObj var11);

    protected abstract double getLabelRelPos(int var1);

    protected abstract List getLabels();

    protected abstract List getLabelIdents();

    protected abstract boolean getMajorGridDisplay(AxisTemplate var1);

    protected abstract double getMajorGridPos(int var1);

    protected abstract boolean getMinorGridDisplay(AxisTemplate var1);

    protected abstract double getMinorGridPosAbsolute(int var1);

    protected abstract double getMinorGridPos(int var1, int var2);

    public abstract double getMaxValue();

    public abstract double getMinValue();

    protected abstract void calcOrdinalScale();

    protected abstract int getNumLabels();

    protected abstract int getNumMajorGrids();

    protected abstract int getNumMinorGridsAbsolute();

    protected abstract int getNumMinorGrids();

    protected abstract int getTitleRotation(AxisTemplate var1, int var2);

    protected abstract boolean isLogScale();

    protected abstract boolean isNumericAxis();

    protected abstract boolean isMinorGridStepTypeAbsolute();

    protected abstract boolean isPolarAxis();

    protected abstract int getTitleJustVert(IdentObj var1, int var2);

    protected abstract int getTitleJustHoriz(IdentObj var1, int var2);

    public abstract String getNonZeroBaselineLabel();

    protected abstract double getValueCoord(double var1);

    protected VC getAxisVC() {
        VC vc = null;
        vc = this.m_Perspective.getZoomAndScroll() == 0 && this.axisRS != null ? this.axisRS.getVC() : this.m_Perspective.getVC();
        return vc;
    }
}

