/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.dataView.WordWrapEnabled;
import oracle.dss.graph.BaseTickLabel;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

public class O1TickLabel
extends BaseTickLabel
implements WordWrapEnabled {
    protected boolean wordWrapEnabled;
    @Concealed
    protected IdentObj m_identObj2;

    @Concealed
    public O1TickLabel(CommonGraph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getO1Label();
        this.m_identObj2 = this.m_pfj.getO1DrillLabel();
    }

    @Override
    public boolean selectObject(int layer, int group) {
        if (group >= 0) {
            IdentObj identObj = new IdentObj(this.m_identObj);
            boolean nestedLabels = this.m_pfj.getNestedLabels();
            int layerCount = 0;
            if (nestedLabels) {
                layerCount = this.m_pfj.getO1LabelCallBack().getNumLevels();
            }
            if (layerCount > 0 && (layer < 0 || layer >= layerCount)) {
                layer = layerCount - 1;
            }
            if (nestedLabels) {
                identObj.setMiscID(layer);
            }
            identObj.setGroupID(group);
            this.m_pfj.setSelection(identObj);
            if (identObj.equals(this.m_pfj.getSelectionID())) {
                return true;
            }
        }
        return false;
    }

    @Concealed
    void setAutoHorizAlignment() {
        boolean isHorizontal = this.m_commonGraph.isHorizontal();
        int currentType = this.m_commonGraph.getGraphType();
        int rotation = this.m_pfj.getTextRotation(this.m_identObj);
        int alignment = this.m_pfj.getTextJustHoriz(this.m_identObj);
        boolean isThreeD = false;
        if (currentType >= 0 && currentType <= 14) {
            isThreeD = true;
        }
        if (isHorizontal) {
            switch (rotation) {
                case 0: {
                    alignment = 4;
                    break;
                }
                case 90: 
                case 270: {
                    alignment = 0;
                }
            }
        } else {
            switch (rotation) {
                case 0: {
                    if (isThreeD) {
                        alignment = 2;
                        break;
                    }
                    alignment = 0;
                    break;
                }
                case 90: {
                    alignment = 4;
                    break;
                }
                case 270: {
                    alignment = 2;
                }
            }
        }
        this.m_pfj.setNoXMLMode(true);
        if (alignment != this.m_pfj.getTextJustHoriz(this.m_identObj)) {
            this.m_pfj.setTextJustHoriz(this.m_identObj, alignment);
        }
        this.m_pfj.setNoXMLMode(false);
    }

    @Override
    public boolean isTextFittingAutomatic() {
        return this.m_pfj.getAutofit(this.m_identObj);
    }

    @Override
    public void setTextFittingAutomatic(boolean yesNo) {
        this.m_pfj.setAutofit(this.m_identObj, yesNo);
    }

    public int getAutomaticRotation() {
        return this.m_pfj.getO1LabelAutoAngle();
    }

    public void setAutomaticRotation(int orient) {
        if (orient < 0 || orient > 2) {
            this.m_commonGraph.getErrorHandler().log("invalid value for TextRotation", this.getClass().getName(), "setAutomaticRotation(int orient)");
        } else {
            this.m_pfj.setO1LabelAutoAngle(orient);
        }
    }

    @Override
    public void setHorizontalAlignment(int a) {
        super.setHorizontalAlignment(a);
        if (a == 2 || a == 0 || a == 4 || a == 10) {
            this.m_pfj.setTextJustHoriz(this.m_identObj2, a);
        }
    }

    @Override
    public void setTextRotation(int orient) {
        if (orient < 0 || orient > 360) {
            this.m_commonGraph.getErrorHandler().log("invalid value for TextRotation", this.getClass().getName(), "setTextRotation(int orient)");
        } else {
            this.m_pfj.setTextRotation(this.m_identObj, orient);
            this.setAutoHorizAlignment();
        }
    }

    public int getTickLabelSkipCount() {
        return this.m_pfj.getSkipCount(this.m_identObj);
    }

    public void setTickLabelSkipCount(int count) {
        if (count < 0) {
            this.m_commonGraph.getErrorHandler().log("invalid Tick Label Skip count", "oracle.dss.graph.O1TickLabel", "setTickLabelSkipCount(int count)");
        } else {
            this.m_pfj.setSkipCount(this.m_identObj, count);
        }
    }

    public int getTickLabelSkipFirst() {
        return this.m_pfj.getSkipBegin(this.m_identObj);
    }

    public void setTickLabelSkipFirst(int first) {
        if (first < 0) {
            this.m_commonGraph.getErrorHandler().log("invalid first tick label", this.getClass().getName(), "setTickLabelSkipFirst (int first)");
        } else {
            this.m_pfj.setSkipBegin(this.m_identObj, first);
        }
    }

    public int getTickLabelSkipMode() {
        return this.m_pfj.getAutoSkip(this.m_identObj);
    }

    public void setTickLabelSkipMode(int mode) {
        if (mode < 0 || mode > 2) {
            this.m_commonGraph.getErrorHandler().log("invalid TickLabelSkipMode", this.getClass().getName(), "void setTickLabelSkipMode( int mode )");
        } else {
            this.m_pfj.setAutoSkip(this.m_identObj, mode);
        }
    }

    @Override
    public boolean isTickLabelStaggered() {
        return this.m_pfj.getLabelStagger(this.m_identObj);
    }

    @Override
    public void setTickLabelStaggered(boolean yesNo) {
        this.m_pfj.setLabelStagger(this.m_identObj, yesNo);
    }

    @Override
    public boolean isWordWrapEnabled() {
        return this.m_pfj.getTextWrap(this.m_identObj);
    }

    @Override
    public void setWordWrapEnabled(boolean yesNo) {
        this.m_pfj.setTextWrap(this.m_identObj, yesNo);
        this.m_pfj.setTextWrap(this.m_identObj2, yesNo);
    }

    @Override
    @Concealed
    protected String getComponentName() {
        return "O1TickLabel";
    }

    @Concealed
    protected String convertTickLabelSkipModeToString(int value) {
        String skipMode = "TLS_NOSKIP";
        switch (value) {
            case 0: {
                skipMode = "TLS_NOSKIP";
                break;
            }
            case 1: {
                skipMode = "TLS_AUTOMATIC";
                break;
            }
            case 2: {
                skipMode = "TLS_MANUAL";
            }
        }
        return skipMode;
    }

    @Concealed
    public static int convertTickLabelSkipModeToInt(String string) {
        if (string.equals("TLS_NOSKIP")) {
            return 0;
        }
        if (string.equals("TLS_AUTOMATIC")) {
            return 1;
        }
        if (string.equals("TLS_MANUAL")) {
            return 2;
        }
        return -1;
    }

    @Concealed
    public static int convertAutomaticRotationToInt(String string) {
        if (string.equals("AR_NO_ROTATE")) {
            return 0;
        }
        if (string.equals("AR_HORIZ_ROTATE_90")) {
            return 1;
        }
        if (string.equals("AR_HORIZ_ROTATE_270")) {
            return 2;
        }
        return -1;
    }

    @Override
    @Concealed
    public void setStyleXML(ObjectNode node) {
        super.setStyleXML(node);
        PropertyNode pNode = node.getProperty("tickLabelSkipMode");
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("tickLabelSkipMode", new Integer(O1TickLabel.convertTickLabelSkipModeToInt(pNode.getValueAsString())));
            } else {
                this.setTickLabelSkipMode(O1TickLabel.convertTickLabelSkipModeToInt(pNode.getValueAsString()));
            }
        }
        if ((pNode = node.getProperty("tickLabelSkipCount")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("tickLabelSkipCount", new Integer(pNode.getValueAsString()));
            } else {
                this.setTickLabelSkipCount(pNode.getValueAsInteger());
            }
        }
        if ((pNode = node.getProperty("tickLabelSkipFirst")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("tickLabelSkipFirst", new Integer(pNode.getValueAsString()));
            } else {
                this.setTickLabelSkipFirst(pNode.getValueAsInteger());
            }
        }
        if ((pNode = node.getProperty("automaticRotation")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("automaticRotation", new Integer(O1TickLabel.convertAutomaticRotationToInt(pNode.getValueAsString())));
            } else {
                this.setAutomaticRotation(O1TickLabel.convertAutomaticRotationToInt(pNode.getValueAsString()));
            }
        }
        if ((pNode = node.getProperty("tickLabelWrapped")) != null) {
            this.setWordWrapEnabled(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty("wordWrapEnabled")) != null) {
            this.setWordWrapEnabled(pNode.getValueAsBoolean());
        }
    }

    @Override
    @Concealed
    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean nodeExists = super.getStyleXML(allProperties, node);
        Object val = this.m_pfj.getAutoSkipObj(this.m_identObj);
        if (val != null) {
            node.addProperty("tickLabelSkipMode", this.convertTickLabelSkipModeToString((Integer)val));
            nodeExists = true;
        }
        if ((val = this.m_pfj.getSkipCountObj(this.m_identObj)) != null) {
            node.addProperty("tickLabelSkipCount", ((Integer)val).intValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getSkipBeginObj(this.m_identObj)) != null) {
            node.addProperty("tickLabelSkipFirst", ((Integer)val).intValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.O1LabelAutoAngle)) != null) {
            int temp = (Integer)val;
            if (temp == 0) {
                node.addProperty("automaticRotation", "AR_NO_ROTATE");
            } else if (temp == 1) {
                node.addProperty("automaticRotation", "AR_HORIZ_ROTATE_90");
            } else if (temp == 2) {
                node.addProperty("automaticRotation", "AR_HORIZ_ROTATE_270");
            }
            nodeExists = true;
        }
        if ((val = this.m_pfj.getTextWrapObj(this.m_identObj)) != null) {
            node.addProperty("wordWrapEnabled", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        return nodeExists;
    }

    @Override
    @Concealed
    public void resetStyle() {
        this.setWordWrapEnabled(false);
        this.setTickLabelSkipMode(0);
        this.setTickLabelSkipCount(1);
        this.setTickLabelSkipFirst(1);
        this.setAutomaticRotation(0);
    }
}

