/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.CubeDataAccess;
import oracle.dss.util.CubeDataDirector;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataAccessAdapter;
import oracle.dss.util.DataAvailableEvent;
import oracle.dss.util.DataChangedEvent;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataDirectorException;
import oracle.dss.util.DataDirectorListener;
import oracle.dss.util.DataException;
import oracle.dss.util.DataMap;
import oracle.dss.util.DataSource;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerMetadataMap;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.QDR;
import oracle.dss.util.RelationalDataAccess;
import oracle.dss.util.RelationalDataDirector;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;

public class LocalDataSource
extends DataAccessAdapter
implements CubeDataDirector,
CubeDataAccess,
RelationalDataDirector,
RelationalDataAccess,
DataSource {
    protected double[][] defaultData1 = new double[][]{{42.0, 50.0, 38.0, 46.0}, {26.0, 34.0, 22.0, 30.0}, {10.0, 18.0, 6.0, 14.0}};
    protected double[][] defaultData2 = new double[][]{{23.0, 4.0, 17.0, 82.0}, {44.0, 3.0, 22.0, 15.0}, {33.0, 14.0, 87.0, 94.0}};
    protected int rowCount = 3;
    protected int columnCount = 4;
    protected int pageCount = 2;
    protected int currentPage = 0;
    private Object[][] cellData;
    protected String[] rowLabels;
    protected String[] columnLabels;
    protected String[] pageLabels;
    private Locale loc = null;
    protected ResourceBundle rBundle = null;
    protected String baseEdgeDim = null;
    protected String baseDim = null;
    protected String basePageMem = null;
    protected String strPage = null;
    protected DataDirectorListener listener;

    public LocalDataSource() {
        this.populateCellData(this.columnCount, this.rowCount, this.defaultData1);
        this.updateResourceBundle(this.getLocale());
    }

    public void setLocale(Locale loc) {
        this.loc = loc;
        this.updateResourceBundle(loc);
    }

    public Locale getLocale() {
        return this.loc;
    }

    protected void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.dataView.resource.DataviewBundle", loc) : ResourceBundle.getBundle("oracle.dss.dataView.resource.DataviewBundle");
        this.updateLabels();
    }

    protected void updateLabels() {
        Integer Num;
        String rowStr = this.rBundle.getString("LDSRow");
        String columnStr = this.rBundle.getString("LDSColumn");
        String pageStr = this.rBundle.getString("LDSPage");
        this.strPage = this.rBundle.getString("Page");
        this.baseEdgeDim = this.rBundle.getString("LDSEdgeDim");
        this.baseDim = this.rBundle.getString("LDSDim");
        this.basePageMem = this.rBundle.getString("LDSPageMem");
        this.rowLabels = new String[this.rowCount];
        for (int row = 0; row < this.rowCount; ++row) {
            Num = new Integer(row + 1);
            this.rowLabels[row] = MessageFormat.format(rowStr, Num.toString());
        }
        this.columnLabels = new String[this.columnCount];
        for (int col = 0; col < this.columnCount; ++col) {
            Num = new Integer(col + 1);
            this.columnLabels[col] = MessageFormat.format(columnStr, Num.toString());
        }
        this.pageLabels = new String[this.pageCount];
        for (int page = 0; page < this.pageCount; ++page) {
            Num = new Integer(page + 1);
            this.pageLabels[page] = MessageFormat.format(pageStr, Num.toString());
        }
    }

    public void populateCellData(int columnCount, int rowCount, double[][] data) {
        this.cellData = new Object[rowCount][columnCount];
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < columnCount; ++col) {
                this.cellData[row][col] = new Double(data[row][col]);
            }
        }
    }

    public DataDirector createDataDirector() {
        return this;
    }

    public CubeDataDirector createCubeDataDirector() {
        return this;
    }

    public RelationalDataDirector createRelationalDataDirector() {
        return this;
    }

    public DataAccess getDataAccess() throws DataDirectorException {
        return this;
    }

    public void addDataDirectorListener(DataDirectorListener l) {
        this.listener = l;
        this.listener.viewDataAvailable(new DataAvailableEvent((Object)this, (DataAccess)this));
    }

    public void removeDataDirectorListener(DataDirectorListener l) {
        if (this.listener == l) {
            this.listener = null;
        }
    }

    public boolean drill(int edge, int layer, int slice, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, DataDirectorException {
        return true;
    }

    public boolean changeEdgeCurrentSlice(int edge, int slice) throws EdgeOutOfRangeException, SliceOutOfRangeException, DataDirectorException {
        if (slice == 1) {
            this.currentPage = 1;
            this.populateCellData(this.columnCount, this.rowCount, this.defaultData2);
            this.listener.viewDataChanged(new DataChangedEvent((Object)this, (DataAccess)this, true, true, true, true));
        } else if (slice == 0) {
            this.currentPage = 0;
            this.populateCellData(this.columnCount, this.rowCount, this.defaultData1);
            this.listener.viewDataChanged(new DataChangedEvent((Object)this, (DataAccess)this, true, false, false, true));
        }
        return true;
    }

    public boolean changeEdgeCurrentHPos(int edge, int[] hPos, int maxLayerSpecified) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, DataDirectorException {
        try {
            return this.changeEdgeCurrentSlice(edge, hPos[maxLayerSpecified]);
        }
        catch (Exception e) {
            return false;
        }
    }

    public int getEdgeExtent(int edge) throws EdgeOutOfRangeException {
        switch (edge) {
            case 0: {
                return this.columnCount;
            }
            case 1: {
                return this.rowCount;
            }
            case 2: {
                return this.pageCount;
            }
        }
        return 0;
    }

    public int getEdgeCount() {
        return 3;
    }

    public Object getValue(int aRow, int aColumn, String type) throws RowOutOfRangeException, ColumnOutOfRangeException {
        if (aRow < 0 || aRow >= this.rowCount) {
            throw new RowOutOfRangeException((long)aRow, (long)this.rowCount);
        }
        if (aColumn < 0 || aColumn >= this.columnCount) {
            throw new ColumnOutOfRangeException((long)aColumn, (long)this.columnCount);
        }
        if (type.equals("dataRatio")) {
            return new Integer(0);
        }
        if (type.equals("dataGroupSort")) {
            return new Integer(0);
        }
        if (type.equals("dataViewFormat") || type.equals("dataViewStyle") || type.equals("dataFormattedValue") || type.equals("dataAnnotation")) {
            return null;
        }
        if (type.equals("dataIsTotal")) {
            return new Boolean(false);
        }
        return this.cellData[aRow][aColumn];
    }

    public boolean setValue(Object aValue, int aRow, int aColumn, String type) throws RowOutOfRangeException, ColumnOutOfRangeException {
        if (aRow < 0 || aRow >= this.rowCount) {
            throw new RowOutOfRangeException((long)aRow, (long)this.rowCount);
        }
        if (aColumn < 0 || aColumn >= this.columnCount) {
            throw new ColumnOutOfRangeException((long)aColumn, (long)this.columnCount);
        }
        Object oldValue = this.getValue(aRow, aColumn, type);
        Object newValue = aValue;
        try {
            newValue = oldValue.getClass().getMethod("valueOf", String.class).invoke(null, aValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cellData[aRow][aColumn] = newValue;
        return true;
    }

    public Object getSliceLabel(int edge, int slice, String type) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        switch (edge) {
            case 0: {
                if (slice < 0 || slice >= this.columnCount) {
                    throw new SliceOutOfRangeException(slice, this.columnCount);
                }
                return this.columnLabels[slice];
            }
            case 1: {
                if (slice < 0 || slice >= this.rowCount) {
                    throw new SliceOutOfRangeException(slice, this.rowCount);
                }
                return this.rowLabels[slice];
            }
            case 2: {
                if (slice < 0 || slice >= this.pageCount) {
                    throw new SliceOutOfRangeException(slice, this.pageCount);
                }
                return this.pageLabels[slice];
            }
        }
        return null;
    }

    public int getEdgeCurrentSlice(int edge, int slice) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        if (edge == 2) {
            return this.currentPage;
        }
        return 0;
    }

    public void setCurrentPage(long aPage) {
        if (aPage < 0L || aPage >= (long)this.pageCount) {
            return;
        }
        this.currentPage = (int)aPage;
    }

    public int getLayerCount(int edge) throws EdgeOutOfRangeException {
        return 1;
    }

    public int getSliceMemberCount(int edge, int slice) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        return 1;
    }

    public Object getLayerMetadata(int edge, int layer, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        if (type.equals("dimCanPivot")) {
            return new Integer(1);
        }
        if (type.equals("dimIsMeasure")) {
            return new Boolean(false);
        }
        if (type.equals("viewStyle")) {
            return null;
        }
        if (type.equals("dimDrillState")) {
            return new Integer(0);
        }
        if (edge == 2) {
            return MessageFormat.format(this.baseEdgeDim, this.strPage, "1");
        }
        return MessageFormat.format(this.baseDim, String.valueOf(layer + 1));
    }

    public Object getMemberMetadata(int edge, int dimension, int dimvalue, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (type.equals("drillState")) {
            switch (dimvalue) {
                case 0: {
                    return new Integer(1);
                }
                case 1: {
                    return new Integer(2);
                }
            }
            return new Integer(0);
        }
        if (type.equals("indent") || type.equals("relIndent")) {
            return new Integer(dimvalue);
        }
        if (type.equals("value") || type.equals("displayName") || type.equals("label") || type.equals("mediumName") || type.equals("shortName")) {
            String obj = null;
            switch (edge) {
                case 0: {
                    obj = this.columnLabels[dimvalue];
                    break;
                }
                case 1: {
                    obj = this.rowLabels[dimvalue];
                    break;
                }
                case 2: {
                    obj = this.pageLabels[dimvalue];
                }
            }
            return obj;
        }
        return null;
    }

    public int getMemberExtent(int edge, int layer, int slice) {
        return 1;
    }

    public int getMemberDepth(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return 1;
    }

    public int getMemberStartSlice(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return slice;
    }

    public boolean drillOK(int edge, int layer, int slice, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, DataDirectorException {
        return false;
    }

    public void setOutline(boolean outline) throws DataDirectorException {
        this.listener.viewDataChanged(new DataChangedEvent((Object)this, (DataAccess)this, true, true, true, true));
    }

    public boolean isOutline() {
        return false;
    }

    public int getMemberSiblingCount(int edge, int[] hPos, int memberLayer) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return 2;
    }

    public Object getMemberMetadata(int edge, int[] hPos, int memberLayer, int hIndex, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (memberLayer == 0 || hPos == null) {
            return MessageFormat.format(this.basePageMem, String.valueOf(hIndex));
        }
        return hPos[0] + " # " + hIndex;
    }

    public int[] getEdgeCurrentHPos(int edge) throws EdgeOutOfRangeException {
        return new int[]{this.currentPage};
    }

    public int[] getMemberHPos(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return new int[]{this.currentPage};
    }

    public int[] getNextHPos(int edge, int[] hPos) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (edge == 2 && this.currentPage == 0) {
            return new int[]{1};
        }
        return null;
    }

    public int[] getPrevHPos(int edge, int[] hPos) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (edge == 2 && this.currentPage == 1) {
            return new int[]{0};
        }
        return null;
    }

    public int[] getFirstHPos(int edge) throws EdgeOutOfRangeException {
        if (edge == 2) {
            return new int[]{0};
        }
        return null;
    }

    public int[] getLastHPos(int edge) throws EdgeOutOfRangeException {
        if (edge == 2) {
            return new int[]{1};
        }
        return null;
    }

    public DataMap getDataMap() {
        return new DataMap();
    }

    public DataMap getSupportedDataMap() {
        String[] supported = new String[]{"dataValue", "dataFormattedValue", "dataRatio", "dataViewFormat", "dataViewStyle", "dataGroupSort", "dataAnnotation", "value", "dataIsTotal"};
        return new DataMap(supported);
    }

    public MetadataMap getSupportedMetadataMap() {
        String[] supported = new String[]{"label", "mediumName", "shortName", "drillState", "viewStyle", "value", "indent", "relIndent", "date"};
        return new MetadataMap(supported);
    }

    public LayerMetadataMap getSupportedLayerMetadataMap() {
        String[] supported = new String[]{"layerLabel", "dimMediumName", "dimShortName", "layerName", "dimCanPivot", "dimIsMeasure", "viewStyle", "dimDrillState"};
        return new LayerMetadataMap(supported);
    }

    public QDR getLayerQDR(int edge, int layer, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        String layerName = this.getLayerMetadata(edge, layer, "layerLabel").toString();
        return new QDR(null, layerName, (String)null);
    }

    public QDR getSliceQDR(int edge, int slice, int flags) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        return this.constructSliceQDR(edge, slice);
    }

    protected QDR constructSliceQDR(int edge, int slice) {
        String layerName = null;
        String memberName = null;
        String result = "";
        int layerCount = 0;
        try {
            layerCount = this.getLayerCount(edge);
        }
        catch (DataException dataException) {
            // empty catch block
        }
        for (int layer = 0; layer < layerCount; ++layer) {
            try {
                layerName = this.getLayerMetadata(edge, layer, "layerLabel").toString();
            }
            catch (DataException de) {
                layerName = "";
            }
            try {
                memberName = this.getMemberMetadata(edge, layer, slice, "label").toString();
            }
            catch (DataException de) {
                memberName = "";
            }
            result = result + ";" + layerName.toString() + ":" + memberName.toString();
        }
        QDR qdr = new QDR(null, result);
        return qdr;
    }
}

