/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.config;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.dbtools.raptor.config.ConfigTraversable;
import oracle.dbtools.raptor.ssh.SshSupportResources;
import oracle.dbtools.raptor.ssh.config.SshConfiguration;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class SshConfigurationPanel
extends ConfigTraversable {
    private JCheckBox mChkHosts = new JCheckBox();
    private URLFileChooser.URLFileChooserPanel mPnlHosts = SshConfigurationPanel.createChooserPanel(SshSupportResources.getString("CONFIG_TITLE_KNOWN_HOSTS"), ".mPnlHosts");
    private JCheckBox mUseConfigFile = new JCheckBox();
    private URLFileChooser.URLFileChooserPanel mPnlConfigFile = SshConfigurationPanel.createChooserPanel(SshSupportResources.getString("CONFIG_TITLE_CONFIG_FILE"), ".mPnlConfigFile");

    private static URLFileChooser.URLFileChooserPanel createChooserPanel(String string, String string2) {
        URLFileChooser.URLFileChooserPanel uRLFileChooserPanel = URLFileChooser.createURLFileChooserPanel((int)0, null, (String)string, (boolean)false, (boolean)true);
        uRLFileChooserPanel.setPathContext(SshConfigurationPanel.class.getName() + string2);
        uRLFileChooserPanel.clearChooseableURLFilters();
        return uRLFileChooserPanel;
    }

    private static ItemListener createStateChangeHandler(final EnabledStateToggle enabledStateToggle) {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                enabledStateToggle.updateEnabledState(itemEvent.getStateChange() == 1);
            }
        };
    }

    protected JPanel createContentPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.mPnlConfigFile.setEnabled(this.mUseConfigFile.isSelected());
        this.mUseConfigFile.addItemListener(SshConfigurationPanel.createStateChangeHandler(bl -> this.mPnlConfigFile.setEnabled(bl)));
        ResourceUtils.resButton((AbstractButton)this.mUseConfigFile, (String)SshSupportResources.getString("CONFIG_OPTION_CONFIG_FILE"));
        jPanel2.add((Component)this.mUseConfigFile, LayoutControl.GBC.gbc((int)0, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel2.add((Component)this.mPnlConfigFile, LayoutControl.GBC.gbc((int)0, (int)3, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jPanel2, LayoutControl.GBC.gbc((int)0, (int)n++, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X, (LayoutControl.GBC.Anchor)LayoutControl.GBC.Anchor.LINE_START));
        jPanel2 = new JPanel(new GridBagLayout());
        this.mChkHosts.addItemListener(SshConfigurationPanel.createStateChangeHandler(bl -> this.mPnlHosts.setEnabled(bl)));
        ResourceUtils.resButton((AbstractButton)this.mChkHosts, (String)SshSupportResources.getString("CONFIG_OPTION_KNOWN_HOSTS"));
        jPanel2.add((Component)this.mChkHosts, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel2.add((Component)this.mPnlHosts, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jPanel2, LayoutControl.GBC.gbc((int)0, (int)n++, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X, (LayoutControl.GBC.Anchor)LayoutControl.GBC.Anchor.LINE_START));
        jPanel.add(Box.createVerticalGlue(), LayoutControl.GBC.gbc((int)0, (int)n++, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.Y, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.Y));
        return jPanel;
    }

    public void onEntry(TraversableContext traversableContext) {
        SshConfiguration sshConfiguration = SshConfiguration.createSettings(traversableContext);
        URL uRL = sshConfiguration.getConfigFile();
        if (uRL != null) {
            this.mUseConfigFile.setSelected(true);
            this.mPnlConfigFile.setSelectedURL(uRL);
        } else {
            this.mUseConfigFile.setSelected(false);
            this.mPnlConfigFile.setEnabled(false);
        }
        URL uRL2 = sshConfiguration.getKnownHostsFile();
        if (uRL2 != null) {
            this.mChkHosts.setSelected(true);
            this.mPnlHosts.setSelectedURL(uRL2);
        } else {
            this.mChkHosts.setSelected(false);
            this.mPnlHosts.setEnabled(false);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        SshConfiguration sshConfiguration = SshConfiguration.createSettings(traversableContext);
        boolean bl = this.mChkHosts.isSelected();
        if (bl) {
            URL uRL = this.mPnlHosts.getSelectedURL();
            if (uRL == null) {
                throw new TraversalException(SshSupportResources.getString("CONFIG_ERROR_MISSING_KNOWN_HOSTS_FILE"));
            }
            sshConfiguration.setKnownHostsFile(uRL);
        } else {
            sshConfiguration.setKnownHostsFile(null);
        }
        boolean bl2 = this.mUseConfigFile.isSelected();
        if (bl2) {
            URL uRL = this.mPnlConfigFile.getSelectedURL();
            if (uRL == null) {
                throw new TraversalException(SshSupportResources.getString("CONFIG_ERROR_MISSING_CONFIG_FILE"));
            }
            sshConfiguration.setConfigFile(uRL);
        } else {
            sshConfiguration.setConfigFile(null);
        }
    }

    public String getHelpID() {
        return "f1_idedidesetssh_html";
    }

    private static interface EnabledStateToggle {
        public void updateEnabledState(boolean var1);
    }
}

